<?php
class Wholesale_cart{
    private $config;
    private $db;
    private $data = [];
    private $payment_address = [];
    private $shipping_address = [];
    private $wholesale = [];
    private $payment_method = [];
    private $shipping_methods = [];
    private $shipping_method = [];
    private $customer_info = [];

    public function __construct($registry) {
        $this->config = $registry->get('config');
        $this->session = $registry->get('session');
        $this->db = $registry->get('db');
        $this->tax = new Tax($registry);

        if (!isset($this->session->data['wholesale']) || !is_array($this->session->data['wholesale'])) {
			$this->session->data['wholesale'] = [];
		}
    }

    public function set_domain($domain_url){
        $this->session->data['wholesale']['customer_info']['domain_url'] = $domain_url;

        return $this->session->data['wholesale']['customer_info'];
    }

    public function add_customer_info($data){
        $this->session->data['wholesale']['customer_info']['customer_name'] = $data['customer_name'];
        $this->session->data['wholesale']['customer_info']['customer_telephone'] = $data['customer_telephone'];
        $this->session->data['wholesale']['customer_info']['customer_email'] = $data['customer_email'];

        return $this->session->data['wholesale']['customer_info'];
    }

    public function add_to_cart($wholesale_product_id, $calculated_data){
        $this->session->data['wholesale']['product'][$wholesale_product_id]['wholesale_product_id'] = $wholesale_product_id;
        $this->session->data['wholesale']['product'][$wholesale_product_id]['unit_price_without_tax'] = $calculated_data['unit_price_without_tax'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['unit_price'] = $calculated_data['unit_price'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['unit_price_unit'] = $calculated_data['unit_price_unit'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['unit_price_unit_per_kg'] = $calculated_data['unit_price_unit'] . '/' . $calculated_data['weight_class_unit'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['calculated_price'] = $calculated_data['calculated_price'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['calculated_price_unit'] = $calculated_data['calculated_price_unit'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['tax_class_id'] = $calculated_data['tax_class_id'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['store_id'] = $calculated_data['store_id'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['etcm_product_id'] = $calculated_data['etcm_product_id'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['product_id'] = $calculated_data['product_id'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['product_name'] = $calculated_data['product_name'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['product_code'] = $calculated_data['product_code'];
        $this->session->data['wholesale']['product'][$wholesale_product_id]['weight_class_unit'] = $calculated_data['weight_class_unit'];

        if(isset($calculated_data['image'])){
            $this->session->data['wholesale']['product'][$wholesale_product_id]['image'] = $calculated_data['image'];
        }

        if(isset($calculated_data['weight_to_buy'])){
            $this->session->data['wholesale']['product'][$wholesale_product_id]['weight_quantity'] = sprintf('%0.2f', $calculated_data['weight_to_buy']);
            $this->session->data['wholesale']['product'][$wholesale_product_id]['weight_quantity_formatted'] = sprintf('%0.2f', $calculated_data['weight_to_buy']) . $calculated_data['weight_class_unit'];

        }

        if(isset($calculated_data['weight_quantity'])){
            $this->session->data['wholesale']['product'][$wholesale_product_id]['weight_quantity'] = sprintf('%0.2f', $calculated_data['weight_quantity']);
            $this->session->data['wholesale']['product'][$wholesale_product_id]['weight_quantity_formatted'] = sprintf('%0.2f', $calculated_data['weight_quantity']) . $calculated_data['weight_class_unit'];
        }

        if(isset($calculated_data['store_name'])){
            $this->session->data['wholesale']['product'][$wholesale_product_id]['store_name'] = $calculated_data['store_name'];
        }


        return $this->session->data['wholesale'];
    }

    public function remove_from_cart($wholesale_product_id){
        $this->wholesale = [];

        unset($this->session->data['wholesale']['product'][$wholesale_product_id]);
    }

    public function set_address_type($address_type){
        $this->session->data['wholesale']['address_type'] = $address_type;

        return $this->session->data['wholesale']['address_type'];
    }

    public function set_payment_address($data){
        $this->session->data['wholesale']['payment_address']['name'] = $data['name'];
        $this->session->data['wholesale']['payment_address']['company'] = $data['company'];
        $this->session->data['wholesale']['payment_address']['address_1'] = $data['address_1'];
        $this->session->data['wholesale']['payment_address']['address_2'] = $data['address_2'];
        $this->session->data['wholesale']['payment_address']['city'] = $data['city'];
        $this->session->data['wholesale']['payment_address']['postcode'] = $data['postcode'];
        $this->session->data['wholesale']['payment_address']['country_id'] = $data['country_id'];
        $this->session->data['wholesale']['payment_address']['country_name'] = $data['country_name'];
        $this->session->data['wholesale']['payment_address']['zone_id'] = $data['zone_id'];
        $this->session->data['wholesale']['payment_address']['zone_name'] = $data['zone_name'];

        return $this->session->data['wholesale']['payment_address'];
    }

    public function set_shipping_address($data){
        $this->session->data['wholesale']['shipping_address']['name'] = $data['name'];
        $this->session->data['wholesale']['shipping_address']['company'] = $data['company'];
        $this->session->data['wholesale']['shipping_address']['address_1'] = $data['address_1'];
        $this->session->data['wholesale']['shipping_address']['address_2'] = $data['address_2'];
        $this->session->data['wholesale']['shipping_address']['city'] = $data['city'];
        $this->session->data['wholesale']['shipping_address']['postcode'] = $data['postcode'];
        $this->session->data['wholesale']['shipping_address']['country_id'] = $data['country_id'];
        $this->session->data['wholesale']['shipping_address']['country_name'] = $data['country_name'];
        $this->session->data['wholesale']['shipping_address']['zone_id'] = $data['zone_id'];
        $this->session->data['wholesale']['shipping_address']['zone_name'] = $data['zone_name'];

        return $this->session->data['wholesale']['shipping_address'];
    }

    public function set_shipping_method($shipping_method, $shipping_remark, $store_id){
        $tax_class_id = 14;

        $this->session->data['shipping_methods'][$store_id] = $shipping_method;
        $this->session->data['shipping_methods'][$store_id]['tax_class_id'] = $tax_class_id;
        $this->session->data['shipping_methods'][$store_id]['shipping_remark'] = $shipping_remark;

        return $this->session->data['shipping_methods'];
    }

    public function set_shipping_method_single($shipping_method){
        $this->session->data['shipping_method'] = $shipping_method;

        return $this->session->data['shipping_method'];
    }

    public function set_payment_method($data){
        $this->session->data['payment_method']['method_name'] = $data['payment_name'];
        $this->session->data['payment_method']['method_code'] = $data['payment_code'];
        $this->session->data['payment_method']['comment'] = $data['comment'];
        $this->session->data['payment_method']['instruction'] = $data['instruction'];

        return $this->session->data['payment_method'];
    }

    public function get_customer_info(){
        if(isset($this->session->data['wholesale']['customer_info'])){
            $this->customer_info = $this->session->data['wholesale']['customer_info'];
        }

        return $this->customer_info;
    }

    public function get_payment_address(){
        if(isset($this->session->data['wholesale']['payment_address'])){
            $this->payment_address = $this->session->data['wholesale']['payment_address'];
        }

        return $this->payment_address;
    }

    public function get_shipping_address(){
        if(isset($this->session->data['wholesale']['shipping_address'])){
            $this->shipping_address = $this->session->data['wholesale']['shipping_address'];
        }

        return $this->shipping_address;
    }

    public function get_payment_method(){
        if(isset($this->session->data['payment_method'])){
            $this->payment_method = $this->session->data['payment_method'];
        }

        return $this->payment_method;
    }

    public function get_shipping_method(){
        if(isset($this->session->data['shipping_methods'])){
            $this->shipping_methods = $this->session->data['shipping_methods'];
        }

        return $this->shipping_methods;
    }

    public function get_single_shipping_method(){
        if(isset($this->session->data['shipping_method'])){
            $this->shipping_method = $this->session->data['shipping_method'];
        }

        return $this->shipping_method;
    }

    public function get_grandtotal_shipping_method(){
        $shipping_methods = $this->get_shipping_method();

        if(!empty($shipping_methods)){
            $cost_value = 0;
            $value_value = 0;

            foreach($shipping_methods as $store_id => $shipping_method){
                $sort_order = isset($shipping_method['sort_order']) ? $shipping_method['sort_order'] : 0;
                $shipping_value = isset($shipping_method['value']) ? $shipping_method['value'] : 0;

                $cost_value += $shipping_method['cost'];
                $value_value += $shipping_value;

                $this->shipping_method = [
                    'code'              => $shipping_method['code'],
                    'sort_order'        => $sort_order,
                    'title'             => $shipping_method['title'],
                    'tax_class_id'      => $shipping_method['tax_class_id'],
                    'shipping_remark'   => $shipping_method['shipping_remark']
                ];
            }

            $this->shipping_method['cost'] = $cost_value;
            $this->shipping_method['value'] = $value_value;
        }

        $this->session->data['shipping_method'] = $this->shipping_method;

        return $this->session->data['shipping_method'];
    }

    public function get_cart(){
        if(isset($this->session->data['wholesale']['product'])){
            foreach($this->session->data['wholesale']['product'] as $wholesale_product_id => $product){
                $calculated_price_without_tax = $product['unit_price_without_tax'] * $product['weight_quantity'];
                $tax_class_id = ($product['tax_class_id'] > 0) ? 11 : 13;
                $image = isset($product['image']) ? $product['image'] : '';

                $this->data['product'][$wholesale_product_id] = [
                    'wholesale_product_id'          => $product['wholesale_product_id'],
                    'etcm_product_id'               => $product['etcm_product_id'],
                    'product_id'                    => $product['product_id'],
                    'product_name'                  => $product['product_name'],
                    'product_code'                  => $product['product_code'],
                    'unit_price_without_tax'        => $product['unit_price_without_tax'],
                    'unit_price'                    => $product['unit_price'],
                    'unit_price_unit'               => $product['unit_price_unit'],
                    'unit_price_unit_per_kg'        => $product['unit_price_unit_per_kg'],
                    'calculated_price_without_tax'  => $calculated_price_without_tax,
                    'calculated_price'              => $product['calculated_price'],
                    'calculated_price_unit'         => $product['calculated_price_unit'],
                    'tax_class_id'                  => $tax_class_id,
                    'weight_quantity'               => $product['weight_quantity'],
                    'weight_class_unit'             => $product['weight_class_unit'],
                    'weight_quantity_formatted'     => $product['weight_quantity_formatted'],
                    'store_id'                      => $product['store_id'],
                    'image'                         => $image
                ];

                if(isset($product['store_name'])){
                    $this->data['product'][$wholesale_product_id]['store_name'] = $product['store_name'];
                }
            }
        }

        return $this->data;
    }

    public function getProducts(){
        $this->data['product'] = [];

        if(isset($this->session->data['wholesale']['product'])){
            foreach($this->session->data['wholesale']['product'] as $wholesale_product_id => $product){
                $calculated_price_without_tax = $product['unit_price_without_tax'] * $product['weight_quantity'];
				$product_id = $product['product_id'];

				$product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
				$product_row = $product_query->row;

                $image = isset($product['image']) ? $product['image'] : '';
                $length = isset($product_row['length']) ? $product_row['length'] : '';
                $width = isset($product_row['width']) ? $product_row['width'] : '';
                $height = isset($product_row['height']) ? $product_row['height'] : '';
                $length_class_id = isset($product_row['length_class_id']) ? $product_row['length_class_id'] : '';

                $this->data['product'][$wholesale_product_id] = [
                    'wholesale_product_id'          => $product['wholesale_product_id'],
                    'key'                           => '',
					'product_id'					=> $product_id,
                    'name'                  		=> $product['product_name'],
                    'product_code'                  => $product['product_code'],
                    'unit_price_without_tax'        => $product['unit_price_without_tax'],
                    'unit_price'                    => $product['unit_price'],
                    'unit_price_unit'               => $product['unit_price_unit'],
                    'calculated_price_without_tax'  => $calculated_price_without_tax,
                    'total'              			=> $product['calculated_price'],
                    'total_unit'         			=> $product['calculated_price_unit'],
                    'tax_class_id'                  => $product['tax_class_id'],
                    'quantity'                      => $product['weight_quantity'],
					'weight_quantity'         		=> $product['weight_quantity'],
                    'store_id'                      => $product['store_id'],
                    'image'                         => $image,
					'length'						=> $length,
					'width'							=> $width,
					'height'						=> $height,
					'weight'						=> $product['weight_quantity'],
					'length_class_id'				=> $length_class_id,
					'weight_class_id'				=> 1,
					'option'						=> [],
					'shipping'						=> true
                ];
            }
        }

        return $this->data['product'];
    }

    public function hasShipping() {
		$shipping = false;

		foreach ($this->getProducts() as $product) {
			if ($product['shipping']) {
				$shipping = true;

				break;
			}
		}

		return $shipping;
	}

    public function countProducts() {
		$product_total = 0;

		$products = $this->get_cart();

        if(!empty($products['product'])){
            foreach ($products['product'] as $wholesale_product_id => $product) {
    			$product_total += $product['weight_quantity'];
    		}
        }

		return $product_total;
	}

    public function getSubTotal(){
        $total = 0;

        $cart_data = $this->get_cart();

        if(isset($cart_data['product'])){
            foreach($cart_data['product'] as $product){
                $tax = $this->tax->getTax($product['unit_price'], $product['tax_class_id']);

                if($tax < 0){
    			    $product['calculated_price_without_tax'] = $product['calculated_price_without_tax'] + ($tax * $product['weight_quantity']);
    			}

    			$total += $product['calculated_price_without_tax'];
            }
        }

        return $total;
    }

    public function getTaxes(){
        $tax_data = [];

        $cart_data = $this->get_cart();

        if(isset($cart_data['product'])){
            foreach($cart_data['product'] as $product){
                if($product['tax_class_id']){
                    $tax_rates = $this->tax->getRates($product['unit_price_without_tax'], $product['tax_class_id']);

                    foreach ($tax_rates as $tax_rate) {
    					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
    						$tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['weight_quantity']);
    					} else {
    						$tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['weight_quantity']);
    					}
    				}
                }
            }
        }

        return $tax_data;
    }

    public function reset_method(){
        unset($this->session->data['shipping_methods']);
        unset($this->session->data['shipping_method']);
        unset($this->session->data['payment_method']);
    }

    public function clear(){
        unset($this->session->data['wholesale']);
        unset($this->session->data['shipping_methods']);
        unset($this->session->data['shipping_method']);
        unset($this->session->data['payment_method']);
    }
}
?>