<?php
namespace vendor\isenselabs\giftteaser\conditions;
use \vendor\isenselabs\giftteaser\conditions\condition as Condition;

class SomeProducts extends Condition {

	public function checkCondition(&$giftCondProps, &$productData) {
		$productIds = array();
		$includedInCart = 0;
		$products = array();
		foreach ($productData as &$p) {
			$productIds[] = $p['product_id'];
			// track quantities per product, since OC creates different cart entries for each combination of options
			if (in_array($p['product_id'], $giftCondProps['some'])) {
				if (!isset($products[$p['product_id']])) {
					$products[$p['product_id']] = $p['quantity'];
				} else {
					$products[$p['product_id']] += $p['quantity'];
				}
			}
		}
		foreach ($products as $productId => $productQuantity) {
			if ($productQuantity >= $giftCondProps['some_product_quantity']) {
				++$includedInCart;
			}
		}
		return ($includedInCart > 0);
	}

}