<?php
//path: system/library/validation
//folder: validation
//filename: email
namespace Validation;

class Email {
    public function validateEmail ($recipient_email) {
        $valid = true;

        // Validate the email address
        if (!filter_var($recipient_email, FILTER_VALIDATE_EMAIL)) {
            $valid = false;	
        }	

        // Validate the email address format using regular expression
        if (!preg_match('/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/', $recipient_email)) {
            $valid = false;	
        }

        // Validate the email address by checking DNS records
        $parts = explode('@', $recipient_email);
        if (count($parts) !== 2) {
            $valid = false;
        } else {
            list($user, $domain) = $parts;
        }
        
        if (!empty($domain) && !checkdnsrr($domain, 'MX')) {
        $valid = false;
        }


        // list($user, $domain) = explode('@', $recipient_email);
        // if (!checkdnsrr($domain, 'MX')) {
        //     $valid = false;	
        // }
        
        // var_dump($recipient_email);
        // die();
        return $valid;
    }
}


?>