<?php

class User {

    private $user_id;
    private $user_group_id;
    private $username;
    private $permission = array();
    private $user_permissions = array();

    public function __construct($registry) {
        $this->db = $registry->get('db');
        $this->request = $registry->get('request');
        $this->session = $registry->get('session');

        if (isset($this->session->data['user_id'])) {
            $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int) $this->session->data['user_id'] . "' AND status = '1'");

            if ($user_query->num_rows) {
                $this->user_id = $user_query->row['user_id'];
                $this->username = $user_query->row['username'];
                $this->user_group_id = $user_query->row['user_group_id'];
                $this->user_view = $user_query->row['viewalldata'];
                //$this->user_edit = $user_query->row['editalldata'];

                $this->db->query("UPDATE " . DB_PREFIX . "user SET ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "' WHERE user_id = '" . (int) $this->session->data['user_id'] . "'");

                $user_group_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int) $user_query->row['user_group_id'] . "'");

                $permissions = json_decode($user_group_query->row['permission'], true);

                if (is_array($permissions)) {
                    foreach ($permissions as $key => $value) {
                        $this->permission[$key] = $value;
                    }

                    $user_permission_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_permission WHERE user_id = '" . (int) $user_query->row['user_id'] . "'");

                    $user_permissions = json_decode($user_permission_query->row['permission'], true);

                    if (is_array($user_permissions)) {
                        foreach ($user_permissions as $key => $value) {
                            $this->user_permissions[$key] = $value;
                        }
                    }
                }
            } else {
                $this->logout();
            }
        }
    }

    public function login($username, $password, $store_id) {
        $user_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE username = '" . $this->db->escape($username) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($password) . "'))))) OR password = '" . $this->db->escape(md5($password)) . "') AND status = '1'");

        if ($user_query->num_rows) {
            $store_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_to_store s  LEFT JOIN " . DB_PREFIX . "setting l ON (s.store_id = l.store_id) WHERE s.user_id = '" . (int) $user_query->row['user_id'] . "' AND s.store_id ='" . $store_id . "' AND l.key= 'config_language' ");

            if ($store_query->num_rows) {
                if (strtotime($user_query->row['periodto']) > strtotime(date("Y-m-d"))) {
                    $this->session->data['user_id'] = $user_query->row['user_id'];
                    $this->session->data['store_id'] = $store_query->row['store_id'];
                    $this->session->data['store_name'] = ' ';
                    $this->session->data['language'] = $store_query->row['value'];

                    $this->user_id = $user_query->row['user_id'];
                    $this->username = $user_query->row['username'];
                    $this->user_group_id = $user_query->row['user_group_id'];

                    $user_group_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = '" . (int) $user_query->row['user_group_id'] . "'");

                    $permissions = json_decode($user_group_query->row['permission'], true);

                    if (is_array($permissions)) {
                        foreach ($permissions as $key => $value) {
                            $this->permission[$key] = $value;
                        }
                    }

                    $user_permission_query = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_permission WHERE user_id = '" . (int) $user_query->row['user_id'] . "'");

                    $user_permissions = json_decode($user_permission_query->row['permission'], true);

                    if (is_array($user_permissions)) {
                        foreach ($user_permissions as $key => $value) {
                            $this->user_permissions[$key] = $value;
                        }
                    }

                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function customerLogin($id, $password) {
        $customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int) $id . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($password) . "'))))) OR password = '" . $this->db->escape(md5($password)) . "') AND status = '1' AND approved = '1'");

        if ($customer_query->num_rows) {
            return true;
        } else {
            return false;
        }
    }

    public function logout() {
        unset($this->session->data['user_id']);
        unset($this->session->data['store_id']);
        unset($this->session->data['store_name']);
        unset($this->session->data['store_language']);

        $this->user_id = '';
        $this->username = '';
    }

    public function hasPermission($key, $value) {
        if (isset($this->permission[$key])) {
            return in_array($value, $this->permission[$key]);
        } else {
            return false;
        }
    }

    public function userPermissions($key, $value) {
        if (isset($this->user_permissions[$key])) {
            return in_array($value, $this->user_permissions[$key]);
        } else {
            return false;
        }
    }

    public function isLogged() {
        return $this->user_id;
    }

    public function getId() {
        return $this->user_id;
    }

    public function getUserName() {
        return $this->username;
    }

    public function getGroupId() {
        return $this->user_group_id;
    }

}
