<?php
@date_default_timezone_get('UTC');
error_reporting(0);

$this->load->model('android/setting');
$this->load->model('android/user');


$this->load->library('obfuscate');
$this->load->library('api');


$language_str = isset($this->request->server['HTTP_ACCEPT_LANGUAGE']) ? $this->request->server['HTTP_ACCEPT_LANGUAGE'] : $this->config->get('config_language');
$this->session->data['language'] = ($language_str == 'cn' || $language_str == 'zh' || $language_str == 'zh-cn') ? 'zh-cn' : 'en-gb';
$language = strtolower($language_str) == 'en' ? 1 : 2;
$this->session->data['language_id'] = $language;


$token_info = $this->api->getTokenInfo();
if (!empty($token_info) && isset($token_info['store_id'])) {
    $this->session->data['store_id'] = $token_info['store_id'];
} else {
    $this->session->data['store_id'] = null;
}

if (!empty($token_info) && isset($token_info['user_id'])) {
    $this->session->data['user_id'] = $token_info['user_id'];
    //get user info
    $this->session->data['user_info'] = $this->model_android_user->getUserInfo($token_info['user_id']);
} else {
    $this->session->data['user_id'] = null;
    $this->session->data['user_info'] = array();
}
$this->s = $this->model_android_setting->getSetting('andassist');
$this->config->set('config_language_id', $this->model_android_setting->getlangugeId());

//check if API enabled
if (!isset($this->s['andassist_status'])) {
    $this->response->setResponse(400, array(), "API is disabled");
    return;
}

$request = $this->request->request;
$this->json = $this->api->get_php_input_json();


if (isset($request['call_function']) && strlen($request['call_function']) > 0) {
    $this->call_function = $request['call_function'];
}


if (!method_exists($this, $this->call_function)) {
    $this->response->setResponse(400, array(), "Method name $this->call_function not exist");
    return;
}

//temporary_save request

$this->session->data['tracking_id'] = $this->api->addTracking();


$reflection = new ReflectionMethod($this, $this->call_function);

if ($reflection->isProtected()) {
    if ($this->user_info = $this->api->checkAuth()) {
        call_user_func(array($this, $this->call_function));
    } else {
        return;
    }
} else {
    call_user_func(array($this, $this->call_function));
}
