<?php
class SMS{
	private $to;
	private $message;
	private $country_code;
	
	private $host;
	private $username;
	private $password;
	private $content_type;
	
	private $parameter;
	
	public function __construct($config){
		foreach($config as $key => $value) if($value) $this->$key = htmlspecialchars_decode($value);
	}
	
	public function sendTo($country_code,$to){
		$this->to = html_entity_decode($to, ENT_QUOTES, 'UTF-8');
		$this->country_code = html_entity_decode($country_code, ENT_QUOTES, 'UTF-8');
		return $this;
	}
	
	public function setMessage($message){
		$this->message = html_entity_decode($message, ENT_QUOTES, 'UTF-8');
		return $this;
	}

	public function convertUnicode($message){
		$this->message = rawurldecode($message);

		return $this;
	}

	public function changeContentType(){
		$this->content_type = 22;

		return $this;
	}
	
	public function send(){
		//data validation
		if(!$this->to) trigger_error('Error: SMS to required!');
		if(!$this->message) trigger_error('Error: SMS message required!');
		
		//multiple recipients
		$this->to = is_array($this->to) ? implode(',', $this->to) : $this->to;
		
		//build api url
		$sms = '';
		$host = $this->host;
		
		$find = array(
			'{username}',
			'{password}',
			'{country_code}',
			'{mobile_number}',
			'{content_type}',
			'{msg_text}'
		);
		
		$replace = array(
			'username' => $this->username,
			'password' => $this->password,
			'country_code' => $this->country_code,
			'mobile_number' => $this->to,
			'content_type' => $this->content_type,
			'msgtext' => rawurlencode($this->message)
		);
		
		$sms = str_replace($find, $replace, $host);
		
		//send
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $sms);
		curl_setopt($curl, CURLOPT_HEADER, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_exec($curl);
		curl_close($curl);
	}

	public function checkCredit(){
		// data validation
		if(!$this->host) trigger_error('Error: SMS check credit api required!');
		if(!$this->username) trigger_error('Error: SMS check credit username required!');
		if(!$this->password) trigger_error('Error: SMS check credit password required!');
		
		//build api url
		$sms_check_credit = '';
		$host = $this->host;
		
		$find = array(
			'{username}',
			'{password}'
		);
		
		$replace = array(
			'username'		=> $this->username,
			'password'		=> $this->password
		);
		
		$sms_check_credit = str_replace($find, $replace, $host);
		
		// start checking
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $sms_check_credit);
		curl_setopt($curl, CURLOPT_HEADER, 0);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		$result = curl_exec($curl);
		curl_close($curl);
		
		return $result;
	}
}
?>