<?php

/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
 */

/**
 * Response class
 */
class Response
{
	private $headers = array();
	private $level = 0;
	private $output;
	private $db;

	private $success_code = [200, 201, 204];
	/**
	 * Constructor
	 *
	 * @param	string	$header
	 *
	 */
	public function addHeader($header)
	{
		$this->headers[] = $header;
	}

	/**
	 * 
	 *
	 * @param	string	$url
	 * @param	int		$status
	 *
	 */
	public function redirect($url, $status = 302)
	{
		header('Location: ' . str_replace(array('&amp;', "\n", "\r"), array('&', '', ''), $url), true, $status);
		exit();
	}

	/**
	 * 
	 *
	 * @param	int		$level
	 */
	public function setCompression($level)
	{
		$this->level = $level;
	}

	/**
	 * 
	 *
	 * @return	array
	 */
	public function getOutput()
	{
		return $this->output;
	}

	/**
	 * 
	 *
	 * @param	string	$output
	 */
	public function setOutput($output)
	{
		$this->output = $output;
	}

	/**
	 * 
	 *
	 * @param	string	$data
	 * @param	int		$level
	 * 
	 * @return	string
	 */
	private function compress($data, $level = 0)
	{
		if (isset($_SERVER['HTTP_ACCEPT_ENCODING']) && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== false)) {
			$encoding = 'gzip';
		}

		if (isset($_SERVER['HTTP_ACCEPT_ENCODING']) && (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'x-gzip') !== false)) {
			$encoding = 'x-gzip';
		}

		if (!isset($encoding) || ($level < -1 || $level > 9)) {
			return $data;
		}

		if (!extension_loaded('zlib') || ini_get('zlib.output_compression')) {
			return $data;
		}

		if (headers_sent()) {
			return $data;
		}

		if (connection_status()) {
			return $data;
		}

		$this->addHeader('Content-Encoding: ' . $encoding);

		return gzencode($data, (int)$level);
	}

	/**
	 * 
	 */
	public function output()
	{
		if ($this->output) {
			$output = $this->level ? $this->compress($this->output, $this->level) : $this->output;

			if (!headers_sent()) {
				foreach ($this->headers as $header) {
					header($header, true);
				}
			}

			echo $output;
		}
	}

	//for API
	public function setResponse($code, $json = array(), $message = '')
	{


		$message = trim($message) ? $message : '';

		$error = in_array($code, $this->success_code) ? false : true;
		$output = array(
			'error'      => $error,
			'code'       => "$code",
			'message'    => $message,
			'response'   => $json
		);

		//temporay update response
		// $sql_track = "INSERT INTO `oc_temp_tracking` SET 
		// `response`='" . $this->db->escape(json_encode($output)) . "'
		// WHERE id ='" . (int)$this->session->data['tracking_id'] . "'";
		// $this->db->query($sql_track);

		$this->addHeader('Access-Control-Allow-Origin: *');
		$this->addHeader('Content-Type: application/json; charset=UTF-8');
		$this->addHeader('Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE');
		$this->addHeader('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
		if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			$this->addHeader('Accept-Language:' . $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		}
		$this->setOutput(json_encode($output));
		$output['headers'] = $this->headers;
		return $output;
	}

	public function setResponse2($code, $json = array(), $message = '', $api_group = false)
	{


		$message = trim($message) ? $message : '';
		$error = in_array($code, $this->success_code) ? false : true;
		$output = array(
			'error'      => $error,
			'code'       => "$code",
			'message'    => $message,
			'response'   => $json
		);

		if ($api_group) {
			$output['api_group'] = $api_group;
		}

		//temporay update response
		// $sql_track = "INSERT INTO `oc_temp_tracking` SET 
		// `response`='" . $this->db->escape(json_encode($output)) . "'
		// WHERE id ='" . (int)$this->session->data['tracking_id'] . "'";
		// $this->db->query($sql_track);

		$this->addHeader('Access-Control-Allow-Origin: *');
		$this->addHeader('Content-Type: application/json; charset=UTF-8');
		$this->addHeader('Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE');
		$this->addHeader('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
		if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			$this->addHeader('Accept-Language:' . $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		}
		$this->setOutput(json_encode($output));
		$output['headers'] = $this->headers;
		return $output;
	}

	public function setCachedResponse($code, $json = array(), $message = '', $api_group = false, $timeout = 2592000)
	{

		$message = trim($message) ? $message : '';
		$error = in_array($code, $this->success_code) ? false : true;
		$output = array(
			'error'      => $error,
			'code'       => "$code",
			'message'    => $message,
			'response'   => $json
		);
		if ($api_group) {
			$output['api_group'] = $api_group;
		}

		//temporay update response

		// $sql_track = "INSERT INTO `oc_temp_tracking` SET 
		// `response`='" . $this->db->escape(json_encode($output)) . "'
		// WHERE id ='" . (int)$this->session->data['tracking_id'] . "'";
		// $this->db->query($sql_track);

		$this->addHeader('Access-Control-Allow-Origin: *');
		$this->addHeader('Content-Type: application/json; charset=UTF-8');
		$this->addHeader('Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE');
		$this->addHeader('Cache-Control: max-age = ' . $timeout);
		$this->addHeader('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
		if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			$this->addHeader('Accept-Language:' . $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		}
		$this->setOutput(json_encode($output));
		$output['headers'] = $this->headers;
		return $output;
	}

	public function setCachedResponse2($code, $json = array(), $message = '', $api_group = false, $timeout = 2592000)
	{

		$message = trim($message) ? $message : '';
		$error = in_array($code, $this->success_code) ? false : true;
		$output = array(
			'error'      => $error,
			'code'       => "$code",
			'message'    => $message,
			'response'   => $json
		);
		if ($api_group) {
			$output['api_group'] = $api_group;
		}

		//temporay update response
		/*$registry = new Registry();
		$config = new Config();
        $config->load('default');
        $registry->set('config', $config);
		$db = new DB(DB_DRIVER, DB_HOSTNAME, DB_USERNAME, DB_PASSWORD, DB_DATABASE);
        $registry->set('db', $db);
        // Session
        $session = new Session($config->get('session_engine'), $registry);
        $registry->set('session', $session);
        
		$sql_track = "INSERT INTO `oc_temp_tracking` SET 
		`response`='" . $db->escape(json_encode($output)) . "'
		WHERE id ='" . (int)$session->data['tracking_id'] . "'";*/
		//$db->query($sql_track);

		$this->addHeader('Access-Control-Allow-Origin: *');
		$this->addHeader('Content-Type: application/json; charset=UTF-8');
		$this->addHeader('Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE');
		$this->addHeader('Cache-Control: max-age = ' . $timeout);
		$this->addHeader('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
		if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			$this->addHeader('Accept-Language:' . $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		}
		$this->setOutput(json_encode($output));
		$output['headers'] = $this->headers;
		return $output;
	}
	public function sendResponseNow($code, $json = array(), $message = '', $api_group = false, $timeout = 2592000)
	{
        ob_start();
		$message = trim($message) ? $message : '';
		$error = in_array($code, $this->success_code) ? false : true;
		$output = array(
			'error'      => $error,
			'code'       => "$code",
			'message'    => $message,
			'response'   => $json
		);
		if ($api_group) {
			$output['api_group'] = $api_group;
		}

		echo json_encode($output);
		$this->addHeader('Access-Control-Allow-Origin: *');
		$this->addHeader('Content-Type: application/json; charset=UTF-8');
		$this->addHeader('Access-Control-Allow-Methods: OPTIONS,GET,POST,PUT,DELETE');
		$this->addHeader('Cache-Control: max-age = ' . $timeout);
		$this->addHeader('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
		if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
			$this->addHeader('Accept-Language:' . $_SERVER['HTTP_ACCEPT_LANGUAGE']);
		}
		foreach($this->headers as $header){
			header($header);
		}
		header('Connection: close');
        header('Content-Length: ' . ob_get_length());
		ob_end_flush();
		@ob_flush();
		flush();
		fastcgi_finish_request();
		$output['headers'] = $this->headers;
		return $output;
	}

	public function noResponse()
	{
		return json_decode("{}");
	}
}
