<?php

class Purchase_receive {

    private $db;
    private $session;
    private $config;
    private $purchase_order_id = 0;
    private $products = array();

    public function __construct($registry) {
        $this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->config = $registry->get('config');

        if (!isset($this->session->data['purchase_receive'])) {
            $this->session->data['purchase_receive'] = array(
                'products' => array(),
                'purchase_order_id' => 0
            );
        } else {
            if (!isset($this->session->data['purchase_receive']['products']) || !is_array($this->session->data['purchase_receive']['products'])) {
                $this->session->data['purchase_receive']['products'] = array();
            }

            if (!isset($this->session->data['purchase_receive']['purchase_order_id'])) {
                $this->session->data['purchase_receive']['purchase_order_id'] = 0;
            }
        }
    }

    public function import($purchase_order_id) {
        $sql = "
		SELECT 
			*
		FROM " . DB_PREFIX . "purchase_order_product pop
		WHERE 1
		AND purchase_order_id = '" . (int)$purchase_order_id . "'
		";

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $this->session->data['purchase_receive']['purchase_order_id'] = $purchase_order_id;

            foreach ($query->rows as $product) {
                $this->add($product['product_id'], 0);
            }
        }

        return $this->getProducts();
    }

    public function importInvoice($invoice_prefix) {

        $sql = "
		SELECT pop.* ,
		(pop.quantity - (
		SELECT COALESCE(SUM(prp.quantity), 0)
		FROM " . DB_PREFIX . "purchase_receive_product prp
		LEFT JOIN " . DB_PREFIX . "purchase_receive pr
		ON prp.purchase_receive_id = pr.purchase_receive_id
		WHERE 1
		AND pr.purchase_order_id = po.purchase_order_id
		AND pr.order_status_id = '5'
		AND prp.product_id = pop.product_id
		))
		AS remain
		FROM " . DB_PREFIX . "purchase_order_product pop
		LEFT JOIN " . DB_PREFIX . "purchase_order po
		ON pop.purchase_order_id = po.purchase_order_id
		WHERE 1
		AND po.invoice_prefix = '" . $this->db->escape($invoice_prefix) . "'
		";

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $get_id_sql = "
			SELECT purchase_order_id
			FROM " . DB_PREFIX . "purchase_order po
			WHERE 1
			AND po.invoice_prefix = '" . $this->db->escape($invoice_prefix) . "'
			";
            $get_id_query = $this->db->query($get_id_sql);

            $this->session->data['purchase_receive']['purchase_order_id'] = $get_id_query->row['purchase_order_id'];

            foreach ($query->rows as $product) {
                $this->add($product['product_id'], $product['remain']);
            }
        }

        return $this->getProducts();
    }

    public function add($product_id, $quantity) {
        if (!isset($this->session->data['purchase_receive']['products'][$product_id]))
            $this->session->data['purchase_receive']['products'][$product_id] = $quantity;
        else
            $this->session->data['purchase_receive']['products'][$product_id] += $quantity;

        return $this->getProducts($product_id);
    }

    public function edit($product_id, $quantity) {
        if ($this->has($product_id)) {
            $this->session->data['purchase_receive']['products'][$product_id] = $quantity;
            return $this->getProducts($product_id);
        } else {
            return array();
        }
    }

    public function remove($product_id) {
        if ($this->has($product_id))
            unset($this->session->data['purchase_receive']['products'][$product_id]);

        return $product_id;
    }

    public function clear() {
        $this->session->data['purchase_receive'] = array(
            'products' => array(),
            'purchase_order_id' => 0
        );
    }

    public function getProducts($product_id = false) {
        $this->products = array();

        $language_id = $this->config->get('config_language_id');

        foreach ($this->session->data['purchase_receive']['products'] as $id => $quantity) {

            $sql = "
			SELECT
				p.product_id,
				p.code,
				p.model,
				pd.name,
				CASE WHEN (
					SELECT COUNT(*) 
					FROM " . DB_PREFIX . "purchase_order_product
					WHERE 1
					AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
					AND product_id = p.product_id
				) > 0 THEN (
					SELECT invoice_prefix 
					FROM " . DB_PREFIX . "purchase_order
					WHERE 1
					AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
				)
				ELSE '' END AS purchase_order,
				CASE WHEN (
					SELECT COUNT(*) 
					FROM " . DB_PREFIX . "purchase_order_product
					WHERE 1
					AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
					AND product_id = p.product_id
				) > 0 THEN (
					SELECT quantity 
					FROM " . DB_PREFIX . "purchase_order_product
					WHERE 1
					AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
					AND product_id = p.product_id
				)
				ELSE 0 END AS order_quantity,
				CASE WHEN (
					SELECT COUNT(*) 
					FROM " . DB_PREFIX . "purchase_order_product
					WHERE 1
					AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
					AND product_id = p.product_id
				) > 0 THEN (
					(
						SELECT quantity
						FROM " . DB_PREFIX . "purchase_order_product
						WHERE 1
						AND purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
						AND product_id = p.product_id
					) -
					(
						SELECT COALESCE(SUM(quantity), 0)
						FROM " . DB_PREFIX . "purchase_receive_product
						LEFT JOIN " . DB_PREFIX . "purchase_receive
						ON " . DB_PREFIX . "purchase_receive_product.purchase_receive_id = " . DB_PREFIX . "purchase_receive.purchase_receive_id
						WHERE 1
						AND " . DB_PREFIX . "purchase_receive.purchase_order_id = '" . (int)$this->session->data['purchase_receive']['purchase_order_id'] . "'
						AND " . DB_PREFIX . "purchase_receive.order_status_id = '5'
						AND product_id = p.product_id
					)
				) ELSE 0 END AS remain
			FROM " . DB_PREFIX . "product p
			LEFT JOIN " . DB_PREFIX . "product_description pd
			ON p.product_id = pd.product_id
			AND pd.language_id = '" . (int)$language_id . "'
			WHERE 1
			AND p.product_id = '" . $id . "
			ORDER BY purchase_order DESC'
			";

            $query = $this->db->query($sql);
            $product_info = $query->row;
            $remain = $product_info['remain'];

            //if($remain >  0){
            $this->products[$id] = array(
                'product_id' => $id,
                'name' => $product_info['model'],
                'code' => $product_info['code'],
                'quantity' => $quantity,
                'purchase_order' => $product_info['purchase_order'],
                'order_quantity' => $product_info['order_quantity'],
                'remain' => ($product_info['remain'] - $quantity) >= 0 ? $product_info['remain'] - $quantity : 0
            );
            //}
        }

        return ($product_id) ? isset($this->products[$product_id]) ? array($product_id => $this->products[$product_id]) : array() : $this->products;
    }

    public function totalProduct() {
        $quantity = 0;
        foreach ($this->getProducts() as $product)
            $quantity += $product['quantity'];
        return $quantity;
    }

    public function has($product_id) {
        return isset($this->session->data['purchase_receive']['products'][$product_id]);
    }

}
