<?php

class Purchase_order {

    private $config;
    private $db;
    private $session;
    private $tax;
    private $currency;
    private $products = array();
    private $product_group = array();
    private $cs_id = array();

    public function __construct($registry) {

        $this->config = $registry->get('config');
        $this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->tax = $registry->get('tax');
        $this->currency = $registry->get('currency');
        $this->currency->set($this->config->get('config_currency'));


        if (!isset($this->session->data['purchase_order']) || !is_array($this->session->data['purchase_order'])) {
            $this->session->data['purchase_order'] = array();
        }
    }

    public function add($product_id, $quantity, $custom_price = 0) {
        $this->products = array();

        if ($this->has($product_id)) {
            $this->session->data['purchase_order'][$product_id] = array(
                'quantity' => $quantity + $this->session->data['purchase_order'][$product_id]['quantity'],
                'custom_price' => number_format($custom_price, 2)
            );
        } else {
            $this->session->data['purchase_order'][$product_id] = array(
                'quantity' => $quantity,
                'custom_price' => number_format($custom_price, 2)
            );
        }

        return $this->getProducts($product_id);
    }

    public function addRange($ranges = array()) {
        $this->products = array();

        $store_id = $this->session->data['store_id'];

        $respond = array();

        $range_statement = '';

        $date_ranges = isset($ranges['date']) ? $ranges['date'] : array();
        $transaction_ranges = isset($ranges['transaction']) ? $ranges['transaction'] : array();

        if ($date_ranges || $transaction_ranges) {
            //$this->clear();

            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(sales_date) >= '" . $range['from'] . "' AND DATE(sales_date) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (invoice_prefix >= '" . $range['from'] . "' AND invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $sql = "
			SELECT
				csp.product_id,
				SUM(csp.quantity) as quantity
			FROM " . DB_PREFIX . "clinical_sale cs
			INNER JOIN " . DB_PREFIX . "clinicalsale_product csp
			ON cs.clinical_sale_id = csp.clinical_sale_id
			LEFT JOIN " . DB_PREFIX . "product p
			ON csp.product_id = p.product_id
			WHERE $range_statement
			AND cs.store_id = '" . (int) $store_id . "'
			GROUP BY csp.product_id
			";

            $query = $this->db->query($sql);

            foreach ($query->rows as $product) {
                $this->add($product['product_id'], $product['quantity']);

                $result = $this->getProducts($product['product_id']);
                $respond[$product['product_id']] = $result[$product['product_id']];
            }
        }

        return $respond;
    }

    public function addPosRange($ranges = array()) {
        $this->products = array();

        $store_id = $this->session->data['store_id'];

        $respond = array();

        $range_statement = '';

        $date_ranges = isset($ranges['date']) ? $ranges['date'] : array();
        $transaction_ranges = isset($ranges['transaction']) ? $ranges['transaction'] : array();

        if ($date_ranges || $transaction_ranges) {
            //$this->clear();

            foreach ($date_ranges as $range) {
                $range_statement .= " OR (DATE(o.date_added) >= '" . $range['from'] . "' AND DATE(o.date_added) <= '" . $range['to'] . "')";
            }

            foreach ($transaction_ranges as $range) {
                $range_statement .= " OR (o.invoice_prefix >= '" . $range['from'] . "' AND o.invoice_prefix <= '" . $range['to'] . "')";
            }

            $range_statement = substr($range_statement, 3, strlen($range_statement) - 3);

            $sql = "
			SELECT
				op.product_id,
				SUM(op.quantity) as quantity
			FROM " . DB_PREFIX . "order_product op
			LEFT JOIN " . DB_PREFIX . "order o
			ON op.order_id = o.order_id
			WHERE $range_statement
			AND o.store_id = '" . (int) $store_id . "'
			GROUP BY op.product_id
			";

            $query = $this->db->query($sql);

            foreach ($query->rows as $product) {
                $this->add($product['product_id'], $product['quantity']);

                $result = $this->getProducts($product['product_id']);
                $respond[$product['product_id']] = $result[$product['product_id']];
            }
        }

        return $respond;
    }

    public function edit($product_id, $quantity, $custom_price = NULL) {
        $this->products = array();

        $respond = false;
        if ($this->has($product_id)) {
            $this->session->data['purchase_order'][$product_id]['quantity'] = $quantity;
            if ($custom_price != NULL)
                $this->session->data['purchase_order'][$product_id]['custom_price'] = $custom_price;

            $respond = $this->getProducts($product_id);
        }

        return $this->getProducts($product_id);
    }

    public function editQuantity($product_id, $quantity) {
        $this->products = array();

        $respond = false;
        if ($this->has($product_id)) {
            $this->session->data['purchase_order'][$product_id]['quantity'] = $quantity;

            $respond = $this->getProducts($product_id);
        }

        return $this->getProducts($product_id);
    }

    public function editPrice($product_id, $custom_price) {
        $this->products = array();

        $respond = false;
        if ($this->has($product_id)) {
            $this->session->data['purchase_order'][$product_id]['custom_price'] = $custom_price;

            $respond = $this->getProducts($product_id);
        }

        return $this->getProducts($product_id);
    }

    public function remove($product_id) {
        if ($this->has($product_id)) {
            unset($this->session->data['purchase_order'][$product_id]);

            return $product_id;
        } else {
            return 0;
        }
    }

    public function clear() {
        $this->session->data['purchase_order'] = array();
    }

    public function getProducts($product_id = false) {

        $language_id = !empty($this->session->data['language_id']) ? $this->session->data['language_id'] : $this->config->get('config_language_id');

        if (!$this->products) {
            foreach ($this->session->data['purchase_order'] as $id => $product) {
                $sql = "
				SELECT 
					*
				FROM " . DB_PREFIX . "product p 
				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON p.product_id = pd.product_id
				WHERE 1
				AND p.product_id = '" . (int) $id . "'
				AND pd.language_id = '" . (int) $language_id . "'
				";


                $query = $this->db->query($sql);
                $product_result = $query->row;
                if (!empty($product_result)) {
                    $custom_price = $product['custom_price'];
                    $amount = $custom_price * $product['quantity'];

                    $tax_class_id = $product_result['tax_class_id'];
                    $tax_data = $this->tax->calculateTax($amount, $tax_class_id, $this->config->get('config_tax'));

                    if (!empty($id)) {
                        $this->products[$id] = array(
                            'name' => $product_result['model'],
                            'code' => $product_result['code'],
                            'model' => $product_result['model'],
                            'tax_class_id' => $tax_class_id,
                            'tax_format' => $tax_data['format'],
                            'tax_code' => $this->tax->getClassCode($tax_class_id),
                            'tax' => $tax_data['tax'],
                            'formatted_tax' => $this->currency->format($tax_data['tax'], $this->config->get('config_currency')),
                            'costprice' => $product_result['costprice'],
                            'formatted_costprice' => $this->currency->format($product_result['costprice'], $this->config->get('config_currency')),
                            'price' => $product_result['price'],
                            'formatted_price' => $this->currency->format($product_result['price'], $this->config->get('config_currency')),
                            'custom_price' => $product['custom_price'],
                            'formatted_custom_price' => $this->currency->format($product['custom_price'], $this->config->get('config_currency')),
                            'quantity' => $product['quantity'],
                            'net_amount' => $tax_data['net_amount'],
                            'formatted_net_amount' => $this->currency->format($tax_data['net_amount'], $this->config->get('config_currency')),
                            'total' => $tax_data['total'],
                            'formatted_total' => $this->currency->format($tax_data['total'], $this->config->get('config_currency')),
                            'weight' => $product_result['weight'],
                            'weight_class_id' => $product_result['weight_class_id']
                        );
                    }
                }
            }
        }

        return !empty($this->products) ? $this->products : [];
    }

    public function has($product_id) {

        $products = $this->session->data['purchase_order'];

        return array_key_exists($product_id, $products);
    }

    public function totalProduct() {
        return count($this->getProducts());
    }

    public function getSubtotal() {
        $subtotal = 0;

        $products = $this->getProducts();

        foreach ($products as $id => $product) {
            $subtotal += $product['net_amount'];
        }

        return $subtotal;
    }

    public function getTaxes() {
        $tax_data = array();
        $products = $this->getProducts();
        foreach ($products as $id => $product) {
            $net_amount = $product['net_amount'];
            if ($product['tax_class_id']) {
                $tax_rates = $this->tax->getRates($net_amount, $product['tax_class_id']);
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                        $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
                    } else {
                        $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
                    }
                }
            } 
        }

        return $tax_data;
    }

    public function getTotal() {
        $total = 0;

        $products = $this->getProducts();

        foreach ($products as $id => $product) {
            $total += $product['total'];
        }

        return $total;
    }

}
