<?php

class Purchase_invoice {

    private $products = array();
    private $config;
    private $db;
    private $session;
    private $tax;
    private $currency;

    public function __construct($registry) {
        $this->config = $registry->get('config');
        $this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->tax = $registry->get('tax');
        $this->currency = $registry->get('currency');
        $this->currency->set($this->config->get('config_currency'));

        if (!isset($this->session->data['purchase_invoice']) || !is_array($this->session->data['purchase_invoice'])) {
            $this->session->data['purchase_invoice'] = array();
        }
    }

    public function importType($type, $purchase_order_id = 0) {
        $this->session->data['purchase_invoice']['info']['type'] = $type;
        $this->session->data['purchase_invoice']['info']['purchase_order_id'] = $purchase_order_id;
    }

    public function getImportType() {
        return $this->session->data['purchase_invoice']['info']['type'];
    }

    public function getPurchaseOrderId() {
        return $this->session->data['purchase_invoice']['info']['purchase_order_id'];
    }

    public function add($product_id, $quantity, $custom_price, $transaction_no = '') {
        $this->products = array();

        if ($this->has($product_id)) {
            $this->session->data['purchase_invoice']['products'][$product_id] = array(
                'quantity' => $quantity + $this->session->data['purchase_invoice']['products'][$product_id]['quantity'],
                'custom_price' => $custom_price,
                'transaction_no' => ($this->session->data['purchase_invoice']['products'][$product_id]['transaction_no']) ? $this->session->data['purchase_invoice']['products'][$product_id]['transaction_no'] : $transaction_no
            );
        } else {
            $this->session->data['purchase_invoice']['products'][$product_id] = array(
                'quantity' => $quantity,
                'custom_price' => $custom_price,
                'transaction_no' => $transaction_no
            );
        }

        return $this->getProducts($product_id);
    }

    public function edit($product_id, $quantity, $custom_price = NULL) {
        $this->products = array();

        $respond = false;
        if ($this->has($product_id)) {
            $this->session->data['purchase_invoice']['products'][$product_id]['quantity'] = $quantity;
            if ($custom_price != NULL)
                $this->session->data['purchase_invoice'][$product_id]['custom_price'] = $custom_price;

            $respond = $this->getProducts($product_id);
        }

        return $this->getProducts($product_id);
    }

    public function editQuantity($product_id, $quantity) {
        $this->products = array();

        $respond = false;

        if ($this->has($product_id)) {
            $this->session->data['purchase_invoice']['products'][$product_id]['quantity'] = $quantity;

            $respond = $this->getProducts($product_id);
        }

        return $respond;
    }

    public function editPrice($product_id, $custom_price) {
        $this->products = array();

        $respond = false;
        if ($this->has($product_id)) {
            $this->session->data['purchase_invoice']['products'][$product_id]['custom_price'] = $custom_price;

            $respond = $this->getProducts($product_id);
        }

        return $this->getProducts($product_id);
    }

    public function remove($product_id) {
        if ($this->has($product_id)) {
            unset($this->session->data['purchase_invoice']['products'][$product_id]);

            return $product_id;
        } else {
            return 0;
        }
    }

    public function removeCustomProduct($product_id) {
        unset($this->session->data['purchase_invoice']['custom_products'][$product_id]);
        return $product_id;
    }

    public function clear() {
        $this->session->data['purchase_invoice'] = array();
    }

    public function addCustomProduct($name, $price, $quantity, $subtotal, $tax_class_id, $tax, $total) {
        $this->session->data['purchase_invoice']['custom_products'][] = array(
            'name' => $name,
            'tax_class_id' => $tax_class_id,
            'custom_price' => $price,
            'quantity' => $quantity,
            'net_amount' => $subtotal,
            'tax' => $tax,
            'total' => $total
        );
    }

    public function getProducts($product_id = false) {
        $language_id = $this->config->get('config_language_id');
        $this->products = array();

        if (isset($this->session->data['purchase_invoice']['products'])) {
            foreach ($this->session->data['purchase_invoice']['products'] as $id => $product) {
                $sql = "
                SELECT 
                    p.*,
                    pd.name AS name,
                    '" . $this->db->escape($product['transaction_no']) . "' AS transaction_no
                FROM " . DB_PREFIX . "product p 
                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON p.product_id = pd.product_id
                WHERE 1
                AND p.product_id = '" . (int) $id . "'
                AND pd.language_id = '" . (int) $language_id . "'
                ";
    
                $query = $this->db->query($sql);
                $product_result = $query->row;
    
                $not_pay_quantity = '-';
    
                if ($this->getImportType() == 1) {
    
                    $have_pr = false;
                    $have_pr_sql = "
                    SELECT COUNT(*) AS have_pr
                    FROM " . DB_PREFIX . "purchase_receive pr
                    WHERE pr.purchase_order_id = '" . (int) $this->getPurchaseOrderId() . "'
                    ";
                    $have_pr_query = $this->db->query($have_pr_sql);
                    $have_pr = $have_pr_query->row['have_pr'] > 0;
    
                    if ($have_pr) {
                        //get total pr quantity
                        $pr_sql = "
                        SELECT SUM(prp.quantity) AS quantity
                        FROM " . DB_PREFIX . "purchase_receive_product prp
                        LEFT JOIN " . DB_PREFIX . "purchase_receive pr
                        ON prp.purchase_receive_id = pr.purchase_receive_id
                        WHERE 1
                        AND pr.order_status_id = '5'
                        AND pr.purchase_order_id = '" . (int) $this->getPurchaseOrderId() . "'
                        AND prp.product_id = '" . (int) $id . "'
                        ";
                        $pr_query = $this->db->query($pr_sql);
                        $pr_quantity = isset($pr_query->row['quantity']) ? $pr_query->row['quantity'] : 0;
    
                        //echo $pr_quantity . ' : ';
                        //get total pi quantity
                        $pi_sql = "
                        SELECT SUM(pid.quantity) AS quantity
                        FROM " . DB_PREFIX . "purchase_invoice_product pid
                        LEFT JOIN " . DB_PREFIX . "purchase_invoice pi
                        ON pid.purchase_invoice_id = pi.purchase_invoice_id
                        WHERE 1
                        AND pi.order_status_id = '5'
                        AND pi.purchase_order_id > 0
                        AND pi.purchase_order_id = '" . (int) $this->getPurchaseOrderId() . "'
                        AND pid.product_id = '" . (int) $id . "'
                        ";
                        $pi_query = $this->db->query($pi_sql);
                        $pi_quantity = isset($pi_query->row['quantity']) ? $pi_query->row['quantity'] : 0;
    
                        //not pay quantity
                        $not_pay_quantity = $pr_quantity - $pi_quantity;
                    } else {
                        $po_sql = "
                        SELECT pop.quantity
                        FROM " . DB_PREFIX . "purchase_order_product pop
                        LEFT JOIN " . DB_PREFIX . "purchase_order po
                        ON pop.purchase_order_id = po.purchase_order_id
                        WHERE 1
                        AND po.order_status_id = '5'
                        AND pop.purchase_order_id = '" . (int) $this->getPurchaseOrderId() . "'
                        AND pop.product_id = '" . (int) $id . "'
                        ";
                        $po_query = $this->db->query($po_sql);
                        $po_quantity = isset($po_query->row['quantity']) ? $po_query->row['quantity'] : 0;
    
                        $not_pay_quantity = $po_quantity;
                    }
                }
    
                $custom_price = $product['custom_price'];
                $amount = $custom_price * $product['quantity'];
    
                $tax_class_id = $product_result['tax_class_id'];
                $tax_data = $this->tax->calculateTax($amount, $tax_class_id, $this->config->get('config_tax'));
    
                if ($id) {
                    $this->products[$id] = array(
                        'is_custom'                 => false,
                        'type'                      => $this->getImportType(),
                        'name'                      => $product_result['model'],
                        'code'                      => $product_result['code'],
                        'model'                     => $product_result['model'],
                        'transaction_no'            => $product_result['transaction_no'],
                        'tax_class_id'              => $tax_class_id,
                        'tax_format'                => $tax_data['format'],
                        'tax_code'                  => $this->tax->getClassCode($tax_class_id),
                        'tax'                       => $tax_data['tax'],
                        'formatted_tax'             => $this->currency->format($tax_data['tax'], $this->config->get('config_currency')),
                        'costprice'                 => $product_result['costprice'],
                        'formatted_costprice'       => $this->currency->format($product_result['costprice'], $this->config->get('config_currency')),
                        'price'                     => $product_result['price'],
                        'formatted_price'           => $this->currency->format($product_result['price'], $this->config->get('config_currency')),
                        'custom_price'              => $product['custom_price'],
                        'formatted_custom_price'    => $this->currency->format($product['custom_price'], $this->config->get('config_currency')),
                        'not_pay_quantity'          => $not_pay_quantity,
                        'quantity'                  => $product['quantity'],
                        'net_amount'                => $tax_data['net_amount'],
                        'formatted_net_amount'      => $this->currency->format($tax_data['net_amount'], $this->config->get('config_currency')),
                        'total'                     => $tax_data['total'],
                        'formatted_total'           => $this->currency->format($tax_data['total'], $this->config->get('config_currency')),
                        'weight'                    => $product_result['weight'],
                        'weight_class_id'           => $product_result['weight_class_id']
                    );
                }
            }
        } 

        if (isset($this->session->data['purchase_invoice']['custom_products'])) {
            foreach ($this->session->data['purchase_invoice']['custom_products'] as $index => $product) {
                $custom_price = $product['custom_price'];
                $amount = $custom_price;
    
                $tax_class_id = $product['tax_class_id'];
                $tax_data = $this->tax->calculateTax($amount, $tax_class_id, $this->config->get('config_tax'));
    
                $this->products['custom' . $index] = array(
                    'is_custom'                 => true,
                    'index'                     => $index,
                    'name'                      => $product['name'],
                    'code'                      => $product['name'],
                    'transaction_no'            => '',
                    'tax_class_id'              => $tax_class_id,
                    'tax_format'                => $tax_data['format'],
                    'tax_code'                  => $this->tax->getClassCode($tax_class_id),
                    'tax'                       => $product['tax'],
                    'formatted_tax'             => $this->currency->format($product['tax']),
                    'custom_price'              => $product['custom_price'],
                    'formatted_custom_price'    => $this->currency->format($product['custom_price']),
                    'not_pay_quantity'          => '-',
                    'quantity'                  => $product['quantity'],
                    'net_amount'                => $product['net_amount'],
                    'formatted_net_amount'      => $this->currency->format($product['net_amount']),
                    'total'                     => $product['total'],
                    'formatted_total'           => $this->currency->format($product['total'])
                );
            }
        }
        
        return $product_id ? array($product_id => $this->products[$product_id]) : $this->products;
    }

    public function has($product_id) {
        $products = isset($this->session->data['purchase_invoice']['products']) ? $this->session->data['purchase_invoice']['products'] : [];
        return array_key_exists($product_id, $products);
    }

    public function totalProduct() {
        return count($this->getProducts());
    }

    public function getSubtotal() {
        $subtotal = 0;

        $products = $this->getProducts();

        foreach ($products as $id => $product) {
            $subtotal += $product['net_amount'];
        }

        return $subtotal;
    }

    public function getTaxes() {
        $tax_data = array();

        foreach ($this->getProducts() as $id => $product) {
            $net_amount = $product['net_amount'];

            if ($product['tax_class_id']) {
                $tax_rates = $this->tax->getRates($net_amount, $product['tax_class_id']);

                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                        $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
                    } else {
                        $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
                    }
                }
            }
        }

        return $tax_data;
    }

    public function getTotal() {
        $total = 0;

        $products = $this->getProducts();

        foreach ($products as $id => $product) {
            $total += $product['total'];
        }

        return $total;
    }

}
