<?php
class Pos_cart
{
	private $config;
	private $db;
	private $data     	   = array();
	private $service  	   = array();
	private $herbal   	   = array();
	private $brewing  	   = array();
	private $brewing_order = array();
	//Constuctor
	public function __construct($registry)
	{
		$this->config = $registry->get('config');
		$this->customer = $registry->get('customer');
		$this->session = $registry->get('session');
		$this->db = $registry->get('db');
		$this->tax = $registry->get('tax');
		$this->weight = $registry->get('weight');
		//Product
		if (!isset($this->session->data['cart']) || !is_array($this->session->data['cart'])) {
			$this->session->data['cart'] = array();
		}
		//Service
		if (!isset($this->session->data['service']) || !is_array($this->session->data['service'])) {
			$this->session->data['service'] = array();
		}
		//Herbal
		if (!isset($this->session->data['herbal']) || !is_array($this->session->data['herbal'])) {
			$this->session->data['herbal'] = array();
		}
		//Brewing
		if (!isset($this->session->data['brewing']) || !is_array($this->session->data['brewing'])) {
			$this->session->data['brewing'] = array();
		}
		//Brewing Order
		if (!isset($this->session->data['brewing_order']) || !is_array($this->session->data['brewing_order'])) {
			$this->session->data['brewing_order'] = array();
		}
	}
	//Get Products
	public function getProducts()
	{
		if (!$this->data) {
			foreach ($this->session->data['cart'] as $key => $quantity) {
				$product = unserialize(base64_decode($key));
				$product_id = $product['product_id'];
				$stock = true;
				// Options
				if (!empty($product['option'])) {
					$options = $product['option'];
				} else {
					$options = array();
				}
				// Profile
				if (!empty($product['recurring_id'])) {
					$recurring_id = $product['recurring_id'];
				} else {
					$recurring_id = 0;
				}
				//Get Product
				$product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int)$product_id . "' AND pd.language_id = '" . (int)$this->config->get('config_language_id') . "' AND p.date_available <= NOW() AND p.internal_status = '1'");
				if ($product_query->num_rows) {
					$option_price = 0;
					$option_points = 0;
					$option_weight = 0;
					$option_data = array();
					//Get Options
					foreach ($options as $product_option_id => $value) {
						$option_query = $this->db->query("SELECT po.product_option_id, po.option_id, od.name, o.type FROM " . DB_PREFIX . "product_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.product_option_id = '" . (int)$product_option_id . "' AND po.product_id = '" . (int)$product_id . "' AND od.language_id = '" . (int)$this->config->get('config_language_id') . "'");
						//Check Options
						if ($option_query->num_rows) {
							if ($option_query->row['type'] == 'select' || $option_query->row['type'] == 'radio' || $option_query->row['type'] == 'image') {
								$option_value_query = $this->db->query("SELECT pov.option_value_id, ovd.name, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int)$value . "' AND pov.product_option_id = '" . (int)$product_option_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
								if ($option_value_query->num_rows) {
									if ($option_value_query->row['price_prefix'] == '+') {
										$option_price += $option_value_query->row['price'];
									} elseif ($option_value_query->row['price_prefix'] == '-') {
										$option_price -= $option_value_query->row['price'];
									}

									if ($option_value_query->row['points_prefix'] == '+') {
										$option_points += $option_value_query->row['points'];
									} elseif ($option_value_query->row['points_prefix'] == '-') {
										$option_points -= $option_value_query->row['points'];
									}

									if ($option_value_query->row['weight_prefix'] == '+') {
										$option_weight += $option_value_query->row['weight'];
									} elseif ($option_value_query->row['weight_prefix'] == '-') {
										$option_weight -= $option_value_query->row['weight'];
									}

									if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $quantity))) {
										$stock = false;
									}
									//Option data
									$option_data[] = array(
										'product_option_id'       => $product_option_id,
										'product_option_value_id' => $value,
										'option_id'               => $option_query->row['option_id'],
										'option_value_id'         => $option_value_query->row['option_value_id'],
										'name'                    => $option_query->row['name'],
										'value'                   => $option_value_query->row['name'],
										'type'                    => $option_query->row['type'],
										'quantity'                => $option_value_query->row['quantity'],
										'subtract'                => $option_value_query->row['subtract'],
										'price'                   => $option_value_query->row['price'],
										'price_prefix'            => $option_value_query->row['price_prefix'],
										'points'                  => $option_value_query->row['points'],
										'points_prefix'           => $option_value_query->row['points_prefix'],
										'weight'                  => $option_value_query->row['weight'],
										'weight_prefix'           => $option_value_query->row['weight_prefix']
									);
								}
							} elseif ($option_query->row['type'] == 'checkbox' && is_array($value)) {
								foreach ($value as $product_option_value_id) {
									$option_value_query = $this->db->query("SELECT pov.option_value_id, ovd.name, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int)$product_option_value_id . "' AND pov.product_option_id = '" . (int)$product_option_id . "' AND ovd.language_id = '" . (int)$this->config->get('config_language_id') . "'");

									if ($option_value_query->num_rows) {
										if ($option_value_query->row['price_prefix'] == '+') {
											$option_price += $option_value_query->row['price'];
										} elseif ($option_value_query->row['price_prefix'] == '-') {
											$option_price -= $option_value_query->row['price'];
										}

										if ($option_value_query->row['points_prefix'] == '+') {
											$option_points += $option_value_query->row['points'];
										} elseif ($option_value_query->row['points_prefix'] == '-') {
											$option_points -= $option_value_query->row['points'];
										}

										if ($option_value_query->row['weight_prefix'] == '+') {
											$option_weight += $option_value_query->row['weight'];
										} elseif ($option_value_query->row['weight_prefix'] == '-') {
											$option_weight -= $option_value_query->row['weight'];
										}

										if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $quantity))) {
											$stock = false;
										}

										$option_data[] = array(
											'product_option_id'       => $product_option_id,
											'product_option_value_id' => $product_option_value_id,
											'option_id'               => $option_query->row['option_id'],
											'option_value_id'         => $option_value_query->row['option_value_id'],
											'name'                    => $option_query->row['name'],
											'value'                   => $option_value_query->row['name'],
											'type'                    => $option_query->row['type'],
											'quantity'                => $option_value_query->row['quantity'],
											'subtract'                => $option_value_query->row['subtract'],
											'price'                   => $option_value_query->row['price'],
											'price_prefix'            => $option_value_query->row['price_prefix'],
											'points'                  => $option_value_query->row['points'],
											'points_prefix'           => $option_value_query->row['points_prefix'],
											'weight'                  => $option_value_query->row['weight'],
											'weight_prefix'           => $option_value_query->row['weight_prefix']
										);
									}
								}
							} elseif ($option_query->row['type'] == 'text' || $option_query->row['type'] == 'textarea' || $option_query->row['type'] == 'file' || $option_query->row['type'] == 'date' || $option_query->row['type'] == 'datetime' || $option_query->row['type'] == 'time') {
								$option_data[] = array(
									'product_option_id'       => $product_option_id,
									'product_option_value_id' => '',
									'option_id'               => $option_query->row['option_id'],
									'option_value_id'         => '',
									'name'                    => $option_query->row['name'],
									'value'                   => $value,
									'type'                    => $option_query->row['type'],
									'quantity'                => '',
									'subtract'                => '',
									'price'                   => '',
									'price_prefix'            => '',
									'points'                  => '',
									'points_prefix'           => '',
									'weight'                  => '',
									'weight_prefix'           => ''
								);
							}
						}
					}
					//Customer Group ID
					if (!empty($this->session->data['customer_group_id'])) {
						$customer_group_id = $this->session->data['customer_group_id'];
					} else if ($this->customer->isLogged()) {
						$customer_group_id = $this->customer->getGroupId();
					} else {
						$customer_group_id = $this->config->get('config_customer_group_id');
					}

					$price = $product_query->row['price'];

					// Product Discounts
					$discount_quantity = 0;

					foreach ($this->session->data['cart'] as $key_2 => $quantity_2) {
						$product_2 = (array)unserialize(base64_decode($key_2));

						if ($product_2['product_id'] == $product_id) {
							$discount_quantity += $quantity_2;
						}
					}
					//Product Discounts
					$product_discount_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$customer_group_id . "' AND ((date_start = '0000-00-00' OR date_start <= CURDATE()) AND (date_end = '0000-00-00' OR date_end >= CURDATE())) ORDER BY quantity DESC, priority ASC, price ASC LIMIT 1");
					if ($product_discount_query->num_rows) {
						$price = $product_discount_query->row['price'];
					}
					// Product Specials
					$product_special_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$customer_group_id . "' AND ((date_start = '0000-00-00' OR date_start <= CURDATE()) AND (date_end = '0000-00-00' OR date_end >= CURDATE())) ORDER BY priority ASC, price ASC LIMIT 1");
					if ($product_special_query->num_rows) {
						$price = $product_special_query->row['price'];
					}
					// Reward Points
					$product_reward_query = $this->db->query("SELECT points FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int)$product_id . "' AND customer_group_id = '" . (int)$customer_group_id . "'");
					if ($product_reward_query->num_rows) {
						$reward = $product_reward_query->row['points'];
					} else {
						$reward = 0;
					}
					// Downloads
					$download_data = array();
					$download_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download p2d LEFT JOIN " . DB_PREFIX . "download d ON (p2d.download_id = d.download_id) LEFT JOIN " . DB_PREFIX . "download_description dd ON (d.download_id = dd.download_id) WHERE p2d.product_id = '" . (int)$product_id . "' AND dd.language_id = '" . (int)$this->config->get('config_language_id') . "'");
					foreach ($download_query->rows as $download) {
						$download_data[] = array(
							'download_id' => $download['download_id'],
							'name'        => $download['name'],
							'filename'    => $download['filename'],
							'mask'        => $download['mask']
						);
					}
					//Check Stock
					if ($product_query->row['promotion'] == 1) {
						$promotion_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_promotion p WHERE p.product_id = '" . (int)$product_id . "'");
						if ($promotion_query->num_rows) {
							foreach ($promotion_query->rows as  $product) {
								$stock_qty = $this->getStock($product['promotion_product_id']);
								$product_weight = $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
								if (!$stock_qty || ($stock_qty[0]['onhand_quantity'] < ($product_weight * $product['quantity']) * $quantity)) {
									$stock = false;
									break;
								} else {
									$stock = true;
								}
							}
						} else {
							$stock = false;
						}
					} else {
						$stock_qty = $this->getStock($product_id);
						$product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));
						if (!$stock_qty[0]['onhand_quantity'] || ($stock_qty[0]['onhand_quantity'] < $product_weight * $quantity)) {
							$stock = false;
						}
					}
					//Recurring Product
					$recurring_query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "recurring` `p` JOIN `" . DB_PREFIX . "product_recurring` `pp` ON `pp`.`recurring_id` = `p`.`recurring_id` AND `pp`.`product_id` = " . (int)$product_query->row['product_id'] . " JOIN `" . DB_PREFIX . "recurring_description` `pd` ON `pd`.`recurring_id` = `p`.`recurring_id` AND `pd`.`language_id` = " . (int)$this->config->get('config_language_id') . " WHERE `pp`.`recurring_id` = " . (int)$recurring_id . " AND `status` = 1 AND `pp`.`customer_group_id` = " . (int)$this->config->get('config_customer_group_id'));
					if ($recurring_query->num_rows) {
						$recurring = array(
							'recurring_id'      => $recurring_id,
							'name'            => $recurring_query->row['name'],
							'frequency'       => $recurring_query->row['frequency'],
							'price'           => $recurring_query->row['price'],
							'cycle'           => $recurring_query->row['cycle'],
							'duration'        => $recurring_query->row['duration'],
							'trial'           => $recurring_query->row['trial_status'],
							'trial_frequency' => $recurring_query->row['trial_frequency'],
							'trial_price'     => $recurring_query->row['trial_price'],
							'trial_cycle'     => $recurring_query->row['trial_cycle'],
							'trial_duration'  => $recurring_query->row['trial_duration']
						);
					} else {
						$recurring = false;
					}
					$this->data[$key] = array(
						'key'             => $key,
						'product_id'      => $product_query->row['product_id'],
						'name'            => $product_query->row['name'],
						'code'            => $product_query->row['code'],
						'model'           => $product_query->row['model'],
						'shipping'        => $product_query->row['shipping'],
						'image'           => $product_query->row['image'],
						'option'          => $option_data,
						'download'        => $download_data,
						'quantity'        => $quantity,
						'minimum'         => $product_query->row['minimum'],
						'subtract'        => $product_query->row['subtract'],
						'stock'           => $stock,
						'unitprice'       => $product_query->row['price'],
						'price'           => ($price + $option_price),
						'total'           => ($price + $option_price) * $quantity,
						'reward'          => $reward * $quantity,
						'points'          => ($product_query->row['points'] ? ($product_query->row['points'] + $option_points) * $quantity : 0),
						'tax_class_id'    => $product_query->row['tax_class_id'],
						'weight'          => ($product_query->row['weight'] + $option_weight) * $quantity,
						'weight_class_id' => $product_query->row['weight_class_id'],
						'length'          => $product_query->row['length'],
						'width'           => $product_query->row['width'],
						'height'          => $product_query->row['height'],
						'length_class_id' => $product_query->row['length_class_id'],
						'recurring'       => $recurring
					);
				} else {
					$this->remove($key);
				}
			}
		}
		return $this->data;
	}
	//Get Service Data
	public function getServices()
	{
		if (!$this->service) {
			foreach ($this->session->data['service'] as $key => $quantity) {
				$service_id = $key;
				$service_query = $this->db->query("SELECT *,c.customer_ic FROM " . DB_PREFIX . "service_form sf  LEFT JOIN " . DB_PREFIX . "customer c ON (sf.customer_id = c.customer_id) WHERE sf.service_form_id = '" . (int)$service_id . "'");
				if ($service_query->num_rows) {
					$price = $service_query->row['total_price'];
					$this->service[$key] = array(
						'key'             => $key,
						'service_id'      => $service_query->row['service_form_id'],
						'name'            => 'Service',
						'invoice_prefix'  => $service_query->row['invoice_prefix'],
						'quantity'        => $quantity,
						'customer_ic'     => $service_query->row['customer_ic'],
						'unitprice'       => $service_query->row['net_amount'],
						'gst'             => $service_query->row['t_gst'],
						'price'           => $service_query->row['total_price'],
						'total'           => $service_query->row['total_price'],
						'reward'          => 0,
						'points'          => 0,
						'tax_class_id'    => 0,
					);
				} else {
					$this->removeService($key);
				}
			}
		}
		return $this->service;
	}
	//Get Brewing Data
	public function getBrewings()
	{
		if (!$this->brewing) {
			foreach ($this->session->data['brewing'] as $key => $quantity) {
				$brewing_id = $key;
				$brewing_query = $this->db->query("SELECT *, c.customer_ic FROM `" . DB_PREFIX . "herbal_transfer` ht LEFT JOIN  `" . DB_PREFIX . "customer` c ON ht.customer_id = c.customer_id WHERE 1 AND ht.herbal_transfer_id = '"  . (int)$brewing_id . "' AND ht.brew_type = '1' ");
				if ($brewing_query->num_rows) {
					$price = $brewing_query->row['t_total'];
					$this->brewing[$key] = array(
						'key'         	  => $key,
						'brewing_id'  	  => $brewing_query->row['herbal_transfer_id'],
						'name'		  	  => 'Brewing Service',
						'invoice_prefix'  => $brewing_query->row['tranfer_invoice'],
						'quantity'		  => $quantity,
						'customer_ic'	  => $brewing_query->row['customer_ic'],
						'unitprice'		  => $brewing_query->row['t_net'],
						'gst'			  => $brewing_query->row['t_gst'],
						'price'			  => $brewing_query->row['t_total'],
						/*'weight'		  => 0,
						'weight_class_id' => 0,*/
						'shipping_address_id' => 0,
						'total'			  => $brewing_query->row['t_total'],
						'reward'		  => 0,
						'points'		  => 0,
						'tax_class_id'	  => 0,
					);
				} else {
					$this->removeBrewing($key);
				}
			}
		}
		return $this->brewing;
	}
	//Get Brewing Data
	public function getBrewingOrders()
	{
		if (!$this->brewing_order) {
			foreach ($this->session->data['brewing_order'] as $key => $quantity) {
				$brewing_id = $key;
				$brewing_query = $this->db->query("SELECT *, c.customer_ic FROM `" . DB_PREFIX . "herbal_transfer` ht LEFT JOIN  `" . DB_PREFIX . "customer` c ON ht.from_store_customer_id = c.customer_id WHERE 1 AND ht.herbal_transfer_id = '"  . (int)$brewing_id . "' AND ht.brew_type = '0' ");
				if ($brewing_query->num_rows) {
					$price = $brewing_query->row['t_total'];
					$this->brewing_order[$key] = array(
						'key'         	  => $key,
						'brewing_id'  	  => $brewing_query->row['herbal_transfer_id'],
						'name'		  	  => 'Brewing Service Order',
						'invoice_prefix'  => $brewing_query->row['tranfer_invoice'],
						'quantity'		  => $quantity,
						'customer_ic'	  => $brewing_query->row['customer_ic'],
						'unitprice'		  => $brewing_query->row['t_net'],
						'gst'			  => $brewing_query->row['t_gst'],
						'price'			  => $brewing_query->row['t_total'],
						/*'weight'		  => 0,
						'weight_class_id' => 0,*/
						'shipping_address_id' => 0,
						'total'			  => $brewing_query->row['t_total'],
						'reward'		  => 0,
						'points'		  => 0,
						'tax_class_id'	  => 0,
					);
				} else {
					$this->removeBrewingOrder($key);
				}
			}
		}
		return $this->brewing_order;
	}
	//Get Herbal Data
	public function getHerbals()
	{
		if (!$this->herbal) {
			foreach ($this->session->data['herbal'] as $key => $quantity) {
				$herbal_id = $key;
				$herbal_query = $this->db->query("SELECT *,c.customer_ic, (SELECT cst.value FROM `" . DB_PREFIX . "clinical_sale_total` cst WHERE cst.code = 'total' AND cst.id = '2' AND cst.clinical_sale_id = cs.clinical_sale_id) AS cs_total FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id) WHERE cs.clinical_sale_id = '" . (int)$herbal_id . "'");
				if ($herbal_query->num_rows) {
					$price = $herbal_query->row['total_d_gst'];
					if ($herbal_query->row['collect_consultation_price'] == '1') {
						$price = $herbal_query->row['d_net_amount'];
						$unitprice = sprintf('%.2f', $price);
					} else {
						$unitprice = $herbal_query->row['clinicalsale_concultation'];
					}
					$this->herbal[$key] = array(
						'key'             => $key,
						'herbal_id'       => $herbal_query->row['clinical_sale_id'],
						'name'            => 'Herbal Remedies',
						'invoice_prefix'  => $herbal_query->row['invoice_prefix'],
						'quantity'        => $quantity,
						'customer_ic'     => $herbal_query->row['customer_ic'],
						// 'unitprice'       => $unitprice,
						'unitprice'      => $herbal_query->row['total'],
						'gst'             => $herbal_query->row['d_gst'],
						'price'           => $herbal_query->row['cs_total'],
						'weight'          => $herbal_query->row['weight'],
						'weight_class_id' => $herbal_query->row['weight_class_id'],
						'total'           => $herbal_query->row['cs_total'],
						'shipping_address_id' => $herbal_query->row['shipping_address_id'],
						'reward'          => 0,
						'points'          => 0,
						'tax_class_id'    => 0,
					);
				} else {
					$this->removeHerbal($key);
				}
			}
		}
		return $this->herbal;
	}
	//Check Product Stock
	public function getStock($product_id)
	{
		$stok_quantity = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store s WHERE s.product_id = '" . (int)$product_id . "' AND store_id = '" . (int)$this->session->data['store_id'] . "'");
		return $stok_quantity->rows;
	}
	//Get Recurring Product
	public function getRecurringProducts()
	{
		$recurring_products = array();
		foreach ($this->getProducts() as $key => $value) {
			if ($value['recurring']) {
				$recurring_products[$key] = $value;
			}
		}
		return $recurring_products;
	}
	//Check Product Stock
	public function checkStock($product_id, $quantity)
	{
		$stock = true;
		$product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p WHERE p.product_id = '" . (int)$product_id . "' AND p.date_available <= NOW() AND p.internal_status = '1'");
		if ($product_query->row) {
			if ($product_query->row['promotion'] == 1) {
				$promotion_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_promotion p WHERE p.product_id = '" . (int)$product_id . "'");
				if ($promotion_query->num_rows) {
					foreach ($promotion_query->rows as  $product) {
						$stock_qty = $this->getStock($product['promotion_product_id']);
						$product_weight = $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
						if (!$stock_qty || ($stock_qty[0]['onhand_quantity'] < ($product_weight * $product['quantity']) * $quantity)) {
							$stock = false;
							break;
						} else {
							$stock = true;
						}
					}
				} else {
					$stock = false;
				}
			} else {
				$stock_qty = $this->getStock($product_id);
				$product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));
				if (!$stock_qty[0]['onhand_quantity'] || ($stock_qty[0]['onhand_quantity'] < $product_weight * $quantity)) {
					$stock = false;
				}
			}
		} else {
			$stock = false;
		}
		return $stock;
	}
	//Clear all Products & Service in POS Cart
	public function clear()
	{
		$this->data = array();
		$this->session->data['cart']          = array();
		$this->session->data['service']       = array();
		$this->session->data['herbal']        = array();
		$this->session->data['brewing']	      = array();
		$this->session->data['brewing_order'] = array();
		unset($this->session->data['shipping_method']);
		unset($this->session->data['shipping_addres_id']);
		unset($this->session->data['customer_id']);
		unset($this->session->data['coupon']);
	}

	//Get Weight
	public function getWeight()
	{
		$weight = 0;
		//Product
		if ($this->getProducts()) {
			foreach ($this->getProducts() as $product) {
				if ($product['shipping']) {
					$weight += $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
				}
			}
		}
		//Brewing
		/*if ($this->getBrewings()) {
			foreach ($this->getBrewings() as $brewing) {
				$weight += $this->weight->convert($brewing['weight'], $brewing['weight_class_id'], $this->config->get('config_weight_class_id'));
			}
		}*/
		//Brewing Order
		/*if ($this->getBrewingOrders()) {
			foreach ($this->getBrewings() as $brewing_order) {
				$weight += $this->weight->convert($brewing_order['weight'], $brewing_order['weight_class_id'], $this->config->get('config_weight_class_id'));
			}
		}*/
		//Herbal
		if ($this->getHerbals()) {
			foreach ($this->getHerbals() as $herbal) {
				$weight += $this->weight->convert($herbal['weight'], $herbal['weight_class_id'], $this->config->get('config_weight_class_id'));
			}
		}
		return $weight;
	}
	//Get All Products & Services Subtotal/Net Amount in POS Cart
	public function getSubTotal()
	{
		$total = 0;
		//Product
		foreach ($this->getProducts() as $product) {
			$tax = $this->tax->getTax($product['price'], $product['tax_class_id']);
			if ($tax < 0) {
				$product['total'] =  $product['total'] + ($tax * $product['quantity']);
			}
			$total += $product['total'];
		}
		//Service
		foreach ($this->getServices() as $service) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int)$service['service_id'] . "' AND code='sub_total'");
			$service_total = !empty($query->row['value']) ?  $query->row['value'] : 0;
			$total += $service_total;
		}
		//Brewing
		foreach ($this->getBrewings() as $brewing) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE 1 AND ht.herbal_transfer_id = '" . (int)$brewing['brewing_id'] . "' AND ht.code = 'sub_total' AND ht.htt_id = '4' ");
			if (!empty($query->row['value'])) {
				$total += $query->row['value'];
			}
		}
		//Brewing Order
		foreach ($this->getBrewingOrders() as $brewing_order) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE ht.herbal_transfer_id = '" . (int)$brewing_order['brewing_id'] . "' AND ht.code = 'sub_total'");
			if (!empty($query->row['value'])) {
				$total += $query->row['value'];
			}
		}
		//Herbal
		foreach ($this->getHerbals() as $herbals) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int)$herbals['herbal_id'] . "' AND code='sub_total' AND id=2");
			$herbal_total = !empty($query->row['value']) ?  $query->row['value'] : 0;
			$total += $herbal_total;
		}
		return $total;
	}
	//Get All Products & Services Tax in POS Cart
	public function getTaxes()
	{
		$tax_data = array();
		//Product
		foreach ($this->getProducts() as $product) {
			if ($product['tax_class_id']) {
				$tax_rates = $this->tax->getRates($product['price'], $product['tax_class_id']);
				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
						$tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['quantity']);
					} else {
						$tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['quantity']);
					}
				}
			}
		}

		//Service
		foreach ($this->getServices() as $service) {
			$query = $this->db->query("SELECT tax_key,value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int)$service['service_id'] . "' AND code='tax'");
			$taxes = $query->rows;
			if ($taxes) {
				$tax_rates = $taxes;
				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_key']])) {
						$tax_data[$tax_rate['tax_key']]  =  $tax_rate['value'];
					} else {
						$tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
					}
				}
			}
		}
		//Brewing
		foreach ($this->getBrewings() as $brewing) {
			$query = $this->db->query("SELECT tax_key, value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE 1 AND ht.herbal_transfer_id = '" . (int)$brewing['brewing_id'] . "' AND ht.code = 'tax' AND ht.htt_id = '4'");
			$taxes = $query->rows;
			if ($taxes) {
				$tax_rates = $taxes;
				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_key']])) {
						$tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
					} else {
						$tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
					}
				}
			}
		}
		//Brewing Order
		foreach ($this->getBrewingOrders() as $brewing_order) {
			$query = $this->db->query("SELECT tax_key, value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE 1 AND ht.herbal_transfer_id = '" . (int)$brewing_order['brewing_id'] . "' AND ht.code = 'tax'");
			$taxes = $query->rows;
			if ($taxes) {
				$tax_rates = $taxes;
				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_key']])) {
						$tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
					} else {
						$tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
					}
				}
			}
		}
		//Herbal
		foreach ($this->getHerbals() as $herbals) {
			$query = $this->db->query("SELECT tax_key,value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int)$herbals['herbal_id'] . "' AND code='tax' AND id=2");
			$taxes = $query->rows;
			if ($taxes) {
				$tax_rates = $taxes;
				foreach ($tax_rates as $tax_rate) {
					if (!isset($tax_data[$tax_rate['tax_key']])) {
						$tax_data[$tax_rate['tax_key']]  =  $tax_rate['value'];
					} else {
						$tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
					}
				}
			}
		}
		return $tax_data;
	}
	//Get All Products & Services Total in POS Cart
	public function getTotal()
	{
		$total = 0;
		//Product
		foreach ($this->getProducts() as $product) {
			$total += $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'];
		}
		//Service
		foreach ($this->getServices() as $service) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int)$service['service_id'] . "' AND code='total'");
			$service_total = !empty($query->row['value']) ?  $query->row['value'] : 0;
			$total += $service_total;
		}
		//Herbal
		foreach ($this->getHerbals() as $herbals) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int)$herbals['herbal_id'] . "' AND code='total' AND id=2");
			$herbal_total = !empty($query->row['value']) ?  $query->row['value'] : 0;
			$total += $herbal_total;
		}
		//Brewing
		foreach ($this->getBrewings() as $brewing) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE ht.herbal_transfer_id = '" . (int)$brewing['brewing_id'] . "' AND ht.code = 'total' AND ht.htt_id = '4'");
			if (!empty($query->row['value'])) {
				$total += $query->row['value'];
			}
		}
		//Brewing Order
		foreach ($this->getBrewingOrders() as $brewing_order) {
			$query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE ht.herbal_transfer_id = '" . (int)$brewing_order['brewing_id'] . "' AND ht.code = 'total'");
			if (!empty($query->row['value'])) {
				$total += $query->row['value'];
			}
		}
		if (isset($this->session->data['rounding'])) {
			$total += $this->session->data['rounding'];
		}
		return $total;
	}
	//Get Points
	public function getpoints()
	{
		$points = 0;
		foreach ($this->getProducts() as $product) {
			$points += $product['points'];
		}
		return $points;
	}
	//Get Reward
	public function getreward()
	{
		$reward = 0;
		foreach ($this->getProducts() as $product) {
			$reward += $product['reward'];
		}
		return $reward;
	}
	//Count Product In POS Cart
	public function countProducts()
	{
		$product_total = 0;
		$products = $this->getProducts();
		foreach ($products as $product) {
			$product_total += $product['quantity'];
		}
		return $product_total;
	}
	//Check Product In POS cart
	public function hasProducts()
	{
		return count($this->session->data['cart']);
	}
	//Has Recurring Products
	public function hasRecurringProducts()
	{
		return count($this->getRecurringProducts());
	}
	//Check Product Stock
	public function hasStock()
	{
		$stock = true;
		foreach ($this->getProducts() as $product) {
			if (!$product['stock']) {
				$stock = false;
			}
		}
		return $stock;
	}
	//Has Shipping
	public function hasShipping()
	{
		$shipping = false;
		foreach ($this->getProducts() as $product) {
			if ($product['shipping']) {
				$shipping = true;
				break;
			}
		}
		return $shipping;
	}
	//Has Download
	public function hasDownload()
	{
		$download = false;
		foreach ($this->getProducts() as $product) {
			if ($product['download']) {
				$download = true;
				break;
			}
		}
		return $download;
	}
	//Update Product
	public function update($key, $qty)
	{
		$this->data = array();
		if ((float)$qty && ((float)$qty > 0) && isset($this->session->data['cart'][$key])) {
			$this->session->data['cart'][$key] = (float)$qty;
		} else {
			$this->remove($key);
		}
	}
	//Add Product
	public function add($product_id, $qty = 1, $option = array(), $recurring_id = 0)
	{
		$this->data = array();
		$product['product_id'] = (int)$product_id;
		if ($option) {
			$product['option'] = $option;
		}
		if ($recurring_id) {
			$product['recurring_id'] = (int)$recurring_id;
		}
		$key = base64_encode(serialize($product));
		if ((float)$qty && ((float)$qty > 0)) {
			if (!isset($this->session->data['cart'][$key])) {
				$this->session->data['cart'][$key] = (float)$qty;
			} else {
				$this->session->data['cart'][$key] += (float)$qty;
			}
		}
		return $key;
	}
	//Add Service
	public function addService($service_id, $qty = 1)
	{
		$this->data = array();
		$service['service_id'] = (int)$service_id;
		$key = $service['service_id'];
		if ((int)$qty && ((int)$qty > 0)) {
			if (!isset($this->session->data['service'][$key])) {
				$this->session->data['service'][$key] = (int)$qty;
			}
		}
		return $key;
	}
	//Add Brewing
	public function addBrewing($brewing_id, $qty = 1)
	{
		$this->data = array();
		$brewing['brewing_id'] = (int)$brewing_id;
		$key = $brewing['brewing_id'];
		if ((int)$qty && ((int)$qty > 0)) {
			if (!isset($this->session->data['brewing'][$key])) {
				$this->session->data['brewing'][$key] = (int)$qty;
			}
		}
		return $key;
	}
	public function addBrewingOrder($brewing_id, $qty = 1)
	{
		$this->data = array();
		$brewing['brewing_order_id'] = (int)$brewing_id;
		$key = $brewing['brewing_order_id'];
		if ((int)$qty && ((int)$qty > 0)) {
			if (!isset($this->session->data['brewing_order'][$key])) {
				$this->session->data['brewing_order'][$key] = (int)$qty;
			}
		}
		return $key;
	}
	//Add Herbal
	public function addHerbal($herbal_id, $qty = 1)
	{
		$this->data = array();
		$service['herbal_id'] = (int)$herbal_id;
		$key = $service['herbal_id'];
		if ((int)$qty && ((int)$qty > 0)) {
			if (!isset($this->session->data['herbal'][$key])) {
				$this->session->data['herbal'][$key] = (int)$qty;
			}
		}
		return $key;
	}
	//Remove Product
	public function remove($key)
	{
		$this->data = array();
		unset($this->session->data['cart'][$key]);
	}
	//Remove Service
	public function removeService($key)
	{
		$this->data = array();
		unset($this->session->data['service'][$key]);
	}
	//Remove Brewing
	public function removeBrewing($key)
	{
		$this->data = array();
		unset($this->session->data['brewing'][$key]);
	}
	//Remove Brewing
	public function removeBrewingOrder($key)
	{
		$this->data = array();
		unset($this->session->data['brewing_order'][$key]);
	}
	//Remove Herbal
	public function removeHerbal($key)
	{
		$this->data = array();
		unset($this->session->data['herbal'][$key]);
	}
	//Clear Service
	public function clearService()
	{
		$this->data = array();
		unset($this->session->data['service']);
	}
	//Clear Herbal
	public function clearHerbal()
	{
		$this->data = array();

		unset($this->session->data['herbal']);
	}
	//Clear Brewing
	public function clearBrewing()
	{
		$this->data = array();
		unset($this->session->data['brewing']);
	}
	//Clear Brewing
	public function clearBrewingOrder()
	{
		$this->data = array();
		unset($this->session->data['brewing_order']);
	}
	//Add Customer Group ID
	public function addCustomerGroupId($customer_group_id)
	{
		if ($customer_group_id) {
			$this->session->data['customer_group_id'] = $customer_group_id;
		}
	}
	//Get Customer Group ID
	public function getCustomerGroupId()
	{
		$customer_group_id = $this->session->data['customer_group_id'];
		return $customer_group_id;
	}
}
