<?php  
class Obfuscate{

	public function __construct($registry){}

	public function encrypt($data, $key = SECURITY_API_KEY_PASS, $random = false){
		$data = is_array($data) ? serialize($data) : $data;

		$iv = !$random ? SECURITY_DEFAULT_IV : mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC), MCRYPT_DEV_URANDOM);

		$encrypted = base64_encode($iv . mcrypt_encrypt(
			MCRYPT_RIJNDAEL_128,
			hash(SECURITY_HASH_ALGO, $key, true),
			$data,
			MCRYPT_MODE_CBC,
			$iv
		));

		return $encrypted;
	}

	public function decrypt($encrypted, $key = SECURITY_API_KEY_PASS, $random = false){
		$encrypted = str_replace(' ', '+', $encrypted);

		$data = base64_decode($encrypted);
		$iv = !$random ? SECURITY_DEFAULT_IV : mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC), MCRYPT_DEV_URANDOM);

		$decrypted = rtrim(
		    mcrypt_decrypt(
		        MCRYPT_RIJNDAEL_128,
		        hash(SECURITY_HASH_ALGO, $key, true),
		        substr($data, mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC)),
		        MCRYPT_MODE_CBC,
		        $iv
		    ),
		    "\0"
		);

		$decrypted = @unserialize($decrypted) ? unserialize($decrypted) : $decrypted;

		return $decrypted;
	}


}
?>