<?php
class Notification{
    private $config;
    private $db;
    private $url;
    private $session;
    private $settings;

	public function __construct($registry){
        $this->config = $registry->get('config');
        $this->db = $registry->get('db');
        $this->url = $registry->get('url');
        $this->session = $registry->get('session');

        $notification_settings_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "notification_setting");
        $notification_settings = $notification_settings_query->rows;
        
        $data = [];
        if(!empty($notification_settings)){
            foreach($notification_settings as $setting){
                if($setting['serialized'] > 0){
                    $this->{$setting['setting_key']} = unserialize($setting['value']);
                } else{
                    $this->{$setting['setting_key']} = $setting['value'];
                }
            }
            
        }
    }

    public function add_notification($module_name, $data){
        $encoded_data = json_encode($data);

        $this->db->query("INSERT INTO " . DB_PREFIX . "notification SET module = '" . $this->db->escape($module_name) . "', notification_data = '" . $this->db->escape($encoded_data) . "', date_added = NOW()");

        return $this->db->getLastId();
    }

    public function get_notification_details($notification_id){
        $return_results = [];

        $notification_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "notification WHERE notification_id = '" . (int)$notification_id . "'");
        $notification_info = $notification_query->row;

        if(!empty($notification_info)){
            $module_name = $notification_info['module'];
            $notification_data = json_decode($notification_info['notification_data'], true);

            $return_results = $this->get_notification_string($module_name, $notification_data);
        }

        return $return_results;
    }

    public function timeAgoSecondsToText($seconds) {
        $time_ago_template = $this->time_ago_template;

		$template_language = $time_ago_template[$this->config->get('config_language_id')];

		$minutes = floor($seconds / 60);

		if ($minutes < 1) {
			$minutes = 1;
		}

		$hours   = floor($seconds / 60 / 60);
		$days    = floor($seconds / 60 / 60 / 24);

		if ($minutes <= 59) {
			return str_replace("{time_counter}", $minutes, $template_language['time_ago_minute']);
		} elseif ($hours <= 23) {
			return str_replace("{time_counter}", $hours, $template_language['time_ago_hour']);
		} else {
			return str_replace("{time_counter}", $days, $template_language['time_ago_day']);
		}
	}

    private function get_notification_string($module_name, $data){
        $return_results = [];

        if($module_name == 'new_appointment_notification'){
            $template_row = $this->new_appointment_notification_template;

            $find_message = [
                '{customer_name}',
                '{doctor_name}',
                '{appointment_date}',
                '{appointment_time}'
            ];

            $replace_message = [
                'customer_name'     => $data['customer_name'],
                'doctor_name'       => $data['doctor_name'],
                'appointment_date'  => $data['appointment_date'],
                'appointment_time'  => $data['appointment_time']
            ];

            $notification_url = $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $data['appointment_id'], true);
        } elseif($module_name == 'cancel_appointment_notification'){
            $template_row = $this->cancel_appointment_notification_template;

            $find_message = [
                '{customer_name}',
                '{appointment_date}'
            ];

            $replace_message = [
                'customer_name'     => $data['customer_name'],
                'appointment_date'  => $data['appointment_date']
            ];

            $notification_url = $this->url->link('appointment/appointment/view', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $data['appointment_id'], true);
        } elseif($module_name == 'reconfirm_appointment_notification'){
            $template_row = $this->reconfirm_appointment_notification_template;

            $find_message = [
                '{customer_name}',
                '{appointment_date}',
                '{appointment_time}'
            ];

            $replace_message = [
                'customer_name'     => $data['customer_name'],
                'appointment_date'  => $data['appointment_date'],
                'appointment_time'  => $data['appointment_time']
            ];

            $notification_url = $this->url->link('appointment/appointment/edit', 'user_token=' . $this->session->data['user_token'] . '&appointment_id=' . $data['appointment_id'], true);
        } elseif($module_name == 'new_service_form_notification'){
            $template_row = $this->new_service_form_notification_template;

            $find_message = [
                '{invoice_prefix}',
                '{customer_name}'
            ];

            $replace_message = [
                'invoice_prefix'    => $data['invoice_prefix'],
                'customer_name'     => $data['customer_name']
            ];

            $notification_url = $this->url->link('service/service_form/edit', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $data['serviceform_id'], true);
        } elseif($module_name == 'new_clinical_sale_notification'){
            $template_row = $this->new_clinical_sale_notification_template;

            $find_message = [
                '{invoice_prefix}',
                '{customer_name}'
            ];

            $replace_message = [
                'invoice_prefix'    => $data['invoice_prefix'],
                'customer_name'     => $data['customer_name']
            ];

            $notification_url = $this->url->link('herbal/new_herbal/edit', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $data['herbal_id'], true);
        }

        if(!empty($template_row)){
            $template_language = $template_row[$this->config->get('config_language_id')];
            $replaced_message = str_replace($find_message, $replace_message, $template_language['message']);

            $return_results = [
                'title'     => $template_language['title'],
                'message'   => $replaced_message,
                'url'       => str_replace('&amp;', '&', $notification_url)
            ];
        }

        return $return_results;
    }
}
?>
