<?php

class medical_record_cart
{
    private $db;
    private $config;
    private $prescription = array();
    private $service = array();
    private $acupuncture_list = array();
    private $medical_record_id = 0;

    public function __construct($registry)
    {
        $this->config = $registry->get('config');
        $this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->tax = $registry->get('tax');
        $this->weight = $registry->get('weight');

        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;

        //clear session as should load from DB
        unset($this->session->data['medical_record_id']);
        unset($this->session->data['clinical_sale_prescription']);
        unset($this->session->data['service']);
        unset($this->session->data['clinical_sale_products']);
        unset($this->session->data['acupuncture_list']);
        // set session based on DB session
        if ($device_id) {
            $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "medical_record_cart WHERE device_id='" . $this->db->escape($device_id) . "'");
            if (!empty($query->row['session_data'])) {
                $db_session = json_decode($query->row['session_data'], true);
                if (!empty($db_session)) {
                    foreach ($db_session as $key => $sessionDB) {
                        $this->session->data[$key] = $sessionDB;
                    }
                }
            } else {
            }
        }

        //initialized session if not set
        if (!empty($this->session->data['medical_record_id'])) {
            $this->medical_record_id = $this->session->data['medical_record_id'];
        }

        if (!isset($this->session->data['clinical_sale_prescription']) || !is_array($this->session->data['clinical_sale_prescription'])) {
            $this->session->data['clinical_sale_prescription'] = array();
        }

        if (!isset($this->session->data['service']) || !is_array($this->session->data['service'])) {
            $this->session->data['service'] = array();
        }

        if (!isset($this->session->data['clinical_sale_products']) || !is_array($this->session->data['clinical_sale_products'])) {
            $this->session->data['clinical_sale_products'] = array();
        }

        if (!isset($this->session->data['acupuncture_list']) || !is_array($this->session->data['acupuncture_list'])) {
            $this->session->data['acupuncture_list'] = array();
        }
    }

    public function saveSession()
    {
        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;
        if ($device_id) {
            $medical_record_id = !empty($this->session->data['medical_record_id']) ? $this->session->data['medical_record_id'] : 0;
            $clinical_sale_prescription = !empty($this->session->data['clinical_sale_prescription']) ? $this->session->data['clinical_sale_prescription'] : array();
            $clinical_sale_products = !empty($this->session->data['clinical_sale_products']) ? $this->session->data['clinical_sale_products'] : array();
            $service = !empty($this->session->data['service']) ? $this->session->data['service'] : array();
            $acupuncture_list = !empty($this->session->data['acupuncture_list']) ? $this->session->data['acupuncture_list'] : array();
            $session_data = array(
                "medical_record_id" => $medical_record_id,
                "clinical_sale_prescription" => $clinical_sale_prescription,
                "clinical_sale_products" => $clinical_sale_products,
                "service" => $service,
                "acupuncture_list" => $acupuncture_list,
            );
            $session_data = json_encode($session_data);
            $this->db->query("DELETE FROM " . DB_PREFIX . "medical_record_cart WHERE device_id='" . $this->db->escape($device_id) . "'");
            $this->db->query("INSERT INTO " . DB_PREFIX . "medical_record_cart SET
            device_id = '" . $this->db->escape($device_id) . "',
            session_data ='" . $this->db->escape($session_data) . "',
            added_by='" . (int)$this->session->data['user_id'] . "',
            date_added=NOW()
            ");
        }
    }

    public function updateDB()
    {
        if (!empty($this->session->data['medical_record_id'])) {
            $clinical_sale_id = $this->session->data['medical_record_id'];
            $arr_products = array();
            $arr_service = array();
            $arr_prescriptions = array();

            //start prescription
            $pres_no = 0;
            foreach ($this->getPrescription() as $prescription_id => $prescription) {
                $pres_no++;
                $name = $prescription['name'];
                if ($this->session->data['language_id'] == '1') {
                    $name = "Prescription " . $pres_no;
                } else {
                    $name = "处方  " . $pres_no;
                }
                // $arr_prescriptions[$prescription_id] = array(
                //     'key' => $prescription['key'],
                //     'name' => $name,
                //     'id' => $prescription['id'],
                //     'discount' => $prescription['discount'],
                //     'times' => $prescription['times'],
                //     'cook' => $prescription['cook'],
                //     'taketype' => $prescription['taketype'],
                //     'day' => $prescription['day'],
                //     'quantity' => $prescription['quantity']
                // );
                $arr_prescriptions[$prescription_id] = array(
                    'key' => $prescription['key'],
                    'id' => $prescription['id'],
                    'name' => $name,
                    'discount' => $prescription['discount'],
                    'day' => $prescription['day'],
                    'times' => $prescription['times'],
                    'cook' => $prescription['cook'],
                    'taketype' => $prescription['taketype'],
                    'quantity' => $prescription['quantity'],
                    'category_id' => $prescription['category_id'],
                    'dispense_code' => $prescription['dispense_code'],
                    'daily_dosage' => $prescription['daily_dosage'],
                    'contraindications' => $prescription['contraindications'],
                    'usage' => $prescription['usage'],
                    'remark' => $prescription['remark'],
                );

                foreach ($this->getProducts($prescription_id) as $key => $products) {

                    $price_discount = $products['price'] * $products['times'] * $products['quantity'] - $products['discount'];

                    $sub_tax = $this->tax->calculateTax($price_discount, $products['tax_class_id'], $this->config->get('config_tax'));
                    $total = $sub_tax['total'];
                    $tax = $sub_tax['tax'];
                    $subtotal = $sub_tax['net_amount'];

                    $product_weight = 0;
                    $product_tax = 0;
                    $product_subtotal = 0;
                    if ($products['weight'] > 0) {
                        $product_weight = ($products['weight'] / $products['quantity']) / $products['times'];
                    }
                    if ($subtotal > 0) {
                        $product_subtotal = ($subtotal / $products['quantity']) / $products['times'];
                    }
                    if ($tax > 0) {
                        $product_tax = ($tax / $products['quantity']) / $products['times'];
                    }

                    $arr_products[$prescription_id][] = array(
                        'product_id' => $products['product_id'],
                        'name' => $products['name'],
                        'code' => $products['code'],
                        'quantity' => $products['quantity'],
                        'times' => $products['times'],
                        'cook' => $products['cook'],
                        'taketype' => $products['taketype'],
                        'stock' => $products['stock'],
                        'day' => $products['day'],
                        'price' => $products['price'],
                        'discount' => $products['discount'],
                        'subtotal' => $subtotal,
                        'total' => $total,
                        'tax' => $tax,
                        'product_tax' => $product_tax,
                        'product_subtotal' => $product_subtotal,
                        'tax_class_id' => $products['tax_class_id'],
                        'tax_code' => $this->tax->has($products['tax_class_id']) ? $this->tax->getClassCode($products['tax_class_id']) : '',
                        'tax_format' => $sub_tax['format'],
                        'weight' => $products['weight'],
                        'product_weight' => $product_weight,
                        'weight_class_id' => $products['weight_class_id'],
                    );
                } //end products
            } //end prescription

            //start service
            foreach ($this->getService() as $key => $service) {
                $sub_tax = $this->tax->calculateTax($service['total'], $service['tax_class_id'], $this->config->get('config_tax'));
                $total = $sub_tax['total'];
                $tax = $sub_tax['tax'];
                $subtotal = $sub_tax['net_amount'];

                $arr_service[$key] = array(
                    'service_id' => $key,
                    'staff_id' => $service['staff_id'],
                    'staff_name' => $service['staff_name'],
                    'service_name' => $service['service_name'],
                    'service_minute' => $service['service_minute'],
                    'price' => $service['price'],
                    'subtotal' => $subtotal,
                    'total' => $total,
                    'net_total' => $sub_tax['net_amount'],
                    'total_whit_gst' => $sub_tax['net_amount'] + $sub_tax['tax'],
                    'tax' => $tax,
                    'net_tax' => $sub_tax['tax'],
                    'net_price' => $sub_tax['net_amount'],
                    'tax_class_id' => $service['tax_class_id'],
                    'tax_format' => $sub_tax['format'],
                    'tax_code' => $this->tax->getClassCode($service['tax_class_id'])
                );
            } //end service

            // if (!empty($arr_prescriptions)) {
            $this->savePrescriptions($arr_prescriptions, $arr_products, $clinical_sale_id);
            // }
            if ($this->allowEditService($clinical_sale_id)) {
                $this->saveServices($arr_service, $clinical_sale_id);
            }
        }
    }

    private function savePrescriptions($prescriptions, $dataProducts, $clinical_sale_id)
    {
        $product_total = 0;
        $product_tax = 0;
        $product_sutotal = 0;
        $total_times = 0;
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinicalsale_product WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");
        foreach ($prescriptions as $key => $item) {
            $sql_prescription = "INSERT INTO  " . DB_PREFIX . "clinecal_sales_prescription 
            SET 
            clinical_sale_id='" . (int) $clinical_sale_id . "', 
            prescription_id='" . $this->db->escape($item['id']) . "', 
            discount='" . (float)$item['discount'] . "', 
            name='" . $this->db->escape($item['name']) . "', 
            category_id='" . $this->db->escape($item['category_id']) . "', 
            times='" . (int)$item['times'] . "', 
            day='" . (int)$item['day'] . "', 
            taketype='" . $this->db->escape($item['taketype']) . "', 
            dispense_code='" . $this->db->escape($item['dispense_code']) . "', 
            daily_dosage='" . $this->db->escape($item['daily_dosage']) . "', 
            contraindications='" . $this->db->escape($item['contraindications']) . "', 
            medication_method='" . $this->db->escape($item['usage']) . "', 
            remark='" . $this->db->escape($item['remark']) . "', 
            modifi_by='" . (int) $this->session->data['user_id'] . "', 
            date_modified=NOW()";
            $this->db->query($sql_prescription);

            $prescription_id = $this->db->getLastId();
            if (!empty($dataProducts)) {
                foreach ($dataProducts[$key] as $product_id => $product) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "clinicalsale_product SET
                        clinical_sale_id = '" . (int) $clinical_sale_id . "',
                        product_id = '" . (int) $product['product_id'] . "',
                        prescription_id = '" . (int) $prescription_id . "',
                        quantity = '" . (float) $product['quantity'] . "',
                        times = '" . (int) $product['times'] . "',
                        price = '" . (float) $product['price'] . "',
                        day = '" . (int) $product['day'] . "',
                        t_qty = '" . (float) $product['quantity'] * (int) $product['times'] . "',
                        weight = '" . (float) $product['product_weight'] . "',
                        weight_class_id = '" . (int) $product['weight_class_id'] . "',
                        t_weight = '" . (float) $product['weight'] . "',
                        cook = '" . $this->db->escape($product['cook']) . "',
                        taketype = '" . $this->db->escape($product['taketype']) . "',
                        t_gst = '" . (float) $product['tax'] . "',
                        discount = '" . (float) $product['discount'] . "',
                        t_net_price = '" . (float) $product['subtotal'] . "',
                        tax_class_id = '" . (int) $product['tax_class_id'] . "',
                        tax_code = '" . $this->db->escape($product['tax_code']) . "',
                        tax_format = '" . $this->db->escape($product['tax_format']) . "',
                        gst = '" . (float) $product['product_tax'] . "',
                        net_price = '" . (float) $product['product_subtotal'] . "',
                        rowtotal = '" . (float) $product['total'] . "',
                        modifi_by = '" . (int) $this->session->data['user_id'] . "',
                        date_modified = NOW()");

                    $product_total += $product['total'];
                    $product_sutotal += $product['subtotal'];
                    $product_tax += $product['tax'];
                    $times = $product['times'];
                }
            }

            $total_times += $times;
            $per_time = $product['day'];
        }

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
            clinicalsale_total = '" . (float) $product_total . "',
            net_total = '" . (float) $product_sutotal . "',
            gst = '" . (float) $product_tax . "'
            WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");
    }

    private function saveServices($services, $clinical_sale_id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");
        foreach ($services as $key => $service) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_service_item SET
                  clinical_sale_id = '" . (int) $clinical_sale_id . "',
                  clinicalservice_id = '" . (int) $service['service_id'] . "',
                  staffincharge ='" . (int) $service['staff_id'] . "',
                  servicename ='" . $this->db->escape($service['service_name']) . "',
                  serviceminutes ='" . $this->db->escape($service['service_minute']) . "',
                  price = '" . (float) $service['price'] . "',
                  tax_class_id = '" . (int) $service['tax_class_id'] . "',
                  tax_code = '" . $this->db->escape($service['tax_code']) . "',
                  tax_format = '" . $this->db->escape($service['tax_format']) . "',
                  t_gst = '" . (float) $service['tax'] . "',
                  t_net_price = '" . (int) $service['subtotal'] . "',
                  gst = '" . $service['net_tax'] . "',
                  net_price = '" . (float) $service['net_price'] . "',
                  rowtotal = '" . (float) $service['total'] . "',
                  modifi_by = '" . (int) $this->session->data['user_id'] . "',
                  date_modified = NOW()");

            $clinecal_service_item_id = $this->db->getLastId();

            if (!empty($data['acupuncture_list'][$service['service_id']])) {
                $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize($data['acupuncture_list'][$service['service_id']])) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
            } else {
                $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize(array())) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
            }
        }
    }

    public function setMedicalRecordId($medical_record_id)
    {
        $this->session->data['medical_record_id'] = $medical_record_id;
        $this->saveSession();
    }

    public function clear()
    {
        unset($this->session->data['clinical_sale_prescription']);
        unset($this->session->data['clinical_sale_products']);
        unset($this->session->data['service']);
        $this->saveSession();
    }

    #region prescription
    public function removePrescription($key)
    {
        $this->prescription = array();
        unset($this->session->data['clinical_sale_prescription'][$key]);
        unset($this->session->data['clinical_sale_products'][$key]);
        $this->saveSession();
    }

    public function getPrescriptionKey()
    {
        if (!empty($this->session->data['clinical_sale_prescription'])) {
            foreach ($this->session->data['clinical_sale_prescription'] as $key => $value) {
            }
        } else {
            $key = 0;
        }
        return $key + 1;
    }

    public function addPrescription($data)
    {
        $key = !empty($data['key']) ? $data['key'] : 0;
        $name = !empty($data['name']) ? $data['name'] : '';
        $id = !empty($data['id']) ? $data['id'] : '';
        $times = !empty($data['times']) ? $data['times'] : 0;
        $day = !empty($data['day']) ? $data['day'] : 0;
        $usage = !empty($data['usage']) ? $data['usage'] : '';
        $cook = !empty($data['cook']) ? $data['cook'] : '';
        $taketype = !empty($data['taketype']) ? $data['taketype'] : '';
        $category_id = !empty($data['category_id']) ? $data['category_id'] : '';
        $discount = !empty($data['discount']) ? $data['discount'] : 0;
        $quantity = !empty($data['quantity']) ? $data['quantity'] : 0;
        $dispense_code = !empty($data['dispense_code']) ? $data['dispense_code'] : '';
        $daily_dosage = !empty($data['daily_dosage']) ? $data['daily_dosage'] : '';
        $contraindications = !empty($data['contraindications']) ? $data['contraindications'] : '';
        $remark = !empty($data['remark']) ? $data['remark'] : '';

        if (empty($key)) {
            $key = $this->getPrescriptionKey();
        }
        $this->session->data['clinical_sale_prescription'][$key]['name'] = $name;
        $this->session->data['clinical_sale_prescription'][$key]['id'] = $id;
        $this->session->data['clinical_sale_prescription'][$key]['discount'] = $discount;
        $this->session->data['clinical_sale_prescription'][$key]['times'] = $times;
        $this->session->data['clinical_sale_prescription'][$key]['day'] = $day;
        $this->session->data['clinical_sale_prescription'][$key]['usage'] = $usage;
        $this->session->data['clinical_sale_prescription'][$key]['cook'] = $cook;
        $this->session->data['clinical_sale_prescription'][$key]['taketype'] = $taketype;
        $this->session->data['clinical_sale_prescription'][$key]['quantity'] = $quantity;
        $this->session->data['clinical_sale_prescription'][$key]['category_id'] = $category_id;
        $this->session->data['clinical_sale_prescription'][$key]['dispense_code'] = $dispense_code;
        $this->session->data['clinical_sale_prescription'][$key]['daily_dosage'] = $daily_dosage;
        $this->session->data['clinical_sale_prescription'][$key]['contraindications'] = $contraindications;
        $this->session->data['clinical_sale_prescription'][$key]['remark'] = $remark;

        $this->saveSession();
        return $key;
    }

    public function updatePrescription($data, $saveSession = true)
    {
        $key = !empty($data['key']) ? $data['key'] : 0;
        $name = !empty($data['name']) ? $data['name'] : '';
        $id = !empty($data['id']) ? $data['id'] : '';
        $times = !empty($data['times']) ? $data['times'] : 0;
        $day = !empty($data['day']) ? $data['day'] : 0;
        $usage = !empty($data['usage']) ? $data['usage'] : '';
        $cook = !empty($data['cook']) ? $data['cook'] : '';
        $taketype = !empty($data['taketype']) ? $data['taketype'] : '';
        $taketype_name = $this->getTakeTypeName($taketype);
        $category_id = !empty($data['category_id']) ? $data['category_id'] : '';
        $discount = !empty($data['discount']) ? $data['discount'] : 0;
        $quantity = !empty($data['quantity']) ? $data['quantity'] : 0;
        $dispense_code = !empty($data['dispense_code']) ? $data['dispense_code'] : '';
        $daily_dosage = !empty($data['daily_dosage']) ? $data['daily_dosage'] : '';
        $contraindications = !empty($data['contraindications']) ? $data['contraindications'] : '';
        $remark = !empty($data['remark']) ? $data['remark'] : '';

        $current_dispense_code = $this->session->data['clinical_sale_prescription'][$key]['dispense_code'];

        $this->session->data['clinical_sale_prescription'][$key]['times'] = $times;
        $this->session->data['clinical_sale_prescription'][$key]['day'] = $day;
        $this->session->data['clinical_sale_prescription'][$key]['usage'] = $usage;
        $this->session->data['clinical_sale_prescription'][$key]['cook'] = $cook;
        $this->session->data['clinical_sale_prescription'][$key]['taketype'] = $taketype;
        $this->session->data['clinical_sale_prescription'][$key]['category_id'] = $category_id;
        $this->session->data['clinical_sale_prescription'][$key]['discount'] = $discount;
        $this->session->data['clinical_sale_prescription'][$key]['quantity'] = $quantity;
        $this->session->data['clinical_sale_prescription'][$key]['dispense_code'] = $dispense_code;
        $this->session->data['clinical_sale_prescription'][$key]['daily_dosage'] = $daily_dosage;
        $this->session->data['clinical_sale_prescription'][$key]['contraindications'] = $contraindications;
        $this->session->data['clinical_sale_prescription'][$key]['remark'] = $remark;

        foreach ($this->session->data['clinical_sale_products'][$key] as $product_id => $items) {
            $this->session->data['clinical_sale_products'][$key][$product_id]['times'] = $times;
            $this->session->data['clinical_sale_products'][$key][$product_id]['day'] = $day;
            $this->session->data['clinical_sale_products'][$key][$product_id]['cook'] = $cook;
            $this->session->data['clinical_sale_products'][$key][$product_id]['taketype'] = $taketype_name;
            $this->session->data['clinical_sale_products'][$key][$product_id]['discount'] = $discount;
        }

        //if dispense_code changed, evaluate product to convert
        if ($current_dispense_code != $dispense_code) {
            $this->convertProduct($key);
        }

        if ($saveSession) {
            $this->saveSession();
        }
    }



    public function getTakeTypeName($id)
    {
        $sql = "SELECT name FROM " . DB_PREFIX . "prescription_taketype_description WHERE language_id = '" . (int)$this->session->data['language_id'] . "'
        AND taketype_id = '" . (int)$id . "'
        ";
        $query = $this->db->query($sql);
        return !empty($query->row['name']) ? $query->row['name'] : '';
    }

    public function getPrescription($prescription_id = 0)
    {
        $prescription = array();
        if (!empty($this->session->data['clinical_sale_prescription'])) {
            foreach ($this->session->data['clinical_sale_prescription'] as $key => $items) {
                $prescription[$key] = array(
                    'key' => $key,
                    'id' => $items['id'],
                    'name' => $items['name'],
                    'discount' => $items['discount'],
                    'day' => $items['day'],
                    'times' => $items['times'],
                    'cook' => $items['cook'],
                    'taketype' => $items['taketype'],
                    'quantity' => $items['quantity'],
                    'category_id' => !empty($items['category_id']) ? $items['category_id'] : '',
                    'dispense_code' => !empty($items['dispense_code']) ? $items['dispense_code'] : '',
                    'daily_dosage' => !empty($items['daily_dosage']) ? $items['daily_dosage'] : '',
                    'contraindications' => !empty($items['contraindications']) ? $items['contraindications'] : '',
                    'usage' => $items['usage'],
                    'remark' => !empty($items['remark']) ? $items['remark'] : '',
                );
            }
        }
        if ($prescription_id) {
            return !empty($prescription[$prescription_id]) ? $prescription[$prescription_id] : [];
        } else {
            return $prescription;
        }
    }

    public function removePrescriptionName($prescription_id, $name)
    {
        if (!empty($this->session->data['clinical_sale_prescription'][$prescription_id])) {
            $prescription_name = $this->session->data['clinical_sale_prescription'][$prescription_id]['name'];
            /* if (($key = array_search($name, $prescription_name)) !== false) {
              unset($prescription_name[$key]);
              } */
            $this->session->data['clinical_sale_prescription'][$prescription_id]['name'] = $prescription_name;
            if (!empty($prescription_name) && !empty($name)) {
                $result = array_keys($prescription_name, $name);
                if (!empty($result)) {
                    foreach ($result as $r) {
                        unset($prescription_name[$r]);
                    }
                    $this->session->data['clinical_sale_prescription'][$prescription_id]['name'] = $prescription_name;
                }
                $prescription_name = $this->session->data['clinical_sale_prescription'][$prescription_id]['name'];
                if (!empty($prescription_name)) {
                    foreach ($prescription_name as $p => $pn) {
                        $final_name = explode(',', $pn);
                        if (!empty($final_name)) {
                            $result2 = array_keys($final_name, $name);
                            if (!empty($result2)) {
                                foreach ($result2 as $r2) {
                                    unset($final_name[$r2]);
                                }
                            }
                            $get_name = implode(',', $final_name);
                            $this->session->data['clinical_sale_prescription'][$prescription_id]['name'][$p] = $get_name;
                        }
                    }
                }
            }
        }
        $this->saveSession();
    }
    #endregion

    #region products

    public function addProduct($data, $saveSession = true)
    {
        $key = !empty($data['key']) ? $data['key'] : 0;
        $product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
        $quantity = !empty($data['quantity']) ? $data['quantity'] : 0;
        $times = !empty($data['times']) ? $data['times'] : 0;
        $day = !empty($data['day']) ? $data['day'] : 0;
        $price = !empty($data['price']) ? $data['price'] : 0;
        $cook = !empty($data['cook']) ? $data['cook'] : '';
        $taketype = !empty($data['taketype']) ? $data['taketype'] : '';
        $discount = !empty($data['discount']) ? $data['discount'] : 0;
        $usage = !empty($data['usage']) ? $data['usage'] : '';

        if (!isset($this->session->data['clinical_sale_products'][$key][$product_id])) {
            $this->session->data['clinical_sale_products'][$key][$product_id]['price'] = $price;
            $this->session->data['clinical_sale_products'][$key][$product_id]['discount'] = $discount;
            $this->session->data['clinical_sale_products'][$key][$product_id]['quantity'] = $quantity;
            $this->session->data['clinical_sale_products'][$key][$product_id]['times'] = $times;
            $this->session->data['clinical_sale_products'][$key][$product_id]['cook'] = $cook;
            $this->session->data['clinical_sale_products'][$key][$product_id]['taketype'] = $taketype;
            $this->session->data['clinical_sale_products'][$key][$product_id]['day'] = $day;
            $this->session->data['clinical_sale_products'][$key][$product_id]['usage'] = $usage;
        }
        if ($saveSession) {
            $this->saveSession();
        }
    }

    public function updateProduct($data, $saveSession = true)
    {
        $prescription_id = !empty($data['prescription_id']) ? $data['prescription_id'] : 0;
        $product_id = !empty($data['product_id']) ? $data['product_id'] : 0;
        if ($prescription_id && $product_id) {
            if (isset($this->session->data['clinical_sale_products'][$prescription_id][$product_id])) {
                if (!empty($data['price'])) {
                    $this->session->data['clinical_sale_products'][$prescription_id][$product_id]['price'] = $data['price'];
                }
                if (!empty($data['discount'])) {
                    $this->session->data['clinical_sale_products'][$prescription_id][$product_id]['discount'] = $data['discount'];
                }
                if (!empty($data['quantity'])) {
                    $this->session->data['clinical_sale_products'][$prescription_id][$product_id]['quantity'] = $data['quantity'];
                }
            }
        }
        if ($saveSession) {
            $this->saveSession();
        }
    }

    public function getProducts($prescription_id)
    {
        $products[$prescription_id] = array();

        if (isset($this->session->data['clinical_sale_products'][$prescription_id])) {
            $dispense_code = $this->session->data['clinical_sale_prescription'][$prescription_id]['dispense_code'];
            $dispense_info = $this->getDispenseInfo($dispense_code);
            foreach ($this->session->data['clinical_sale_products'][$prescription_id] as $key => $items) {
                $product_id = $key;
                $stock = true;

                // $checkProduct = $this->db->query("SELECT p.product_id FROM `" . DB_PREFIX . "product` p WHERE 1 AND p.product_id = '" . (int) $product_id . "' AND p.internal_status = '1'");

                // if (!empty($checkProduct->row['product_id'])) {
                $product_query = $this->db->query("SELECT p.*, pd.*,wcd.unit AS weight_class FROM " . DB_PREFIX . "product p 
                    LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) 
                    LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(p.weight_class_id=wcd.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "')
                    WHERE p.product_id = '" . (int) $product_id . "' AND pd.language_id = '" . (int) $this->session->data['language_id'] . "' AND p.date_available <= NOW() AND p.internal_status = '1'");

                if ($product_query->num_rows) {

                    $stock_qty = $this->getStock($product_id);
                    $product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));

                    if (!empty($stock_qty)) {
                        if (!$stock_qty['onhand_quantity'] || ($stock_qty['onhand_quantity'] < ($product_weight * $items['times']) * $items['quantity'])) {
                            $stock = false;
                        }
                    } else {
                        $stock = false;
                    }

                    //etcm_matched
                    $etcm_matched = true;
                    if ($dispense_code != '') {
                        if (substr($dispense_code, 0, 5) !== 'SELF_') {
                            $etcm_matched = $this->matchedEtcm($product_id);
                        }
                    }

                    //convert_matched
                    $convert_matched = true;
                    if (!empty($dispense_info['product_type'])) {
                        $convert_matched = $this->matchedConvert($product_id, $dispense_info['product_type']);
                    }

                    if (!empty($this->session->data['customer_group_id'])) {
                        $customer_group_id = $this->session->data['customer_group_id'];
                    } else {
                        $customer_group_id = $this->config->get('config_customer_group_id');
                    }

                    $price = $items['price'];

                    $products[$prescription_id][$product_id] = array(
                        'product_id' => $product_query->row['product_id'],
                        'name' => $product_query->row['name'],
                        'code' => $product_query->row['code'],
                        'quantity' => $items['quantity'],
                        'shipping' => $product_query->row['shipping'],
                        'times' => $items['times'],
                        'cook' => $items['cook'],
                        'taketype' => $items['taketype'],
                        'stock' => $stock,
                        'convert_matched' => $convert_matched,
                        'etcm_matched' => $etcm_matched,
                        'day' => $items['day'],
                        'usage' => $items['usage'],
                        'price' => $price,
                        'discount' => $items['discount'],
                        'total' => ($items['price'] * $items['quantity']) * $items['times'],
                        'tax_class_id' => $product_query->row['tax_class_id'],
                        'weight' => ($product_query->row['weight'] * $items['quantity']) * $items['times'],
                        'weight_class_id' => $product_query->row['weight_class_id'],
                        'weight_class' => $product_query->row['weight_class'],
                        'customer_group_id' => $customer_group_id,
                    );
                } else {
                    //$this->removeProduct($prescription_id,$key);
                }

                // }
            }
        }
        return $products[$prescription_id];
    }

    public function convertProduct($key)
    {
        $dispense_code = $this->session->data['clinical_sale_prescription'][$key]['dispense_code'];
        $dispense_info = $this->getDispenseInfo($dispense_code);
        if (!empty($dispense_info['product_type'])) {
            $products = !empty($this->session->data['clinical_sale_products'][$key]) ? $this->session->data['clinical_sale_products'][$key] : [];

            foreach ($products as $id => $product) {
                $product_id = $id;
                $prod_qty = $product['quantity'];

                if ($dispense_info['product_type'] == 'herbs') {
                    $convert_result = $this->ngpToHerbs($product_id, $prod_qty);
                }
                if ($dispense_info['product_type'] == 'granule') {
                    $convert_result = $this->herbsToNgp($product_id, $prod_qty);
                }

                if (!empty($convert_result)) {
                    if ($convert_result['product_id'] != $product_id) {
                        //add
                        $convert_result['quantity'];
                        $convert_result['price'];

                        $data = array(
                            "key" => $key,
                            "product_id" => $convert_result['product_id'],
                            "quantity" => $convert_result['quantity'],
                            "price" => $convert_result['price'],
                            "times" => $product['times'],
                            "day" => $product['day'],
                            "cook" => $product['cook'],
                            "taketype" => $product['taketype'],
                            "usage" => $product['usage'],
                        );
                        $this->addProduct($data, false);
                        //remove
                        $this->removeProduct($key, $product_id, false);
                    }
                }
            }
        }
    }

    public function checkNgpPrescription()
    {
        $quantity_changed = false;
        $prescriptions = $this->getPrescription();
        foreach ($prescriptions as $prescription) {
            if ($prescription['dispense_code'] == 'GRANULE' || $prescription['dispense_code'] == 'SELF_GRANULE') {
                $products = $this->getProducts($prescription['key']);
                $mixed_product = false;
                $total_weight = 0;
                foreach ($products as $product) {
                    if (!$product['convert_matched']) {
                        $mixed_product = true;
                        break;
                    }
                    $total_weight += ($product['quantity'] * $product['times']);
                }
                if (!$mixed_product) {
                    $total_box = ceil(($prescription['day'] * $prescription['times']) / 6);
                    if ($total_weight / $total_box > 120) {
                        $coefficient = ceil($total_weight / 120);
                        $quantity_changed = true;
                        $data = array(
                            "key"   => $prescription['key'],
                            "times" => ($prescription['times'] * $coefficient),
                            "day" => $prescription['day'],
                            "usage" => $prescription['usage'],
                            "cook" => $prescription['cook'],
                            "taketype" => $prescription['taketype'],
                            "category_id" => $prescription['category_id'],
                            "discount" => $prescription['discount'],
                            "quantity" => $prescription['quantity'],
                            "dispense_code" => $prescription['dispense_code'],
                            "daily_dosage" => $prescription['daily_dosage'],
                            "contraindications" => $prescription['contraindications'],
                            "remark" => $prescription['remark'],
                        );
                        $this->updatePrescription($data, false);
                        foreach ($products as $prod) {
                            $data_prod = [
                                "prescription_id" => $prescription['key'],
                                "product_id" => $prod['product_id'],
                                "quantity"  => ($prod['quantity'] / $coefficient)
                            ];
                            $this->updateProduct($data_prod, false);
                        }
                    }
                }
            }
        }
        if ($quantity_changed) {
            $this->saveSession();
            $this->updateDB();
        }
    }

    public function getDispenseInfo($code)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "medication_dispense WHERE dispense_code='" . $this->db->escape($code) . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function removeProduct($prescription_id, $key, $saveSession = true)
    {
        $this->data = array();
        $this->prescription = array();
        unset($this->session->data['clinical_sale_products'][$prescription_id][$key]);
        if (empty($this->session->data['clinical_sale_products'][$prescription_id])) {
            unset($this->session->data['clinical_sale_prescription'][$prescription_id]);
        }
        if ($saveSession) {
            $this->saveSession();
        }
    }

    public function removeUnmatchedProducts($prescription_id)
    {
        $products = $this->getProducts($prescription_id);
        foreach ($products as $product) {
            if ($product['convert_matched'] == false) {
                $this->removeProduct($prescription_id, $product['product_id'], false);
            }
            if ($product['etcm_matched'] == false) {
                $this->removeProduct($prescription_id, $product['product_id'], false);
            }
        }
        $this->saveSession();
    }

    public function getStock($product_id)
    {
        $stok_quantity = $this->db->query("SELECT SUM(s.onhand_quantity) as onhand_quantity FROM " . DB_PREFIX . "product_to_store s WHERE s.product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $this->session->data['store_id'] . "'");
        return $stok_quantity->row;
    }

    public function herbsToNgp($product_id, $herb_qty)
    {
        $sql = "SELECT np.product_id, p.price, np.compressscale FROM " . DB_PREFIX . "ngp_product np 
        LEFT JOIN " . DB_PREFIX . "product p ON(np.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "product_code_match pcm ON(pcm.drug_id = np.drug_id)
        WHERE pcm.drug_type = 'granule' AND pcm.status = '1' AND pcm.shelf_grid = '1' AND pcm.product_id = '" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $result = array(
                "product_id" => $query->row['product_id'],
                "quantity"  => ($herb_qty / $query->row['compressscale']),
                "price"     => $query->row['price']
            );
        } else {
            $result = [];
        }

        return $result;
    }

    public function ngpToHerbs($product_id, $herb_qty)
    {
        $sql = "SELECT pcm.product_id, p.price, np.compressscale FROM " . DB_PREFIX . "ngp_product np 
        LEFT JOIN " . DB_PREFIX . "product_code_match pcm ON(pcm.drug_id = np.drug_id)
        LEFT JOIN " . DB_PREFIX . "product p ON(pcm.product_id = p.product_id)
        WHERE pcm.drug_type = 'granule' 
        AND pcm.product_type = 'herbs'
        AND pcm.status = '1' 
        AND pcm.shelf_grid = '1' 
        AND np.product_id = '" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $result = array(
                "product_id" => $query->row['product_id'],
                "quantity"  => ($herb_qty * $query->row['compressscale']),
                "price"     => $query->row['price']
            );
        } else {
            $result = [];
        }

        return $result;
    }

    public function matchedEtcm($product_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "etcm_service_partner_product_match WHERE product_id='" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        return $query->num_rows ? true : false;
    }

    public function matchedConvert($product_id, $product_type)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "product_to_category ptc WHERE ptc.product_id = '" . (int)$product_id . "' AND ptc.category_id IN (SELECT DISTINCT(category_id) FROM " . DB_PREFIX . "product_code_match WHERE product_type='" . $this->db->escape($product_type) . "')";
        $query = $this->db->query($sql);
        return $query->num_rows ? true : false;
    }
    #endregion

    #region service
    public function setService($service_id, $staff_id, $price)
    {
        $this->service = array();
        $this->session->data['service'][$service_id] = array(
            'service_id' => $service_id,
            'staff_id' => $staff_id,
            'price' => $price
        );
        $this->saveSession();
        return $service_id;
    }

    public function editService($service_id, $staff_id)
    {
        $this->session->data['service'][$service_id]['staff_id'] = $staff_id;
        $this->saveSession();
    }

    public function removeService($key)
    {
        $this->service = array();
        unset($this->session->data['service'][$key]);
        $this->saveSession();
    }

    public function getService()
    {

        $this->service = array();
        // if (!$this->service) {
        if (!empty($this->session->data['service'])) {
            foreach ($this->session->data['service'] as $id => $clinicalservice) {
                $clinicalservice_id = $id;
                $staff_id = $clinicalservice["staff_id"];
                $price = $clinicalservice["price"];

                //get staff info
                $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '$staff_id' AND status = 1";
                /*
                  echo "<pre>";
                  print_r($sql);
                  echo "</pre>";
                 */
                $query = $this->db->query($sql);
                $staff_result = $query->row;

                if (!empty($staff_result)) {
                    $staff_name = $staff_result["firstname"] . " " . $staff_result["lastname"];
                } else {
                    $staff_name = '';
                }

                //get service info
                $sql = "
				SELECT
					" . DB_PREFIX . "clinical_service_description.name,
					" . DB_PREFIX . "clinical_service.cs_minute,
					" . DB_PREFIX . "clinical_service.price,
					" . DB_PREFIX . "clinical_service.tax_class_id
				FROM
					" . DB_PREFIX . "clinical_service,
					" . DB_PREFIX . "clinical_service_description
				WHERE
					" . DB_PREFIX . "clinical_service.clinicalservice_id = " . DB_PREFIX . "clinical_service_description.clinicalservice_id
				AND " . DB_PREFIX . "clinical_service.clinicalservice_id = '$clinicalservice_id'
				AND " . DB_PREFIX . "clinical_service_description.language_id = " . (int) $this->session->data['language_id'];

                $query = $this->db->query($sql);
                $service_result = $query->row;
                if (!empty($service_result)) {
                    $service_name = $service_result['name'];
                    $service_minute = $service_result['cs_minute'];
                    $tax_class_id = $service_result['tax_class_id'];
                    $price = $service_result['price']; //overwrite price


                    $this->service[$clinicalservice_id] = array(
                        'service_name' => $service_name,
                        'staff_id' => $staff_id,
                        'staff_name' => $staff_name,
                        'price' => $price,
                        'service_minute' => $service_minute,
                        'total' => $price,
                        'tax_class_id' => $tax_class_id
                    );
                }
            }
        }
        // }

        return $this->service;
    }

    public function getAcupunctureList()
    {
        if (!$this->acupuncture_list) {
            foreach ($this->session->data['acupuncture_list'] as $clinicalservice_id => $acupuncture_list) {
                foreach ($acupuncture_list as $index => $acupuncture) {
                    $this->acupuncture_list[$clinicalservice_id][] = array(
                        'acupuncture_id' => $acupuncture['acupuncture_id'],
                        'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                    );
                }
            }
        }

        return $this->acupuncture_list;
    }

    #endregion

    public function getDoctorTaxes($price, $tax_class_id)
    {
        $tax_data = array();
        $tax_rates = $this->tax->getRates($price, $tax_class_id);
        foreach ($tax_rates as $tax_rate) {
            if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
            } else {
                $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
            }
        }
        return $tax_data;
    }

    public function getTaxes()
    {
        $tax_data = array();
        if (!empty($this->getPrescription())) {
            foreach ($this->getPrescription() as $key => $prescription) {
                if (isset($this->session->data['clinical_sale_products'][$key])) {
                    foreach ($this->getProducts($key) as $product) {

                        $total = $product['price'] * $product['quantity'] * $product['times'];
                        $subtotal = $total - $product['discount'];

                        if ($product['tax_class_id']) {
                            $tax_rates = $this->tax->getRates($subtotal, $product['tax_class_id']);
                            foreach ($tax_rates as $tax_rate) {
                                if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                                    $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
                                } else {
                                    $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
                                }
                            }
                        }
                    }
                }
            }
        }
        return $tax_data;
    }

    public function getSubTotal()
    {
        $total = 0;

        foreach ($this->getPrescription() as $key => $perscription) {
            if (isset($this->session->data['clinical_sale_products'][$key])) {
                if (!empty($this->getProducts($key))) {
                    foreach ($this->getProducts($key) as $product) {
                        $tax = $this->tax->getTax($product['price'] - $product['discount'], $product['tax_class_id']);
                        if ($tax < 0) {
                            $product['total'] = $product['total'] + ($tax * $product['quantity']);
                        }
                        $total += $product['total'] - $product['discount'];
                    }
                }
            }
        }

        return $total;
    }

    public function hasShipping()
    {
        $shipping = false;

        foreach ($this->getPrescription() as $key => $perscription) {
            if (isset($this->session->data['clinical_sale_products'][$key])) {
                foreach ($this->getProducts($key) as $product) {
                    if ($product['shipping']) {
                        $shipping = true;

                        break;
                    }
                }
            }
        }
        return $shipping;
    }

    private function allowEditService($medical_record_id)
    {
        $allow = false;
        $services = $this->getServiceForm($medical_record_id);
        if (empty($services)) {
            $allow = true;
        }
        return $allow;
    }

    private function getServiceForm($medical_record_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_form WHERE
        clinical_sale_id = '" . (int) $medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    private function getClinicalSale($clinical_sale_id)
    {
        $sql = "SELECT 
        cs.*,
        os2.name AS payment_status,
        os.name AS status,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name
        FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON(cs.clinicalsale_action = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "order_status os2 ON(cs.order_action = os2.order_status_id AND os2.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE cs.clinical_sale_id='" . (int)$clinical_sale_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    //dummy function for kuler cp error
    public function countProducts()
    {
        return 0;
    }
}
