<?php

class Herbal_request_brewing_cart {

    private $config;
    private $db;
    private $data = array();
    private $customer_info = [];

    public function __construct($registry) {
        $this->config = $registry->get('config');
        $this->customer = $registry->get('customer');
        $this->session = $registry->get('session');
        $this->db = $registry->get('db');

        if (!isset($this->session->data['herbal_request_brewing']) || !is_array($this->session->data['herbal_request_brewing'])) {
            $this->session->data['herbal_request_brewing'] = array();
        }
    }

    public function addProduct($product_id, $quantity) {
        $this->session->data['herbal_request_brewing']['product'][$product_id]['product_id'] = $product_id;
        $this->session->data['herbal_request_brewing']['product'][$product_id]['quantity'] = $quantity;

        return $this->session->data['herbal_request_brewing']['product'];
    }

    public function getProducts() {
        $data = array();

        if (isset($this->session->data['herbal_request_brewing'])) {
            foreach (($this->session->data['herbal_request_brewing']) as $product_id => $product) {
                $this->data['herbal_request_brewing'][$product_id] = [
                    'product_id' => $product['product_id'],
                    'quantity' => $product['quantity']
                ];
            }
        }

        return $this->data;
    }

    public function GetProductCart() {
        if (isset($this->session->data['herbal_request_brewing']['product'])) {
            foreach ($this->session->data['herbal_request_brewing']['product'] as $product_id => $product) {
                $this->data['product'][$product_id] = [
                    'product_id' => $product['product_id'],
                    'quantity' => $product['quantity']
                ];
            }
        }

        return $this->data;
    }

    public function RemoveProduct($product_id) {
        $this->herbal_request_brewing = [];

        unset($this->session->data['herbal_request_brewing']['product'][$product_id]);

        return $this->session->data['herbal_request_brewing']['product'];
    }

    public function getCustomer() {
        if (isset($this->session->data['herbal_request_brewing']['customer_info'])) {
            $this->customer_info = $this->session->data['herbal_request_brewing']['customer_info'];
        }

        return $this->customer_info;
    }

    public function clear() {
        unset($this->session->data['herbal_request_brewing']);
        unset($this->session->data['herbal_request_brewing']['product']);
    }

    public function set_payment_method($data) {
        $this->session->data['payment_method']['method_name'] = $data['payment_name'];
        $this->session->data['payment_method']['method_code'] = $data['payment_code'];

        $this->session->data['payment_method']['comment'] = isset($data['comment']) ? $data['comment'] : '';
        $this->session->data['payment_method']['instruction'] = isset($data['instruction']) ? $data['instruction'] : '';

        if (isset($data['merchant_code'])) {
            $this->session->data['payment_method']['merchant_code'] = $data['merchant_code'];
        } else {
            unset($this->session->data['payment_method']['merchant_code']);
        }

        if (isset($data['merchant_key'])) {
            $this->session->data['payment_method']['merchant_key'] = $data['merchant_key'];
        } else {
            unset($this->session->data['payment_method']['merchant_key']);
        }

        if (isset($data['payment_id'])) {
            $this->session->data['payment_method']['payment_id'] = $data['payment_id'];
        } else {
            unset($this->session->data['payment_method']['payment_id']);
        }

        if (isset($data['backend_post_url'])) {
            $this->session->data['payment_method']['backend_post_url'] = $data['backend_post_url'];
        } else {
            unset($this->session->data['payment_method']['backend_post_url']);
        }

        return $this->session->data['payment_method'];
    }

}
