<?php

class Herbal_cart
{

    private $config;
    private $db;
    private $data = array();
    private $service = array();
    private $herbal = array();
    private $acupuncture_list = array();
    private $prescription = array();
    private $image = array();

    public function __construct($registry)
    {
        $this->config = $registry->get('config');
        $this->customer = $registry->get('customer');
        $this->session = $registry->get('session');
        $this->db = $registry->get('db');
        $this->tax = $registry->get('tax');
        $this->weight = $registry->get('weight');


        if (!isset($this->session->data['prescription']) || !is_array($this->session->data['prescription'])) {
            $this->session->data['prescription'] = array();
        }

        if (!isset($this->session->data['service']) || !is_array($this->session->data['service'])) {
            $this->session->data['service'] = array();
        }

        if (!isset($this->session->data['product']) || !is_array($this->session->data['product'])) {
            $this->session->data['product'] = array();
        }

        if (!isset($this->session->data['image']) || !is_array($this->session->data['image'])) {
            $this->session->data['image'] = array();
        }

        if (!isset($this->session->data['acupuncture_list']) || !is_array($this->session->data['acupuncture_list'])) {
            $this->session->data['acupuncture_list'] = array();
        }
    }

    public function removePrescription($key)
    {
        $this->prescription = array();
        unset($this->session->data['prescription'][$key]);
        unset($this->session->data['product'][$key]);
    }

    public function removeService($key)
    {
        $this->service = array();
        unset($this->session->data['service'][$key]);
    }

    function getStock($product_id)
    {

        $stok_quantity = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store s WHERE s.product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $this->session->data['store_id'] . "'");
        return $stok_quantity->row;
    }

    public function removeProduct($prescription_id, $key)
    {
        $this->data = array();
        $this->prescription = array();
        unset($this->session->data['product'][$prescription_id][$key]);
        if (empty($this->session->data['product'][$prescription_id])) {
            unset($this->session->data['prescription'][$prescription_id]);
        }
    }

    public function getPerscriptionKey()
    {
        if (!empty($this->session->data['prescription']))
            foreach ($this->session->data['prescription'] as $key => $value) {
            }
        else
            $key = 0;
        return $key + 1;
    }

    public function getImages()
    {
        if (!$this->image) {
            foreach ($this->session->data['image'] as $key => $image) {

                $this->image[$key] = array(
                    'category_id' => $image['category_id'],
                    'name' => $image['name'],
                    'remark' => $image['remark'],
                    'path' => $image['path']
                );
            } //end foreach
        }
        return $this->image;
    }

    public function addPrescription($key, $name, $prescription_id)
    {
        if ($key == 0) {
            $key = $this->getPerscriptionKey();
            $this->session->data['prescription'][$key]['name'] = $name;
            $this->session->data['prescription'][$key]['id'] = $prescription_id;
            $this->session->data['prescription'][$key]['discount'] = 0;
        } else {
            $key = $key;
            if (isset($this->session->data['prescription'][$key])) {
                $this->session->data['prescription'][$key]['name'] = $this->session->data['prescription'][$key]['name'] . ',' . $name;
                $this->session->data['prescription'][$key]['id'] = $this->session->data['prescription'][$key]['id'] . ',' . $prescription_id;
                $this->session->data['prescription'][$key]['discount'] = 0;
            } else {
                $this->session->data['prescription'][$key]['name'] = $name;
                $this->session->data['prescription'][$key]['id'] = $prescription_id;
                $this->session->data['prescription'][$key]['discount'] = 0;
            }
        }

        return $key;
    }

    public function addImages($key, $category_id, $name, $remark, $path)
    {
        $this->session->data['image'][$key] = array(
            'category_id' => $category_id,
            'name' => $name,
            'remark' => $remark,
            'path' => $path
        );
    }

    public function removeImage($key)
    {
        $this->image = array();
        // unlink($this->session->data['image'][$key]['path']);
        unset($this->session->data['image'][$key]);
    }

    public function clearImage()
    {
        $this->session->data['image'] = array();
    }

    public function setService($service_id, $staff_id, $price)
    {
        $this->service = array();

        $this->session->data['service'][$service_id] = array(
            'service_id' => $service_id,
            'staff_id' => $staff_id,
            'price' => $price
        );

        return $service_id;
    }

    public function addProduct($key, $product_id, $quantity, $times, $cook, $taketype, $day, $price = NULL, $discount = NULL)
    {

        $this->session->data['product'][$key][$product_id]['price'] = $price;
        $this->session->data['product'][$key][$product_id]['discount'] = $discount;
        $this->session->data['product'][$key][$product_id]['quantity'] = $quantity;
        $this->session->data['product'][$key][$product_id]['quantity2'] = $quantity;
        $this->session->data['product'][$key][$product_id]['times'] = $times;
        $this->session->data['product'][$key][$product_id]['cook'] = $cook;
        $this->session->data['product'][$key][$product_id]['taketype'] = $taketype;
        $this->session->data['product'][$key][$product_id]['day'] = $day;
    }

    public function getPrescription()
    {
        if (!$this->prescription) {
            foreach ($this->session->data['prescription'] as $key => $items) {

                $this->prescription[$key] = array(
                    'key' => $key,
                    'id' => $items['id'],
                    'name' => $items['name'],
                    'discount' => $items['discount'],
                );
            } //end foreach
        }
        return $this->prescription;
    }

    public function getProducts($prescription_id)
    {
        $this->data[$prescription_id] = '';

        if (isset($this->session->data['product'][$prescription_id])) {
            foreach ($this->session->data['product'][$prescription_id] as $key => $items) {
                $product_id = $key;
                $stock = true;

                $checkProduct = $this->db->query("SELECT p.product_id FROM `" . DB_PREFIX . "product` p WHERE 1 AND p.product_id = '" . (int) $product_id . "' AND p.internal_status = '1'");

                if (!empty($checkProduct->row['product_id'])) {
                    $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p.product_id = '" . (int) $product_id . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.date_available <= NOW() AND p.internal_status = '1'");

                    if ($product_query->num_rows) {

                        $stock_qty = $this->getStock($product_id);
                        $product_weight = $this->weight->convert($product_query->row['weight'], $product_query->row['weight_class_id'], $this->config->get('config_weight_class_id'));

                        if (!empty($stock_qty)) {
                            if (!$stock_qty['onhand_quantity'] || ($stock_qty['onhand_quantity'] < ($product_weight * $items['times']) * $items['quantity'])) {
                                $stock = false;
                            }
                        } else {
                            $stock = false;
                        }

                        if (!empty($this->session->data['customer_group_id'])) {
                            $customer_group_id = $this->session->data['customer_group_id'];
                        } else {
                            $customer_group_id = $this->config->get('config_customer_group_id');
                        }

                        $price = $items['price'];
                        /* if(!empty($this->session->data['product'][$prescription_id][$product_id]['count'])){
                          $updateCount = $this->session->data['product'][$prescription_id][$product_id]['count'] ;
                          }

                          if(!empty($updateCount) && $updateCount == 1){
                          $price = $items['price'];
                          }else{

                          $price = $items['price'];

                          // Product discounts
                          $product_discount_query = $this->db->query("SELECT price FROM `" . DB_PREFIX . "product_discount` WHERE product_id = '".(int)$product_id."' AND customer_group_id = '".(int)$customer_group_id."' AND ((date_start = '0000-00-00' OR date_start <= CURDATE()) AND (date_end = '0000-00-00' OR date_end >= CURDATE())) ORDER BY quantity DESC, priority ASC, price ASC LIMIT 1") ;

                          if($product_discount_query->num_rows){
                          $price = number_format($product_discount_query->row['price'],2);
                          }

                          //Product specials
                          $product_special_query = $this->db->query("SELECT price FROM `" .DB_PREFIX . "product_special` WHERE product_id = '".(int)$product_id."' AND customer_group_id = '".(int)$customer_group_id."' AND ((date_start = '0000-00-00' OR date_start <= CURDATE()) AND (date_end = '0000-00-00' OR date_end >= CURDATE())) ORDER BY priority ASC, price ASC LIMIT 1") ;

                          if($product_special_query->num_rows){
                          $price = number_format($product_special_query->row['price'],2);
                          }

                          } */

                        $this->data[$prescription_id][$product_id] = array(
                            'product_id' => $product_query->row['product_id'],
                            'name' => $product_query->row['name'],
                            'code' => $product_query->row['code'],
                            'quantity' => $items['quantity'],
                            'shipping' => $product_query->row['shipping'],
                            'times' => $items['times'],
                            'cook' => $items['cook'],
                            'taketype' => $items['taketype'],
                            'stock' => $stock,
                            'day' => $items['day'],
                            'price' => $price,
                            'discount' => $items['discount'],
                            'total' => ($items['price'] * $items['quantity']) * $items['times'],
                            'tax_class_id' => $product_query->row['tax_class_id'],
                            'weight' => ($product_query->row['weight'] * $items['quantity']) * $items['times'],
                            'weight_class_id' => $product_query->row['weight_class_id'],
                            'customer_group_id' => $customer_group_id,
                        );
                    } else {
                        //$this->removeProduct($prescription_id,$key);
                    }
                }
            }
        }
        return $this->data[$prescription_id];
    }

    public function updatePrescription($prescription_id, $arg, $value)
    {
        foreach ($this->session->data['product'][$prescription_id] as $product_id => $items) {
            $this->session->data['product'][$prescription_id][$product_id][$arg] = $value;
        }
    }

    public function hasShipping()
    {
        $shipping = false;

        foreach ($this->getPrescription() as $key => $perscription) {
            if (isset($this->session->data['product'][$key])) {
                foreach ($this->getProducts($key) as $product) {
                    if ($product['shipping']) {
                        $shipping = true;

                        break;
                    }
                }
            }
        }
        return $shipping;
    }

    public function getService()
    {

        if (!$this->service) {
            foreach ($this->session->data['service'] as $id => $clinicalservice) {
                $clinicalservice_id = $id;
                $staff_id = $clinicalservice["staff_id"];
                $price = $clinicalservice["price"];

                //get staff info
                $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = $staff_id AND status = 1";
                /*
                  echo "<pre>";
                  print_r($sql);
                  echo "</pre>";
                 */
                $query = $this->db->query($sql);
                $staff_result = $query->row;

                $staff_firstname = !empty($staff_result['firstname']) ? $staff_result['firstname'] : 'EMPTY DOCTOR SET! ';
                $staff_lastname = !empty($staff_result['lastname']) ? $staff_result['lastname'] : 'CONTACT ADMIN! ';
                $staff_name = $staff_firstname . " " . $staff_lastname;

                //get service info
                $sql = "
				SELECT
					" . DB_PREFIX . "clinical_service_description.name,
					" . DB_PREFIX . "clinical_service.cs_minute,
					" . DB_PREFIX . "clinical_service.tax_class_id
				FROM
					" . DB_PREFIX . "clinical_service,
					" . DB_PREFIX . "clinical_service_description
				WHERE
					" . DB_PREFIX . "clinical_service.clinicalservice_id = " . DB_PREFIX . "clinical_service_description.clinicalservice_id
				AND " . DB_PREFIX . "clinical_service.clinicalservice_id = $clinicalservice_id
				AND " . DB_PREFIX . "clinical_service_description.language_id = " . (int) $this->config->get('config_language_id');

                $query = $this->db->query($sql);
                $service_result = $query->row;

                $service_name = $service_result['name'];
                $service_minute = $service_result['cs_minute'];
                $tax_class_id = $service_result['tax_class_id'];

                $this->service[$clinicalservice_id] = array(
                    'service_name' => $service_name,
                    'staff_id' => $staff_id,
                    'staff_name' => $staff_name,
                    'price' => $price,
                    'service_minute' => $service_minute,
                    'total' => $clinicalservice['price'],
                    'tax_class_id' => $tax_class_id
                );
            }
        }

        return $this->service;
    }

    public function updateProduct($prescription_id, $product_id, $price, $discount, $taketype, $cook, $day, $quantity, $times)
    {

        $this->session->data['product'][$prescription_id][$product_id]['price'] = $price;
        $this->session->data['product'][$prescription_id][$product_id]['discount'] = $discount;

        if ($this->session->data['product'][$prescription_id][$product_id]['quantity'] != $quantity) {
            $this->session->data['product'][$prescription_id][$product_id]['quantity'] = $quantity;
            $this->session->data['product'][$prescription_id][$product_id]['quantity2'] = $quantity;
            $this->session->data['product'][$prescription_id][$product_id]['count'] = 0;
        } else {
            $this->session->data['product'][$prescription_id][$product_id]['quantity'] = $quantity;
            $this->session->data['product'][$prescription_id][$product_id]['count'] = 1;
            $this->session->data['product'][$prescription_id][$product_id]['quantity2'] = $quantity;
        }

        $this->session->data['product'][$prescription_id][$product_id]['times'] = $times;
        $this->session->data['product'][$prescription_id][$product_id]['cook'] = $cook;
        $this->session->data['product'][$prescription_id][$product_id]['taketype'] = $taketype;
        $this->session->data['product'][$prescription_id][$product_id]['day'] = $day;
    }

    public function getSubTotal()
    {
        $total = 0;

        foreach ($this->getPrescription() as $key => $perscription) {
            if (isset($this->session->data['product'][$key])) {
                foreach ($this->getProducts($key) as $product) {
                    $tax = $this->tax->getTax($product['price'] - $product['discount'], $product['tax_class_id']);
                    if ($tax < 0) {
                        $product['total'] = $product['total'] + ($tax * $product['quantity']);
                    }
                    $total += $product['total'] - $product['discount'];
                }
            }
        }

        return $total;
    }

    public function getTaxes()
    {
        $tax_data = array();

        foreach ($this->getPrescription() as $key => $perscription) {
            if (isset($this->session->data['product'][$key])) {
                foreach ($this->getProducts($key) as $product) {

                    $total = $product['price'] * $product['quantity'] * $product['times'];
                    $subtotal = $total - $product['discount'];

                    if ($product['tax_class_id']) {
                        $tax_rates = $this->tax->getRates($subtotal, $product['tax_class_id']);
                        foreach ($tax_rates as $tax_rate) {
                            if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                                $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
                            } else {
                                $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
                            }
                        }
                    }
                }
            }
        }
        return $tax_data;
    }

    public function getWeights()
    {
        $weight_data = array();

        $total_quantity = 0;
        $total_weight = 0;

        foreach ($this->getPrescription() as $key => $prescription) {
            if (isset($this->session->data['product'][$key])) {
                foreach ($this->getProducts($key) as $product) {
                    $quantity = $product['quantity'];
                    $times = $product['times'];
                    $weight = $quantity * $times;
                    $total_quantity += $quantity;
                    $total_weight += $weight;

                    if ($product['weight_class_id']) {
                        $quantity_format = $this->weight->format($total_quantity, $product['weight_class_id']);
                        $weight_format = $this->weight->format($total_weight, $product['weight_class_id']);
                    }
                }

                $weight_data = array(
                    array(
                        'weight_name' => 'Total Weight',
                        'weight' => $quantity_format
                    ),
                    array(
                        'weight_name' => 'Grand Total Weight',
                        'weight' => $weight_format
                    )
                );
            }
        }

        return $weight_data;
    }

    public function getTotal()
    {
        $total = 0;

        foreach ($this->getPrescription() as $key => $perscription) {
            foreach ($this->getProducts($key) as $product) {
                $total += $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'] * $product['times'];
            }
        }

        return $total;
    }

    public function updateDiscount($discount)
    {

        $tota_product = 0;

        foreach ($this->getPrescription() as $key => $perscription) {
            $tota_product += count($this->getProducts($key));
        }
        foreach ($this->getPrescription() as $key => $perscription) {
            foreach ($this->getProducts($key) as $product) {
                $this->session->data['product'][$key][$product['product_id']]['discount'] = $discount;
            }
        }
    }

    public function getDoctorTaxes($price, $tax_class_id)
    {
        $tax_data = array();
        $tax_rates = $this->tax->getRates($price, $tax_class_id);
        foreach ($tax_rates as $tax_rate) {
            if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);
            } else {
                $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);
            }
        }
        return $tax_data;
    }

    public function addCustomerGroupId($customer_group_id)
    {
        if ($customer_group_id) {
            $this->session->data['customer_group_id'] = $customer_group_id;
        }
    }

    public function getCustomerGroupId()
    {
        $customer_group_id = $this->session->data['customer_group_id'];

        return $customer_group_id;
    }

    public function setAcupunctureList($clinicalservice_id, $acupuncture_id, $num_of_acupuncture)
    {
        $this->acupuncture_list = array();

        $this->session->data['acupuncture_list'][$clinicalservice_id][$acupuncture_id]['acupuncture_id'] = $acupuncture_id;
        $this->session->data['acupuncture_list'][$clinicalservice_id][$acupuncture_id]['num_of_acupuncture'] = $num_of_acupuncture;

        return $clinicalservice_id;
    }

    public function unsetAcupunctureList($clinicalservice_id, $acupuncture_id)
    {
        $this->acupuncture_list = array();

        unset($this->session->data['acupuncture_list'][$clinicalservice_id][$acupuncture_id]);

        return $clinicalservice_id;
    }

    public function removeAcupunctureList($clinicalservice_id)
    {
        $this->acupuncture_list = array();

        unset($this->session->data['acupuncture_list'][$clinicalservice_id]);

        return $clinicalservice_id;
    }

    public function getAcupunctureList()
    {
        if (!$this->acupuncture_list) {
            foreach ($this->session->data['acupuncture_list'] as $clinicalservice_id => $acupuncture_list) {
                foreach ($acupuncture_list as $index => $acupuncture) {
                    $this->acupuncture_list[$clinicalservice_id][] = array(
                        'acupuncture_id' => $acupuncture['acupuncture_id'],
                        'num_of_acupuncture' => $acupuncture['num_of_acupuncture']
                    );
                }
            }
        }

        return $this->acupuncture_list;
    }
}
