<?php

class GCM {

    private $config;
    private $db;
    private $to;
    private $data;
    private $ios_notification;
    private $content_available;

    public function __construct($registry) {
        $this->config = $registry->get('config');
        $this->db = $registry->get('db');

        //load notification config
        $config_notification = $this->config->get('config_notification');
        foreach ($config_notification as $key => $value)
            if ($value)
                $this->$key = $value;

        $to = array();
        $data = array();
        $ios_notification = array();
        $content_available = false;
    }

    public function sendTo($to) {
        if (is_array($to))
            $this->to = $to;
        else
            $this->to[] = $to;

        return $this;
    }

    public function setData($data) {
        $this->data = $data;
        return $this;
    }

    public function setIosNotification($ios_notification) {
        $this->ios_notification = $ios_notification;
        return $this;
    }

    public function setContentAvailable($content_available) {
        $this->content_available = $content_available;
        return $this;
    }

    public function send() {
        //data validation
        if (!$this->to)
            trigger_error('Error: Notification to required!');
        if (!$this->data)
            trigger_error('Error: Notification data required!');

        // GCM URL
        $url = $this->api_url;

        $find_url = array(
            'SECRET_API_KEY'
        );

        $replace_url = array(
            'secret_api_key' => $this->api_key
        );

        $final_url = str_replace($find_url, $replace_url, $url);

        // Set POST variables
        $fields = array(
            'tokens' => $this->to,
            'data' => $this->data,
            'notification' => $this->ios_notification,
            'content_available' => $this->content_available
        );

        $headers = array(
            'Content-Type: application/json'
        );

        // Open connection
        $ch = curl_init();

        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $final_url);

        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Disabling SSL Certificate support temporarly
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));

        // Execute post
        $result = curl_exec($ch);

        $this->send_mail_to_dev(json_decode($result, true), $this->data);

        if ($result === FALSE) {
            $file = DIR_LOGS . "/firebasenotification.log";
            $handle = fopen($file, 'a+');
            fwrite($handle, date('Y-m-d G:i:s') . ' - ' . print_r($result, true) . "\n");
            fclose($handle);

            die('Curl failed: ' . curl_error($ch));
        }

        // Close connection
        curl_close($ch);
        //echo $result;
    }

    public function get_user_token($user_id) {
        $registration_ids = array();
        $sql = "SELECT gcm_token FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int) $user_id . "' AND gcm_token != ''";
        $query = $this->db->query($sql);
        $result = $query->rows;
        foreach ($result as $row)
            $registration_ids[] = $row['gcm_token'];

        return $registration_ids;
    }

    private function send_mail_to_dev($pushy_response, $push_data) {
        $admin_or_catalog = HTTP_SERVER;

        if (strpos($admin_or_catalog, 'admin')) {
            $final_url = HTTP_CATALOG . 'index.php?route=etcm/pushy';
        } else {
            $final_url = HTTP_SERVER . 'index.php?route=etcm/pushy';
        }

        $post_data = [$pushy_response, $push_data];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $final_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_data));
        $result = curl_exec($ch);

        curl_close($ch);
    }

}

?>
