<?php
class FCM
{ //firebase cloud messaging

    private $url;
    private $key;
    private $registration_ids;
    private $notification;
    private $data;
    private $error;

    public function __construct($registry)
    {
        $this->error = '';
    }

    public function sendTo($to)
    {
        $this->registration_ids = null;
        if (is_array($to))   $this->registration_ids = $to;
        else                $this->registration_ids[] = $to;

        return $this;
    }

    public function setData($data)
    {
        $this->data = $data;
        return $this;
    }
    public function setNotification($notification)
    {
        $this->notification = $notification;
        return $this;
    }

    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }

    public function setKey($key)
    {
        $this->key = $key;
        return $this;
    }

    public function push_notification()
    {
        $this->error = '';
        $fields = array(
            'registration_ids' =>  $this->registration_ids,
        );
        if (!empty($this->data)) {
            $fields['data'] = $this->data;
        }
        if (!empty($this->notification)) {
            $fields["notification"] = $this->notification;
        }

        //set android priority high
        $fields["android"] = [
            "priority" => "high"
        ];

        //header includes Content type and api key
        $headers = array(
            'Content-Type:application/json',
            'Authorization:key=' . $this->key
        );

        $fields = json_encode($fields);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        $result = curl_exec($ch);
        if ($result === FALSE) {
            $this->error = curl_error($ch);
        }
        curl_close($ch);
        return array($fields, $result, $this->error);
    }
}
