<?php
class Community_cart {
    private $config;
    private $db;
    private $data = [];
    private $payment_address = [];
    private $shipping_address = [];
    private $cart = [];
    private $payment_method = [];
    private $shipping_methods = [];
    private $shipping_method = [];
    private $customer_info = [];

    public function __construct($registry) {
		$this->config = $registry->get('config');
		$this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->tax = $registry->get('tax');

        if (!isset($this->session->data['cart']) || !is_array($this->session->data['cart'])) {
			$this->session->data['cart'] = [];
		}
    }

    public function add_to_cart($product_id, $calculated_data){
        $this->session->data['cart']['product'][$product_id]['product_id'] = $product_id;
        $this->session->data['cart']['product'][$product_id]['unit_price_without_tax'] = $calculated_data['unit_price_without_tax'];
        $this->session->data['cart']['product'][$product_id]['unit_price'] = $calculated_data['unit_price'];
        $this->session->data['cart']['product'][$product_id]['unit_price_unit'] = $calculated_data['unit_price_unit'];
        $this->session->data['cart']['product'][$product_id]['calculated_price'] = $calculated_data['calculated_price'];
        $this->session->data['cart']['product'][$product_id]['calculated_price_unit'] = $calculated_data['calculated_price_unit'];
        $this->session->data['cart']['product'][$product_id]['tax_class_id'] = $calculated_data['tax_class_id'];
        $this->session->data['cart']['product'][$product_id]['store_id'] = $calculated_data['store_id'];
        $this->session->data['cart']['product'][$product_id]['product_name'] = $calculated_data['product_name'];
		$this->session->data['cart']['product'][$product_id]['product_code'] = $calculated_data['product_code'];

        if(isset($calculated_data['image'])){
            $this->session->data['cart']['product'][$product_id]['image'] = $calculated_data['image'];
        }

        if(isset($calculated_data['quantity'])){
            $this->session->data['cart']['product'][$product_id]['quantity'] = $calculated_data['quantity'];
        }

        if(isset($calculated_data['store_name'])){
            $this->session->data['cart']['product'][$product_id]['store_name'] = $calculated_data['store_name'];
        }

        return $this->session->data['cart']['product'];
    }

    public function remove_from_cart($product_id){
        $this->cart = [];

        unset($this->session->data['cart']['product'][$product_id]);

        return $this->session->data['cart']['product'];
    }

    public function set_payment_address($data){
        $this->session->data['cart']['payment_address']['customer_name'] = $data['customer_name'];
        $this->session->data['cart']['payment_address']['address_1'] = $data['address_1'];
        $this->session->data['cart']['payment_address']['address_2'] = $data['address_2'];
        $this->session->data['cart']['payment_address']['city'] = $data['city'];
        $this->session->data['cart']['payment_address']['postcode'] = $data['postcode'];
        $this->session->data['cart']['payment_address']['country_id'] = (int)$data['country_id'];
        $this->session->data['cart']['payment_address']['country_name'] = $data['country_name'];
        $this->session->data['cart']['payment_address']['zone_id'] = (int)$data['zone_id'];
        $this->session->data['cart']['payment_address']['zone_name'] = $data['zone_name'];

        return $this->session->data['cart']['payment_address'];
    }

    public function set_shipping_address($data){
        $this->session->data['cart']['shipping_address']['customer_name'] = $data['customer_name'];
        $this->session->data['cart']['shipping_address']['address_1'] = $data['address_1'];
        $this->session->data['cart']['shipping_address']['address_2'] = $data['address_2'];
        $this->session->data['cart']['shipping_address']['city'] = $data['city'];
        $this->session->data['cart']['shipping_address']['postcode'] = $data['postcode'];
        $this->session->data['cart']['shipping_address']['country_id'] = (int)$data['country_id'];
        $this->session->data['cart']['shipping_address']['country_name'] = $data['country_name'];
        $this->session->data['cart']['shipping_address']['zone_id'] = (int)$data['zone_id'];
        $this->session->data['cart']['shipping_address']['zone_name'] = $data['zone_name'];

        return $this->session->data['cart']['shipping_address'];
    }

    public function set_payment_method($data){
        $this->session->data['payment_method']['method_name'] = $data['payment_name'];
        $this->session->data['payment_method']['method_code'] = $data['payment_code'];

        if (isset($data['comment'])) {
            $this->session->data['payment_method']['comment'] = $data['comment'];
        } else {
            unset($this->session->data['payment_method']['comment']);
        }

        if (isset($data['instruction'])) {
            $this->session->data['payment_method']['instruction'] = $data['instruction'];
        } else {
            unset($this->session->data['payment_method']['instruction']);
        }
        
        if (isset($data['merchant_code'])) {
            $this->session->data['payment_method']['merchant_code'] = $data['merchant_code'];
        } else {
            unset($this->session->data['payment_method']['merchant_code']);
        }

        if (isset($data['merchant_key'])) {
            $this->session->data['payment_method']['merchant_key'] = $data['merchant_key'];
        } else {
            unset($this->session->data['payment_method']['merchant_key']);
        }

        if (isset($data['payment_id'])) {
            $this->session->data['payment_method']['payment_id'] = $data['payment_id'];
        } else {
            unset($this->session->data['payment_method']['payment_id']);
        }
      
        if (isset($data['backend_post_url'])) {
            $this->session->data['payment_method']['backend_post_url'] = $data['backend_post_url'];
        } else {
            unset($this->session->data['payment_method']['backend_post_url']);
        }

        return $this->session->data['payment_method'];
    }

    public function get_cart() {
        if(isset($this->session->data['cart']['product'])){
            foreach($this->session->data['cart']['product'] as $product_id => $product){
                $calculated_price_without_tax = $product['unit_price_without_tax'] * $product['quantity'];
                $image = isset($product['image']) ? $product['image'] : '';

                $this->data['product'][$product_id] = [
                    'product_id'                    => $product['product_id'],
                    'product_name'                  => $product['product_name'],
                    'product_code'                  => $product['product_code'],
                    'unit_price_without_tax'        => $product['unit_price_without_tax'],
                    'unit_price'                    => $product['unit_price'],
                    'unit_price_unit'               => $product['unit_price_unit'],
                    'calculated_price_without_tax'  => $calculated_price_without_tax,
                    'calculated_price'              => $product['calculated_price'],
                    'calculated_price_unit'         => $product['calculated_price_unit'],
                    'tax_class_id'                  => $product['tax_class_id'],
                    'quantity'                      => $product['quantity'],
                    'store_id'                      => $product['store_id'],
                    'image'                         => $image
                ];

                if(isset($product['store_name'])){
                    $this->data['product'][$product_id]['store_name'] = $product['store_name'];
                }
            }
        }

        return $this->data;
    }

    public function getProducts(){
        $this->data['product'] = [];

        if(isset($this->session->data['cart']['product'])){
            foreach($this->session->data['cart']['product'] as $product_id => $product){
                $calculated_price_without_tax = $product['unit_price_without_tax'] * $product['quantity'];
				$product_id = $product['product_id'];

				$product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'");
				$product_row = $product_query->row;


                $this->data['product'][$product_id] = [
					'product_id'					=> $product_id,
                    'key'                           => '',
                    'name'                  		=> $product['product_name'],
                    'product_code'                  => $product['product_code'],
                    'unit_price_without_tax'        => $product['unit_price_without_tax'],
                    'unit_price'                    => $product['unit_price'],
                    'unit_price_unit'               => $product['unit_price_unit'],
                    'calculated_price_without_tax'  => $calculated_price_without_tax,
                    'total'              			=> $product['calculated_price'],
                    'total_unit'         			=> $product['calculated_price_unit'],
                    'tax_class_id'                  => $product['tax_class_id'],
					'length_class_id'               => $product_row['length_class_id'],
					'length'						=> $product_row['length'],
					'width'							=> $product_row['width'],
					'height'						=> $product_row['height'],
                    'weight_class_id'               => $product_row['weight_class_id'],
                    'weight'  			            => $product_row['weight'],
                    'quantity'                      => $product['quantity'],
                    'store_id'                      => $product['store_id'],
					'option'						=> [],
					'shipping'						=> true
                ];
            }
        }

        return $this->data['product'];
    }

    public function get_payment_address(){
        if(isset($this->session->data['cart']['payment_address'])){
            $this->payment_address = $this->session->data['cart']['payment_address'];
        }

        return $this->payment_address;
    }

    public function get_shipping_address(){
        if(isset($this->session->data['cart']['shipping_address'])){
            $this->shipping_address = $this->session->data['cart']['shipping_address'];
        }

        return $this->shipping_address;
    }

    public function get_payment_method(){
        if(isset($this->session->data['payment_method'])){
            $this->payment_method = $this->session->data['payment_method'];
        }

        return $this->payment_method;
	}
	
	public function countProducts() {
		$product_total = 0;

		$products = $this->getProducts();

		foreach ($products as $product) {
			$product_total += $product['quantity'];
		}

		return $product_total;
	}

    
    public function hasShipping() {
		$shipping = false;

		foreach ($this->getProducts() as $product) {
			if ($product['shipping']) {
				$shipping = true;

				break;
			}
		}

		return $shipping;
	}

    public function getSubTotal(){
        $total = 0;

        $cart_data = $this->get_cart();

        if(isset($cart_data['product'])){
            foreach($cart_data['product'] as $product){
                $tax = $this->tax->getTax($product['unit_price'], $product['tax_class_id']);

                if($tax < 0){
    			    $product['calculated_price_without_tax'] = $product['calculated_price_without_tax'] + ($tax * $product['quantity']);
    			}

    			$total += $product['calculated_price_without_tax'];
            }
        }

        return $total;
    }

    public function getTaxes(){
        $tax_data = [];

        $cart_data = $this->get_cart();

        if(isset($cart_data['product'])){
            foreach($cart_data['product'] as $product){
                if($product['tax_class_id']){
                    $tax_rates = $this->tax->getRates($product['unit_price_without_tax'], $product['tax_class_id']);

                    foreach ($tax_rates as $tax_rate) {
    					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
    						$tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['quantity']);
    					} else {
    						$tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['quantity']);
    					}
    				}
                }
            }
        }

        return $tax_data;
    }

    public function clear(){
        unset($this->session->data['cart']);
        unset($this->session->data['shipping_methods']);
        unset($this->session->data['shipping_method']);
        unset($this->session->data['payment_method']);
    }
}
?>