<?php

class ClinicalServices{

	private $config;

	private $db;

	private $data = array();



	private $tax;

	private $currenty;



	public function __construct($registry){

		$this->config = $registry->get('config');

		$this->session = $registry->get('session');

		$this->db = $registry->get('db');



		$this->tax = $registry->get('tax');

		$this->currency = $registry->get('currency');

		$this->currency->set($this->config->get('config_currency'));



		if(!isset($this->session->data['clinical_services']) || !is_array($this->session->data['clinical_services'])){

			$this->session->data['clinical_services'] = array();

		}

	}

	public function addImages($key,$category_id,$name,$remark,$path){
	   $this->session->data['clinical_services']['image'][$key] = array(
	     'category_id' => $category_id,
	     'name' => $name,
		 'remark' => $remark,
		 'path' => $path
	   );
	}

	public function removeImage($key){
		unset($this->session->data['clinical_services']['image'][$key]);
	}

	public function getImages(){
		$images = array();

		if(isset($this->session->data['clinical_services']['image'])){
			foreach ($this->session->sata['clinical_service']['image'] as $key => $image) {
				$images[$key] = array(
					'category_id' => $image['category_id'],
					'name' => $images['name'],
					'remark' => $image['remark'],
					'path' => $imae['path']
				);
			}
		}

		return $images;
	}

	public function clearImages(){
		$this->session->data['clinical_services']['image'] = array();
	}

	public function getServices($index = false){

		if(!$this->data){
			foreach($this->session->data['clinical_services'] as $id => $clinicalservice){

				$clinicalservice_id = $id;

				$staff_id = $clinicalservice["staff_id"];

				$price = $clinicalservice["price"];

				$starttime = $clinicalservice["starttime"];

				$endtime = $clinicalservice["endtime"];



				//get staff info

				$sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = $staff_id AND status = 1";


				$query = $this->db->query($sql);

				$staff_result = $query->row;

				/*
				echo "<pre>";
				print_r($staff_result);
				echo "</pre>";
				*/

				$staff_name = $staff_result["firstname"] . " " . $staff_result["lastname"];



				//get service info

				$sql = "

				SELECT

					" . DB_PREFIX . "clinical_service_description.name,

					" . DB_PREFIX . "clinical_service.cs_minute,

					" . DB_PREFIX . "clinical_service.tax_class_id,

					" . DB_PREFIX . "clinical_service.price

				FROM

					" . DB_PREFIX . "clinical_service,

					" . DB_PREFIX . "clinical_service_description

				WHERE

					" . DB_PREFIX . "clinical_service.clinicalservice_id = " . DB_PREFIX . "clinical_service_description.clinicalservice_id

				AND " . DB_PREFIX . "clinical_service.clinicalservice_id = $clinicalservice_id

				AND " . DB_PREFIX . "clinical_service_description.language_id = " . (int)$this->config->get('config_language_id');



				/*

				echo "<pre>";

				print_r($sql);

				echo "</pre>";

				*/



				$query = $this->db->query($sql);

				$service_result = $query->row;



				$service_name = $service_result["name"];
				$service_minute = $service_result['cs_minute'];
				$oprice = $service_result["price"];

				$tax_class_id = $service_result['tax_class_id'];


				$tax_data = $this->tax->calculateTax($price, $tax_class_id, $this->config->get('config_tax'));



				$this->data[$clinicalservice_id] = array(
					'service_name' 			=> $service_name,
					'service_id'			=> $clinicalservice_id,
					'staff_id' 				=> $staff_id,
					'oprice'				=> $oprice,
					'formated_oprice'		=> $this->currency->format($oprice),
					'price'					=> $price,
					'formated_price'		=> $this->currency->format($price),
					'service_minute'		=> $service_minute,
					'tax'					=> $tax_data['tax'],
					'formated_tax'			=> $this->currency->format($tax_data['tax']),
					'tax_class_id'			=> $tax_class_id,
					'staff_name' 			=> $staff_name,
					'starttime'				=> $starttime,
					'formated_starttime' 	=> $this->dateFormat($starttime),
					'endtime'				=> $endtime,
					'formated_endtime'		=> $this->dateFormat($endtime),
					'usedminute'			=> $endtime - $starttime,
					'formated_usedminute'	=> $this->totalTimeFormat($endtime - $starttime),
					'net_amount'			=> $tax_data['net_amount'],
					'formatted_net_amount'	=> $this->currency->format($tax_data['net_amount']),
					'total'					=> $tax_data['total'],
					'formatted_total'		=> $this->currency->format($tax_data['total']),
					'tax_format'			=> $tax_data['format'],
					'tax_code'				=> $this->tax->getClassCode($tax_class_id)
				);

			}

		}



		return $index ? array($index => $this->data[$index]) : $this->data;

	}



	public function set($clinicalservice_id, $staff_id, $price, $starttime, $endtime){

		$this->data = array();



		$this->session->data['clinical_services'][$clinicalservice_id] = array(

			'staff_id' 	=> $staff_id,

			'price'		=> $price,

			'starttime' => $starttime,

			'endtime'	=> $endtime

		);



		return $this->getServices($clinicalservice_id);

	}



	public function setArray($array){

		$this->data = array();



		$this->session->data['clinical_services'] = $array;



		return $this->getServices();

	}



	public function setStartTime($clinicalservice_id, $value){

		$this->data = array();

		$this->session->data['clinical_services'][$clinicalservice_id]['starttime'] = $value;

	}



	public function setEndTime($clinicalservice_id, $value){

		$this->data = array();

		$this->session->data['clinical_services'][$clinicalservice_id]['endtime'] = $value;

	}



	public function getSubTotal(){

		$subtotal = 0;



		$services = $this->getServices();



		foreach($services as $id => $service){

			$subtotal += $service['net_amount'];

		}



		return $subtotal;

	}



	public function getFormatedSubTotal(){

		return $this->currency->format($this->getSubTotal());

	}



	public function getTotalTax(){

		$tax = 0;



		$services = $this->getServices();



		foreach($services as $service){

			$tax += $service['tax'];

		}



		return $tax;

	}



	public function getFormatedTotalTax(){

		return $this->currency->format($this->getTotalTax());

	}



	public function getTotal(){

		$total = 0;



		$services = $this->getServices();



		foreach($services as $id => $service){

			$total += $service['total'];

		}



		return $total;

	}



	public function getFormatedTotal(){

		return $this->currency->format($this->getTotal());

	}



	public function has($clinicalservice_id){

		$services = $this->getServices();



		return isset($services[$clinicalservice_id]);

	}

	public function hasShipping(){
		return false;
	}



	public function remove($clinicalservice_id){

		$this->data = array();



		if(isset($this->session->data['clinical_services'][$clinicalservice_id]))

			unset($this->session->data['clinical_services'][$clinicalservice_id]);



		return $clinicalservice_id;

	}



	public function clear(){

		$this->data = array();

		$this->session->data['clinical_services'] = array();

	}



	private function dateFormat($miliseconds){
		date_default_timezone_set($this->config->get('config_time_zone'));
		$seconds = $miliseconds / 1000;

		//return date("d-m-Y H:i:s", $seconds);

		return date("H:i:s", $seconds);
	}



	private function totalTimeFormat($miliseconds){

		$usedTime = $miliseconds;



		$ul = $usedTime - ($usedTime % 1000);



		$uss = ($ul / 1000) % 60;

		$uss = $uss < 10 ? "0" . $uss : $uss;

		$ul -= ($uss * 1000);

		$ul = $ul > 0 ? $ul : 0;



		$usm = ($ul / 1000 / 60) % 60;

		$usm = $usm < 10 ? "0" . $usm : $usm;

		$ul -= ($usm * 1000 * 60);

		$ul = $ul > 0 ? $ul : 0;



		$ush = ($ul / 1000 / 60 / 60);



		//return $ush . ":" + $usm . ":" . $uss;



		return $ush . ":" . $usm . ":" . $uss;

	}



	public function getTaxes() {

		$tax_data = array();



		foreach($this->getServices() as $id => $service){



			$total = $service['price'];

			$subtotal = $service['net_amount'];



			if ($service['tax_class_id']) {

				$tax_rates = $this->tax->getRates($total, $service['tax_class_id']);

				foreach ($tax_rates as $tax_rate) {

					if (!isset($tax_data[$tax_rate['tax_rate_id']])) {

						$tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount']);

					} else {

						$tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount']);

					}

				}

			}



		}



 	  return $tax_data;

	}

}

?>
