<?php

namespace Cart;

class Cart {

    private $config;
    private $db;
    private $data = array();
    private $service = array();
    private $herbal = array();
    private $brewing = array();

    public function __construct($registry) {
        $this->config = $registry->get('config');
        $this->customer = $registry->get('customer');
        $this->session = $registry->get('session');
        $this->db = $registry->get('db');
        $this->tax = $registry->get('tax');
        $this->weight = $registry->get('weight');

        // Remove all the expired carts with no customer ID
        $this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE (api_id > '0' OR customer_id = '0') AND date_added < DATE_SUB(NOW(), INTERVAL 1 HOUR)");

        if ($this->customer->getId()) {
            // We want to change the session ID on all the old items in the customers cart
            $this->db->query("UPDATE " . DB_PREFIX . "cart SET session_id = '" . $this->db->escape($this->session->getId()) . "' WHERE api_id = '0' AND customer_id = '" . (int) $this->customer->getId() . "'");

            // Once the customer is logged in we want to update the customers cart
            $cart_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '0' AND customer_id = '0' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");

            foreach ($cart_query->rows as $cart) {
                $this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE cart_id = '" . (int) $cart['cart_id'] . "'");

                // The advantage of using $this->add is that it will check if the products already exist and increaser the quantity if necessary.
                $this->add($cart['product_id'], $cart['quantity'], json_decode($cart['option']), $cart['recurring_id']);
            }
        }
        //Product
        if (!isset($this->session->data['cart']) || !is_array($this->session->data['cart'])) {
            $this->session->data['cart'] = array();
        }
        //Service
        if (!isset($this->session->data['service']) || !is_array($this->session->data['service'])) {
            $this->session->data['service'] = array();
        }
        //Brewing
        if (!isset($this->session->data['brewing']) || !is_array($this->session->data['brewing'])) {
            $this->session->data['brewing'] = array();
        }
        //Herbal
        if (!isset($this->session->data['herbal']) || !is_array($this->session->data['herbal'])) {
            $this->session->data['herbal'] = array();
        }
    }

    public function getProducts() {
        $product_data = array();
        
        /*echo '<pre>';
        print_r($this->session->data);
        echo '</pre>';
        
        echo '<pre>';
        print_r($this->session->getId());
        echo '</pre>';
        
        echo '<pre>';
        print_r($this->customer->getId());
        echo '</pre>';*/

        $cart_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");

        foreach ($cart_query->rows as $cart) {
            $stock = true;

            $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store p2s LEFT JOIN " . DB_PREFIX . "product p ON (p2s.product_id = p.product_id) LEFT JOIN " . DB_PREFIX . "product_description pd ON (p.product_id = pd.product_id) WHERE p2s.store_id = '" . (int) $this->config->get('config_store_id') . "' AND p2s.product_id = '" . (int) $cart['product_id'] . "' AND pd.language_id = '" . (int) $this->config->get('config_language_id') . "' AND p.date_available <= NOW() AND (p.status = '1' OR p.internal_status ='1')");

            if ($product_query->num_rows && ($cart['quantity'] > 0)) {
                $option_price = 0;
                $option_points = 0;
                $option_weight = 0;

                $option_data = array();

                foreach (json_decode($cart['option']) as $product_option_id => $value) {
                    $option_query = $this->db->query("SELECT po.product_option_id, po.option_id, od.name, o.type FROM " . DB_PREFIX . "product_option po LEFT JOIN `" . DB_PREFIX . "option` o ON (po.option_id = o.option_id) LEFT JOIN " . DB_PREFIX . "option_description od ON (o.option_id = od.option_id) WHERE po.product_option_id = '" . (int) $product_option_id . "' AND po.product_id = '" . (int) $cart['product_id'] . "' AND od.language_id = '" . (int) $this->config->get('config_language_id') . "'");

                    if ($option_query->num_rows) {
                        if ($option_query->row['type'] == 'select' || $option_query->row['type'] == 'radio') {
                            $option_value_query = $this->db->query("SELECT pov.option_value_id, ovd.name, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value ov ON (pov.option_value_id = ov.option_value_id) LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (ov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int) $value . "' AND pov.product_option_id = '" . (int) $product_option_id . "' AND ovd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

                            if ($option_value_query->num_rows) {
                                //Price
                                if ($option_value_query->row['price_prefix'] == '+') {
                                    $option_price += $option_value_query->row['price'];
                                } elseif ($option_value_query->row['price_prefix'] == '-') {
                                    $option_price -= $option_value_query->row['price'];
                                }
                                //Point
                                if ($option_value_query->row['points_prefix'] == '+') {
                                    $option_points += $option_value_query->row['points'];
                                } elseif ($option_value_query->row['points_prefix'] == '-') {
                                    $option_points -= $option_value_query->row['points'];
                                }
                                //Weight
                                if ($option_value_query->row['weight_prefix'] == '+') {
                                    $option_weight += $option_value_query->row['weight'];
                                } elseif ($option_value_query->row['weight_prefix'] == '-') {
                                    $option_weight -= $option_value_query->row['weight'];
                                }
                                //Quantity
                                if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $cart['quantity']))) {
                                    $stock = false;
                                }

                                $option_data[] = array(
                                    'product_option_id' => $product_option_id,
                                    'product_option_value_id' => $value,
                                    'option_id' => $option_query->row['option_id'],
                                    'option_value_id' => $option_value_query->row['option_value_id'],
                                    'name' => $option_query->row['name'],
                                    'value' => $option_value_query->row['name'],
                                    'type' => $option_query->row['type'],
                                    'quantity' => $option_value_query->row['quantity'],
                                    'subtract' => $option_value_query->row['subtract'],
                                    'price' => $option_value_query->row['price'],
                                    'price_prefix' => $option_value_query->row['price_prefix'],
                                    'points' => $option_value_query->row['points'],
                                    'points_prefix' => $option_value_query->row['points_prefix'],
                                    'weight' => $option_value_query->row['weight'],
                                    'weight_prefix' => $option_value_query->row['weight_prefix']
                                );
                            }
                        } elseif ($option_query->row['type'] == 'checkbox' && is_array($value)) {
                            foreach ($value as $product_option_value_id) {
                                $option_value_query = $this->db->query("SELECT pov.option_value_id, pov.quantity, pov.subtract, pov.price, pov.price_prefix, pov.points, pov.points_prefix, pov.weight, pov.weight_prefix, ovd.name FROM " . DB_PREFIX . "product_option_value pov LEFT JOIN " . DB_PREFIX . "option_value_description ovd ON (pov.option_value_id = ovd.option_value_id) WHERE pov.product_option_value_id = '" . (int) $product_option_value_id . "' AND pov.product_option_id = '" . (int) $product_option_id . "' AND ovd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

                                if ($option_value_query->num_rows) {
                                    if ($option_value_query->row['price_prefix'] == '+') {
                                        $option_price += $option_value_query->row['price'];
                                    } elseif ($option_value_query->row['price_prefix'] == '-') {
                                        $option_price -= $option_value_query->row['price'];
                                    }

                                    if ($option_value_query->row['points_prefix'] == '+') {
                                        $option_points += $option_value_query->row['points'];
                                    } elseif ($option_value_query->row['points_prefix'] == '-') {
                                        $option_points -= $option_value_query->row['points'];
                                    }

                                    if ($option_value_query->row['weight_prefix'] == '+') {
                                        $option_weight += $option_value_query->row['weight'];
                                    } elseif ($option_value_query->row['weight_prefix'] == '-') {
                                        $option_weight -= $option_value_query->row['weight'];
                                    }

                                    if ($option_value_query->row['subtract'] && (!$option_value_query->row['quantity'] || ($option_value_query->row['quantity'] < $cart['quantity']))) {
                                        $stock = false;
                                    }

                                    $option_data[] = array(
                                        'product_option_id' => $product_option_id,
                                        'product_option_value_id' => $product_option_value_id,
                                        'option_id' => $option_query->row['option_id'],
                                        'option_value_id' => $option_value_query->row['option_value_id'],
                                        'name' => $option_query->row['name'],
                                        'value' => $option_value_query->row['name'],
                                        'type' => $option_query->row['type'],
                                        'quantity' => $option_value_query->row['quantity'],
                                        'subtract' => $option_value_query->row['subtract'],
                                        'price' => $option_value_query->row['price'],
                                        'price_prefix' => $option_value_query->row['price_prefix'],
                                        'points' => $option_value_query->row['points'],
                                        'points_prefix' => $option_value_query->row['points_prefix'],
                                        'weight' => $option_value_query->row['weight'],
                                        'weight_prefix' => $option_value_query->row['weight_prefix']
                                    );
                                }
                            }
                        } elseif ($option_query->row['type'] == 'text' || $option_query->row['type'] == 'textarea' || $option_query->row['type'] == 'file' || $option_query->row['type'] == 'date' || $option_query->row['type'] == 'datetime' || $option_query->row['type'] == 'time') {
                            $option_data[] = array(
                                'product_option_id' => $product_option_id,
                                'product_option_value_id' => '',
                                'option_id' => $option_query->row['option_id'],
                                'option_value_id' => '',
                                'name' => $option_query->row['name'],
                                'value' => $value,
                                'type' => $option_query->row['type'],
                                'quantity' => '',
                                'subtract' => '',
                                'price' => '',
                                'price_prefix' => '',
                                'points' => '',
                                'points_prefix' => '',
                                'weight' => '',
                                'weight_prefix' => ''
                            );
                        }
                    }
                }

                $price = $product_query->row['price'];

                // Product Discounts
                $discount_quantity = 0;

                foreach ($cart_query->rows as $cart_2) {
                    if ($cart_2['product_id'] == $cart['product_id']) {
                        $discount_quantity += $cart_2['quantity'];
                    }
                }

                $product_discount_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_discount WHERE product_id = '" . (int) $cart['product_id'] . "' AND customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "' AND quantity <= '" . (int) $discount_quantity . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY quantity DESC, priority ASC, price ASC LIMIT 1");

                if ($product_discount_query->num_rows) {
                    $price = $product_discount_query->row['price'];
                }

                // Product Specials
                $product_special_query = $this->db->query("SELECT price FROM " . DB_PREFIX . "product_special WHERE product_id = '" . (int) $cart['product_id'] . "' AND customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "' AND ((date_start = '0000-00-00' OR date_start < NOW()) AND (date_end = '0000-00-00' OR date_end > NOW())) ORDER BY priority ASC, price ASC LIMIT 1");

                if ($product_special_query->num_rows) {
                    $price = $product_special_query->row['price'];
                }

                // Reward Points
                $product_reward_query = $this->db->query("SELECT points FROM " . DB_PREFIX . "product_reward WHERE product_id = '" . (int) $cart['product_id'] . "' AND customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "'");

                if ($product_reward_query->num_rows) {
                    $reward = $product_reward_query->row['points'];
                } else {
                    $reward = 0;
                }

                // Downloads
                $download_data = array();

                $download_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_download p2d LEFT JOIN " . DB_PREFIX . "download d ON (p2d.download_id = d.download_id) LEFT JOIN " . DB_PREFIX . "download_description dd ON (d.download_id = dd.download_id) WHERE p2d.product_id = '" . (int) $cart['product_id'] . "' AND dd.language_id = '" . (int) $this->config->get('config_language_id') . "'");

                foreach ($download_query->rows as $download) {
                    $download_data[] = array(
                        'download_id' => $download['download_id'],
                        'name' => $download['name'],
                        'filename' => $download['filename'],
                        'mask' => $download['mask']
                    );
                }

                // Stock
                if (!$product_query->row['quantity'] || ($product_query->row['quantity'] < $cart['quantity'])) {
                    $stock = false;
                }

                $recurring_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "recurring r LEFT JOIN " . DB_PREFIX . "product_recurring pr ON (r.recurring_id = pr.recurring_id) LEFT JOIN " . DB_PREFIX . "recurring_description rd ON (r.recurring_id = rd.recurring_id) WHERE r.recurring_id = '" . (int) $cart['recurring_id'] . "' AND pr.product_id = '" . (int) $cart['product_id'] . "' AND rd.language_id = " . (int) $this->config->get('config_language_id') . " AND r.status = 1 AND pr.customer_group_id = '" . (int) $this->config->get('config_customer_group_id') . "'");

                if ($recurring_query->num_rows) {
                    $recurring = array(
                        'recurring_id' => $cart['recurring_id'],
                        'name' => $recurring_query->row['name'],
                        'frequency' => $recurring_query->row['frequency'],
                        'price' => $recurring_query->row['price'],
                        'cycle' => $recurring_query->row['cycle'],
                        'duration' => $recurring_query->row['duration'],
                        'trial' => $recurring_query->row['trial_status'],
                        'trial_frequency' => $recurring_query->row['trial_frequency'],
                        'trial_price' => $recurring_query->row['trial_price'],
                        'trial_cycle' => $recurring_query->row['trial_cycle'],
                        'trial_duration' => $recurring_query->row['trial_duration']
                    );
                } else {
                    $recurring = false;
                }

                $product_data[] = array(
                    'cart_id' => $cart['cart_id'],
                    'product_id' => $product_query->row['product_id'],
                    'name' => $product_query->row['name'],
                    'model' => $product_query->row['model'],
                    'shipping' => $product_query->row['shipping'],
                    'image' => $product_query->row['image'],
                    'option' => $option_data,
                    'download' => $download_data,
                    'quantity' => $cart['quantity'],
                    'minimum' => $product_query->row['minimum'],
                    'subtract' => $product_query->row['subtract'],
                    'stock' => $stock,
                    'unitprice' => $product_query->row['price'],
                    'price' => ($price + $option_price),
                    'total' => ($price + $option_price) * $cart['quantity'],
                    'reward' => $reward * $cart['quantity'],
                    'points' => ($product_query->row['points'] ? ($product_query->row['points'] + $option_points) * $cart['quantity'] : 0),
                    'tax_class_id' => $product_query->row['tax_class_id'],
                    'weight' => ($product_query->row['weight'] + $option_weight) * $cart['quantity'],
                    'weight_class_id' => $product_query->row['weight_class_id'],
                    'length' => $product_query->row['length'],
                    'width' => $product_query->row['width'],
                    'height' => $product_query->row['height'],
                    'length_class_id' => $product_query->row['length_class_id'],
                    'recurring' => $recurring
                );
            } else {
                $this->remove($cart['cart_id']);
            }
        }

        return $product_data;
    }

    //Get Brewing
    public function getBrewings() {
        if (!$this->brewing) {
            foreach ($this->session->data['brewing'] as $cart_id => $quantity) {
                $brewing_id = $cart_id;
                $brewing_query = $this->db->query("SELECT *, c.customer_ic FROM `" . DB_PREFIX . "herbal_transfer` ht LEFT JOIN `" . DB_PREFIX . "customer` c ON ht.customer_id = c.customer_id WHERE ht.herbal_transfer_id = '" . (int) $brewing_id . "'");
                if ($brewing_query->num_rows) {
                    $price = $brewing_query->row['t_total'];
                    $this->brewing[$cart['cart_id']] = array(
                        'cart_id' => $cart['cart_id'],
                        'brewing_id' => $brewing_query->row['herbal_transfer_id'],
                        'name' => 'Brewing Service',
                        'invoice_prefix' => $brewing_query->row['tranfer_invoice'],
                        'quantity' => $quantity,
                        'customer_ic' => $brewing_query->row['customer_ic'],
                        'unitprice' => $brewing_query->row['t_net'],
                        'gst' => $brewing_query->row['t_gst'],
                        'price' => $brewing_query->row['t_total'],
                        'weight' => 0,
                        'weight_class_id' => 0,
                        'total' => $brewing_query->row['total'],
                        'shipping_address_id' => 0,
                        'reward' => 0,
                        'points' => 0,
                        'tax_class_id' => 0,
                    );
                } else {
                    $this->removeBrewing($cart['cart_id']);
                }
            }
        }
        return $this->brewing;
    }

    //Get Herbal
    public function getHerbals() {
        if (!$this->herbal) {
            foreach ($this->session->data['herbal'] as $cart_id => $quantity) {
                $herbal_id = $cart_id;
                $herbal_query = $this->db->query("SELECT *,c.customer_ic FROM " . DB_PREFIX . "clinical_sale cs  LEFT JOIN " . DB_PREFIX . "customer c ON (cs.customer_id = c.customer_id) WHERE cs.clinical_sale_id = '" . (int) $herbal_id . "'");
                if ($herbal_query->num_rows) {
                    $price = $herbal_query->row['total_d_gst'];
                    $enable_consultation = $herbal_query->row['collect_consultation_price'];
                    if ($enable_consultation == 1) {
                        $unitprice = $herbal_query->row['d_net_amount'];
                    } else {
                        $unitprice = $herbal_query->row['clinicalsale_concultation'];
                    }

                    $this->herbal[$cart['cart_id']] = array(
                        'cart_id' => $cart['cart_id'],
                        'herbal_id' => $herbal_query->row['clinical_sale_id'],
                        'name' => 'Herbal Remedies',
                        'invoice_prefix' => $herbal_query->row['invoice_prefix'],
                        'quantity' => $quantity,
                        'customer_ic' => $herbal_query->row['customer_ic'],
                        'unitprice' => $unitprice,
                        'gst' => $herbal_query->row['d_gst'],
                        'price' => $herbal_query->row['total_d_gst'],
                        'weight' => $herbal_query->row['weight'],
                        'weight_class_id' => $herbal_query->row['weight_class_id'],
                        'total' => $herbal_query->row['total_d_gst'],
                        'shipping_address_id' => $herbal_query->row['shipping_address_id'],
                        'reward' => 0,
                        'points' => 0,
                        'tax_class_id' => 0,
                    );
                } else {
                    $this->removeHerbal($cart['cart_id']);
                }
            }
        }
        return $this->herbal;
    }

    //Get Services
    public function getServices() {
        if (!$this->service) {
            foreach ($this->session->data['service'] as $cart_id => $quantity) {
                $service_id = $cart_id;
                $service_query = $this->db->query("SELECT *,c.customer_ic FROM " . DB_PREFIX . "service_form sf  LEFT JOIN " . DB_PREFIX . "customer c ON (sf.customer_id = c.customer_id) WHERE sf.service_form_id = '" . (int) $service_id . "'");
                if ($service_query->num_rows) {
                    $price = $service_query->row['total_price'];
                    $this->service[$cart['cart_id']] = array(
                        'cart_id' => $cart['cart_id'],
                        'service_id' => $service_query->row['service_form_id'],
                        'name' => 'Service',
                        'invoice_prefix' => $service_query->row['invoice_prefix'],
                        'quantity' => $quantity,
                        'customer_ic' => $service_query->row['customer_ic'],
                        'unitprice' => $service_query->row['net_amount'],
                        'gst' => $service_query->row['t_gst'],
                        'price' => $service_query->row['total_price'],
                        'total' => $service_query->row['total_price'],
                        'reward' => 0,
                        'points' => 0,
                        'tax_class_id' => 0,
                    );
                } else {
                    $this->removeService($cart['cart_id']);
                }
            }
        }
        return $this->service;
    }

    public function add($product_id, $quantity = 1, $option = array(), $recurring_id = 0) {
        $query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND product_id = '" . (int) $product_id . "' AND recurring_id = '" . (int) $recurring_id . "' AND `option` = '" . $this->db->escape(json_encode($option)) . "'");

        if (!$query->row['total']) {
            $this->db->query("INSERT " . DB_PREFIX . "cart SET api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "', customer_id = '" . (int) $this->customer->getId() . "', session_id = '" . $this->db->escape($this->session->getId()) . "', product_id = '" . (int) $product_id . "', recurring_id = '" . (int) $recurring_id . "', `option` = '" . $this->db->escape(json_encode($option)) . "', quantity = '" . (int) $quantity . "', date_added = NOW()");
        } else {
            $this->db->query("UPDATE " . DB_PREFIX . "cart SET quantity = (quantity + " . (int) $quantity . ") WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "' AND product_id = '" . (int) $product_id . "' AND recurring_id = '" . (int) $recurring_id . "' AND `option` = '" . $this->db->escape(json_encode($option)) . "'");
        }
    }

    public function update($cart_id, $quantity) {
        $this->db->query("UPDATE " . DB_PREFIX . "cart SET quantity = '" . (int) $quantity . "' WHERE cart_id = '" . (int) $cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
    }

    public function remove($cart_id) {
        $this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE cart_id = '" . (int) $cart_id . "' AND api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");
    }

    public function clear() {
        $this->db->query("DELETE FROM " . DB_PREFIX . "cart WHERE api_id = '" . (isset($this->session->data['api_id']) ? (int) $this->session->data['api_id'] : 0) . "' AND customer_id = '" . (int) $this->customer->getId() . "' AND session_id = '" . $this->db->escape($this->session->getId()) . "'");

        $this->data = array();
        $this->session->data['cart'] = array();
        $this->session->data['service'] = array();
        $this->session->data['herbal'] = array();
        $this->session->data['brewing'] = array();
        unset($this->session->data['shipping_method']);
        unset($this->session->data['shipping_addres_id']);
    }

    //Get Product Stock
    function getStock($product_id) {
        $stok_quantity = $this->db->query("SELECT * FROM " . DB_PREFIX . "product_to_store s WHERE s.product_id = '" . (int) $product_id . "' AND store_id = '" . (int) $this->config->get('config_store_id') . "'");
        return $stok_quantity->rows;
    }

    public function getRecurringProducts() {
        $product_data = array();

        foreach ($this->getProducts() as $value) {
            if ($value['recurring']) {
                $product_data[] = $value;
            }
        }

        return $product_data;
    }

    //Get Points
    public function getpoints() {
        $points = 0;
        foreach ($this->getProducts() as $product) {
            $points += $product['points'];
        }
        return $points;
    }

    //Get Reward
    public function getreward() {
        $reward = 0;
        foreach ($this->getProducts() as $product) {
            $reward += $product['reward'];
        }
        return $reward;
    }

    public function getWeight() {
        $weight = 0;

        foreach ($this->getProducts() as $product) {
            if ($product['shipping']) {
                $weight += $this->weight->convert($product['weight'], $product['weight_class_id'], $this->config->get('config_weight_class_id'));
            }
        }

        if ($this->getHerbals()) {
            foreach ($this->getHerbals() as $herbal) {
                $weight += $this->weight->convert($herbal['weight'], $herbal['weight_class_id'], $this->config->get('config_weight_class_id'));
            }
        }

        return $weight;
    }

    //Get All Subtotal In Cart
    public function getSubTotal() {
        $total = 0;
        //Product
        foreach ($this->getProducts() as $product) {
            $tax = $this->tax->getTax($product['price'], $product['tax_class_id']);
            if ($tax < 0) {
                $product['total'] = $product['total'] + ($tax * $product['quantity']);
            }
            $total += $product['total'];
        }
        //Service
        foreach ($this->getServices() as $service) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int) $service['service_id'] . "' AND code='sub_total'");
            $total += $query->row['value'];
        }
        //Brewing
        foreach ($this->getBrewings() as $brewings) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE 1 AND ht.herbal_transfer_id = '" . (int) $brewings['brewing_id'] . "' AND ht.code = 'sub_total' AND ht.htt_id = '4' ");
            if (!empty($query->row['value'])) {
                $total += $query->row['value'];
            }
        }
        //Herbal
        foreach ($this->getHerbals() as $herbals) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int) $herbals['herbal_id'] . "' AND code='sub_total' AND id=2");
            $total += $query->row['value'];
        }
        return $total;
    }

    //get Taxes Total of Cart
    public function getTaxes() {
        $tax_data = array();
        //Product
        foreach ($this->getProducts() as $product) {
            if ($product['tax_class_id']) {
                $tax_rates = $this->tax->getRates($product['price'], $product['tax_class_id']);
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_rate_id']])) {
                        $tax_data[$tax_rate['tax_rate_id']] = ($tax_rate['amount'] * $product['quantity']);
                    } else {
                        $tax_data[$tax_rate['tax_rate_id']] += ($tax_rate['amount'] * $product['quantity']);
                    }
                }
            }
        }
        //Service
        foreach ($this->getServices() as $service) {
            $query = $this->db->query("SELECT tax_key,value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int) $service['service_id'] . "' AND code='tax'");
            $taxes = $query->rows;
            if ($taxes) {
                $tax_rates = $taxes;
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_key']])) {
                        $tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
                    } else {
                        $tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
                    }
                }
            }
        }
        //Brewing 
        foreach ($this->getBrewings() as $brewings) {
            $query = $this->db->query("SELECT tax_key, value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE ht.herbal_transfer_id = '" . (int) $brewings['brewing_id'] . "' AND ht.code = 'tax' AND ht.htt_id = '4' ");
            $taxes = $query->rows;
            if ($taxes) {
                $tax_rates = $taxes;
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_key']])) {
                        $tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
                    } else {
                        $tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
                    }
                }
            }
        }
        //Herbal
        foreach ($this->getHerbals() as $herbals) {
            $query = $this->db->query("SELECT tax_key,value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int) $herbals['herbal_id'] . "' AND code='tax' AND id=2");
            $taxes = $query->rows;
            if ($taxes) {
                $tax_rates = $taxes;
                foreach ($tax_rates as $tax_rate) {
                    if (!isset($tax_data[$tax_rate['tax_key']])) {
                        $tax_data[$tax_rate['tax_key']] = $tax_rate['value'];
                    } else {
                        $tax_data[$tax_rate['tax_key']] += $tax_rate['value'];
                    }
                }
            }
        }
        return $tax_data;
    }

    //Get Totol In Cart
    public function getTotal() {
        $total = 0;
        //Product
        foreach ($this->getProducts() as $product) {
            $total += $this->tax->calculate($product['price'], $product['tax_class_id'], $this->config->get('config_tax')) * $product['quantity'];
        }
        //Service
        foreach ($this->getServices() as $service) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "service_total` WHERE service_form_id = '" . (int) $service['service_id'] . "' AND code='total'");
            $total += $query->row['value'];
        }
        //Brewing
        foreach ($this->getBrewings() as $brewings) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "herbal_transfer_total` ht WHERE ht.herbal_transfer_id = '" . (int) $brewings['brewing_id'] . "' AND ht.code = 'total' AND ht.htt_id = '4' ");
            if (!empty($query->row['value'])) {
                $total += $query->row['value'];
            }
        }
        //Herbal
        foreach ($this->getHerbals() as $herbals) {
            $query = $this->db->query("SELECT value FROM `" . DB_PREFIX . "clinical_sale_total` WHERE clinical_sale_id = '" . (int) $herbals['herbal_id'] . "' AND code='total' AND id=2");
            $total += $query->row['value'];
        }
        //Rounding
        if (isset($this->session->data['rounding'])) {
            $total += $this->session->data['rounding'];
        }
        return $total;
    }

    public function countProducts() {
        $product_total = 0;

        $products = $this->getProducts();

        foreach ($products as $product) {
            $product_total += $product['quantity'];
        }

        return $product_total;
    }

    public function hasProducts() {
        return count($this->getProducts());
    }

    public function hasRecurringProducts() {
        return count($this->getRecurringProducts());
    }

    public function hasStock() {
        foreach ($this->getProducts() as $product) {
            if (!$product['stock']) {
                return false;
            }
        }

        return true;
    }

    public function hasShipping() {
        foreach ($this->getProducts() as $product) {
            if ($product['shipping']) {
                return true;
            }
        }

        return false;
    }

    public function hasDownload() {
        foreach ($this->getProducts() as $product) {
            if ($product['download']) {
                return true;
            }
        }

        return false;
    }

    //Add Brewing
    public function addBrewing($brewing_id, $quantity = 1) {
        $this->data = array();
        $brewing['brewing_id'] = (int) $brewing_id;
        $cart_id = $brewing['brewing_id'];
        if ((int) $quantity && ((int) $quantity > 0)) {
            if (!isset($this->session->data['brewing'][$cart_id])) {
                $this->session->data['brewing'][$cart_id] = (int) $quantity;
            }
        }
        return $cart_id;
    }

    //Add Herbal
    public function addHerbal($herbal_id, $quantity = 1) {
        $this->data = array();
        $service['herbal_id'] = (int) $herbal_id;
        $cart_id = $service['herbal_id'];
        if ((int) $quantity && ((int) $quantity > 0)) {
            if (!isset($this->session->data['herbal'][$cart_id])) {
                $this->session->data['herbal'][$cart_id] = (int) $quantity;
            }
        }
        return $cart_id;
    }

    //Add Service
    public function addService($service_id, $quantity = 1) {
        $this->data = array();
        $service['service_id'] = (int) $service_id;
        $cart_id = $service['service_id'];
        if ((int) $quantity && ((int) $quantity > 0)) {
            if (!isset($this->session->data['service'][$cart_id])) {
                $this->session->data['service'][$cart_id] = (int) $quantity;
            }
        }
        return $cart_id;
    }

    //Remove Brewing
    public function removeBrewing($cart_id) {
        $this->data = array();
        unset($this->session->data['brewing'][$cart_id]);
    }

    //Remove Herbal
    public function removeHerbal($cart_id) {
        $this->data = array();
        unset($this->session->data['herbal'][$cart_id]);
    }

    //Remove Service
    public function removeService($cart_id) {
        $this->data = array();
        unset($this->session->data['service'][$cart_id]);
    }

    //Clear Brewing
    public function clearBrewing() {
        $this->data = array();
        unset($this->session->data['brewing']);
    }

    //Clear Herbal
    public function clearHerbal() {
        $this->data = array();
        unset($this->session->data['herbal']);
    }

    //Clear Service
    public function clearService() {
        $this->data = array();
        unset($this->session->data['service']);
    }

}
