<?php

class Api
{
    public function __construct($registry)
    {
        date_default_timezone_set("Asia/Kuala_Lumpur");
        $this->obfuscate = $registry->get('obfuscate');
        $this->response = $registry->get('response');
        $this->db = $registry->get('db');
        $this->session = $registry->get('session');
        $this->config = $registry->get('config');
    }

    public function checkOrigin($from = "https://www.etcm.me/")
    {
        if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', base64_decode(substr($_SERVER['HTTP_AUTHORIZATION'], 6)));
        }
        $authorization_key = !empty($_SERVER['PHP_AUTH_PW']) ? $_SERVER['PHP_AUTH_PW'] : false;


        $data = $authorization_key;
        $result = $this->obfuscate->decrypt($data);
        $server = isset($result['server']) ? $result['server'] : false;
        $datetime = isset($result['datetime']) ? $result['datetime'] : date("Y-m-d H:is");
        if (!($server == $from)) {
            return false;
        }
        if (strtotime($datetime) > strtotime(date("Y-m-d H:is"))) {
            return true;
        } else {
            return false;
        }
    }

    public function checkAuth()
    {
        if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', base64_decode(substr($_SERVER['HTTP_AUTHORIZATION'], 6)));
        }
        $token = !empty($_SERVER['PHP_AUTH_PW']) ? $_SERVER['PHP_AUTH_PW'] : false;

        if ($token) {
            $token_info = $this->obfuscate->decrypt($token);
            if (!(is_array($token_info) && isset($token_info['expired']) && isset($token_info['user_name']) && isset($token_info['store_id']) && isset($token_info['user_id']))) {
                $this->response->setResponse(401,    $this->response->noResponse(), "Wrong authorization format");
                return;
            }
            //temp disabled expiration token checking
            // if (strtotime($token_info['expired']) < strtotime(date('Y-m-d H:i:s'))) {
            //     $this->response->setResponse(419,    $this->response->noResponse(), "Token expired");
            //     return;
            // } 
            else {
                return $token_info;
            }
        } else {
            $this->response->setResponse(401, $this->response->noResponse(), "no authorization found");
            return;
        }
    }

    public function getTokenInfo()
    {
        $info = array();
        if (!empty($_SERVER['HTTP_AUTHORIZATION'])) {
            list($_SERVER['PHP_AUTH_USER'], $_SERVER['PHP_AUTH_PW']) = explode(':', base64_decode(substr($_SERVER['HTTP_AUTHORIZATION'], 6)));
        }
        $token = !empty($_SERVER['PHP_AUTH_PW']) ? $_SERVER['PHP_AUTH_PW'] : false;

        if ($token) {
            $info = $this->obfuscate->decrypt($token);
        }

        return $info;
    }


    private function clean($data)
    {
        if (is_array($data)) {
            foreach ($data as $key => $value) {
                unset($data[$key]);

                $data[$this->clean($key)] = $this->clean($value);
            }
        } else {
            $data = htmlspecialchars($data, ENT_COMPAT, 'UTF-8');
        }

        return $data;
    }

    public function get_php_input_json()
    {
        $jsonString = file_get_contents('php://input');
        $json = json_decode($jsonString, true);
        $result = is_array($json) ? $json : array();

        return $this->clean($result);
    }

    public function addTracking()
    {
        $device_id = isset($_SERVER['HTTP_DEVICE_ID']) ? $_SERVER['HTTP_DEVICE_ID'] : false;
        $combine_request = [
            'server' => $_SERVER,
            'get' => $_GET,
            'post' => $_POST,
            'raw_post_data' => file_get_contents('php://input'),
            'session_params' => session_get_cookie_params(),
            'cookie' => $_COOKIE,
            'header' => headers_list(),
        ];
        $sql_track = "INSERT INTO " . DB_PREFIX . "doctorapp_tracking SET 
                    url='" . $this->db->escape($_SERVER['REQUEST_URI']) . "',
                    device_id='" . $this->db->escape($device_id) . "',
                    request='" . $this->db->escape(json_encode($combine_request)) . "',
                    created_date=NOW()";

        $this->db->query($sql_track);
        return $this->db->getLastId();
    }

    public function trackResponse($response)
    {
        $sql_track = "UPDATE " . DB_PREFIX . "doctorapp_tracking SET 
		response='" . $this->db->escape(json_encode($response)) . "'
		WHERE id ='" . (int)$this->session->data['tracking_id'] . "'";
        $this->db->query($sql_track);
    }
}
