<?php

class ControllerSaleOrder extends Controller
{

    private $error = array();

    public function index()
    {
        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        $this->load->model('sale/customer_group');
        $this->getList();
    }

    public function add()
    {
        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        unset($this->session->data['cookie']);

        if ($this->validate()) {
            // API
            $this->load->model('user/api');
            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

            if ($api_info) {
                $curl = curl_init();
                // Set SSL if required
                if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                    curl_setopt($curl, CURLOPT_PORT, 443);
                }
                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));
                $json = curl_exec($curl);

                if (!$json) {
                    $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                } else {
                    $response = json_decode($json, true);
                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }
                    curl_close($curl);
                }
            }
        }

        $this->getForm();
    }

    public function edit()
    {
        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        unset($this->session->data['cookie']);

        if ($this->validate()) {
            // API
            $this->load->model('user/api');
            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

            if ($api_info) {
                $curl = curl_init();
                // Set SSL if required
                if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                    curl_setopt($curl, CURLOPT_PORT, 443);
                }
                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));
                $json = curl_exec($curl);

                if (!$json) {
                    $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                } else {
                    $response = json_decode($json, true);

                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }
                    curl_close($curl);
                }
            }
        }

        $this->getForm();
    }

    public function complete_order()
    {
        $this->load->language('sale/order');

        $this->load->model('sale/order');
        $this->load->model('setting/transaction_no');

        if (isset($this->request->post['selected'])) {
            array_multisort($this->request->post['selected'], SORT_ASC);
            foreach ($this->request->post['selected'] as $order_id) {
                $order_info = $this->model_sale_order->getOrder($order_id);

                if (!empty($order_info)) {
                    if ($order_info['order_status_id'] != '5' && empty($order_info['invoice_prefix'])) {
                        $module = 'pos/pos';
                        $store_id = $this->session->data['store_id'];

                        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => $module, 'store' => $store_id));

                        $this->model_sale_order->complete_order($order_id, $invoice_prefix, $module, $store_id);
                    } else if ($order_info['order_status_id'] != '5' && !empty($order_info['invoice_prefix'])) {
                        $module = 'pos/pos';
                        $store_id = $this->session->data['store_id'];

                        $invoice_prefix = $order_info['invoice_prefix'];

                        $this->model_sale_order->complete_order2($order_id, $invoice_prefix, $module, $store_id);
                    }
                }
            }

            $this->session->data['success'] = $this->language->get('text_success_complete_order');

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }

            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            if (isset($this->request->get['filter_invoice'])) {
                $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group'])) {
                $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_tracking_num'])) {
                $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }
    }

    public function delete()
    {
        $this->load->language('sale/order');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->load->model('sale/order');
        unset($this->session->data['cookie']);

        if (isset($this->request->get['order_id']) && $this->validate()) {
            // API
            $this->load->model('user/api');

            $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

            if ($api_info) {
                $curl = curl_init();

                // Set SSL if required
                if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                    curl_setopt($curl, CURLOPT_PORT, 443);
                }

                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));

                $json = curl_exec($curl);

                if (!$json) {
                    $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                } else {
                    $response = json_decode($json, true);

                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }

                    curl_close($curl);
                }
            }
        }

        if (isset($this->session->data['cookie'])) {
            $curl = curl_init();

            // Set SSL if required
            if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                curl_setopt($curl, CURLOPT_PORT, 443);
            }

            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/order/delete&order_id=' . $this->request->get['order_id']);
            curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

            $json = curl_exec($curl);

            if (!$json) {
                $this->error['warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
            } else {
                $response = json_decode($json, true);

                curl_close($curl);

                if (isset($response['error'])) {
                    $this->error['warning'] = $response['error'];
                }
            }
        }

        if (isset($response['error'])) {
            $this->error['warning'] = $response['error'];
        }

        if (isset($response['success'])) {
            $this->session->data['success'] = $response['success'];

            $url = '';

            if (isset($this->request->get['filter_date_added_from'])) {
                $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
            }

            if (isset($this->request->get['filter_date_added_to'])) {
                $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
            }

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_store_id'])) {
                $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
            }

            if (isset($this->request->get['filter_invoice'])) {
                $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            if (isset($this->request->get['filter_customer_group'])) {
                $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
            }

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_tracking_num'])) {
                $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true));
        }

        $this->getList();
    }

    public function getProductWeight($product_id)
    {
        $product_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "product p  WHERE p.product_id = '" . (int) $product_id . "'");
        return !empty($product_query->row['weight']) ? $product_query->row['weight'] : 1;
    }

    public function hold_order()
    {
        $this->load->language('sale/order');
        $this->load->model('sale/order');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];

            $herbals_paid = $this->model_sale_order->getPaidHerbals($order_id);
            $services_paid = $this->model_sale_order->getPaidServies($order_id);

            $orders_products = $this->model_sale_order->getOrderProducts($order_id);
            if (!empty($orders_products)) {
                $order_info = $this->model_sale_order->getOrder($order_id);
                $invoice_wholesaler = 0;
                if (!empty($order_info['invoice_wholesaler'])) {
                    $invoice_wholesaler = $order_info['invoice_wholesaler'];
                }

                foreach ($orders_products as $product) {
                    $product_id = $product['product_id'];
                    $weight = $this->getProductWeight($product_id);
                    if (empty($invoice_wholesaler)) {
                        $product_weight = $this->weight->convert($weight, $product['weight_class_id'], $this->config->get('config_weight_class_id'));
                        $quantity = $product_weight * $product['quantity'];
                    } else {
                        $quantity = $product['total_weight'];
                    }

                    $product_stock = $this->model_sale_order->get_product_stock($product_id);
                    if (!empty($product_stock)) {
                        $product_stock_qty = $product_stock['onhand_quantity'];

                        $stock_to_reload = $product_stock_qty + $quantity;

                        //$this->model_sale_order->update_product_stock($product_id, $stock_to_reload);
                    }
                }
            }

            if (!empty($herbals_paid)) {
                foreach ($herbals_paid as $herbal) {
                    $clinical_sale_id = $herbal['clinical_sale_id'];

                    $clinical_sale_products = $this->model_sale_order->get_clinicalsale_products($clinical_sale_id);

                    if (!empty($clinical_sale_products)) {
                        foreach ($clinical_sale_products as $product) {
                            $product_id = $product['product_id'];
                            $quantity = $product['t_qty'];

                            $product_stock = $this->model_sale_order->get_product_stock($product_id);

                            if (!empty($product_stock)) {
                                $product_stock_qty = $product_stock['onhand_quantity'];

                                $stock_to_reload = $product_stock_qty + $quantity;

                                //$this->model_sale_order->update_product_stock($product_id, $stock_to_reload);
                            }
                        }
                    }

                    $this->model_sale_order->set_pending_clinical_sale($clinical_sale_id);
                }
            }

            if (!empty($services_paid)) {
                foreach ($services_paid as $service) {
                    $service_form_id = $service['service_form_id'];

                    $this->model_sale_order->set_pending_service_form($service_form_id);
                }
            }

            $this->model_sale_order->updateCancel(1, $order_id);

            $data = array();

            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $data['invoice_prefix'] = $order_info['invoice_prefix'];
            }

            $this->model_sale_order->set_hold_order_status($order_id, $data);

            $this->session->data['success'] = $this->language->get('text_hold_order_success');

            $this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true));
        } else {
            $this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true));
        }
    }

    public function getOrderStatusColor($order_status_id)
    {
        $color = '#000';
        switch ($order_status_id) {
            case '0':
                $color = '#000';
                break;
            case '1':
                $color = '#ff5722';
                break;
            case '2':
                $color = '#03a9f4';
                break;
            case '3':
                $color = '#8d6e63';
                break;
            case '5':
                $color = '#00c853';
                break;
            case '7':
                $color = '#ff1744';
                break;
            case '15':
                $color = '#283593';
                break;
            case '17':
                $color = '#9c27b0';
                break;
            default:
                $color = '#000';
                break;
        }
        return $color;
    }

    protected function getList()
    {
        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_store_id'])) {
            if ($this->request->get['filter_store_id'] != '*') {
                $filter_store_id = $this->request->get['filter_store_id'];
            } else {
                $filter_store_id = NULL;
            }
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $filter_invoice = $this->request->get['filter_invoice'];
        } else {
            $filter_invoice = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_carrier'])) {
            $filter_carrier = $this->request->get['filter_carrier'];
        } else {
            $filter_carrier = null;
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $filter_tracking_num = $this->request->get['filter_tracking_num'];
        } else {
            $filter_tracking_num = null;
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['filter_telephone'])) {
            $filter_telephone = $this->request->get['filter_telephone'];
        } else {
            $filter_telephone = null;
        }

        if (isset($this->request->get['filter_payment'])) {
            $filter_payment = $this->request->get['filter_payment'];
        } else {
            $filter_payment = null;
        }


        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }


        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_payment'])) {
            $url .= '&filter_payment=' . $this->request->get['filter_payment'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['hold_invoice_pdf'] = $this->url->link('sale/order/invoiceHoald', 'user_token=' . $this->session->data['user_token'] . '&pdf=true', true);
        $data['invoiceSO'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&pdf=true', true);
        $data['invoice_pdf'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=true', true);
        $data['invoice_pdf_gst'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&pdf=true&gst=1', true);
        $data['shipping'] = $this->url->link('sale/order/shipping', 'user_token=' . $this->session->data['user_token'], true);
        $data['receipt'] = $this->url->link('sale/order/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1', true);
        $data['receipt_gst'] = $this->url->link('sale/order/invoiceReceipt', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&gst=1', true);
        $data['insert'] = $this->url->link('sale/order/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['complete_order'] = $this->url->link('sale/order/complete_order', 'user_token=' . $this->session->data['user_token'], true);
        $data['export_excel'] = $this->url->link('sale/order/export_excel', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['import_excel'] = $this->url->link('sale/order/import_excel', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['user_view'] = $this->user->user_view;

        $this->load->model('setting/store');
        $data['stores'] = array();

        $sname = $this->config->get('config_name');

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $sname . $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name' => $store['name']
            );
        }

        $data['orders'] = array();

        $filter_data = array(
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_order_id' => $filter_order_id,
            'filter_store_id' => $filter_store_id,
            'filter_customer' => $filter_customer,
            'filter_invoice' => $filter_invoice,
            'filter_customer_group' => $filter_customer_group,
            'filter_telephone' => $filter_telephone,
            'filter_order_status' => $filter_order_status,
            'filter_tracking_num' => $filter_tracking_num,
            'filter_carrier' => $filter_carrier,
            'filter_total' => $filter_total,
            'filter_date_added' => $filter_date_added,
            'filter_date_modified' => $filter_date_modified,
            'filter_payment' => $filter_payment,
            'sort' => $sort,
            'order' => $order,
            'start' => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit' => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);

        $results = $this->model_sale_order->getOrders($filter_data);

        $this->load->model('tool/image');

        foreach ($results as $result) {
            $customer_group_row = $this->model_sale_customer_group->getCustomerGroup($result['customer_group_id']);
            $customer_group = !empty($customer_group_row) ? $customer_group_row['name'] : '';

            $status_color = $this->getOrderStatusColor($result['order_status_id']);

            if ($result['carrier_id'] > 0) {
                $carrier_info = $this->model_sale_order->getCarrier($result['carrier_id']);
                $carrier_url = !empty($carrier_info) ? str_replace('{tracking_number}', $result['tracking_number'], $carrier_info['tracking_url']) : '';
                $carrier_image = !empty($carrier_info) ? $this->model_tool_image->resize($carrier_info['image'], 110, 30) : '';
            } else {
                $carrier_url = '';
                $carrier_image = '';
            }

            $add_by_info    = !empty($result['add_by']) ? $this->model_sale_order->getUserInfo($result['add_by']) : [];
            $add_by         = !empty($add_by_info['name']) ? $add_by_info['name'] : '';
            $modify_by_info    = !empty($result['modifi_by']) ? $this->model_sale_order->getUserInfo($result['modifi_by']) : [];
            $modifi_by         = !empty($modify_by_info['name']) ? $modify_by_info['name'] : '';

            $data['orders'][] = array(
                'order_id' => $result['order_id'],
                'invoice_prefix' => $result['invoice_prefix'],
                'customer' => $result['customer'],
                'customer_group' => $customer_group,
                'order_status_id' => $result['order_status_id'],
                'telephone' => $result['telephone'],
                'status' => $result['status'],
                'status_color' => $status_color,
                'total' => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'add_by' => $add_by,
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'modifi_by' => $modifi_by,
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'carrier_id' => $result['carrier_id'],
                'tracking_num' => $result['tracking_number'],
                'carrier_url' => $carrier_url,
                'carrier_image' => $carrier_image,
                'payment_method' => $result['payment_method'],
                'view' => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true),
                'print_cn' => $this->url->link('extension/module/shipping_template/print_consignment_note', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'], true),
                'edit' => $this->url->link('sale/order/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true),
                'delete' => $this->url->link('sale/order/delete', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true),
                'hold'            => $this->url->link('sale/order/hold_order', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, 'SSL')
            );
        }

        $data['payment_methods'] = $this->model_sale_order->getPaymentMethod(); 

        $data['payment_methods'] = array_column($data['payment_methods'], 'payment_method');

        $data['add'] = $this->url->link('sale/order/add', 'user_token=' . $this->session->data['user_token'], true);
        $data['online_customer_settings'] = $this->url->link('sale/order/settings', 'user_token=' . $this->session->data['user_token'], true);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array) $this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_telephone'])) {
            $url .= '&filter_telephone=' . urlencode(html_entity_decode($this->request->get['filter_telephone'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_payment'])) {
            $url .= '&filter_payment=' . $this->request->get['filter_payment'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.order_id' . $url, true);
        $data['sort_invoice'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.invoice_prefix' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, true);
        $data['sort_customer_group'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=customer_group_id' . $url, true);
        $data['sort_status'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_modified' . $url, true);
        $data['sort_telephone'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.telephone' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_date_added_from'])) {
            $url .= '&filter_date_added_from=' . $this->request->get['filter_date_added_from'];
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $url .= '&filter_date_added_to=' . $this->request->get['filter_date_added_to'];
        }

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_store_id'])) {
            $url .= '&filter_store_id=' . $this->request->get['filter_store_id'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $url .= '&filter_invoice=' . urlencode(html_entity_decode($this->request->get['filter_invoice'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $url .= '&filter_customer_group=' . $this->request->get['filter_customer_group'];
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_carrier'])) {
            $url .= '&filter_carrier=' . $this->request->get['filter_carrier'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['filter_payment'])) {
            $url .= '&filter_payment=' . $this->request->get['filter_payment'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_store_id'] = $filter_store_id;
        $data['filter_invoice'] = $filter_invoice;
        $data['filter_customer'] = $filter_customer;
        $data['filter_customer_group'] = $filter_customer_group;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_carrier'] = $filter_carrier;
        $data['filter_total'] = $filter_total;
        $data['filter_telephone'] = $filter_telephone;
        $data['filter_tracking_num'] = $filter_tracking_num;
        $data['filter_date_added_to'] = $filter_date_added_to;
        $data['filter_date_added_from'] = $filter_date_added_from;
        //$data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;
        $data['filter_payment'] = $filter_payment;


        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        // $filter_keys = array('1', '2', '5', '7', '10', '11', '15', '17');
        // foreach ($order_statuses as $order_status) {
        //     if (in_array($order_status['order_status_id'], $filter_keys)) {
        //         $data['order_statuses'][] = [
        //             'order_status_id' => $order_status['order_status_id'],
        //             'name' => $order_status['name']
        //         ];
        //     }
        // }

        $data['order_statuses_for_shipping'] = $data['order_statuses'];

        $this->load->model('sale/shipping_module');

        $data['carriers'] = $this->model_sale_shipping_module->getCarriers();

        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();

        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/order_list', $data));
    }

    public function getForm()
    {
        $data['text_form'] = !isset($this->request->get['order_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        $url = '';

        $data['order_products'] = array();
        $data['order_vouchers'] = array();
        $data['order_herbal'] = array();
        $data['order_service'] = array();

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['cancel'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->request->get['order_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);
        }

        if (!empty($order_info)) {
            $data['order_id'] = $this->request->get['order_id'];
            $data['store_id'] = $order_info['store_id'];
            $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

            $data['customer'] = $order_info['customer'];
            $data['customer_id'] = $order_info['customer_id'];
            $data['customer_group_id'] = $order_info['customer_group_id'];
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];
            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['fax'] = $order_info['fax'];
            $data['account_custom_field'] = $order_info['custom_field'];
            $data['invoice_prefix'] = $order_info['invoice_prefix'];

            $this->load->model('customer/customer');

            $data['addresses'] = $this->model_customer_customer->getAddresses($order_info['customer_id']);

            $data['payment_firstname'] = $order_info['payment_firstname'];
            $data['payment_lastname'] = $order_info['payment_lastname'];
            $data['payment_company'] = $order_info['payment_company'];
            $data['payment_address_1'] = $order_info['payment_address_1'];
            $data['payment_address_2'] = $order_info['payment_address_2'];
            $data['payment_city'] = $order_info['payment_city'];
            $data['payment_postcode'] = $order_info['payment_postcode'];
            $data['payment_country_id'] = $order_info['payment_country_id'];
            $data['payment_zone_id'] = $order_info['payment_zone_id'];
            $data['payment_custom_field'] = $order_info['payment_custom_field'];
            $data['payment_method'] = $order_info['payment_method'];
            $data['payment_code'] = $order_info['payment_code'];

            $data['card_no'] = $order_info['card_no'];
            $data['shipping_firstname'] = $order_info['shipping_firstname'];
            $data['shipping_lastname'] = $order_info['shipping_lastname'];
            $data['shipping_company'] = $order_info['shipping_company'];
            $data['shipping_address_1'] = $order_info['shipping_address_1'];
            $data['shipping_address_2'] = $order_info['shipping_address_2'];
            $data['shipping_city'] = $order_info['shipping_city'];
            $data['shipping_postcode'] = $order_info['shipping_postcode'];
            $data['shipping_country_id'] = $order_info['shipping_country_id'];
            $data['shipping_zone_id'] = $order_info['shipping_zone_id'];
            $data['shipping_custom_field'] = $order_info['shipping_custom_field'];
            $data['shipping_method'] = $order_info['shipping_method'];
            $data['shipping_code'] = $order_info['shipping_code'];

            //api clear cart
            if (isset($this->session->data['cookie'])) {

                $test = array();

                $curl = curl_init();

                // Set SSL if required
                if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                    curl_setopt($curl, CURLOPT_PORT, 443);
                }

                curl_setopt($curl, CURLOPT_HEADER, false);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/cart/clear');
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($test));
                curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

                $response = curl_exec($curl);

                if (!$response) {
                    $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                }
            }

            // Add products to the API
            if (isset($this->session->data['cookie'])) {
                $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] == 'select' || $option['type'] == 'radio' || $option['type'] == 'image') {
                            $option_data[$option['product_option_id']] = $option['product_option_value_id'];
                        }

                        if ($option['type'] == 'checkbox') {
                            $option_data[$option['product_option_id']][] = $option['product_option_value_id'];
                        }

                        if ($option['type'] == 'text' || $option['type'] == 'textarea' || $option['type'] == 'file' || $option['type'] == 'date' || $option['type'] == 'datetime' || $option['type'] == 'time') {
                            $option_data[$option['product_option_id']] = $option['value'];
                        }
                    }

                    $this->weight = new Weight($this->registry);

                    if (!empty($product['weight_class_id'])) {
                        $weight_class_from = $product['weight_class_id'];
                    } else {
                        $weight_class_from = '1';
                    }

                    if (isset($this->request->post['weight_class_to'])) {
                        $weight_class_to = $this->request->post['weight_class_to'];
                    } else {
                        $weight_class_to = '1';
                    }

                    $weight_value = $this->weight->convert($product['quantity'], $weight_class_from, $weight_class_to);

                    $product_data = array(
                        'product_id' => $product['product_id'],
                        'option' => $option_data,
                        'quantity' => $weight_value,
                        'weight_class_id' => $product['weight_class_id'],
                        'weigth_value' => $weight_value,
                        'override' => true,
                        'cookie' => $this->session->data['cookie'],
                        'curl' => $curl,
                        'server' => $this->request->server['HTTP_USER_AGENT']
                    );

                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
                    $header = array("Cache-Control: no-cache");
                    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/cart/add');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($product_data));
                    curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

                    $response = curl_exec($curl);

                    curl_close($curl);
                    if (!$response) {

                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    }

                    $data['test'] = array(
                        'header' => $header,
                        'response' => $response
                    );
                }
            }

            // Add Service to the AP
            if (isset($this->session->data['cookie'])) {
                $order_services = $this->model_sale_order->getServies($this->request->get['order_id']);
                foreach ($order_services as $order_service) {

                    $service_data = array(
                        'service_form_id' => $order_service['service_form_id'],
                        'quantity' => 1,
                        'override' => true
                    );

                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/cart/addService');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($service_data));
                    curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

                    $response = curl_exec($curl);

                    if (!$response) {
                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    }
                }
            }

            // Add Herbale to the AP
            if (isset($this->session->data['cookie'])) {
                $order_herbals = $this->model_sale_order->getHerbals($this->request->get['order_id']);
                foreach ($order_herbals as $order_herbal) {

                    $herbal_data = array(
                        'herbal_id' => $order_herbal['clinical_sale_id'],
                        'quantity' => 1,
                        'override' => true
                    );

                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/cart/addHerbal');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($herbal_data));
                    curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

                    $response = curl_exec($curl);

                    if (!$response) {
                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    }
                }
            }

            // Add vouchers to the API
            if (isset($this->session->data['cookie'])) {
                $vouchers = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);

                foreach ($vouchers as $voucher) {
                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/voucher/add');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($voucher));
                    curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');

                    $response = curl_exec($curl);

                    if (!$response) {
                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    }
                }
            }

            // Products
            $data['order_products'] = array();

            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);

            foreach ($products as $product) {
                $data['order_products'][] = array(
                    'product_id' => $product['product_id'],
                    'name' => $product['name'],
                    'model' => $product['model'],
                    'option' => $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']),
                    'quantity' => number_format($product['quantity'], 2),
                    'price' => $product['price'],
                    'total' => $product['total'],
                    'reward' => $product['reward']
                );
            }

            /* Herbal
              $data['order_herbal'] = array();

              $herbals = $this->model_sale_order->getHerbals($this->request->get['order_id']);

              foreach ($herbals as $herbal) {
              $data['order_herbal'][] = array(
              'herbal_id' => $herbal['clinical_sale_id'],
              'invoice_prefix' => $herbal['invoice_prefix'],
              'customer_ic' => $herbal['customer_ic'],
              'quantity' => $herbal['quantity'],
              'unitprice' => $herbal['price'],
              'total' => $herbal['total'],
              );
              }


              // Service
              $data['order_service'] = array();

              $services = $this->model_sale_order->getServies($this->request->get['order_id']);

              foreach ($services as $service) {
              $data['order_herbal'][] = array(
              'service_form_id' => $service['service_form_id'],
              'invoice_prefix' => $service['invoice_prefix'],
              'customer_ic' => $service['customer_ic'],
              'quantity' => $service['quantity'],
              'unitprice' => $service['price'],
              'total' => $service['total_price'],
              );
              } */

            // Vouchers
            $data['order_vouchers'] = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);

            $data['coupon'] = '';
            $data['voucher'] = '';
            $data['reward'] = '';

            $data['order_totals'] = array();

            $order_totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);

            foreach ($order_totals as $order_total) {
                // If coupon, voucher or reward points
                $start = strpos($order_total['title'], '(') + 1;
                $end = strrpos($order_total['title'], ')');

                if ($start && $end) {
                    if ($order_total['code'] == 'coupon') {
                        $data['coupon'] = substr($order_total['title'], $start, $end - $start);
                    }

                    if ($order_total['code'] == 'voucher') {
                        $data['voucher'] = substr($order_total['title'], $start, $end - $start);
                    }

                    if ($order_total['code'] == 'reward') {
                        $data['reward'] = substr($order_total['title'], $start, $end - $start);
                    }
                }
            }

            $data['order_status_id'] = $order_info['order_status_id'];
            $data['comment'] = $order_info['comment'];
            $data['affiliate_id'] = $order_info['affiliate_id'];
            $data['affiliate'] = $order_info['affiliate_firstname'] . ' ' . $order_info['affiliate_lastname'];
            $data['currency_code'] = $order_info['currency_code'];
        } else {
            $data['order_id'] = 0;
            $data['store_id'] = 0;
            $data['store_url'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

            $data['customer'] = '';
            $data['customer_id'] = '';
            $data['customer_group_id'] = $this->config->get('config_customer_group_id');
            $data['firstname'] = '';
            $data['lastname'] = '';
            $data['email'] = '';
            $data['telephone'] = '';
            $data['fax'] = '';
            $data['customer_custom_field'] = array();
            $this->load->model('setting/setting');
            $data['invoice_prefix'] = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $data['store_id']));

            $data['addresses'] = array();

            $data['payment_firstname'] = '';
            $data['payment_lastname'] = '';
            $data['payment_company'] = '';
            $data['payment_address_1'] = '';
            $data['payment_address_2'] = '';
            $data['payment_city'] = '';
            $data['payment_postcode'] = '';
            $data['payment_country_id'] = '';
            $data['payment_zone_id'] = '';
            $data['payment_custom_field'] = array();
            $data['payment_method'] = '';
            $data['payment_code'] = '';

            $data['shipping_firstname'] = '';
            $data['shipping_lastname'] = '';
            $data['shipping_company'] = '';
            $data['shipping_address_1'] = '';
            $data['shipping_address_2'] = '';
            $data['shipping_city'] = '';
            $data['shipping_postcode'] = '';
            $data['shipping_country_id'] = '';
            $data['shipping_zone_id'] = '';
            $data['shipping_custom_field'] = array();
            $data['shipping_method'] = '';
            $data['shipping_code'] = '';

            $data['order_products'] = array();
            $data['order_vouchers'] = array();
            $data['order_totals'] = array();
            $data['order_herbal'] = array();
            $data['order_service'] = array();

            $data['order_status_id'] = $this->config->get('config_order_status_id');
            $data['comment'] = '';
            $data['affiliate_id'] = '';
            $data['affiliate'] = '';
            $data['currency_code'] = $this->config->get('config_currency');

            $data['coupon'] = '';
            $data['voucher'] = '';
            $data['reward'] = '';
        }

        // Stores
        $this->load->model('setting/store');

        $data['stores'] = array();

        $data['stores'][] = array(
            'store_id' => 0,
            'name' => $this->language->get('text_default')
        );

        $results = $this->model_setting_store->getStores();

        foreach ($results as $result) {
            $data['stores'][] = array(
                'store_id' => $result['store_id'],
                'name' => $result['name']
            );
        }

        // Customer Groups
        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        // Custom Fields
        $this->load->model('customer/custom_field');

        $data['custom_fields'] = array();

        $filter_data = array(
            'sort' => 'cf.sort_order',
            'order' => 'ASC'
        );

        $custom_fields = $this->model_customer_custom_field->getCustomFields($filter_data);

        foreach ($custom_fields as $custom_field) {
            $data['custom_fields'][] = array(
                'custom_field_id' => $custom_field['custom_field_id'],
                'custom_field_value' => $this->model_customer_custom_field->getCustomFieldValues($custom_field['custom_field_id']),
                'name' => $custom_field['name'],
                'value' => $custom_field['value'],
                'type' => $custom_field['type'],
                'location' => $custom_field['location'],
                'sort_order' => $custom_field['sort_order']
            );
        }

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->load->model('localisation/country');

        $data['countries'] = $this->model_localisation_country->getCountries();

        $this->load->model('localisation/currency');

        $data['currencies'] = $this->model_localisation_currency->getCurrencies();

        $data['config_voucher_min'] = $this->config->get('config_voucher_min');

        $data['addslashes_voucher_min'] = addslashes($data['config_voucher_min']);

        $this->load->model('sale/voucher_theme');

        $data['voucher_themes'] = $this->model_sale_voucher_theme->getVoucherThemes();

        // API login
        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        // API login
        $this->load->model('user/api');

        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

        if ($api_info && $this->user->hasPermission('modify', 'sale/order')) {
            $session = new Session($this->config->get('session_engine'), $this->registry);

            $session->start();

            $this->model_user_api->deleteApiSessionBySessonId($session->getId());

            $this->model_user_api->addApiSession($api_info['api_id'], $session->getId(), $this->request->server['REMOTE_ADDR']);

            $session->data['api_id'] = $api_info['api_id'];

            $data['api_token'] = $session->getId();
        } else {
            $data['api_token'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/order_form', $data));
    }

    public function info()
    {
        $this->load->model('sale/order');

        $this->load->model('extension/module/shipping_template');

        if (isset($this->request->get['order_id'])) {
            $order_id = $this->request->get['order_id'];
        } else {
            $order_id = 0;
        }

        $order_info = $this->model_sale_order->getOrder($order_id);

        // API login
        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        // API login
        $this->load->model('user/api');

        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

        if ($api_info && $this->user->hasPermission('modify', 'sale/order')) {
            $session = new Session($this->config->get('session_engine'), $this->registry);

            $session->start();

            $this->model_user_api->deleteApiSessionBySessonId($session->getId());

            $this->model_user_api->addApiSession($api_info['api_id'], $session->getId(), $this->request->server['REMOTE_ADDR']);

            $session->data['api_id'] = $api_info['api_id'];

            $data['api_token'] = $session->getId();
        } else {
            $data['api_token'] = '';
        }

        if ($order_info) {
            $this->load->language('sale/order');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['user_token'] = $this->session->data['user_token'];

            $url = '';

            if (isset($this->request->get['filter_order_id'])) {
                $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
            }

            if (isset($this->request->get['filter_customer'])) {
                $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
            }

            $data['store_id'] = $order_info['store_id'];

            if (isset($this->request->get['filter_order_status'])) {
                $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
            }

            if (isset($this->request->get['filter_tracking_num'])) {
                $url .= '&filter_tracking_num=' . $this->request->get['filter_tracking_num'];
            }

            if (isset($this->request->get['filter_total'])) {
                $url .= '&filter_total=' . $this->request->get['filter_total'];
            }

            if (isset($this->request->get['filter_date_added'])) {
                $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
            }

            if (isset($this->request->get['filter_date_modified'])) {
                $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort=' . $this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order=' . $this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page=' . $this->request->get['page'];
            }

            $data['breadcrumbs'] = array();

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
            );

            $data['shipping'] = $this->url->link('sale/order/shipping', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['link_consignment_note'] = $this->url->link('extension/module/shipping_template/print_consignment_note', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['invoice'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['invoice_pdf'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=true', true);
            $data['invoice_pdf_gst'] = $this->url->link('sale/order/invoiceA5', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'] . '&pdf=true&gst=1', true);

            $data['invoiceSO'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1' . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['invoiceSO_gst'] = $this->url->link('sale/order/invoiceSO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&gst=1' . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['invoiceDO'] = $this->url->link('sale/order/invoiceDO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1' . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['invoiceDO_gst'] = $this->url->link('sale/order/invoiceDO', 'user_token=' . $this->session->data['user_token'] . '&pdf=1&gst=1' . '&order_id=' . (int) $this->request->get['order_id'], true);

            $data['edit'] = $this->url->link('sale/order/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . (int) $this->request->get['order_id'], true);
            $data['cancel'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true);

            $data['order_id'] = $this->request->get['order_id'];

            if ($order_info['invoice_no']) {
                $data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
            } else {
                $data['invoice_no'] = '';
            }

            $data['store_name'] = $order_info['store_name'];
            $data['invoice_no'] = $order_info['invoice_prefix'];
            $data['store_url'] = $order_info['store_url'];
            $data['firstname'] = $order_info['firstname'];
            $data['lastname'] = $order_info['lastname'];

             $data['customer_id'] = $order_info['customer_id'];

            $data['customer_name']= $order_info['firstname'] . ' ' . $order_info['lastname'];
            $data['email']= $order_info['email'];
            $data['phone_no'] = $order_info['telephone'];
            $data['hidden_order_status_id'] = $order_info['order_status_id'];


            if ($order_info['customer_id']) {
                $data['customer'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $order_info['customer_id'], true);
            } else {
                $data['customer'] = '';
            }

            // Customer Groups
            $this->load->model('customer/customer_group');

            $customer_group_info = $this->model_customer_customer_group->getCustomerGroup($order_info['customer_group_id']);

            if ($customer_group_info) {
                $data['customer_group'] = $customer_group_info['name'];
            } else {
                $data['customer_group'] = '';
            }

            $data['customer_group_id'] = $order_info['customer_group_id'];
            $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

            $data['email'] = $order_info['email'];
            $data['telephone'] = $order_info['telephone'];
            $data['fax'] = $order_info['fax'];
            $data['comment'] = nl2br($order_info['comment']);
            $data['shipping_method'] = $order_info['shipping_method'];

            $data['payment_method'] = $order_info['payment_method'];
            $data['payment_methods'] = $this->model_sale_order->getPaymentMethods();

            $data['total'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value']);

            $this->load->model('customer/customer');

            $data['reward'] = $order_info['reward'];

            $data['reward_total'] = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($this->request->get['order_id']);

            $data['affiliate_firstname'] = $order_info['affiliate_firstname'];
            $data['affiliate_lastname'] = $order_info['affiliate_lastname'];

            if ($order_info['affiliate_id']) {
                $data['affiliate'] = $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=' . $order_info['affiliate_id'], true);
            } else {
                $data['affiliate'] = '';
            }

            $data['commission'] = $this->currency->format($order_info['commission'], $order_info['currency_code'], $order_info['currency_value']);

            $this->load->model('customer/customer');

            $data['commission_total'] = $this->model_customer_customer->getTotalTransactionsByOrderId($this->request->get['order_id']);

            $this->load->model('localisation/order_status');

            $order_status_info = $this->model_localisation_order_status->getOrderStatus($order_info['order_status_id']);

            if ($order_status_info) {
                $data['order_status'] = $order_status_info['name'];
            } else {
                $data['order_status'] = '';
            }

            // Payment Address
            if ($order_info['payment_address_format']) {
                $format = $order_info['payment_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
            }

            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}'
            );

            $replace = array(
                'firstname' => $order_info['payment_firstname'],
                'lastname' => $order_info['payment_lastname'],
                'company' => $order_info['payment_company'],
                'address_1' => $order_info['payment_address_1'],
                'address_2' => $order_info['payment_address_2'],
                'city' => $order_info['payment_city'],
                'postcode' => $order_info['payment_postcode'],
                'zone' => $order_info['payment_zone'],
                'zone_code' => $order_info['payment_zone_code'],
                'country' => $order_info['payment_country']
            );

            $data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            // Shipping Address
            if ($order_info['shipping_address_format']) {
                $format = $order_info['shipping_address_format'];
            } else {
                $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
            }

            $find = array(
                '{firstname}',
                '{lastname}',
                '{company}',
                '{address_1}',
                '{address_2}',
                '{city}',
                '{postcode}',
                '{zone}',
                '{zone_code}',
                '{country}'
            );

            $replace = array(
                'firstname' => $order_info['shipping_firstname'],
                'lastname' => $order_info['shipping_lastname'],
                'company' => $order_info['shipping_company'],
                'address_1' => $order_info['shipping_address_1'],
                'address_2' => $order_info['shipping_address_2'],
                'city' => $order_info['shipping_city'],
                'postcode' => $order_info['shipping_postcode'],
                'zone' => $order_info['shipping_zone'],
                'zone_code' => $order_info['shipping_zone_code'],
                'country' => $order_info['shipping_country']
            );

            $data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

            $data['order_status_id'] = $order_info['order_status_id'];

            $data['ip'] = $order_info['ip'];
            $data['forwarded_ip'] = $order_info['forwarded_ip'];
            $data['user_agent'] = $order_info['user_agent'];
            $data['accept_language'] = $order_info['accept_language'];
            $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
            $data['date_modified'] = date($this->language->get('date_format_short'), strtotime($order_info['date_modified']));
            $data['invoice_date'] = date('Y-m-d', strtotime($order_info['invoice_date']));


            $data['payment_firstname'] = $order_info['payment_firstname'];
            $data['payment_lastname'] = $order_info['payment_lastname'];
            $data['payment_company'] = $order_info['payment_company'];
            $data['payment_address_1'] = $order_info['payment_address_1'];
            $data['payment_address_2'] = $order_info['payment_address_2'];
            $data['payment_city'] = $order_info['payment_city'];
            $data['payment_postcode'] = $order_info['payment_postcode'];
            $data['payment_zone'] = $order_info['payment_zone'];
            $data['payment_zone_code'] = $order_info['payment_zone_code'];
            $data['payment_zone_id'] = $order_info['payment_zone_id'];
            $data['payment_country'] = $order_info['payment_country'];
            $data['payment_country_id'] = $order_info['payment_country_id'];

            $data['card_no'] = $order_info['card_no'];
            $data['shipping_firstname'] = $order_info['shipping_firstname'];
            $data['shipping_lastname'] = $order_info['shipping_lastname'];
            $data['shipping_company'] = $order_info['shipping_company'];
            $data['shipping_address_1'] = $order_info['shipping_address_1'];
            $data['shipping_address_2'] = $order_info['shipping_address_2'];
            $data['shipping_city'] = $order_info['shipping_city'];
            $data['shipping_postcode'] = $order_info['shipping_postcode'];
            $data['shipping_zone'] = $order_info['shipping_zone'];
            $data['shipping_zone_code'] = $order_info['shipping_zone_code'];
            $data['shipping_country'] = $order_info['shipping_country'];
            $data['shipping_country_id'] = $order_info['shipping_country_id'];
            $data['shipping_zone_id'] = $order_info['shipping_zone_id'];
            
            // $data['user_id']= $this->session->data['user_id'];

            // $data['staff_name'] = $this->model_sale_order->getStaffName($user_id);

            $this->load->model('localisation/country');
            $data['countries'] = $this->model_localisation_country->getCountries();

            $this->load->model('localisation/zone');
            $data['zones'] = $this-> model_localisation_zone->getZonesByCountryId($data['payment_country_id']);

            $this->load->model('customer/customer');
            $data['addresses'] = $this->model_customer_customer->getAddresses($order_info['customer_id']);

            $this->load->model('tool/upload');


        //xtensions- Custom Fields
  			if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
  				$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
  				$data['payment_address'] = $formatted_address['payment_address_formatted'];
  				$data['shipping_address'] = $formatted_address['shipping_address_formatted'];
  			}
  			//xtensions- Custom Fields
			
            $data['products'] = array();

            $products = $this->model_sale_order->getOrderProducts($this->request->get['order_id']);
            $herbales = $this->model_sale_order->getHerbals($this->request->get['order_id']);
            $services = $this->model_sale_order->getServies($this->request->get['order_id']);
            // $brewings = $this->model_sale_order->getBrewings($this->request->get['order_id']);
            // $brewing_orders = $this->model_sale_order->getBrewingOrders($this->request->get['order_id']);

            $option_data = array();

            foreach ($herbales as $herbale) {
                $weight_class_unit = '';

                if ($herbale['collect_consultation_price'] == 1) {
                    $consultation_total = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency')),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], true)
                    );

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_consultation_price'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($consultation_total, $this->config->get('config_currency')),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], true)
                    );
                } else {
                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_herbal'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency')),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], true)
                    );

                    $data['products'][] = array(
                        'order_product_id' => $herbale['clinical_sale_id'],
                        'product_id' => $herbale['clinical_sale_id'],
                        'name' => $this->language->get('text_free_consultation'),
                        'model' => $herbale['invoice_prefix'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'weight_class_unit' => $weight_class_unit,
                        'price' => $this->currency->format(0, $this->config->get('config_currency')),
                        'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                        'total' => $this->currency->format(0, $this->config->get('config_currency')),
                        'href' => $this->url->link('herbal/herbal/getInfo', 'user_token=' . $this->session->data['user_token'] . '&herbal_id=' . $herbale['clinical_sale_id'], true)
                    );
                }
            }

            foreach ($services as $service) {

                $weight_class_unit = '';

                $data['products'][] = array(
                    'order_product_id' => $service['service_Item_id'],
                    'product_id' => $service['clinicalservice_id'],
                    'name' => $service['servicename'],
                    'model' => $service['invoice_prefix'],
                    'option' => $option_data,
                    'quantity' => 1,
                    'weight_class_unit' => $weight_class_unit,
                    'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                    'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                    'total' => $this->currency->format($service['net_amount'] + $service['gst'], $this->config->get('config_currency')),
                    'href' => $this->url->link('service/service_form/info', 'user_token=' . $this->session->data['user_token'] . '&serviceform_id=' . $service['service_form_id'], true)
                );
            }

            foreach ($products as $product) {


                $options = $this->model_sale_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);

                foreach ($options as $option) {
                    if ($option['type'] != 'file') {
                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $option['value'],
                            'type' => $option['type']
                        );
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $option_data[] = array(
                                'name' => $option['name'],
                                'value' => $upload_info['name'],
                                'type' => $option['type'],
                                'href' => $this->url->link('tool/upload/download', 'user_token=' . $this->session->data['user_token'] . '&code=' . $upload_info['code'], true)
                            );
                        }
                    }
                }

                $this->load->model('sale/order');

                if ($product['weight_class_id'] > 0) {
                    $weight_class_unit = $this->model_sale_order->getWeightClassUnit($product['weight_class_id']);
                } else {
                    $weight_class_unit = '';
                }

                $weight_class_id = !empty($product['weight_class_id']) ? $product['weight_class_id'] : 0;
                if (!empty($weight_class_id)) {
                    $weight_class_id = $weight_class_id;
                } else {
                    $weight_class_id = '';
                }

                $data['products'][] = array(
                    'order_product_id' => $product['order_product_id'],
                    'product_id' => $product['product_id'],
                    'name' => $product['name'],
                    'model' => $product['model'],
                    'option' => $option_data,
                    'quantity' => number_format($product['quantity'], 2),
                    'weight_class_unit' => $weight_class_unit,
                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                    'total' => $this->currency->format($product['total'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $product['product_id'], true)
                );
            }

            $data['vouchers'] = array();

            $vouchers = $this->model_sale_order->getOrderVouchers($this->request->get['order_id']);

            foreach ($vouchers as $voucher) {
                $data['vouchers'][] = array(
                    'description' => $voucher['description'],
                    'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),
                    'href' => $this->url->link('sale/voucher/edit', 'user_token=' . $this->session->data['user_token'] . '&voucher_id=' . $voucher['voucher_id'], true)
                );
            }

            $totals = $this->model_sale_order->getOrderTotals($this->request->get['order_id']);

            foreach ($totals as $total) {
                $data['totals'][] = array(
                    'title' => $total['title'],
                    'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                );
            }

            $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

            $data['order_status_id'] = $order_info['order_status_id'];

            // Unset any past sessions this page date_added for the api to work.
            unset($this->session->data['cookie']);

            // Set up the API session
            if ($this->user->hasPermission('modify', 'sale/order')) {
                $this->load->model('user/api');

                $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

                if ($api_info) {
                    $curl = curl_init();

                    // Set SSL if required
                    if (substr(HTTPS_CATALOG, 0, 5) == 'https') {
                        curl_setopt($curl, CURLOPT_PORT, 443);
                    }

                    curl_setopt($curl, CURLOPT_HEADER, false);
                    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                    curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($curl, CURLOPT_URL, HTTPS_CATALOG . 'index.php?route=api/login');
                    curl_setopt($curl, CURLOPT_POST, true);
                    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($api_info));

                    $json = curl_exec($curl);

                    if (!$json) {
                        $data['error_warning'] = sprintf($this->language->get('error_curl'), curl_error($curl), curl_errno($curl));
                    } else {
                        $response = json_decode($json, true);
                    }

                    if (isset($response['cookie'])) {
                        $this->session->data['cookie'] = $response['cookie'];
                    }
                }
            }

            if (isset($response['cookie'])) {
                $this->session->data['cookie'] = $response['cookie'];
            } else {
                $data['error_warning'] = $this->language->get('error_permission');
            }

            // Fraud
            $this->load->model('sale/fraud');

            $fraud_info = $this->model_sale_fraud->getFraud($order_info['order_id']);

            if ($fraud_info) {
                $data['country_match'] = $fraud_info['country_match'];

                if ($fraud_info['country_code']) {
                    $data['country_code'] = $fraud_info['country_code'];
                } else {
                    $data['country_code'] = '';
                }

                $data['high_risk_country'] = $fraud_info['high_risk_country'];
                $data['distance'] = $fraud_info['distance'];

                if ($fraud_info['ip_region']) {
                    $data['ip_region'] = $fraud_info['ip_region'];
                } else {
                    $data['ip_region'] = '';
                }

                if ($fraud_info['ip_city']) {
                    $data['ip_city'] = $fraud_info['ip_city'];
                } else {
                    $data['ip_city'] = '';
                }

                $data['ip_latitude'] = $fraud_info['ip_latitude'];
                $data['ip_longitude'] = $fraud_info['ip_longitude'];

                if ($fraud_info['ip_isp']) {
                    $data['ip_isp'] = $fraud_info['ip_isp'];
                } else {
                    $data['ip_isp'] = '';
                }

                if ($fraud_info['ip_org']) {
                    $data['ip_org'] = $fraud_info['ip_org'];
                } else {
                    $data['ip_org'] = '';
                }

                $data['ip_asnum'] = $fraud_info['ip_asnum'];

                if ($fraud_info['ip_user_type']) {
                    $data['ip_user_type'] = $fraud_info['ip_user_type'];
                } else {
                    $data['ip_user_type'] = '';
                }

                if ($fraud_info['ip_country_confidence']) {
                    $data['ip_country_confidence'] = $fraud_info['ip_country_confidence'];
                } else {
                    $data['ip_country_confidence'] = '';
                }

                if ($fraud_info['ip_region_confidence']) {
                    $data['ip_region_confidence'] = $fraud_info['ip_region_confidence'];
                } else {
                    $data['ip_region_confidence'] = '';
                }

                if ($fraud_info['ip_city_confidence']) {
                    $data['ip_city_confidence'] = $fraud_info['ip_city_confidence'];
                } else {
                    $data['ip_city_confidence'] = '';
                }

                if ($fraud_info['ip_postal_confidence']) {
                    $data['ip_postal_confidence'] = $fraud_info['ip_postal_confidence'];
                } else {
                    $data['ip_postal_confidence'] = '';
                }

                if ($fraud_info['ip_postal_code']) {
                    $data['ip_postal_code'] = $fraud_info['ip_postal_code'];
                } else {
                    $data['ip_postal_code'] = '';
                }

                $data['ip_accuracy_radius'] = $fraud_info['ip_accuracy_radius'];

                if ($fraud_info['ip_net_speed_cell']) {
                    $data['ip_net_speed_cell'] = $fraud_info['ip_net_speed_cell'];
                } else {
                    $data['ip_net_speed_cell'] = '';
                }

                $data['ip_metro_code'] = $fraud_info['ip_metro_code'];
                $data['ip_area_code'] = $fraud_info['ip_area_code'];

                if ($fraud_info['ip_time_zone']) {
                    $data['ip_time_zone'] = $fraud_info['ip_time_zone'];
                } else {
                    $data['ip_time_zone'] = '';
                }

                if ($fraud_info['ip_region_name']) {
                    $data['ip_region_name'] = $fraud_info['ip_region_name'];
                } else {
                    $data['ip_region_name'] = '';
                }

                if ($fraud_info['ip_domain']) {
                    $data['ip_domain'] = $fraud_info['ip_domain'];
                } else {
                    $data['ip_domain'] = '';
                }

                if ($fraud_info['ip_country_name']) {
                    $data['ip_country_name'] = $fraud_info['ip_country_name'];
                } else {
                    $data['ip_country_name'] = '';
                }

                if ($fraud_info['ip_continent_code']) {
                    $data['ip_continent_code'] = $fraud_info['ip_continent_code'];
                } else {
                    $data['ip_continent_code'] = '';
                }

                if ($fraud_info['ip_corporate_proxy']) {
                    $data['ip_corporate_proxy'] = $fraud_info['ip_corporate_proxy'];
                } else {
                    $data['ip_corporate_proxy'] = '';
                }

                $data['anonymous_proxy'] = $fraud_info['anonymous_proxy'];
                $data['proxy_score'] = $fraud_info['proxy_score'];

                if ($fraud_info['is_trans_proxy']) {
                    $data['is_trans_proxy'] = $fraud_info['is_trans_proxy'];
                } else {
                    $data['is_trans_proxy'] = '';
                }

                $data['free_mail'] = $fraud_info['free_mail'];
                $data['carder_email'] = $fraud_info['carder_email'];

                if ($fraud_info['high_risk_username']) {
                    $data['high_risk_username'] = $fraud_info['high_risk_username'];
                } else {
                    $data['high_risk_username'] = '';
                }

                if ($fraud_info['high_risk_password']) {
                    $data['high_risk_password'] = $fraud_info['high_risk_password'];
                } else {
                    $data['high_risk_password'] = '';
                }

                $data['bin_match'] = $fraud_info['bin_match'];

                if ($fraud_info['bin_country']) {
                    $data['bin_country'] = $fraud_info['bin_country'];
                } else {
                    $data['bin_country'] = '';
                }

                $data['bin_name_match'] = $fraud_info['bin_name_match'];

                if ($fraud_info['bin_name']) {
                    $data['bin_name'] = $fraud_info['bin_name'];
                } else {
                    $data['bin_name'] = '';
                }

                $data['bin_phone_match'] = $fraud_info['bin_phone_match'];

                if ($fraud_info['bin_phone']) {
                    $data['bin_phone'] = $fraud_info['bin_phone'];
                } else {
                    $data['bin_phone'] = '';
                }

                if ($fraud_info['customer_phone_in_billing_location']) {
                    $data['customer_phone_in_billing_location'] = $fraud_info['customer_phone_in_billing_location'];
                } else {
                    $data['customer_phone_in_billing_location'] = '';
                }

                $data['ship_forward'] = $fraud_info['ship_forward'];

                if ($fraud_info['city_postal_match']) {
                    $data['city_postal_match'] = $fraud_info['city_postal_match'];
                } else {
                    $data['city_postal_match'] = '';
                }

                if ($fraud_info['ship_city_postal_match']) {
                    $data['ship_city_postal_match'] = $fraud_info['ship_city_postal_match'];
                } else {
                    $data['ship_city_postal_match'] = '';
                }

                $data['score'] = $fraud_info['score'];
                $data['explanation'] = $fraud_info['explanation'];
                $data['risk_score'] = $fraud_info['risk_score'];
                $data['queries_remaining'] = $fraud_info['queries_remaining'];
                $data['maxmind_id'] = $fraud_info['maxmind_id'];
                $data['error'] = $fraud_info['error'];
            } else {
                $data['maxmind_id'] = '';
            }

            $data['payment_action'] = $this->load->controller('payment/' . $order_info['payment_code'] . '/orderAction', '');

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');



            $this->response->setOutput($this->load->view('sale/order_info', $data));
        } else {
            $this->load->language('error/not_found');

            $this->document->setTitle($this->language->get('heading_title'));

            $data['heading_title'] = $this->language->get('heading_title');

            $data['text_not_found'] = $this->language->get('text_not_found');

            $data['breadcrumbs'] = array();

            $data['store_id'] = 0;

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('text_home'),
                'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['breadcrumbs'][] = array(
                'text' => $this->language->get('heading_title'),
                'href' => $this->url->link('error/not_found', 'user_token=' . $this->session->data['user_token'], true)
            );

            $data['header'] = $this->load->controller('common/header');
            $data['column_left'] = $this->load->controller('common/column_left');
            $data['footer'] = $this->load->controller('common/footer');

            $this->response->setOutput($this->load->view('error/not_found', $data));
        }
    }

    protected function validate()
    {
        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }

       public function createInvoiceNo()
    {

        $this->load->language('sale/order');

        $json = array();

        $invoice_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'pos/pos', 'store' => $this->session->data['store_id']));



        if ($invoice_no) {
            $json['invoice_no'] = $invoice_no;
        } else {
            $json['error'] = $this->language->get('error_action');
        }


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addReward()
    {
        $this->load->language('sale/order');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order');

            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info && $order_info['customer_id'] && ($order_info['reward'] > 0)) {
                $this->load->model('customer/customer');

                $reward_total = $this->model_customer_customer->getTotalCustomerRewardsByOrderId($order_id);

                if (!$reward_total) {
                    $this->model_customer_customer->addReward($order_info['customer_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['reward'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_reward_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeReward()
    {
        $this->load->language('sale/order');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order');

            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $this->load->model('customer/customer');

                $this->model_customer_customer->deleteReward($order_id);
            }

            $json['success'] = $this->language->get('text_reward_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function addCommission()
    {
        $this->load->language('sale/order');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order');

            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $this->load->model('customer/customer');

                $affiliate_total = $this->model_customer_customer->getTotalTransactionsByOrderId($order_id);

                if (!$affiliate_total) {
                    $this->model_customer_customer->addTransaction($order_info['affiliate_id'], $this->language->get('text_order_id') . ' #' . $order_id, $order_info['commission'], $order_id);
                }
            }

            $json['success'] = $this->language->get('text_commission_added');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function removeCommission()
    {
        $this->load->language('sale/order');

        $json = array();

        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $json['error'] = $this->language->get('error_permission');
        } else {
            if (isset($this->request->get['order_id'])) {
                $order_id = $this->request->get['order_id'];
            } else {
                $order_id = 0;
            }

            $this->load->model('sale/order');

            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $this->load->model('customer/customer');

                $this->model_customer_customer->deleteTransaction($order_id);
            }

            $json['success'] = $this->language->get('text_commission_removed');
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function country()
    {
        $json = array();

        $this->load->model('localisation/country');

        $country_info = $this->model_localisation_country->getCountry($this->request->get['country_id']);

        if ($country_info) {
            $this->load->model('localisation/zone');

            $json = array(
                'country_id' => $country_info['country_id'],
                'name' => $country_info['name'],
                'iso_code_2' => $country_info['iso_code_2'],
                'iso_code_3' => $country_info['iso_code_3'],
                'address_format' => $country_info['address_format'],
                'postcode_required' => $country_info['postcode_required'],
                'zone' => $this->model_localisation_zone->getZonesByCountryId($this->request->get['country_id']),
                'status' => $country_info['status']
            );
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function history() {
        $this->load->language('sale/order');

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $data['histories'] = array();

        $this->load->model('sale/order');

        $results = $this->model_sale_order->getOrderHistories($this->request->get['order_id'], ($page - 1) * 10, 10);

        foreach ($results as $result) {
            $data['histories'][] = array(
                'notify' => $result['notify'] ? $this->language->get('text_yes') : $this->language->get('text_no'),
                'status' => $result['status'],
                'comment' => nl2br($result['comment']),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added']))
            );
        }

        $history_total = $this->model_sale_order->getTotalOrderHistories($this->request->get['order_id']);

        $pagination = new Pagination();
        $pagination->total = $history_total;
        $pagination->page = $page;
        $pagination->limit = 10;
        $pagination->url = $this->url->link('sale/order/history', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $this->request->get['order_id'] . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($history_total) ? (($page - 1) * 10) + 1 : 0, ((($page - 1) * 10) > ($history_total - 10)) ? $history_total : ((($page - 1) * 10) + 10), $history_total, ceil($history_total / 10));

        $this->response->setOutput($this->load->view('sale/order_history', $data));
    }



	public function addHistory() {
		$this->load->language('sale/order');

		$json = array();

		
			// Add keys for missing post vars
			$keys = array(
				'order_status_id',
				'notify',
				'override',
				'comment'
			);

			foreach ($keys as $key) {
				if (!isset($this->request->post[$key])) {
					$this->request->post[$key] = '';
				}
			}

			$this->load->model('sale/order');

			if (isset($this->request->get['order_id'])) {
				$order_id = $this->request->get['order_id'];
			} else {
				$order_id = 0;
			}

			$order_info = $this->model_sale_order->getOrder($order_id);

               $user_id = $this->session->data['user_id'];
                $staff_name = $this->model_sale_order->getStaffName($user_id);

                date_default_timezone_set('Asia/Kuala_Lumpur'); 
                
                $date = date('Y-m-d H:i:s');
    			$comment = $this->request->post['comment'];
    			$comment .=" updated by $staff_name at $date";

			if ($order_info) {
				$this->model_sale_order->addOrderHistory($order_id, $comment, $this->request->post['order_status_id']);

				$json['success'] = $this->language->get('text_success');
			} else {
				$json['error'] = $this->language->get('error_not_found');
			}
		

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}


    public function export_excel()
    {
        $this->load->language('sale/order');

        $this->load->model('sale/order');
        $this->load->model('localisation/order_status');
        $this->load->model('sale/senangpay_import');

        // get user detail
        $this->load->model('user/user');
        $user_info = $this->model_user_user->getUser($this->session->data['user_id']);

        // load php Excel
        $this->load->library('PHPExcel');
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setLastModifiedBy($user_info['firstname'] . ' ' . $user_info['lastname'])
            ->setTitle('Title')
            ->setSubject('Subject')
            ->setDescription('Description')
            ->setKeywords('report etcm.me')
            ->setCategory('report excel');

        // Set default font
        $objPHPExcel->getDefaultStyle()->getFont()->setName('Arial')
            ->setSize(10);

        // Table Data
        // get data collection from database
        if (isset($this->request->get['filter_date_added_from'])) {
            $filter_date_added_from = $this->request->get['filter_date_added_from'];
        } else {
            $filter_date_added_from = null;
        }

        if (isset($this->request->get['filter_date_added_to'])) {
            $filter_date_added_to = $this->request->get['filter_date_added_to'];
        } else {
            $filter_date_added_to = null;
        }

        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = null;
        }

        if (isset($this->request->get['filter_store_id'])) {
            if ($this->request->get['filter_store_id'] != '*') {
                $filter_store_id = $this->request->get['filter_store_id'];
            } else {
                $filter_store_id = NULL;
            }
        } else {
            $filter_store_id = $this->session->data['store_id'];
        }

        if (isset($this->request->get['filter_invoice'])) {
            $filter_invoice = $this->request->get['filter_invoice'];
        } else {
            $filter_invoice = null;
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = null;
        }

        if (isset($this->request->get['filter_customer_group'])) {
            $filter_customer_group = $this->request->get['filter_customer_group'];
        } else {
            $filter_customer_group = null;
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = null;
        }

        if (isset($this->request->get['filter_carrier'])) {
            $filter_carrier = $this->request->get['filter_carrier'];
        } else {
            $filter_carrier = null;
        }

        if (isset($this->request->get['filter_tracking_num'])) {
            $filter_tracking_num = $this->request->get['filter_tracking_num'];
        } else {
            $filter_tracking_num = null;
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = null;
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = null;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        $filter_data = [
            'filter_date_added_from' => $filter_date_added_from,
            'filter_date_added_to' => $filter_date_added_to,
            'filter_order_id' => $filter_order_id,
            'filter_store_id' => $filter_store_id,
            'filter_invoice' => $filter_invoice,
            'filter_customer' => $filter_customer,
            'filter_customer_group' => $filter_customer_group,
            'filter_order_status' => $filter_order_status,
            'filter_carrier' => $filter_carrier,
            'filter_tracking_num' => $filter_tracking_num,
            'filter_total' => $filter_total,
            'filter_date_modified' => $filter_date_modified,
            'sort' => $sort,
            'order' => $order
        ];

        $table_collection = [];

        $results = $this->model_sale_order->getOrders($filter_data);

        if (!empty($results)) {
            foreach ($results as $result) {
                $order_status_row = $this->model_localisation_order_status->getOrderStatus($result['order_status_id']);
                $order_status = !empty($order_status_row) ? $order_status_row['name'] : '';

                $senangpay_ref_row = $this->model_sale_senangpay_import->get_senangpay_transaction_by_order_id($result['order_id']);
                $transaction_ref = !empty($senangpay_ref_row) ? $senangpay_ref_row['transaction_reference'] : '';

                $shipping_address_1 = !empty($result['shipping_address_1']) ? $result['shipping_address_1'] . ', ' : '';
                $shipping_address_2 = !empty($result['shipping_address_2']) ? $result['shipping_address_2'] . ', ' : '';
                $shipping_address_3 = !empty($result['shipping_address_3']) ? $result['shipping_address_3'] . ', ' : '';
                $shipping_city = !empty($result['shipping_city']) ? $result['shipping_city'] . ', ' : '';
                $shipping_postcode = !empty($result['shipping_postcode']) ? $result['shipping_postcode'] . ', ' : '';
                $shipping_country = !empty($result['shipping_country']) ? $result['shipping_country'] . '.' : '';
                $shipping_zone = !empty($result['shipping_zone']) ? $result['shipping_zone'] . ', ' : '';

                $full_address = $shipping_address_1 . $shipping_address_2 . $shipping_address_3 . $shipping_city . $shipping_postcode . $shipping_zone . $shipping_country;

                $table_collection[] = [
                    'order_id' => $result['order_id'],
                    'transaction_ref' => !empty($transaction_ref) ? "'" . $transaction_ref : '',
                    'customer_name' => $result['customer'],
                    'telephone' => chunk_split($result['telephone'], 3, ' '),
                    'email' => $result['email'],
                    'total' => $result['total'],
                    'transaction_date' => date('Y-m-d', strtotime($result['date_added'])),
                    'order_status' => $order_status,
                    'courier_service' => '',
                    'tracking_number' => '',
                    'city' => $result['shipping_city'],
                    'address' => $full_address
                ];
            }
        }

        $table = array();

        $table_header = array( //table headers
            $this->language->get('column_excel_order_id'),
            $this->language->get('column_excel_transaction_ref'),
            $this->language->get('column_excel_customer_name'),
            $this->language->get('column_excel_telephone'),
            $this->language->get('column_excel_email'),
            $this->language->get('column_excel_total'),
            $this->language->get('column_excel_transaction_date'),
            $this->language->get('column_excel_order_status'),
            $this->language->get('column_excel_courier_service'),
            $this->language->get('column_excel_tracking_number'),
            $this->language->get('column_city'),
            $this->language->get('column_address')
        );

        $header_index_row = 1;

        $table[] = $table_header; //add header to table

        $table_data = $table_collection;
        $row;
        $total_row = 0;
        foreach ($table_data as $key => $data) {
            $row = array();

            foreach ($data as $key => $value) {
                $row[] = $value;
            }

            $table[] = $row; //add data row to table
            $total_row++;
        }

        //  Styling
        $autosize_column_index = 'A';
        foreach ($table_header as $header) { //loop each header
            $objPHPExcel->getActiveSheet()->getColumnDimension($autosize_column_index)->setAutoSize(true);
            $autosize_column_index++;
        }

        $header_index_s_column = 'A';
        $header_index_e_column = $header_index_s_column;
        foreach ($table_header as $col)
            $header_index_e_column++;
        $header_index_range = "$header_index_s_column$header_index_row:$header_index_e_column$header_index_row";

        $header_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER
            ),
            'font' => array(
                'bold' => true
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle($header_index_range)->applyFromArray($header_style);

        $currency_style = array(
            'alignment' => array(
                'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
            ),
            'numberformat' => array(
                'code' => "0.00"
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle("F" . ($header_index_row) . ":F" . ($header_index_row + $total_row))->applyFromArray($currency_style);

        // Add Array To Excel
        $objPHPExcel->getActiveSheet()->fromArray($table, null, 'A1', true);

        // Rename worksheet
        $sheettitle = $this->language->get('heading_title');
        $sheettitle = strlen($sheettitle) > 31 ? substr($sheettitle, 0, 28) . '...' : $sheettitle;
        $objPHPExcel->getActiveSheet()->setTitle($sheettitle);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // Save Excel 2007 file
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        //ob_end_clean();
        // We'll be outputting an excel file
        header('Content-type: application/vnd.ms-excel');

        // It will be called file.xls
        header('Content-Disposition: attachment; filename="' . $this->language->get('heading_title') . ' ' . $filter_date_added_from . ' to ' . $filter_date_added_to . '.xlsx"');
        $objWriter->save('php://output');
    }

    public function invoice()
    {
        $this->load->language('sale/order');

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . ' ' . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . ' ' . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();

                $products = $this->model_sale_order->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product['name'],
                        'model' => $product['model'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'] + ($this->config->get('config_tax') ? $product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $this->currency->format($product['total'] + ($this->config->get('config_tax') ? ($product['tax'] * $product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);

                foreach ($totals as $total) {
                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/order_invoice', $data));
    }

    public function invoiceSO()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_gst');
        } else {
            $this->load->language('sale/order');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getUnPaidHerbals($order_id);
                $services = $this->model_sale_order->getUnPaidServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($consultation_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($consultation_price, $this->config->get('config_currency'))
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0, $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                            'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                            'total' => $this->currency->format(0, $this->config->get('config_currency'))
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($service['service_price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }

                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_gst_amount'] = $this->currency->format($total_tax + $shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                if (!empty($shipping)) {
                    $shipping_address = $shipping_address;
                } else {
                    $shipping_address = '';
                }

                // $qr_code_content = $data['catalog'] . 'index.php?route=account/quick_register&order_id=' . base64_encode($order_id);
                // $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . urlencode($qr_code_content) . '&choe=UTF-8';

                $qr_code_content = !empty($product) ? 'order_product_' . $product['order_product_id'] : '';
                $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . base64_encode($qr_code_content) . '&choe=UTF-8';

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'qr_code' => $qr_code
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_invoice_so', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_invoice_so', $data));
    }

    public function invoiceDO()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_gst');
        } else {
            $this->load->language('sale/order');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getUnPaidHerbals($order_id);
                $services = $this->model_sale_order->getUnPaidServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($consultation_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($consultation_price, $this->config->get('config_currency'))
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0),
                            'sub_total' => $this->currency->format(0),
                            'tax' => $this->currency->format(0),
                            'total' => $this->currency->format(0)
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($service['service_price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $qr_code_content = !empty($product) ? 'order_product_' . $product['order_product_id'] : '';
                    $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . base64_encode($qr_code_content) . '&choe=UTF-8';

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                        'qr_code' => $qr_code
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }


                $data['total_gst_amount'] = $this->currency->format($total_tax + $shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                if (!empty($shipping)) {
                    $shipping_address = $shipping_address;
                } else {
                    $shipping_address = '';
                }


                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_invoice_do', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_invoice_do', $data));
    }

    public function invoiceA5()
    {
        $this->document->addStyle('view/stylesheet/invoicea5.css?v=' . time());

        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_gst');
        } else {
            $this->load->language('sale/order');
        }

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['store_image'] = HTTPS_IMAGE . $this->config->get('config_image');

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getPaidHerbals($order_id);
                $services = $this->model_sale_order->getPaidServies($order_id);
                // $brewings  = $this->model_sale_order->getPaidBrewings($order_id);
                // $brewing_orders  = $this->model_sale_order->getPaidBrewingOrders($order_id);

                $option_data = array();
                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => 'Herbal Remedies',
                            'code' => $herbale['invoice_prefix'],
                            'model' => '',
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => 'Consultation Fee',
                            'code' => $herbale['invoice_prefix'],
                            'model' => '',
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($consultation_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($consultation_price, $this->config->get('config_currency'))
                        );
                    } else {
                        $product_data[] = array(
                            'name' => 'Herbal Remedies',
                            'code' => $herbale['invoice_prefix'],
                            'model' => '',
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                        );

                        $product_data[] = array(
                            'name' => 'Free Consultation',
                            'code' => $herbale['invoice_prefix'],
                            'model' => '',
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0, $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                            'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                            'total' => $this->currency->format(0, $this->config->get('config_currency'))
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'code' => $service['invoice_prefix'],
                        'model' => '',
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'sub_total' => $this->currency->format($service['service_price'], $this->config->get('config_currency')),
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'code' => $product['code'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);

                // $qr_code_content = $data['catalog'] . 'index.php?route=account/quick_register&order_id=' . base64_encode($order_id);
                // $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . urlencode($qr_code_content) . '&choe=UTF-8';

                $qr_code_content = !empty($product) ? 'order_product_' . $product['order_product_id'] : '';
                $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . base64_encode($qr_code_content) . '&choe=UTF-8';

                $date_completed = !empty($order_info['invoice_date']) ? $order_info['invoice_date'] : $order_info['date_added'];

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_completed' => date($this->language->get('date_format_short'), strtotime($date_completed)),
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'sub_total' => $data['sub_total'],
                    'rounding' => $data['rounding'],
                    'shipping' => $data['shipping'],
                    'alltotal' => $data['alltotal'],
                    'total_tax' => $data['total_tax'],
                    'tax' => $data['tax'],
                    'qr_code' => $qr_code
                );
            }
        }

        $data['bank_name']         = !empty($this->config->get('config_payment_bank_transfer_bank_name')) ? $this->config->get('config_payment_bank_transfer_bank_name') : '';
        $data['bank_account_name'] = !empty($this->config->get('config_payment_bank_transfer_bank_account_name')) ? $this->config->get('config_payment_bank_transfer_bank_account_name') : '';
        $data['bank_account_number'] = !empty($this->config->get('config_payment_bank_transfer_bank_account_number')) ? $this->config->get('config_payment_bank_transfer_bank_account_number') : '';

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_invoice_a5', $data), $pdf_file_name, $page_size, $show));
        }

        $this->response->setOutput($this->load->view('sale/order_invoice_a5', $data));
    }

    public function invoiceHoald()
    {
        $this->load->language('sale/order');

        $data = array();

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }


        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);


            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                if ($order_info['payment_address_format']) {
                    $format = $order_info['payment_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country']
                );

                $payment_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();
                $data['tax'] = array();
                $nat_amount = 0;
                $tax = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getHoaldHerbals($order_id);
                $services = $this->model_sale_order->getHoaldServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;////$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($consultation_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($consultation_price, $this->config->get('config_currency'))
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0, $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                            'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                            'total' => $this->currency->format(0, $this->config->get('config_currency'))
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'sub_total' => $this->currency->format($service['service_price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => '',
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'sub_total' => $this->currency->format($product['total_net_amount'], $this->config->get('config_currency')),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {
                        $shipping += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }



                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency'));
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency'));
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency'));
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency'));
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency'));




                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'payment_address' => $payment_address,
                    'payment_method' => (strpos($order_info['payment_method'], "image/payment") !== false) ? str_replace("image", "view/image", $order_info['payment_method']) : $order_info['payment_method'],
                    'product' => $product_data,
                    'voucher' => $voucher_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }



        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            if ($this->config->get('pdf_invoice_invoice_button') != "browser") {
                $show = 'D';
            } else {
                $show = 'I';
            }
            $page_size = $this->config->get('pdf_invoice_page_size') . $page_format;
            $data['pdf'] = true;
            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_invoice_hoald', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_invoice_hoald', $data));
    }

    public function invoiceReceipt()
    {
        if (isset($this->request->get['gst'])) {
            $this->load->language('sale/order_gst');
        } else {
            $this->load->language('sale/order');
        }

        $data['title'] = $this->language->get('text_invoice');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        $this->load->model('sale/order');

        $this->load->model('setting/setting');

        $this->load->model('localisation/country');

        $this->load->model('localisation/zone');

        $data['orders'] = array();

        $data['print_time'] = date("Y-m-d H:i:s");


        $orders = array();

        $data['pdf'] = false;

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
            $pdf = (isset($this->request->get['pdf'])) ? true : false;
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);

            $data['staff_name'] = $order_info['staff_name'];

            if ($order_info) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);
                $country = $this->model_localisation_country->getCountry($store_info['config_country_id']);
                $zone = $this->model_localisation_zone->getZone($store_info['config_zone_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                    $store_number = $store_info['config_number'];
                    $store_gstno = $store_info['config_gstno'];
                    $store_country = $country['name'];
                    $store_zone = $zone['name'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                    $store_number = '';
                    $store_gstno = '';
                    $store_country = '';
                    $zone = '';
                }

                $invoice_no = $order_info['invoice_prefix'];

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();
                $data['tax'] = array();
                $data['whit_tax'] = 0;
                $data['product_tax'] = 0;
                $data['non_tax'] = 0;
                $data['product_non'] = 0;

                $products = $this->model_sale_order->getOrderProducts($order_id);
                $herbales = $this->model_sale_order->getPaidHerbals($order_id);
                $services = $this->model_sale_order->getPaidServies($order_id);

                $option_data = array();

                foreach ($herbales as $herbale) {

                    if (!array_key_exists($herbale['tax_code'], $data['tax'])) {
                        $data['tax'][$herbale['tax_code']] = array(
                            'net_amount' => $this->currency->format($herbale['d_net_amount'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $herbale['d_net_amount'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$herbale['tax_code']]['value_net_amount'] += $herbale['d_net_amount'];
                        $data['tax'][$herbale['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$herbale['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$herbale['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$herbale['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }

                    if ($herbale['collect_consultation_price'] == 1) {
                        $herbal_tax = $this->model_sale_order->getHerbalTax2($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['net_total'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbal_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['clinicalsale_total'], $this->config->get('config_currency'))
                        );

                        $consultation_price = $this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']); //$herbale['clinicalsale_concultation'] * 1.06 ;//
                        //$this->model_sale_order->getHerbalTotal($herbale['clinical_sale_id']);
                        $consultation_tax = $this->model_sale_order->getHerbalTax($herbale['clinical_sale_id']);

                        $product_data[] = array(
                            'name' => $this->language->get('text_consultation_price'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($consultation_tax, $this->config->get('config_currency')),
                            'total' => $this->currency->format($consultation_price, $this->config->get('config_currency'))
                        );
                    } else {
                        $product_data[] = array(
                            'name' => $this->language->get('text_herbal'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format($herbale['clinicalsale_concultation'], $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format($herbale['d_net_amount'], $this->config->get('config_currency')),
                            'tax' => $this->currency->format($herbale['d_gst'], $this->config->get('config_currency')),
                            'total' => $this->currency->format($herbale['d_net_amount'] + $herbale['d_gst'], $this->config->get('config_currency'))
                        );

                        $product_data[] = array(
                            'name' => $this->language->get('text_free_consultation'),
                            'model' => $herbale['invoice_prefix'],
                            'sympol' => $herbale['tax_code'],
                            'option' => $option_data,
                            'quantity' => 1,
                            'price' => $this->currency->format(0, $this->config->get('config_currency')),
                            'sub_total' => $this->currency->format(0, $this->config->get('config_currency')),
                            'tax' => $this->currency->format(0, $this->config->get('config_currency')),
                            'total' => $this->currency->format(0, $this->config->get('config_currency'))
                        );
                    }
                }

                foreach ($services as $service) {
                    if (!array_key_exists($service['tax_code'], $data['tax'])) {
                        $data['tax'][$service['tax_code']] = array(
                            'net_amount' => $this->currency->format($service['service_price'], $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => $service['service_price'],
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$service['tax_code']]['value_net_amount'] += $service['service_price'];
                        $data['tax'][$service['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$service['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$service['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$service['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $product_data[] = array(
                        'name' => $service['servicename'],
                        'model' => $service['invoice_prefix'],
                        'sympol' => $service['tax_code'],
                        'option' => $option_data,
                        'quantity' => 1,
                        'price' => $this->currency->format($service['price'], $this->config->get('config_currency')),
                        'tax' => $this->currency->format($service['gst'], $this->config->get('config_currency')),
                        'total' => $this->currency->format($service['service_price'] + $service['gst'], $this->config->get('config_currency'))
                    );
                }

                foreach ($products as $product) {
                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    if (!array_key_exists($product['tax_code'], $data['tax'])) {
                        $data['tax'][$product['tax_code']] = array(
                            'net_amount' => $this->currency->format(($product['net_amount'] * $product['quantity']), $order_info['currency_code'], $order_info['currency_value']),
                            'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                            'value_net_amount' => ($product['net_amount'] * $product['quantity']),
                            'value_tax_amount' => 0
                        );
                    } else {
                        $data['tax'][$product['tax_code']]['value_net_amount'] += ($product['net_amount'] * $product['quantity']);
                        $data['tax'][$product['tax_code']]['value_tax_amount'] += 0;
                        $data['tax'][$product['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$product['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        $data['tax'][$product['tax_code']]['tax'] = $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']);
                    }



                    $total = $this->currency->format($product['total_net_amount'] + $product['total_tax'], $order_info['currency_code'], $order_info['currency_value']);

                    $product_data[] = array(
                        'name' => $product['model'],
                        'model' => $product['model'],
                        'sympol' => $product['tax_code'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'price' => $this->currency->format($product['price'], $order_info['currency_code'], $order_info['currency_value']),
                        'tax' => $this->currency->format(($this->config->get('config_tax') ? $product['total_tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                        'total' => $total,
                    );
                }

                $voucher_data = array();

                $vouchers = $this->model_sale_order->getOrderVouchers($order_id);

                foreach ($vouchers as $voucher) {
                    $voucher_data[] = array(
                        'description' => $voucher['description'],
                        'amount' => $this->currency->format($voucher['amount'], $order_info['currency_code'], $order_info['currency_value'])
                    );
                }

                $total_data = array();

                $totals = $this->model_sale_order->getOrderTotals($order_id);
                $total_tax = 0;
                $sub_total = 0;
                $rounding = 0;
                $shipping = 0;
                $alltotal = 0;

                foreach ($totals as $total) {

                    $total_data[] = array(
                        'title' => $total['title'],
                        'text' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value'], $this->config->get('config_currency')),
                    );

                    if ($total['code'] == 'sub_total') {
                        $sub_total += $total['value'];
                    }

                    if ($total['code'] == 'rounding') {
                        $rounding += $total['value'];
                    }

                    if ($total['code'] == 'total') {
                        $alltotal += $total['value'];
                    }


                    if ($total['code'] == 'shipping') {

                        $shipping += $total['value'];

                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => $total['value'],
                                'value_tax_amount' => 0
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += 0;
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }

                    if ($total['code'] == 'tax') {
                        $total_tax += $total['value'];
                        if (!array_key_exists($total['tax_code'], $data['tax'])) {
                            $data['tax'][$total['tax_code']] = array(
                                'net_amount' => $this->currency->format(0, $order_info['currency_code'], $order_info['currency_value']),
                                'tax' => $this->currency->format($total['value'], $order_info['currency_code'], $order_info['currency_value']),
                                'value_net_amount' => 0,
                                'value_tax_amount' => $total['value']
                            );
                        } else {
                            $data['tax'][$total['tax_code']]['value_net_amount'] += 0;
                            $data['tax'][$total['tax_code']]['value_tax_amount'] += $total['value'];
                            $data['tax'][$total['tax_code']]['net_amount'] = $this->currency->format($data['tax'][$total['tax_code']]['value_net_amount'], $order_info['currency_code'], $order_info['currency_value']);
                            $data['tax'][$total['tax_code']]['tax'] = $this->currency->format($data['tax'][$total['tax_code']]['value_tax_amount'], $order_info['currency_code'], $order_info['currency_value']);
                        }
                    }
                }

                $data['total_tax'] = $this->currency->format($total_tax, $order_info['currency_code'], $order_info['currency_value']);
                $data['sub_total'] = $this->currency->format($sub_total, $order_info['currency_code'], $order_info['currency_value']);
                $data['rounding'] = $this->currency->format($rounding, $order_info['currency_code'], $order_info['currency_value']);
                $data['shipping'] = $this->currency->format($shipping, $order_info['currency_code'], $order_info['currency_value']);
                $data['alltotal'] = $this->currency->format($alltotal, $order_info['currency_code'], $order_info['currency_value']);

                $data['currency'] = $this->currency->getSymbolLeft($this->config->get('config_currency'));

                $qr_code_content = $data['catalog'] . 'index.php?route=account/quick_register&order_id=' . base64_encode($order_id);
                $qr_code = 'https://chart.apis.google.com/chart?chs=300x300&cht=qr&chl=' . urlencode($qr_code_content) . '&choe=UTF-8';

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_gstno' => $store_gstno,
                    'store_country' => $store_country,
                    'store_number' => $store_number,
                    'store_zone' => $store_zone,
                    'store_address' => nl2br($store_address),
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'telephone' => $order_info['telephone'],
                    'product' => $product_data,
                    'total' => $total_data,
                    'comment' => nl2br($order_info['comment']),
                    'tax' => $data['tax'],
                    'total_tax' => $data['total_tax'],
                    'sub_total' => $data['sub_total'],
                    'rounding' => $data['rounding'],
                    'shipping' => $data['shipping'],
                    'alltotal' => $data['alltotal'],
                    'qr_code' => $qr_code
                );
            }
        }

        if ($pdf) {
            $pdf = new PDF();
            $data['pdf'] = true;
            $data['margin_top'] = $this->config->get('pdf_invoice_margin_top');
            $data['margin_right'] = $this->config->get('pdf_invoice_margin_right');
            $data['margin_bottom'] = $this->config->get('pdf_invoice_margin_bottom');
            $data['margin_left'] = $this->config->get('pdf_invoice_margin_left');
            $page_format = '';
            if ($this->config->get('pdf_invoice_page_orientation') == "landscape") {
                $page_format = '-L';
            }
            if (count($data['orders']) > 1) {
                $pdf_file_name = date('Ymd_His') . '.pdf';
            } else {
                $pdf_name_find = array(
                    '{invoice_prefix}',
                    '{invoice_no}',
                    '{order_id}'
                );
                $pdf_name_replace = array(
                    'invoice_prefix' => $order_info['invoice_prefix'],
                    'invoice_no' => $order_info['invoice_no'],
                    'order_id' => $order_id,
                );

                $pdf_file_name = trim(str_replace($pdf_name_find, $pdf_name_replace, $this->config->get('pdf_invoice_file_name')));
            }

            $show = 'I';

            $page_size = array(80, 500);

            $this->response->setOutput($pdf->pdf($this->load->view('sale/order_receipt', $data), $pdf_file_name, $page_size, $show));
        }
        $this->response->setOutput($this->load->view('sale/order_receipt', $data));
    }

    public function shipping()
    {
        $this->load->language('sale/order');

        $data['title'] = $this->language->get('text_shipping');

        if ($this->request->server['HTTPS']) {
            $data['base'] = HTTPS_SERVER;
        } else {
            $data['base'] = HTTP_SERVER;
        }

        $this->load->model('sale/order');

        $this->load->model('catalog/product');

        $this->load->model('setting/setting');

        $data['orders'] = array();

        $orders = array();

        if (isset($this->request->post['selected'])) {
            $orders = $this->request->post['selected'];
        } elseif (isset($this->request->get['order_id'])) {
            $orders[] = $this->request->get['order_id'];
        }

        foreach ($orders as $order_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);

            // Make sure there is a shipping method
            if ($order_info && $order_info['shipping_code']) {
                $store_info = $this->model_setting_setting->getSetting('config', $order_info['store_id']);

                if ($store_info) {
                    $store_address = $store_info['config_address'];
                    $store_email = $store_info['config_email'];
                    $store_telephone = $store_info['config_telephone'];
                    $store_fax = $store_info['config_fax'];
                } else {
                    $store_address = $this->config->get('config_address');
                    $store_email = $this->config->get('config_email');
                    $store_telephone = $this->config->get('config_telephone');
                    $store_fax = $this->config->get('config_fax');
                }

                if ($order_info['invoice_no']) {
                    $invoice_no = $order_info['invoice_prefix'] . $order_info['invoice_no'];
                } else {
                    $invoice_no = '';
                }

                if ($order_info['shipping_address_format']) {
                    $format = $order_info['shipping_address_format'];
                } else {
                    $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                }

                $find = array(
                    '{firstname}',
                    '{lastname}',
                    '{company}',
                    '{address_1}',
                    '{address_2}',
                    '{city}',
                    '{postcode}',
                    '{zone}',
                    '{zone_code}',
                    '{country}'
                );

                $replace = array(
                    'firstname' => $order_info['shipping_firstname'],
                    'lastname' => $order_info['shipping_lastname'],
                    'company' => $order_info['shipping_company'],
                    'address_1' => $order_info['shipping_address_1'],
                    'address_2' => $order_info['shipping_address_2'],
                    'city' => $order_info['shipping_city'],
                    'postcode' => $order_info['shipping_postcode'],
                    'zone' => $order_info['shipping_zone'],
                    'zone_code' => $order_info['shipping_zone_code'],
                    'country' => $order_info['shipping_country']
                );

                $shipping_address = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                $this->load->model('tool/upload');


        //xtensions- Custom Fields
				$customer_fields =array();
				if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
					$customer_fields =array();
					$fieldData = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldByIdentifier($order_info['custom_field'],'account');
					foreach($this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getCustomFieldsAll($order_info['customer_group_id']) as $field){
						if($field['location']=='account' && $field['invoice']){
							if(isset($fieldData[$field['identifier']])){
								$customer_fields[] = $fieldData[$field['identifier']];
							}
						}
					}
					$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
					$payment_address = $formatted_address['payment_address_formatted'];
					$shipping_address = $formatted_address['shipping_address_formatted'];
				}
				//xtensions- Custom Fields
			
                $product_data = array();

                $products = $this->model_sale_order->getOrderProducts($order_id);

                foreach ($products as $product) {
                    $product_info = $this->model_catalog_product->getProduct($product['product_id']);

                    $option_data = array();

                    $options = $this->model_sale_order->getOrderOptions($order_id, $product['order_product_id']);

                    foreach ($options as $option) {
                        if ($option['type'] != 'file') {
                            $value = $option['value'];
                        } else {
                            $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                            if ($upload_info) {
                                $value = $upload_info['name'];
                            } else {
                                $value = '';
                            }
                        }

                        $option_data[] = array(
                            'name' => $option['name'],
                            'value' => $value
                        );
                    }

                    $product_data[] = array(
                        'name' => $product_info['name'],
                        'model' => $product_info['model'],
                        'option' => $option_data,
                        'quantity' => number_format($product['quantity'], 2),
                        'location' => $product_info['location'],
                        'sku' => $product_info['sku'],
                        'upc' => $product_info['upc'],
                        'ean' => $product_info['ean'],
                        'jan' => $product_info['jan'],
                        'isbn' => $product_info['isbn'],
                        'mpn' => $product_info['mpn'],
                        'weight' => $this->weight->format($product_info['weight'], $this->config->get('config_weight_class_id'), $this->language->get('decimal_point'), $this->language->get('thousand_point'))
                    );
                }

                $data['orders'][] = array(
                    'order_id' => $order_id,
                    'invoice_no' => $invoice_no,
                    'date_added' => date($this->language->get('date_format_short'), strtotime($order_info['date_added'])),
                    'store_name' => $order_info['store_name'],
                    'store_url' => rtrim($order_info['store_url'], '/'),
                    'store_address' => nl2br($store_address),
                    'store_email' => $store_email,
                    'store_telephone' => $store_telephone,
                    'store_fax' => $store_fax,
                    'email' => $order_info['email'],
                    'telephone' => $order_info['telephone'],
                    'shipping_address' => $shipping_address,
                    'shipping_method' => $order_info['shipping_method'],
                    'product' => $product_data,
                    'comment' => nl2br($order_info['comment'])
                );
            }
        }

        $this->response->setOutput($this->load->view('sale/order_shipping', $data));
    }

    public function api()
    {

        $json = array();

        // Store
        if (isset($this->request->get['store_id'])) {
            $store_id = $this->request->get['store_id'];
        } else {
            $store_id = 0;
        }
        $this->load->model('setting/store');

        $store_info = $this->model_setting_store->getStore($store_id);


        if ($store_info) {
            $url = $store_info['ssl'];
        } else {
            $url = HTTPS_CATALOG;
        }

        if (isset($this->session->data['cookie']) || isset($this->request->get['api'])) {

            // Include any URL perameters
            $url_data = array();

            foreach ($this->request->get as $key => $value) {
                if ($key != 'route' && $key != 'user_token') {
                    $url_data[$key] = $value;
                }
            }

            //html decode
            foreach ($this->request->post as $key => $value) {
                $this->request->post[$key] = html_entity_decode($value, ENT_QUOTES, 'UTF-8');
            }

            $curl = curl_init();

            // Set SSL if required
            if (substr($url, 0, 5) == 'https') {
                curl_setopt($curl, CURLOPT_PORT, 443);
            }

            curl_setopt($curl, CURLOPT_FRESH_CONNECT, 1);
            $header = array("Cache-Control: no-cache");
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLINFO_HEADER_OUT, true);
            curl_setopt($curl, CURLOPT_USERAGENT, $this->request->server['HTTP_USER_AGENT']);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
            curl_setopt($curl, CURLOPT_FORBID_REUSE, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($curl, CURLOPT_URL, $url . 'index.php?route=' . $this->request->get['api'] . ($url_data ? '&' . http_build_query($url_data) : ''));


            if ($this->request->post) {
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($this->request->post));
            }

            //curl_setopt($curl, CURLOPT_COOKIE, session_name() . '=' . $this->session->data['cookie'] . ';');
            $json = curl_exec($curl);


            curl_close($curl);
        }


        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput($json);
    }

    /** NFA-START-20200129
     * New function added 
     * Added By Chew Yi Xuan
     * Date Added: 2020-01-29
     */
    protected function update_product_onhand_activity()
    {
    }

    protected function check_product_onhand_acitvity_exists()
    {
        $this->load->model('sale/order');
        $result = $this->model_sale_order->checkProductOnHandActivityTableExists();
        return $result;
    }

    public function import_excel()
    {
        $this->load->model('sale/order');
        $this->load->language('sale/order');
        $this->load->model('setting/store');
        $this->load->model('localisation/country');
        $this->load->model('sale/excel_import');

        $send_sms = new SMS($this->config->get('config_sms'));

        $url = '';

        $this->document->setTitle($this->language->get('text_import_order'));

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['cancel'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true);

        $data['error_text_warning'] = $this->language->get('error_warning');

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->request->post['orders'])) {
            $data['orders'] = $this->request->post['orders'];
        } else {
            $data['orders'] = [];
        }

        if (isset($this->request->post['notify_customer_when_shipped'])) {
            $data['notify_customer_when_shipped'] = $this->request->post['notify_customer_when_shipped'];
        } else {
            $data['notify_customer_when_shipped'] = '0';
        }

        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validateFormImport()) {
            if (isset($this->request->post['orders'])) {
                $notify_customer_when_shipped = $this->request->post['notify_customer_when_shipped'];

                $order_row = [];

                foreach ($this->request->post['orders'] as $order) {
                    $order_json = base64_decode($order);
                    $order_arr = json_decode($order_json, true);

                    $order_info = $this->model_sale_order->get_order_by_order_id($order_arr['order_id']);

                    $order_id = !empty($order_info) ? $order_info['order_id'] : 0;

                    $courier_info = $this->model_sale_order->getCourierService($order_arr['courier_service']);

                    $courier_id = !empty($courier_info) ? $courier_info['carrier_id'] : 0;

                    $tracking_number = !empty($order_arr['tracking_number']) ? $order_arr['tracking_number'] : '';

                    $courier_service = !empty($order_arr['courier_service']) ? $order_arr['courier_service'] : '';

                    $customer_telephone = !empty($order_arr['telephone']) ? $order_arr['telephone'] : '';

                    $courier_comment = '';

                    $order_status_with_courier_row = $this->model_sale_excel_import->get_setting_by_key('order_status_with_courier');
                    $order_status_with_courier_id = !empty($order_status_with_courier_row) ? $order_status_with_courier_row['value'] : 0;

                    $country_id = $this->config->get('config_country_id');
                    $country_info = $this->model_localisation_country->getCountry($country_id);
                    $mobile_code = $country_info['mobile_code'];

                    $order_tracking_number_sms_settings = $this->config->get('config_sms_customer_order_tracking_number');

                    if ($order_arr['order_id'] > 0) {
                        $order_id = $order_arr['order_id'];

                        if (!empty($tracking_number) && !empty($courier_service)) {
                            // check order history with shipped for this order is exists or not
                            $shipped_order_history_row = $this->model_sale_excel_import->get_order_history($order_id, $order_status_with_courier_id);

                            if (empty($shipped_order_history_row)) {
                                // check notify customer or not
                                if ($notify_customer_when_shipped > 0) {
                                    // send sms to the customer for the tracking number 
                                    if (!empty($customer_telephone)) {

                                        if (substr($customer_telephone, 0, 2) == '+6') {
                                            $customer_telephone = ltrim($customer_telephone, '+6');
                                        }

                                        if ($order_tracking_number_sms_settings['status'] == '1') {
                                            $find_sms_template = ['{order_id}', '{courier}', '{shipping_tracking}'];

                                            $replace_sms_template = [
                                                'order_id' => $order_id,
                                                'courier' => $courier_service,
                                                'shipping_tracking' => $tracking_number
                                            ];

                                            $sms_message = str_replace($find_sms_template, $replace_sms_template, $order_tracking_number_sms_settings['template']);

                                            $send_sms->sendTo($mobile_code, $customer_telephone);

                                            if (preg_match('/\p{Han}+/u', $sms_message)) {
                                                $send_sms->changeContentType();
                                                $send_sms->convertUnicode($sms_message);
                                            } else {
                                                $send_sms->setMessage($sms_message);
                                            }

                                            $send_sms->send();
                                        }
                                    }
                                }

                                // add shipped order history
                                $this->model_sale_excel_import->add_order_history($order_id, $order_status_with_courier_id, $notify_customer_when_shipped, $courier_comment);

                                // update order status of the order
                                $this->model_sale_excel_import->update_order_status($order_id, $order_status_with_courier_id);

                                // update the carrier
                                $courier_info = !empty($courier_service) ? $this->model_sale_excel_import->get_courier_data_by_name($courier_service) : [];
                                $carrier_id = !empty($courier_info) ? $courier_info['carrier_id'] : 0;

                                $this->model_sale_excel_import->update_carrier($order_id, $carrier_id, $tracking_number);
                            }
                        }
                    }

                    $order_row[] = [
                        'order_id' => $order_id,
                        'tracking_number' => $order_arr['tracking_number'],
                        'carrier_id' => $courier_id
                    ];
                }

                if (!empty($order_row)) {
                    $this->model_sale_order->updateOrderTracking($order_row);
                }
            }
        }

        $data['total_order'] = 0;

        $data['user_token'] = $this->session->data['user_token'];

        $data['action'] = $this->url->link('sale/order/import_excel', 'user_token=' . $this->session->data['user_token'], true);
        $data['import_excel_action'] = $this->url->link('sale/order/ImportExcel', 'user_token=' . $this->session->data['user_token'], true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/import_order_form', $data));
    }

    public function update_single_shipment()
    {
        $json = [];

        $this->load->language('sale/shipping_module');
        $this->load->language('sale/order');

        $this->load->model('sale/order');
        $this->load->model('localisation/country');

        $send_sms = new SMS($this->config->get('config_sms'));
        $order_tracking_number_sms_settings = $this->config->get('config_sms_customer_order_tracking_number');

        $country_id = $this->config->get('config_country_id');
        $country_info = $this->model_localisation_country->getCountry($country_id);
        $mobile_code = $country_info['mobile_code'];

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;
        $carrier_id = isset($this->request->post['carrier_id']) ? $this->request->post['carrier_id'] : false;
        $tracking_number = isset($this->request->post['tracking_number']) ? $this->request->post['tracking_number'] : false;
        $comment = isset($this->request->post['comment']) ? $this->request->post['comment'] : false;
        $notify = isset($this->request->post['notify']) ? $this->request->post['notify'] : 0;

        if ($order_status_id && $carrier_id) {
            $order_info = $this->model_sale_order->getOrder($order_id);
            $carrier_info = $this->model_sale_order->getCarrier($carrier_id);

            if (!empty($order_info) && !empty($carrier_info)) {
                if ($notify > 0) {
                    // send sms to the customer for the tracking number 
                    if (!empty($order_info['telephone'])) {
                        $customer_telephone = $order_info['telephone'];

                        if (substr($customer_telephone, 0, 2) == '+6') {
                            $customer_telephone = ltrim($customer_telephone, '+6');
                        }

                        if (substr($customer_telephone, 0, 1) == '6') {
                            $customer_telephone = ltrim($customer_telephone, '6');
                        }

                        if ($order_tracking_number_sms_settings['status'] == '1') {
                            $find_sms_template = ['{order_id}', '{courier}', '{shipping_tracking}'];

                            $replace_sms_template = [
                                'order_id' => $order_id,
                                'courier' => $carrier_info['name'],
                                'shipping_tracking' => $tracking_number
                            ];

                            $sms_message = str_replace($find_sms_template, $replace_sms_template, $order_tracking_number_sms_settings['template']);

                            $send_sms->sendTo($mobile_code, $customer_telephone);

                            if (preg_match('/\p{Han}+/u', $sms_message)) {
                                $send_sms->changeContentType();
                                $send_sms->convertUnicode($sms_message);
                            } else {
                                $send_sms->setMessage($sms_message);
                            }

                            $send_sms->send();
                        }
                    }

                    if (!empty($order_info['email'])) {
                        $data['title'] = sprintf($this->language->get('text_subject'), $order_info['store_name'], $order_info['order_id']);

                        $data['text_greeting'] = sprintf($this->language->get('text_greeting'), $order_info['store_name']);

                        $order_products = $this->model_sale_order->getOrderProducts($order_info['order_id']);

                        $data['logo'] = $order_info['store_url'] . 'image/' . $this->config->get('config_logo');

                        $data['store_name'] = $order_info['store_name'];
                        $data['store_url'] = $order_info['store_url'];
                        $data['customer_id'] = $order_info['customer_id'];
                        $data['link'] = $comment;

                        $data['order_id'] = $order_info['order_id'];
                        $data['date_added'] = date($this->language->get('date_format_short'), strtotime($order_info['date_added']));
                        $data['payment_method'] = $order_info['payment_method'];
                        $data['shipping_method'] = $order_info['shipping_method'];
                        $data['email'] = $order_info['email'];
                        $data['telephone'] = $order_info['telephone'];
                        $data['ip'] = $order_info['ip'];

                        date_default_timezone_set("Asia/Kuala_Lumpur");
                        $data['now_time'] = date("d/M/y h:i:s A");

                        $order_status_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_status WHERE order_status_id = '" . (int) $order_status_id . "' AND language_id = '" . (int) $order_info['language_id'] . "'");

                        if ($order_status_query->num_rows) {
                            $data['order_status'] = $order_status_query->row['name'];
                        } else {
                            $data['order_status'] = '';
                        }

                        if ($comment && $notify) {
                            $data['comment'] = nl2br($comment);
                        } else {
                            $data['comment'] = '';
                        }

                        if ($order_info['payment_address_format']) {
                            $format = $order_info['payment_address_format'];
                        } else {
                            $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                        }

                        $find = array(
                            '{firstname}',
                            '{lastname}',
                            '{company}',
                            '{address_1}',
                            '{address_2}',
                            '{city}',
                            '{postcode}',
                            '{zone}',
                            '{zone_code}',
                            '{country}'
                        );

                        $replace = array(
                            'firstname' => $order_info['payment_firstname'],
                            'lastname' => $order_info['payment_lastname'],
                            'company' => $order_info['payment_company'],
                            'address_1' => $order_info['payment_address_1'],
                            'address_2' => $order_info['payment_address_2'],
                            'city' => $order_info['payment_city'],
                            'postcode' => $order_info['payment_postcode'],
                            'zone' => $order_info['payment_zone'],
                            'zone_code' => $order_info['payment_zone_code'],
                            'country' => $order_info['payment_country']
                        );

                        $data['payment_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                        if ($order_info['shipping_address_format']) {
                            $format = $order_info['shipping_address_format'];
                        } else {
                            $format = '{firstname} {lastname}' . "\n" . '{company}' . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}';
                        }

                        $find = array(
                            '{firstname}',
                            '{lastname}',
                            '{company}',
                            '{address_1}',
                            '{address_2}',
                            '{city}',
                            '{postcode}',
                            '{zone}',
                            '{zone_code}',
                            '{country}'
                        );

                        $replace = array(
                            'firstname' => $order_info['shipping_firstname'],
                            'lastname' => $order_info['shipping_lastname'],
                            'company' => $order_info['shipping_company'],
                            'address_1' => $order_info['shipping_address_1'],
                            'address_2' => $order_info['shipping_address_2'],
                            'city' => $order_info['shipping_city'],
                            'postcode' => $order_info['shipping_postcode'],
                            'zone' => $order_info['shipping_zone'],
                            'zone_code' => $order_info['shipping_zone_code'],
                            'country' => $order_info['shipping_country']
                        );

                        $data['shipping_address'] = str_replace(array("\r\n", "\r", "\n"), '<br />', preg_replace(array("/\s\s+/", "/\r\r+/", "/\n\n+/"), '<br />', trim(str_replace($find, $replace, $format))));

                        $this->load->model('tool/upload');

                        // Products

        //xtensions- Custom Fields
  			if($this->xtensions_checkout->isActive('xtensions_best_checkout',$order_info['store_id'])){
  				$formatted_address = $this->xtensions_checkout->getXtensionsModel($this->config->get('xtensions_custom_fields_path'))->getFormattedAddressForOrder($order_info);
  				$data['payment_address'] = $formatted_address['payment_address_formatted'];
  				$data['shipping_address'] = $formatted_address['shipping_address_formatted'];
  			}
  			//xtensions- Custom Fields
			
                        $data['products'] = array();

                        foreach ($order_products as $order_product) {
                            $option_data = array();

                            $order_options = $this->model_sale_order->getOrderOptions($order_info['order_id'], $order_product['order_product_id']);

                            foreach ($order_options as $order_option) {
                                if ($order_option['type'] != 'file') {
                                    $value = $order_option['value'];
                                } else {
                                    $upload_info = $this->model_tool_upload->getUploadByCode($order_option['value']);

                                    if ($upload_info) {
                                        $value = $upload_info['name'];
                                    } else {
                                        $value = '';
                                    }
                                }

                                $option_data[] = array(
                                    'name' => $order_option['name'],
                                    'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
                                );
                            }

                            $data['products'][] = array(
                                'name' => $order_product['name'],
                                'model' => $order_product['model'],
                                'option' => $option_data,
                                'quantity' => $order_product['quantity'],
                                'price' => $this->currency->format($order_product['price'] + ($this->config->get('config_tax') ? $order_product['tax'] : 0), $order_info['currency_code'], $order_info['currency_value']),
                                'total' => $this->currency->format($order_product['total'] + ($this->config->get('config_tax') ? ($order_product['tax'] * $order_product['quantity']) : 0), $order_info['currency_code'], $order_info['currency_value'])
                            );
                        }

                        // Vouchers
                        $data['vouchers'] = array();

                        $order_vouchers = $this->model_sale_order->getOrderVouchers($order_info['order_id']);

                        foreach ($order_vouchers as $order_voucher) {
                            $data['vouchers'][] = array(
                                'description' => $order_voucher['description'],
                                'amount' => $this->currency->format($order_voucher['amount'], $order_info['currency_code'], $order_info['currency_value']),
                            );
                        }

                        // Order Totals
                        $data['totals'] = array();

                        $order_totals = $this->model_sale_order->getOrderTotals($order_info['order_id']);

                        foreach ($order_totals as $order_total) {
                            $data['totals'][] = array(
                                'title' => $order_total['title'],
                                'text' => $this->currency->format($order_total['value'], $order_info['currency_code'], $order_info['currency_value']),
                            );
                        }

                        $this->load->model('setting/setting');

                        $from = $this->model_setting_setting->getSettingValue('config_email', $order_info['store_id']);

                        if (!$from) {
                            $from = $this->config->get('config_email');
                        }

                        $mail = new Mail($this->config->get('config_mail_engine'));
                        $mail->parameter = $this->config->get('config_mail_parameter');
                        $mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
                        $mail->smtp_username = $this->config->get('config_mail_smtp_username');
                        $mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
                        $mail->smtp_port = $this->config->get('config_mail_smtp_port');
                        $mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
                        $mail->setTo($order_info['email']);
                        $mail->setFrom($from);
                        $mail->setSender(html_entity_decode($order_info['store_name'], ENT_QUOTES, 'UTF-8'));
                        $mail->setSubject(html_entity_decode(sprintf($order_info['store_name']), ENT_QUOTES, 'UTF-8'));
                        $mail->setHtml($this->load->view('sale/notify_customer_email', $data));
                        $mail->send();
                    }
                }

                // add order history
                $user_id = $this->session->data['user_id'];
                $staff_name = $this->model_sale_order->getStaffName($user_id);

                date_default_timezone_set('Asia/Kuala_Lumpur'); 
                $date = date('Y-m-d H:i:s');
                
                $comment .=" updated by $staff_name at $date" ;
                $this->model_sale_order->add_order_history($order_id, $order_status_id, $comment, $notify);

                // update order status
                $this->model_sale_order->updateCancel($order_status_id, $order_id);

                // update tracking shipment
                $this->model_sale_order->update_carrier($order_id, $carrier_id, $tracking_number);

                $this->session->data['success'] = $this->language->get('text_success_update_shipment');

                $json = [
                    'error' => false,
                    'message' => 'update shipment success'
                ];
            } else {
                $error_arr['warning'] = $this->language->get('error_warning');

                $json = [
                    'error' => true,
                    'error_arr' => $error_arr,
                    'message' => 'order not found'
                ];
            }
        } else {
            $error_arr = [];

            if (!$order_status_id) {
                $error_arr['order_status'] = $this->language->get('error_order_status');
            }

            if (!$carrier_id) {
                $error_arr['carrier'] = $this->language->get('error_carrier');
            }

            if (!empty($error_arr)) {
                $error_arr['warning'] = $this->language->get('error_warning');
            }

            $json = [
                'error' => true,
                'error_arr' => $error_arr,
                'message' => 'cannot get post data'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
    //add by alia
    public function settings()
    {
        $this->load->language('sale/order');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('sale/order');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateSettingsForm()) {
            $this->model_sale_order->save_settings($this->request->post);

            $this->session->data['success'] = $this->language->get('text_success_import_settings');

            $this->response->redirect($this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true));
        }

        $this->getSettingsForm();
    }

    protected function validateSettingsForm()
    {
        if (!$this->user->hasPermission('modify', 'sale/order')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (empty($this->request->post['customer_group'])) {
            $this->error['customer_group'] = $this->language->get('error_customer_group');
        }

        if ($this->error && !isset($this->error['warning'])) {
            $this->error['warning'] = $this->language->get('error_warning');
        }

        return !$this->error;
    }

    protected function getSettingsForm()
    {
        $import_settings = $this->get_settings();

        $url = '';

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['action'] = $this->url->link('sale/order/settings', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true);

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['config_order_online_customer_group'])) {
            $data['error_order_online_customer_group'] = $this->error['config_order_online_customer_group'];
        } else {
            $data['error_order_online_customer_group'] = '';
        }


        if (isset($this->request->post['config_order_online_customer_group'])) {
            $data['config_order_online_customer_group'] = $this->request->post['config_order_online_customer_group'];
        } elseif (!empty($import_settings)) {
            $data['config_order_online_customer_group'] = $import_settings['config_order_online_customer_group'];
        } else {
            $data['config_order_online_customer_group'] = '';
        }



        $this->load->model('sale/customer_group');


        $data['customer_groups'] = $this->model_sale_customer_group->getCustomerGroups();


        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('sale/online_customer_form', $data));
    }

    private function get_settings()
    {
        $setting_results = [];

        $this->load->model('sale/order');

        $settings = $this->model_sale_order->get_settings();

        if (!empty($settings)) {
            foreach ($settings as $setting) {
                if ($setting['serialized'] == '1') {
                    $setting_results[$setting['key']] = unserialize($setting['value']);
                } else {
                    $setting_results[$setting['key']] = $setting['value'];
                }
            }
        }

        return $setting_results;
    }

    public function updateOrders() {
        $json = [];

        $this->load->language('sale/order');
        $this->load->model('sale/order');

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $payment_method = isset($this->request->post['payment_method']) ? $this->request->post['payment_method'] : false;
        $invoice_date = isset($this->request->post['invoice_date']) ? $this->request->post['invoice_date'] : false;
        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;


           
        // update order payment method
          $this->model_sale_order->updatePaymentOrder($order_id,$payment_method,$invoice_date,$order_status_id);

            $this->session->data['success'] = $this->language->get('text_success_update_shipment');

            $json = [
            'error' => false,
            'message' => 'update shipment success'
            ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updatePaymentAddress() {
        $json = [];
        $this->load->language('sale/order');
        $this->load->model('sale/order');
    
        $data = [
            'order_id' => isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false,
            'payment_firstname' => isset($this->request->post['payment_firstname']) ? $this->request->post['payment_firstname'] : false,
            'payment_lastname' => isset($this->request->post['payment_lastname']) ? $this->request->post['payment_lastname'] : false,
            'payment_company' => isset($this->request->post['payment_company']) ? $this->request->post['payment_company'] : false,
            'payment_address_1' => isset($this->request->post['payment_address_1']) ? $this->request->post['payment_address_1'] : false,
            'payment_address_2' => isset($this->request->post['payment_address_2']) ? $this->request->post['payment_address_2'] : false,
            'payment_city' => isset($this->request->post['payment_city']) ? $this->request->post['payment_city'] : false,
            'payment_postcode' => isset($this->request->post['payment_postcode']) ? $this->request->post['payment_postcode'] : false,
            'country_id' => isset($this->request->post['country_id']) ? $this->request->post['country_id'] : '129',
            'zone_id' => isset($this->request->post['zone_id']) ? $this->request->post['zone_id'] : false,
            'payment_country' => isset($this->request->post['payment_country']) ? $this->request->post['payment_country'] : false,
            'payment_zone' => isset($this->request->post['payment_zone']) ? $this->request->post['payment_zone'] : false,
            'user_id' => $this->session->data['user_id'],
            'order_status_id' => isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false

        ];
    
        $this->load->model('customer/customer');

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $customer_id = $this->model_sale_order->getCustomerId($order_id);

       

    
        // Update payment address
        $this->model_sale_order->updatePaymentAddress($data);
    
        $this->session->data['success'] = $this->language->get('text_success_update_shipment');
    
        $json = [
            'error' => false,
            'message' => 'Update shipment success'
        ];
    
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateShippingAddress() {
        $json = [];
        $this->load->language('sale/order');
        $this->load->model('sale/order');
    
        $data = [
            'order_id' => isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false,
            'shipping_firstname' => isset($this->request->post['shipping_firstname']) ? $this->request->post['shipping_firstname'] : false,
            'shipping_lastname' => isset($this->request->post['shipping_lastname']) ? $this->request->post['shipping_lastname'] : false,
            'shipping_company' => isset($this->request->post['shipping_company']) ? $this->request->post['shipping_company'] : false,
            'shipping_address_1' => isset($this->request->post['shipping_address_1']) ? $this->request->post['shipping_address_1'] : false,
            'shipping_address_2' => isset($this->request->post['shipping_address_2']) ? $this->request->post['shipping_address_2'] : false,
            'shipping_city' => isset($this->request->post['shipping_city']) ? $this->request->post['shipping_city'] : false,
            'shipping_postcode' => isset($this->request->post['shipping_postcode']) ? $this->request->post['shipping_postcode'] : false,
            'country_id' => isset($this->request->post['country_id']) ? $this->request->post['country_id'] : '129',
            'zone_id' => isset($this->request->post['zone_id']) ? $this->request->post['zone_id'] : false,
            'shipping_country' => isset($this->request->post['shipping_country']) ? $this->request->post['shipping_country'] : false,
            'shipping_zone' => isset($this->request->post['shipping_zone']) ? $this->request->post['shipping_zone'] : false,
            'user_id' => $this->session->data['user_id'],
            'order_status_id' => isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false

        ];
    
        $this->load->model('customer/customer');

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $customer_id = $this->model_sale_order->getCustomerId($order_id);

    
        // Update payment address
        $this->model_sale_order->updateShippingAddress($data);
    
        $this->session->data['success'] = $this->language->get('text_success_update_shipment');
    
        $json = [
            'error' => false,
            'message' => 'Update shipment success'
        ];
    
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateOrderInvoice()
    {
        $json = [];
        $this->load->language('sale/order');
        $this->load->model('sale/order');

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $invoice_prefix = isset($this->request->post['invoice_prefix']) ? $this->request->post['invoice_prefix'] : false;
        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;


        // Get the previous invoice prefix
        $previous_invoice_prefix = $this->model_sale_order->getInvoicePrefix($order_id);

        // Check if the invoice prefix already exists in the database
        $invoiceExists = $this->model_sale_order->checkInvoiceExists($invoice_prefix);

        if ($invoiceExists) {
            $json = [
                'error' => true,
                'message' => 'Invoice prefix already exists.Please Key in new one'
            ];
        } else {
            // Update order invoice
            $this->model_sale_order->updateInvoice($order_id, $invoice_prefix);

            // Add to order history if invoice prefix is changed
            if ($previous_invoice_prefix != $invoice_prefix) {
                $user_id = $this->session->data['user_id'];
                $staff_name = $this->model_sale_order->getStaffName($user_id);
                $order_info = $this->model_sale_order->getOrder($order_id);

                date_default_timezone_set('Asia/Kuala_Lumpur'); 
                $date = date('Y-m-d H:i:s');
                $comment = "[Sale/Order][Order's invoice number changed] Order's invoice number has been changed from {$previous_invoice_prefix} to {$invoice_prefix} by {$staff_name} at {$date}";

                $this->model_sale_order->addOrderHistory($order_id, $comment,$order_status_id);
            }

            $this->session->data['success'] = $this->language->get('text_success_update_shipment');

            $json = [
                'error' => false,
                'message' => 'Update shipment success'
            ];
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function cancel_reason() {
        $json = [];

        $this->load->language('sale/order');
        $this->load->model('sale/order');

        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $reason = isset($this->request->post['reason']) ? $this->request->post['reason'] : false;
           
        $data = array();

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info) {
            $data['invoice_prefix'] = $order_info['invoice_prefix'];
            $data['user_id'] = $order_info['user_id'];
        }

          $this->model_sale_order->addCancelReason($order_id,$reason,$data);


          $this->session->data['success'] = $this->language->get('text_success_update_shipment');

          $json = [
            'error' => false,
            'message' => 'update shipment success'
            ];

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function autocomplete()
    {
        $json = array();

        if (isset($this->request->get['customer_name'])) {
            $filter_name = $this->request->get['customer_name'];

            $this->load->model('customer/customer');

            $filter_data = array(
                'filter_name' => $filter_name,
                'start' => 0,
                'limit' => 5
            );

            $results = $this->model_customer_customer->getCustomersAutocomplete($filter_data);

            foreach ($results as $result) {
                $json[] = array(
                    'customer_id' => $result['customer_id'],
                    'name' => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8')),
                    'telephone' => $result['telephone'],
                    'email' => $result['email']
                    // Add other necessary fields for autocomplete results
                );
            }
        }

        $sort_order = array();

        foreach ($json as $key => $value) {
            $sort_order[$key] = $value['name'];
        }

        array_multisort($sort_order, SORT_ASC, $json);

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function updateCustomer()
    {
        $this->load->model('sale/order');
        $json = [];

        

        // $old_customer_id = $this->request->post['old_customer_id'];
        $new_customer_id = $this->request->post['new_customer_id'];
        $order_id = $this->request->post['order_id'];
        $customer_group = $this->request->post['customer_group'];
        $email = $this->request->post['email'];
        $telephone = $this->request->post['telephone'];
        $order_status_id = $this->request->post['order_status_id'];



        // $customer_group_id = $this->request->post['customer_group_id'];



        $data = array();

        $order_info = $this->model_sale_order->getOrder($order_id);

        if ($order_info) {
            $data['user_id'] = $order_info['user_id'];
            $data['customer_group'] = $customer_group;
            $data['email'] = $email;
            $data['telephone'] = $telephone;
            $data['hidden_order_status_id'] = $order_status_id;



        }


        $this->model_sale_order->updateCustomerInfo($order_id, $new_customer_id,$data);


        $json['success'] = 1;

        header('Content-Type: application/json');
        return $this->response->setOutput(json_encode($json));
    }

    public function updateComment() {
        $this->load->language('sale/order');
        $this->load->model('sale/order');
        
        $order_id = isset($this->request->post['order_id']) ? $this->request->post['order_id'] : false;
        $comment = isset($this->request->post['comment']) ? $this->request->post['comment'] : '';
        $user_id = $this->session->data['user_id'];
        $order_status_id = isset($this->request->post['order_status_id']) ? $this->request->post['order_status_id'] : false;


        // Update the order comment
        $this->model_sale_order->updateOrderComment($order_id, $comment,$user_id,$order_status_id);
        
        $this->session->data['success'] = $this->language->get('text_success_update_comment');
        
        $json = [
            'error' => false,
            'message' => 'Update comment success'
        ];
        
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
    
    /** NFA-END-20200129 */
}
