<?php echo $header; ?>
<div class="container">
   <ul class="breadcrumb">
    <?php foreach ($breadcrumbs as $breadcrumb) { ?>
    <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
    <?php } ?>
  </ul>
  <div class="row">
    <div id="content" class="col-sm-12">
       <h1 class="page-heading"><?php echo $heading_title; ?></h1>
      
      <div id="warning">
      <?php if ($success) { ?>
      <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
      </div>
      <?php } ?>
      <?php if ($error_warning) { ?>
      <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
        <button type="button" class="close" data-dismiss="alert">&times;</button>
      </div>
      <?php } ?>
      </div>
      
      <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-customer" class="form-horizontal">  
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-customer-ic"><?php echo $entry_customer_ic; ?></label>
          <div class="col-sm-10">
            <input type="text" name="customer_ic" value="<?php echo $customer_ic; ?>" placeholder="<?php echo $text_place_holder_ic; ?>" id="input-customer-ic" class="form-control" />
            <?php if ($error_customer_ic) { ?>
            <div class="text-danger"><?php echo $error_customer_ic; ?></div>
            <?php } ?>
          </div>
        </div>
        
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-firstname"><?php echo $entry_firstname; ?></label>
          <div class="col-sm-10">
            <input type="text" name="firstname" value="<?php echo $firstname; ?>" placeholder="<?php echo $text_place_holder_name; ?>" id="input-firstname" class="form-control enter-key" />
            <?php if ($error_firstname) { ?>
            <div class="text-danger"><?php echo $error_firstname; ?></div>
            <?php } ?>
          </div>
        </div>
        
        <div class="form-group">
          <label class="col-sm-2 control-label" for="input-gender"><?php echo $entry_gender; ?></label>
          <div class="col-sm-10">
            <select name="gender" id="input-gender" class="form-control enter-key">
              <?php if ($gender == '1') { ?>
              <option value="1" selected="selected"><?php echo $filed_male; ?></option>
              <option value="2"><?php echo $filed_female; ?></option>
              <?php } else { ?>
              <option value="1"><?php echo $filed_male; ?></option>
              <option value="2" selected="selected"><?php echo $filed_female; ?></option>
              <?php } ?>
            </select>
          </div>
        </div>
        
        <div class="form-group">
          <label class="col-sm-2 control-label" for="input-email"><?php echo $entry_email; ?></label>
          <div class="col-sm-10">
            <input type="text" name="email" value="<?php echo $email; ?>" placeholder="<?php echo $text_place_holder_email; ?>" id="input-email" class="form-control enter-key" />  
            <?php if ($error_email) { ?>
            <div class="text-danger"><?php echo $error_email; ?></div>
            <?php } ?>
          </div>
        </div>
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-telephone"><?php echo $entry_telephone; ?></label>
          <div class="col-sm-10">
            <input type="text" name="telephone" value="<?php echo $telephone; ?>" placeholder="<?php echo $text_place_holder_telephone; ?>" id="input-telephone" class="form-control enter-key" />
            <?php if ($error_telephone) { ?>
            <div class="text-danger"><?php echo $error_telephone; ?></div>
            <?php  } ?>
          </div>
        </div>
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-address-1"><?php echo $entry_address_1; ?></label>
          <div class="col-sm-10">
            <input type="text" name="address_1" value="<?php echo $address_1; ?>" placeholder="<?php echo $text_place_holder_address_1; ?>" id="input-address-1" class="form-control enter-key" />
            <?php if ($error_address_1) { ?>
            <div class="text-danger"><?php echo $error_address_1; ?></div>
            <?php  } ?>
          </div>
        </div>
        
        <div class="form-group">
          <label class="col-sm-2 control-label" for="input-address-2"><?php echo $entry_address_2; ?></label>
          <div class="col-sm-10">
            <input type="text" name="address_2" value="<?php echo $address_2; ?>" placeholder="<?php echo $entry_address_2; ?>" id="input-address-2" class="form-control enter-key" />
          </div>
        </div>
        
         <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-city"><?php echo $entry_city; ?></label>
          <div class="col-sm-10">
            <input type="text" name="city" value="<?php echo $city; ?>" placeholder="<?php echo $text_place_holder_city; ?>" id="input-city" class="form-control enter-key" />
            <?php if ($error_city) { ?>
            <div class="text-danger"><?php echo $error_city; ?></div>
            <?php  } ?>
          </div>
        </div>
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-postcode"><?php echo $entry_postcode; ?></label>
          <div class="col-sm-10">
            <input type="text" name="postcode" value="<?php echo $postcode; ?>" placeholder="<?php echo $text_place_holder_postcode; ?>" id="input-postcode" class="form-control enter-key" />
            <?php if ($error_postcode) { ?>
            <div class="text-danger"><?php echo $error_postcode; ?></div>
            <?php  } ?>
          </div>
        </div>
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-country"><?php echo $entry_country; ?></label>
          <div class="col-sm-10 textbox">
            <select name="country_id" id="input-country" class="form-control">
              <option value=""><?php echo $text_select; ?></option>
              <?php foreach ($countries as $country) { ?>
              <?php if ($country['country_id'] == $country_id) { ?>
              <option value="<?php echo $country['country_id']; ?>" selected="selected"><?php echo $country['name']; ?></option>
              <?php } else { ?>
              <option value="<?php echo $country['country_id']; ?>"><?php echo $country['name']; ?></option>
              <?php } ?>
              <?php } ?>
            </select>
            <?php if ($error_country) { ?>
            <div class="text-danger"><?php echo $error_country; ?></div>
            <?php } ?>
          </div>
        </div>
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-zone"><?php echo $entry_zone; ?></label>
          <div class="col-sm-10 textbox">
            <select name="zone_id" id="input-zone" class="form-control">
            </select>
            <?php if ($error_zone) { ?>
            <div class="text-danger"><?php echo $error_zone; ?></div>
            <?php } ?>
          </div>
        </div>
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-password"><?php echo $entry_password; ?></label>
          <div class="col-sm-10">
            <input type="password" name="password" value="<?php echo $password; ?>" placeholder="<?php echo $entry_password; ?>" id="input-password" class="form-control enter-key" autocomplete="off"/>
            <?php if ($error_password) { ?>
            <div class="text-danger"><?php echo $error_password; ?></div>
            <?php  } ?>
          </div>
        </div>
        
        
        <div class="form-group required">
          <label class="col-sm-2 control-label" for="input-confirm"><?php echo $entry_confirm; ?></label>
          <div class="col-sm-10">
          <input type="password" name="confirm" value="<?php echo $confirm; ?>" placeholder="<?php echo $entry_confirm; ?>" autocomplete="off" id="input-confirm" class="form-control enter-key" />
          <?php if ($error_confirm) { ?>
          <div class="text-danger"><?php echo $error_confirm; ?></div>
          <?php  } ?>
          </div>
        </div>
        
        <div class="button_div">
          <div class="pull-left"><a href="<?php echo $back; ?>" class="btn btn-default"><?php echo $button_back; ?></a></div>
          <div class="pull-right">
          	  <input type="button" value="<?php echo $button_clear; ?>" onclick="clearForm()" class="btn btn-default">
              <input type="submit" value="<?php echo $button_continue; ?>" class="btn btn-primary">
          </div>
        </div>
      </form>
    
   
<script type="text/javascript"><!--
function clearForm(){
	$('input[type=text]').val('');
	$('input[type=password]').val('');
	$('select').val('1');
	$('.enter-key').attr("readonly",false); 
}

$('select[name=\'country_id\']').on('change', function() {
	$.ajax({
		url: 'index.php?route=account/account/country&country_id=' + this.value,
		dataType: 'json',
		beforeSend: function() {
			$('select[name=\'country_id\']').after(' <i class="fa fa-circle-o-notch fa-spin"></i>');
		},
		complete: function() {
			$('.fa-spin').remove();
		},
		success: function(json) {
			if (json['postcode_required'] == '1') {
				$('input[name=\'postcode\']').parent().parent().addClass('required');
			} else {
				$('input[name=\'postcode\']').parent().parent().removeClass('required');
			}
			
			html = '<option value=""><?php echo $text_select; ?></option>';
			
			if (json['zone'] != '') {
				for (i = 0; i < json['zone'].length; i++) {
					html += '<option value="' + json['zone'][i]['zone_id'] + '"';
					
					if (json['zone'][i]['zone_id'] == '<?php echo $zone_id; ?>') {
						html += ' selected="selected"';
					}
				
					html += '>' + json['zone'][i]['name'] + '</option>';
				}
			} else {
				html += '<option value="0" selected="selected"><?php echo $text_none; ?></option>';
			}
			
			$('select[name=\'zone_id\']').html(html);
		},
		error: function(xhr, ajaxOptions, thrownError) {
			alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
		}
	});
});

$('select[name=\'country_id\']').trigger('change');

$("#input-customer-ic").keypress(function (event) {
	var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;    
    if(keyCode >= 48 && keyCode <= 57){
		// when user type 0 to 9
        return true;
	} else if(keyCode >= 97 && keyCode <= 122){
		// when user type a to z auto change to uppercase
		this.value = this.value.toUpperCase();
		return true;
	} else if(keyCode >= 65 && keyCode <= 90){
		// when user type A to Z
		return true;
	} else if(keyCode == 32){
		return true;
	} else {
		return false;
	}
});

$('#input-telephone').keypress(function (event) {
	var keyCode = event.keyCode ? event.keyCode : event.which ? event.which : event.charCode;
	if(keyCode >=48 && keyCode <= 57)
		return true;
	else return false;
});
//--></script>
    </div>
    </div>
</div>
<?php echo $footer; ?>
