<?php
class ModelAppointmentView extends Model{
	public function getAppointments($data = array()){
		$sort 	= isset($data['sort']) ? $data['sort'] : "a.appointment_date";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";
		
		$limmited_statement = "";
		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$limmited_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}
		
		$sql = "
		SELECT a.appointment_id,a.appointment_date,a.appointment_time,a.remark,a.status,csd.name AS service_name,CONCAT(u.firstname,' ',u.lastname) AS doctor_name,u.image
		FROM " . DB_PREFIX . "appointment a
		LEFT JOIN ". DB_PREFIX ."user u
		ON u.user_id = a.doctor_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON csd.clinicalservice_id = a.clinicalservice_id
		AND csd.language_id = '". $this->config->get('config_language_id')."'
		WHERE 1
		AND a.customer_id = '" . (int)$data['customer_id'] . "'	
		AND a.from_etcm = '0' 
		ORDER BY $sort $order
		$limmited_statement"; 
		
		$query = $this->db->query($sql);
		
		return $query->rows;
	}
	
	public function getTotalAppointments($data = array()){		
		$sql = "
		SELECT COUNT(*) as total 
		FROM " . DB_PREFIX . "appointment a
		LEFT JOIN ". DB_PREFIX ."user u
		ON u.user_id = a.doctor_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON csd.clinicalservice_id = a.clinicalservice_id
		AND csd.language_id = '". $this->config->get('config_language_id')."'
		WHERE 1
		AND a.customer_id = '" . (int)$data['customer_id'] . "' 
		AND a.from_etcm = '0'"; 
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	
	public function getAppointment($appointment_id){
		$sql = "SELECT 	a.appointment_date,
						a.appointment_time,
						a.remark,
						a.status,
						a.doctor_id, 
						csd.name AS service_name,
						CONCAT(u.firstname,' ',u.lastname) AS doctor_name,
						c.customer_id,
						c.firstname,
						c.lastname,
						c.gender,
						a.telephone,
						a.email,
						c.customer_ic,
						c.unique_customer_id 
			FROM " . DB_PREFIX . "appointment a 
			LEFT JOIN " . DB_PREFIX . "clinical_service_description csd 
			ON csd.clinicalservice_id = a.clinicalservice_id 
			LEFT JOIN " . DB_PREFIX . "user u 
			ON u.user_id = a.doctor_id 
			LEFT JOIN " . DB_PREFIX . "customer c
			ON c.customer_id = a.customer_id 
			WHERE a.appointment_id = '" . $appointment_id . "'" ;	
		
		$query = $this->db->query($sql);
		
		return $query->row;
	}
	
	public function cancelAppointment($appointment_id){
		$sql = "UPDATE " . DB_PREFIX ."appointment 
				SET status = '2' 
				WHERE appointment_id = '" . (int)$appointment_id . "'";	
		
		$query = $this->db->query($sql);
	}
}
?>