<?php

class ModelAppointmentAppointment extends Model
{
    public function getAppointments($data = array())
    {
        $customer_id = $this->session->data['customer_id'];

        $limmited_statement = "";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limmited_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT
			a.*,
			CASE WHEN a.store_id = 0 THEN '" . $this->config->get('config_name') . "' ELSE s.name END AS store
		FROM " . DB_PREFIX . "appointment a
		LEFT JOIN " . DB_PREFIX . "store s
		ON a.store_id = s.store_id
		WHERE 1
		AND a.customer_id = '" . (int)$customer_id . "'
		AND a.status != 5
		ORDER BY a.appointment_date DESC
		$limmited_statement";
        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getAppointmentList($data = array())
    {
        $sort 	= isset($data['sort']) ? $data['sort'] : "a.appointment_date";
		$order 	= isset($data['order']) ? $data['order'] : "DESC";

        $limmited_statement = "";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limmited_statement = " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $sql = "
		SELECT a.appointment_id,a.appointment_date,a.appointment_time,a.remark,a.status,csd.name AS service_name,CONCAT(u.firstname,' ',u.lastname) AS doctor_name,u.image
		FROM " . DB_PREFIX . "appointment a
		LEFT JOIN ". DB_PREFIX ."user u
		ON u.user_id = a.doctor_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON csd.clinicalservice_id = a.clinicalservice_id
		AND csd.language_id = '". $this->config->get('config_language_id')."'
		WHERE 1
		AND a.email = '" . $data['email'] . "'	
        AND a.telephone = '" . $data['phone_no'] . "'	
		AND a.from_etcm = '0' 
		ORDER BY $sort $order
		$limmited_statement"; 
		
		$query = $this->db->query($sql);
		
		return $query->rows;
    }
    
     public function addAppointmentData($data)
    {
        $store_id = $this->config->get('store_id');

        $this->db->query("
            INSERT INTO " . DB_PREFIX . "appointment
            SET
                appointment_date = '" . $this->db->escape($data['date']) . "',
                appointment_time = '" . $this->db->escape($data['time']) . "',
                customer_id = '" . (int) $data['customer_id'] . "',
                clinicalservice_id = '" . (int) $data['service'] . "',
                store_id = '" . (int)$store_id . "',
                customer_name = '" . $data['firstname'] . "',
                email = '" . $data['email'] . "',
                telephone = '" . $data['phone_no'] . "',
                remark = '" . $this->db->escape($data['remark']) . "',
                status = 0,
                created_date = NOW()
            ");

        $appointment_id = $this->db->getLastId();


        if ($data['got_doctor_id']) {
            $this->db->query("UPDATE " . DB_PREFIX . "appointment SET doctor_id = '" . (int) $data['doctor_id'] . "' WHERE appointment_id = '" . (int) $appointment_id . "'");
        }

        return $appointment_id;
    }

    // public function getTotalAppointments($data = array())
    // {
    //     $customer_id = $this->session->data['customer_id'];

    //     $sql = "
	// 	SELECT COUNT(*) as total
	// 	FROM " . DB_PREFIX . "appointment
	// 	WHERE 1
	// 	AND customer_id = '" . (int)$customer_id . "'";
    //     $query = $this->db->query($sql);

    //     return $query->row['total'];
    // }

    public function getTotalAppointments($data = array()){		
		$sql = "
		SELECT COUNT(*) as total 
		FROM " . DB_PREFIX . "appointment a
		LEFT JOIN ". DB_PREFIX ."user u
		ON u.user_id = a.doctor_id
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON csd.clinicalservice_id = a.clinicalservice_id
		AND csd.language_id = '". $this->config->get('config_language_id')."'
		WHERE 1
		AND a.email = '" . $data['email'] . "'	
        AND a.telephone = '" . $data['phone_no'] . "'	
		AND a.from_etcm = '0'"; 
		$query = $this->db->query($sql);
		
		return $query->row['total'];
	}
	

    public function getAppointment($appointment_id)
    {
        $query = $this->db->query("
		SELECT b.*, csd.name AS service_name
		FROM " . DB_PREFIX . "appointment b
		LEFT JOIN " . DB_PREFIX . "clinical_service_description csd
		ON csd.clinicalservice_id = b.clinicalservice_id
		AND csd.language_id = '" . $this->config->get('config_language_id') . "'
		WHERE b.appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    public function addAppointment($customer_id, $data)
    {
        $this->load->model('account/customer');

        $customer_data = $this->model_account_customer->getCustomer($customer_id);

        $store_id = $this->config->get('store_id');
        $doctor_id = isset($data['doctor']) ? $data['doctor'] : 'NULL';
        $service_id = isset($data['service']) ? $data['service'] : 'NULL';

        $sql = "
		INSERT INTO " . DB_PREFIX . "appointment
		SET
			appointment_date = '" . $this->db->escape($data['date']) . "',
			appointment_time = '" . $this->db->escape($data['time']) . "',
			store_id = '" . (int)$store_id . "',
			customer_id = '" . (int)$customer_id . "',
			email = '" . $customer_data['email'] . "',
			telephone = '" . $customer_data['telephone'] . "',
			doctor_id = '" . (int)$doctor_id . "',
			clinicalservice_id = '" . (int)$service_id . "',
			remark = '" . $this->db->escape($data['remark']) . "',
			status = 0,
			new_customer = '" . (int)$data['new'] . "',
			created_date = NOW()
		";

        $query = $this->db->query($sql);

        return $this->db->getLastId();
    }

    public function addDoctorAppointment($data)
    {
        $store_id = $this->config->get('store_id');

        $this->db->query("
            INSERT INTO " . DB_PREFIX . "appointment
            SET
                appointment_date = '" . $this->db->escape($data['date']) . "',
                appointment_time = '" . $this->db->escape($data['time']) . "',
                customer_id = '" . (int) $data['customer_id'] . "',
                clinicalservice_id = '" . (int) $data['service'] . "',
                store_id = '" . (int)$store_id . "',
                customer_name = '" . $data['firstname'] . "',
                email = '" . $data['email'] . "',
                telephone = '" . $data['phone_no'] . "',
                remark = '" . $this->db->escape($data['remark']) . "',
                status = 0,
                created_date = NOW()
            ");

        $appointment_id = $this->db->getLastId();


        if ($data['got_doctor_id']) {
            $this->db->query("UPDATE " . DB_PREFIX . "appointment SET doctor_id = '" . (int) $data['doctor_id'] . "' WHERE appointment_id = '" . (int) $appointment_id . "'");
        }

        return $appointment_id;
    }

    public function checkUserHoliday($doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_holiday WHERE store_id = '" . $this->config->get('store_id') . "' AND user_id = '" . (int)$doctor_id . "'");

        return $query->rows;
    }

    public function checkStoreHoliday($store_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_holiday WHERE store_id = '" . $store_id . "'");

        return $query->rows;
    }

    public function isNewCustomer($customer_id)
    {
        $service_sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "service_form WHERE customer_id = '" . (int)$customer_id . "'";
        $service_query = $this->db->query($service_sql);

        $herbal_sql = "SELECT COUNT(*) AS num FROM " . DB_PREFIX . "clinical_sale WHERE customer_id = '" . (int)$customer_id . "'";
        $herbal_query = $this->db->query($herbal_sql);

        return !($service_query->row['num'] > 0 || $herbal_query->row['num'] > 0);
    }

    public function getServices()
    {
        $query = $this->db->query("SELECT *
			FROM " . DB_PREFIX . "clinical_service a
			LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
			WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY b.name DESC");

        return $query->rows;
    }

    public function getService($service_id)
    {
        $query = $this->db->query("SELECT *
			FROM " . DB_PREFIX . "clinical_service a
			LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
			WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' AND a.clinicalservice_id = '" . (int)$service_id . "'");

        return $query->row;
    }

    public function getService1($service_id)
    {
        $query = $this->db->query("SELECT doctor_id
			FROM " . DB_PREFIX . "clinical_service a
			LEFT JOIN " . DB_PREFIX . "clinical_service_description b ON a.clinicalservice_id = b.clinicalservice_id
			WHERE b.language_id = '" . (int)$this->config->get('config_language_id') . "' AND a.clinicalservice_id = '" . (int)$service_id . "'");

        return $query->row;
    }

    public function getDoctors($data = [])
    {
        $doctor_statement = '';

        // if (!empty($data['doctors'])) {
        //     $doctor_statement=  "CONCAT(firstname, ' ', lastname) LIKE '%" . $this->db->escape($data['doctors']) . "%'";
        // }

        if (!empty($data['doctor_id'])) {
            $doctor_statement=" AND user_id IN  (" . implode(',', $data['doctor_id']) . ")";
        }

        $sql= "SELECT * FROM " . DB_PREFIX . "user WHERE position = 2 AND show_for_appointment = 1 $doctor_statement ORDER BY doctor_sort_order ASC";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getDoctor($doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user WHERE position = '" . (int) 2 . "' AND user_id = '" . (int)$doctor_id . "'");

        return $query->row;
    }

    public function getTimes($date, $doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id LEFT JOIN " . DB_PREFIX . "user u ON u.user_id = aa.doctor_id WHERE aa.day = '" . $this->db->escape($date) . "' AND aa.doctor_id = '" . (int)$doctor_id . "' AND u.enable_appointment = '1' ORDER BY aat.availability_time_id ASC");

        return $query->rows;
    }

    public function getServiceTimes($date, $service_id)
    {
        $doctor_availability = array();

        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int)$service_id . "'";

        $query_service = $this->db->query($sql);

        $service = $query_service->row;

        if (!empty($service)) {
            $doctor_ids = unserialize($service['doctor_id']);

            foreach ($doctor_ids as $key => $doctor) {
                $sql_availability = "SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id LEFT JOIN " . DB_PREFIX . "user u ON u.user_id = aa.doctor_id WHERE  aa.day = '" . $this->db->escape($date) . "' AND aa.doctor_id = '" . (int)$doctor . "' AND u.enable_appointment = '1' ORDER BY aat.availability_time_id ASC";

                $query_availiability = $this->db->query($sql_availability);

                if ($query_availiability->num_rows > 0) {
                    $doctor_availability[] = $query_availiability->rows;
                }
            }
        }

        return $doctor_availability;
    }

    public function getDoctorAvailabilityTime($doctor_id, $day)
    {
        $sql = "
		SELECT
			aa.doctor_id,
			aa.day,
			aa.minutes,
			aat.start_time,
			aat.end_time
		FROM " . DB_PREFIX . "appointment_availability aa
		LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat
		ON aat.availability_id = aa.availability_id
		WHERE 1
		AND aa.doctor_id = '" . (int) $doctor_id . "'
		AND aa.day = '" . $this->db->escape($day) . "'
		ORDER BY aat.availability_time_id ASC";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctorTimes($store_id, $date, $doctor_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability WHERE store_id = '" . (int)$store_id . "' AND day = '" . $this->db->escape($date) . "' AND doctor_id = '" . (int)$doctor_id . "'");

        return $query->row;
    }

    public function getCustomerGroups($data = array())
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer_group cg LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON (cg.customer_group_id = cgd.customer_group_id) WHERE cgd.language_id = '" . (int)$this->config->get('config_language_id') . "'";

        $sort_data = array(
            'cgd.name',
            'cg.sort_order'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY cgd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomFields($data = array())
    {
        if (empty($data['filter_customer_group_id'])) {
            $sql = "SELECT * FROM `" . DB_PREFIX . "custom_field` cf LEFT JOIN " . DB_PREFIX . "custom_field_description cfd ON (cf.custom_field_id = cfd.custom_field_id) WHERE cfd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
        } else {
            $sql = "SELECT * FROM " . DB_PREFIX . "custom_field_customer_group cfcg LEFT JOIN `" . DB_PREFIX . "custom_field` cf ON (cfcg.custom_field_id = cf.custom_field_id) LEFT JOIN " . DB_PREFIX . "custom_field_description cfd ON (cf.custom_field_id = cfd.custom_field_id) WHERE cfd.language_id = '" . (int)$this->config->get('config_language_id') . "'";
        }

        if (!empty($data['filter_name'])) {
            $sql .= " AND cfd.name LIKE '" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_customer_group_id'])) {
            $sql .= " AND cfcg.customer_group_id = '" . (int)$data['filter_customer_group_id'] . "'";
        }

        $sort_data = array(
            'cfd.name',
            'cf.type',
            'cf.location',
            'cf.status',
            'cf.sort_order'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY cfd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomFieldValues($custom_field_id)
    {
        $custom_field_value_data = array();

        $custom_field_value_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "custom_field_value cfv LEFT JOIN " . DB_PREFIX . "custom_field_value_description cfvd ON (cfv.custom_field_value_id = cfvd.custom_field_value_id) WHERE cfv.custom_field_id = '" . (int)$custom_field_id . "' AND cfvd.language_id = '" . (int)$this->config->get('config_language_id') . "' ORDER BY cfv.sort_order ASC");

        foreach ($custom_field_value_query->rows as $custom_field_value) {
            $custom_field_value_data[$custom_field_value['custom_field_value_id']] = array(
                'custom_field_value_id' => $custom_field_value['custom_field_value_id'],
                'name'                  => $custom_field_value['name']
            );
        }

        return $custom_field_value_data;
    }

    public function selectCustomers($data = array())
    {
        $sql = "SELECT * from " . DB_PREFIX . "customer c WHERE c.status = '1' AND c.approved = '1'";

        //print_r($sql);

        if (isset($data['customer_ic']) && !is_null($data['customer_ic'])) {
            $sql .= " AND c.customer_ic = '" . $this->db->escape($data['customer_ic']) . "'";
        }

        if (isset($data['telephone_no']) && !is_null($data['telephone_no'])) {
            $sql .= " AND c.telephone = '" . $this->db->escape($data['telephone_no']) . "'";
        }

        if (isset($data['customer_card']) && !is_null($data['customer_card'])) {
            $sql .= " AND c.customer_card = '" . $this->db->escape($data['customer_card']) . "'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function customerExistsByIc($ic)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_ic = '" . $ic . "'";
        $query = $this->db->query($sql);
        return  $query->row;
    }

    public function customerExistsByIcAndTelephone($ic, $phone_num)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_ic = '" . $ic . "' AND telephone = '" . $phone_num . "'";
        $query = $this->db->query($sql);
        return  $query->row;
    }

    // public function customerExistsByPhoneAndEmail($phone, $email)
    // {
    //     $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $phone . "' AND email = '" . $email . "'";
    //     $query = $this->db->query($sql);
    //     return  $query->row;
    // }

    public function customerExistsByPhoneAndEmail($phone, $email)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment WHERE telephone = '" . $phone . "' AND email = '" . $email . "'";
        $query = $this->db->query($sql);
        return  $query->row;
    }

    public function customerExistsByPhoneNum($phone_num)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $phone_num . "'";
        $query = $this->db->query($sql);
        return  $query->row;
    }

    public function addCustomer($data)
    {
        do {
            $insert = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);

            if (empty($customer_row)) {
                $insert = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '1',
                        customer_id = '" . (int)$data['customer_id'] . "',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape(isset($data['customer_card']) ? $data['customer_card'] : $data['customer_ic']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['phone_no']) . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						status = '1',
						approved = '1',
						date_added = NOW()
				");
            }
        } while ($insert == false);

        return $unique_id;
    }

    public function addCustomerAppointment($data)
    {
        do {
            $insert = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);

            if (empty($customer_row)) {
                $insert = true;
                $this->db->query("
					INSERT INTO " . DB_PREFIX . "customer SET
						unique_customer_id = '" . $this->db->escape($unique_id) . "',
						customer_group_id = '1',
						firstname = '" . $this->db->escape($data['firstname']) . "',
						customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
						customer_card = '" . $this->db->escape(isset($data['customer_card']) ? $data['customer_card'] : $data['customer_ic']) . "',
						email = '" . $this->db->escape($data['email']) . "',
						telephone = '" . $this->db->escape($data['phone_no']) . "',
						salt = '" . $this->db->escape($salt = substr(md5(uniqid(rand(), true)), 0, 9)) . "',
						status = '1',
						approved = '1',
						date_added = NOW()
				");
            }
        } while ($insert == false);

        $customer_id = $this->db->getLastId();
        return $customer_id;
    }

    public function getCustomerByEmail($email)
    {
        $query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "customer WHERE LCASE(email) = '" . $this->db->escape(utf8_strtolower($email)) . "'");

        return $query->row;
    }

    public function getStore($appointment_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment a
			INNER JOIN " . DB_PREFIX . "store b ON a.store_id = b.store_id
			WHERE a.appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    public function getCustomerData($email ,$telephone)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment
        WHERE email = '" . $email . "' AND telephone ='" .$telephone ."'");

        return $query->row;
    }
    public function getCustomerInfo($email)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment
        WHERE email = '" . $email . "'");

        return $query->row;
    }

    public function getDoctorDevice($doctor_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device WHERE user_id = '" . (int)$doctor_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function checkBooked($doctor_id, $date, $time)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment
				WHERE doctor_id = '" . (int)$doctor_id . "'
				AND appointment_date = '" . $this->db->escape($date) . "'
				AND appointment_time = '" . $this->db->escape($time) . "'
				AND status != '2'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getCustomers()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer");

        return $query->rows;
    }

    public function getCustomer($appointment_id)
    {
        $query = $this->db->query("SELECT a.*, ad.country_id
									FROM " . DB_PREFIX . "customer a
									INNER JOIN " . DB_PREFIX . "appointment b
									ON a.customer_id = b.customer_id
									LEFT JOIN " . DB_PREFIX . "address ad
									ON ad.customer_id = a.customer_id
									WHERE b.appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }

    public function getGeneralAppointment($appointment_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . $appointment_id . "'");

        return $query->row;
    }


    public function check_unique_id($unique_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'");

        return $query->row;
    }

    public function checkNumOfApp($appointment_date, $appointment_time, $doctor_id)
    {
        $availability = [];
        $appointment_times = [];
        $num_of_appointment_made = 0;
        $book_status = true;

        $appointment_day = date('l', strtotime($appointment_date));

        $appointment_availability_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment_availability aa LEFT JOIN " . DB_PREFIX . "appointment_availability_time aat ON aat.availability_id = aa.availability_id WHERE aa.day = '" . $this->db->escape($appointment_day) . "' AND aa.doctor_id = '" . (int)$doctor_id . "' ORDER BY aat.availability_time_id ASC");

        $appointment_availability_rows = $appointment_availability_query->rows;

        if (!empty($appointment_availability_rows)) {
            foreach ($appointment_availability_rows as $row) {
                $availability[] = [
                    'availability_time_id'    => $row['availability_time_id'],
                    'start_time'            => $row['start_time'],
                    'end_time'                => $row['end_time'],
                    'num_app'                => $row['num_app'],
                    'enable_num_app'        => $row['enable_num_app']
                ];
            }
        }

        $appointments_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_date = '" . $this->db->escape($appointment_date) . "' AND doctor_id = '" . (int)$doctor_id . "' AND status != '2'");

        $appointments_rows = $appointments_query->rows;

        if (!empty($appointments_rows)) {
            foreach ($appointments_rows as $row) {
                $appointment_time_made = $row['appointment_time'];

                $appointment_times[] = $appointment_time_made;
            }
        }

        foreach ($availability as $available) {
            $start_timestamp = strtotime($available['start_time']);
            $end_timestamp = strtotime($available['end_time']);

            $appointment_time_timestamp = strtotime($appointment_time);

            $enable_num_app = $available['enable_num_app'];

            if ($enable_num_app) {
                if (($start_timestamp <= $appointment_time_timestamp) && ($end_timestamp >= $appointment_time_timestamp)) {
                    $num_of_app = $available['num_app'];

                    foreach ($appointment_times as $time) {
                        $time_booked_timestamp = strtotime($time);

                        if (($start_timestamp <= $time_booked_timestamp) && ($end_timestamp >= $time_booked_timestamp)) {
                            $num_of_appointment_made += 1;
                        }
                    }

                    $book_status = ($num_of_app > $num_of_appointment_made) ? true : false;
                }
            }
        }

        return $book_status;
    }

    public function checkServiceSession($appointment_date, $appointment_time)
    {
        $appointment_day = date('l', strtotime($appointment_date));
        $book_status = true;

        $appointments_booked = $this->db->query("SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_date = '" . $this->db->escape($appointment_date) . "' AND appointment_time = '" . $this->db->escape($appointment_time) . "' AND doctor_id = '0' AND clinicalservice_id > 0 AND clinicalservice_id != '26' AND status != '2'");

        $appointments_booked_rows = $appointments_booked->rows;

        $store_opening_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening WHERE day = '" . $this->db->escape($appointment_day) . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");

        $store_opening = $store_opening_query->row;

        $service_session = (!empty($store_opening)) ? $store_opening['session'] : 0;

        if (!empty($appointments_booked_rows)) {
            $num_of_appointment_booked = count($appointments_booked_rows);

            if ($store_opening['enable_session'] > 0) {
                $book_status = ($service_session > $num_of_appointment_booked) ? true : false;
            }
        }

        return $book_status;
    }
}
