<?php
class ModelAndroidUser extends Model
{
    public function getUserStores($user_id)
    {
        $sql = "SELECT store_id FROM " . DB_PREFIX . "user_to_store WHERE user_id = '" . (int)$user_id . "'";
        $query = $this->db->query($sql);
        $result = array();
        if ($query->num_rows) {
            foreach ($query->rows as $row) {
                $result[] = $row['store_id'];
            }
        }
        return $result;
    }

    public function getUserInfo($user_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "' ";
        $query = $this->db->query($sql);
        $result = $query->row;
        if (!empty($result)) {
            $user_desc = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_description WHERE user_id = '" . (int)$result['user_id'] . "'")->row;
            $result['user_desc'] = $user_desc;
        }
        return $result;
    }

    public function update_image($img_url, $user_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "user SET image = '" . $this->db->escape($img_url) . "' WHERE user_id = '" . (int)$user_id . "'";

        $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function update_user($data)
    {
        $user_id = $data['user_id'];

        $professions = !empty($data['professions']) ? $data['professions'] : [];

        $professions = serialize($professions);
        $description = !empty($data['introduction']) ? $data['introduction'] : '';
        $user_desc = array(
            "professions" => $professions,
            "description" => $description,
        );

        $this->updateUserDesc($user_id, $user_desc);
        $sql = "UPDATE " . DB_PREFIX . "user SET ";
        if (isset($data['name'])) {
            $sql .= "firstname = '" . $this->db->escape($data['name']) . "' ,";
        }
        if (!isset($data['lastname'])) {
            $sql .= "lastname = '' ,";
        }
        if (isset($data['email'])) {
            $sql .= "email = '" . $this->db->escape($data['email']) . "' ,";
        }
        if (isset($data['dob'])) {
            $sql .= "dob = '" . $this->db->escape($data['dob']) . "' ,";
        }
        if (isset($data['ic'])) {
            $sql .= "ic = '" . $this->db->escape($data['ic']) . "' ,";
        }
        if (isset($data['gender'])) {
            $sql .= "gender = '" . (int)$data['gender'] . "' ,";
        }
        if (isset($data['show_for_appointment'])) {
            $sql .= "show_for_appointment = '" . (int)$data['show_for_appointment'] . "' ,";
        }
        if (isset($data['enable_appointment'])) {
            $sql .= "enable_appointment = '" . (int)$data['enable_appointment'] . "' ,";
        }
        $sql .= "date_modify = NOW(),";
        $sql .= "modify_by = '" . (int)$user_id . "' ";
        $sql .= "WHERE user_id = '" . (int)$user_id . "'";
        $this->db->query($sql);
        return $this->db->countAffected();
    }

    public function updateUserDesc($user_id, $desc)
    {
        $user_info = $this->getUserInfo($user_id);
        if (empty($user_info['user_desc'])) {
            //add
            $sql = "INSERT INTO " . DB_PREFIX . "user_description SET 
            user_id = '" . (int)$user_id . "',
            position = '',
            professions = '" . $this->db->escape($desc['professions']) . "',
            other_professions = '',
            description = '" . $this->db->escape($desc['description']) . "'";
        } else {
            //update
            $sql = "UPDATE " . DB_PREFIX . "user_description SET 
            professions = '" . $this->db->escape($desc['professions']) . "',
            description = '" . $this->db->escape($desc['description']) . "'
            WHERE
            user_id = '" . (int)$user_id . "'
            ";
        }
        $this->db->query($sql);
    }

    public function updateUserDeviceInfo($data)
    {
        $user_id = isset($data['user_id']) ? $data['user_id'] : false;
        $device_id = isset($data['device_id']) ? $data['device_id'] : false;
        $access_token = isset($data['access_token']) ? $data['access_token'] : false;
        $fcm_token = !empty($data['fcm_token']) ? $data['fcm_token'] : '';
        $huawei_token = !empty($data['huawei_token']) ? $data['huawei_token'] : '';


        if ($user_id && $device_id) {
            //delete all records match with device_id(as 1 device only can login 1 user) and gcm_token = '' (as not been used by other apps)
            $this->db->query("UPDATE " . DB_PREFIX . "user_device SET fcm_token='', huawei_token='' WHERE device_id='" . $this->db->escape($device_id) . "'");
            $this->db->query("DELETE FROM " . DB_PREFIX . "user_device WHERE device_id='" . $this->db->escape($device_id) . "' AND gcm_token=''");

            //check existing data
            $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_device WHERE user_id='" . (int)$user_id . "' AND device_id='" . $this->db->escape($device_id) . "'");
            if ($query->num_rows) {
                $sql_update = "UPDATE " . DB_PREFIX . "user_device 
                SET 
                access_token='" . $this->db->escape($access_token) . "' ";

                $sql_update .= !empty($fcm_token) ? " , fcm_token='" . $this->db->escape($fcm_token) . "'" : '';
                $sql_update .= !empty($huawei_token) ? " , huawei_token='" . $this->db->escape($huawei_token) . "'" : '';

                $sql_update .= " WHERE user_id='" . (int)$user_id . "' AND device_id='" . $this->db->escape($device_id) . "'";

                $this->db->query($sql_update);
            } else {
                $sql_insert = "INSERT INTO " . DB_PREFIX . "user_device
                SET
                user_id='" . (int)$user_id . "',
                device_id='" . $this->db->escape($device_id) . "',
                access_token='" . $this->db->escape($access_token) . "',
                fcm_token='" . $this->db->escape($fcm_token) . "',
                huawei_token='" . $this->db->escape($huawei_token) . "',
                date_added=NOW()
                 ";
                $this->db->query($sql_insert);
            }
        }
    }

    public function getDeviceInfo($device_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_device WHERE device_id = '" . $this->db->escape($device_id) . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function deleteUserDeviceInfo($device_id)
    {
        //delete all records match with device_id(as 1 device only can login 1 user) and gcm_token = '' (as not been used by other apps)
        $this->db->query("UPDATE " . DB_PREFIX . "user_device SET fcm_token='', huawei_token='' WHERE device_id='" . $this->db->escape($device_id) . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_device WHERE device_id='" . $this->db->escape($device_id) . "' AND gcm_token=''");
    }

    public function updateFirebaseToken($device_id, $fcm_token)
    {
        //insert if device id not exist
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_device WHERE device_id='" . $this->db->escape($device_id) . "'");
        if ($query->num_rows) {
            $sql_update = "UPDATE " . DB_PREFIX . "user_device 
            SET 
            fcm_token='" . $this->db->escape($fcm_token) . "'
            WHERE device_id='" . $this->db->escape($device_id) . "'";
            $this->db->query($sql_update);
        } else {
            $sql_insert = "INSERT INTO " . DB_PREFIX . "user_device
                SET
                user_id='" . (int)$this->session->data['user_id'] . "',
                device_id='" . $this->db->escape($device_id) . "',
                fcm_token='" . $this->db->escape($fcm_token) . "',
                date_added=NOW()
                 ";
            $this->db->query($sql_insert);
        }
    }

    public function updateHuaweiToken($device_id, $huawei_token)
    {
        //insert if device id not exist
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "user_device WHERE device_id='" . $this->db->escape($device_id) . "'");
        if ($query->num_rows) {
            $sql_update = "UPDATE " . DB_PREFIX . "user_device 
            SET 
            huawei_token='" . $this->db->escape($huawei_token) . "'
            WHERE device_id='" . $this->db->escape($device_id) . "'";
            $this->db->query($sql_update);
        } else {
            $sql_insert = "INSERT INTO " . DB_PREFIX . "user_device
                SET
                user_id='" . (int)$this->session->data['user_id'] . "',
                device_id='" . $this->db->escape($device_id) . "',
                huawei_token='" . $this->db->escape($huawei_token) . "',
                date_added=NOW()
                 ";
            $this->db->query($sql_insert);
        }
    }
}
