<?php
class ModelAndroidStockStockIssue extends Model
{
    public function getStockIssues($data)
    {

        $sort   = isset($data['sort']) ? $data['sort'] : "date_added";
        $order  = isset($data['order']) ? $data['order'] : "DESC";

        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;

        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

        $filter_customer = isset($data['filter_customer']) ? $data['filter_customer'] : false;

        $filter_product_name = isset($data['filter_product_name']) ? $data['filter_product_name'] : false;

        $filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;


        $filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
        $filter_batch_date_from_str = trim($filter_batch_date_from);
        $filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
        $filter_batch_date_to_str = trim($filter_batch_date_to);
        $filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) : false;

        $filter_store_id = isset($data['filter_store_id']) ? $data['filter_store_id'] : false;
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        //prepare where clause statement
        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND a.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";

        $filter_add_by_statement = $filter_add_by ? "AND a.add_by_id in (" . $filter_add_by . ")" : "";

        $filter_customer_statement = $filter_customer ? "AND a.customer_id in (" . $filter_customer . ")" : "";

        //bi-language and pinyin
        $filter_product_name_statement = $filter_product_name ? "AND (a.en_cn_product_name LIKE '%" . $filter_product_name . "%' OR a.pinyin LIKE '%" . $filter_product_name . "%' OR a.product_code LIKE '%" . $filter_product_name . "%' )" : "";

        $filter_product_code_statement = $filter_product_code ? "AND a.product_code LIKE '%" . $filter_product_code . "%'" : "";

        $filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

        $filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";


        $filter_store_id_statement = $filter_store_id !== false ? "AND a.store_id in (" . $filter_store_id . ")" : "";

        $filter_location_id_statement = $filter_location_id !== false ? "AND a.location_id in (" . $filter_location_id . ")" : "";

        $filter_status_statement = $filter_status ? "AND a.status = '$filter_status'" : "";

        $sql = "
            SELECT *
            FROM(
                SELECT
                
                    si.stock_issue_id,
                    sii.date_added,
                    si.invoice_prefix,
                    pd.name as product_name,
                    p.code as product_code,
                    p.pinyin as pinyin,
                    si.description,
                    si.store_id,
                    (SELECT st.name FROM " . DB_PREFIX . "store st WHERE st.store_id = si.store_id ) AS store_name,
                    si.customer_id,
                    os.name as status_name,
                    sii.location,
                    sii.location_id,
                    si.status,
                    sii.quantity,
                    (SELECT wcd.unit FROM " . DB_PREFIX . "weight_class_description wcd WHERE wcd.weight_class_id = sii.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "') AS weight_uom,
                    sii.remark,
                    sii.stock_onhand,
                    sii.stock_balance,
                    sii.batch_date,
                    sii.date_modified,
                    sii.add_by as add_by_id,
                    CONCAT(pd_en.name, ' ', pd_cn.name) AS en_cn_product_name,
                    CONCAT(c.firstname , ' ', c.lastname) AS 'customer_name',
                    CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',
                    CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'

                FROM

				" . DB_PREFIX . "stock_issue_item sii
       
                LEFT JOIN " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id)

				LEFT JOIN " . DB_PREFIX . "order_status os
				ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->session->data['language_id'] . "')

                LEFT JOIN " . DB_PREFIX . "product p
				ON(sii.product_id = p.product_id )

				LEFT JOIN " . DB_PREFIX . "product_description pd
				ON(sii.product_id = pd.product_id AND pd.language_id='" . (int) $this->session->data['language_id'] . "')

				LEFT JOIN " . DB_PREFIX . "product_description pd_en
				ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                LEFT JOIN " . DB_PREFIX . "product_description pd_cn
				ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2')

				LEFT JOIN " . DB_PREFIX . "user u1
				ON(sii.add_by = u1.user_id)

                LEFT JOIN " . DB_PREFIX . "user u2
				ON(sii.modify_by = u2.user_id)

                LEFT JOIN " . DB_PREFIX . "customer c
				ON(si.customer_id = c.customer_id)
            
			WHERE 1
			
		)a

		WHERE 1

		$filter_invoice_prefix_statement

		$filter_add_by_statement

        $filter_product_name_statement
        
        $filter_product_code_statement
		
        $filter_date_from_statement

		$filter_date_to_statement

        $filter_batch_date_from_statement
        
        $filter_batch_date_to_statement
        
		$filter_store_id_statement
        
        $filter_location_id_statement

        $filter_status_statement

        $filter_customer_statement

		ORDER BY a.$sort $order

		LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getTotalStockIssues($data)
    {
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;

        $filter_add_by = isset($data['filter_add_by']) ? $data['filter_add_by'] : false;

        $filter_customer = isset($data['filter_customer']) ? $data['filter_customer'] : false;

        $filter_product_name = isset($data['filter_product_name']) ? $data['filter_product_name'] : false;

        $filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;


        $filter_batch_date_from = isset($data['filter_batch_date_from']) ? $data['filter_batch_date_from'] : false;
        $filter_batch_date_from_str = trim($filter_batch_date_from);
        $filter_batch_date_from = (!empty($filter_batch_date_from_str)) ? date("Y-m-d", strtotime($filter_batch_date_from)) : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_batch_date_to = isset($data['filter_batch_date_to']) ? $data['filter_batch_date_to'] : false;
        $filter_batch_date_to_str = trim($filter_batch_date_to);
        $filter_batch_date_to = (!empty($filter_batch_date_to_str)) ? date("Y-m-d", strtotime($filter_batch_date_to)) : false;

        $filter_store_id = isset($data['filter_store_id']) ? $data['filter_store_id'] : false;
        $filter_location_id = isset($data['filter_location_id']) ? $data['filter_location_id'] : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        //prepare where clause statement
        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND a.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";

        $filter_add_by_statement = $filter_add_by ? "AND a.add_by_id in (" . $filter_add_by . ")" : "";

        $filter_customer_statement = $filter_customer ? "AND a.customer_id in (" . $filter_customer . ")" : "";

        //todo bi-language

        $filter_product_name_statement = $filter_product_name ? "AND (a.en_cn_product_name LIKE '%" . $filter_product_name . "%' OR a.pinyin LIKE '%" . $filter_product_name . "%' OR a.product_code LIKE '%" . $filter_product_name . "%' )" : "";

        $filter_product_code_statement = $filter_product_code ? "AND a.product_code LIKE '%" . $filter_product_code . "%'" : "";

        $filter_date_from_statement = $filter_date_from ? "AND DATE(a.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(a.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_batch_date_from_statement = $filter_batch_date_from ? "AND DATE(a.batch_date) >= DATE('" . $filter_batch_date_from . "')" : "";

        $filter_batch_date_to_statement = $filter_batch_date_to ? "AND DATE(a.batch_date) <= DATE('" . $filter_batch_date_to . "')" : "";


        $filter_store_id_statement = $filter_store_id !== false ? "AND a.store_id in (" . $filter_store_id . ")" : "";

        $filter_location_id_statement = $filter_location_id !== false ? "AND a.location_id in (" . $filter_location_id . ")" : "";

        $filter_status_statement = $filter_status ? "AND a.status = '$filter_status'" : "";

        $sql = "
         SELECT COUNT(*) AS total
            FROM(
                SELECT
                si.stock_issue_id,
                sii.date_added,
                si.invoice_prefix,
                pd.name as product_name,
                p.code as product_code,
                p.pinyin as pinyin,
                si.description,
                si.store_id,
                si.customer_id,
                os.name as status_name,
                sii.location,
				sii.location_id,
                si.status,
                sii.quantity,
                sii.remark,
                sii.stock_onhand,
				sii.stock_balance,
                sii.batch_date,
                sii.date_modified,
                sii.add_by as add_by_id,

                CONCAT(pd_en.name, ' ', pd_cn.name) AS en_cn_product_name,

                CONCAT(c.firstname , ' ', c.lastname) AS 'customer_name',
                CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by',
                CONCAT(u2.firstname , ' ', u2.lastname) AS 'modified_by'


                    FROM

                    " . DB_PREFIX . "stock_issue_item sii
            
                    LEFT JOIN " . DB_PREFIX . "stock_issue si ON (si.stock_issue_id = sii.stock_issue_id)


                    LEFT JOIN " . DB_PREFIX . "order_status os
                    ON(si.status = os.order_status_id AND os.language_id='" . (int) $this->config->get('config_language_id') . "')

                    LEFT JOIN " . DB_PREFIX . "product p
                    ON(sii.product_id = p.product_id )

                    LEFT JOIN " . DB_PREFIX . "product_description pd
                    ON(sii.product_id = pd.product_id AND pd.language_id='" . (int) $this->config->get('config_language_id') . "')

                    LEFT JOIN " . DB_PREFIX . "product_description pd_en
                    ON(sii.product_id = pd_en.product_id AND pd_en.language_id='1')
				
                    LEFT JOIN " . DB_PREFIX . "product_description pd_cn
                    ON(sii.product_id = pd_cn.product_id AND pd_cn.language_id='2')

                    LEFT JOIN " . DB_PREFIX . "user u1
                    ON(sii.add_by = u1.user_id)

                    LEFT JOIN " . DB_PREFIX . "user u2
                    ON(sii.modify_by = u2.user_id)

                    LEFT JOIN " . DB_PREFIX . "customer c
                    ON(si.customer_id = c.customer_id)
                
                WHERE 1
                
            )a

        WHERE 1

            $filter_invoice_prefix_statement

            $filter_add_by_statement

            $filter_product_name_statement
            
            $filter_product_code_statement
            
            $filter_date_from_statement

            $filter_date_to_statement

            $filter_batch_date_from_statement
            
            $filter_batch_date_to_statement
            
            $filter_store_id_statement
            
            $filter_location_id_statement
            
            $filter_status_statement

            $filter_customer_statement
            ";


        $query = $this->db->query($sql);


        return $query->row['total'];
    }

    public function getStockIssue($stock_issue_id)
    {
        $stock_issue_info = array();

        $language_id = $this->session->data['language_id'];



        $sql = "

		SELECT

				si.*,

				CONCAT(u.firstname , ' ', u.lastname) AS 'staff',

                CONCAT(c.firstname , ' ', c.lastname) AS 'customer_name'
                
			FROM

				" . DB_PREFIX . "stock_issue si LEFT JOIN " . DB_PREFIX . "user u
                ON(si.add_by = u.user_id)

                LEFT JOIN " . DB_PREFIX . "customer c
				ON(si.customer_id = c.customer_id)
            WHERE 

			 si.stock_issue_id = $stock_issue_id

		";



        $query = $this->db->query($sql);



        $stock_issue_info = $query->row;



        $sql = "

		SELECT

			p.product_id,

			pd.name AS product_name,

			p.code AS product_code,

            wcd.unit,

            CASE WHEN sii.location_id = 0 THEN 'Default Location' ELSE CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) END AS location_text,

			sii.*

		FROM

			" . DB_PREFIX . "stock_issue_item sii 
            LEFT JOIN " . DB_PREFIX . "product p
            ON (sii.product_id = p.product_id)

			LEFT JOIN " . DB_PREFIX . "product_description pd
            ON (p.product_id = pd.product_id AND pd.language_id = '$language_id')

            LEFT JOIN " . DB_PREFIX . "wms_location wms
            ON (sii.location_id = wms.location_id)

            LEFT JOIN " . DB_PREFIX . "weight_class_description wcd 
            ON(sii.weight_class_id = wcd.weight_class_id and wcd.language_id ='" . (int)$language_id . "')

		WHERE 
            sii.stock_issue_id = '$stock_issue_id'

		";



        $query = $this->db->query($sql);



        $stock_issue_items = $query->rows;



        foreach ($stock_issue_items as $product) {

            $stock_issue_info['stock_issue_item'][$product['stock_issue_item_id']] = $product;
        }



        return $stock_issue_info;
    }

    public function addStockIssue($data)
    {
        $result = array();
        if (!empty($data)) {

            $save_all_doc = true;

            //first loop for checking
            foreach ($data as $key => $doc) {
                $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                $description = isset($doc['description']) ? $doc['description'] : null;
                $status = isset($doc['status']) ? $doc['status'] : 1; //1=draft, 5=completed

                $result[$key]['error'] = false;
                $result[$key]['error_text'] = "";

                $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();

                if (empty($item)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = "Missing Item";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                $products = array();
                $error_input = array();
                foreach ($item as $key2 => $product) {
                    $product_id = isset($product['product_id']) ? $product['product_id'] : null;
                    $quantity = isset($product['quantity']) ? $product['quantity'] : null;
                    $batch_date = isset($product['batch_date']) ? $product['batch_date'] : null;
                    $location_id = isset($product['location_id']) ? $product['location_id'] : null;
                    $products[$key2] = array();
                    $remark = isset($product['remark']) ? $product['remark'] : null;

                    // initialize
                    $result[$key]['issue_item'][$key2]['product_id']      = true;
                    $result[$key]['issue_item'][$key2]['location_id']     = true;
                    $result[$key]['issue_item'][$key2]['batch_date']      = true;
                    $result[$key]['issue_item'][$key2]['quantity']        = true;
                    $result[$key]['issue_item'][$key2]['remark']          = true;

                    $proceed = true;

                    //check param if status=5 (completed)

                    if ($status == 5) {
                        if (!$this->validateProduct($product_id)) {
                            $result[$key]['issue_item'][$key2]['product_id'] = false;
                            $proceed = false;
                            if (!in_array("product", $error_input)) {
                                $error_input[] = "product";
                            }
                        }
                        if (!$this->validateLocation($product_id, $location_id)) {
                            $result[$key]['issue_item'][$key2]['location_id'] = false;
                            $proceed = false;
                            if (!in_array("location", $error_input)) {
                                $error_input[] = "location";
                            }
                        }
                        if (!$this->validateBdate($product_id, $location_id, $batch_date)) {
                            $result[$key]['issue_item'][$key2]['batch_date'] = false;
                            $proceed = false;
                            if (!in_array("batch date", $error_input)) {
                                $error_input[] = "batch date";
                            }
                        }
                        if (!$this->validateQty($product_id, $location_id, $batch_date, $quantity)) {
                            $result[$key]['issue_item'][$key2]['quantity'] = false;
                            $proceed = false;
                            if (!in_array("quantity", $error_input)) {
                                $error_input[] = "quantity";
                            }
                        }
                    }

                    if (!$proceed) {
                        $result[$key]['error'] = true;
                        $save_all_doc = false;
                    }
                }
                $error_text = implode(", ", $error_input);
                $result[$key]['error_text'] = $error_text ? $error_text . " is not valid" : "";

                //check customer_id
                if (!$this->validateCustomer($customer_id)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = $error_text ? $error_text . " ,customer_id is not valid" : "customer_id is not valid";
                }
            }

            if ($save_all_doc) {
                //second loop for saving
                foreach ($data as $key => $doc) {
                    $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                    $description = isset($doc['description']) ? $doc['description'] : null;
                    $status = isset($doc['status']) ? $doc['status'] : 1;

                    $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();

                    //save to db if doc no error
                    if (!$result[$key]['error']) {
                        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));
                        $store_id = $this->session->data['store_id'];
                        $user_id = $this->session->data['user_id'];

                        //insert stock_issue table
                        $sql = "INSERT INTO " . DB_PREFIX . "stock_issue
                        SET invoice_prefix = '" . $invoice_prefix . "',
                            store_id = " . $store_id . ",
                            customer_id = " . (int)$customer_id . ",
                            status = '$status',
                            description = '" . $this->db->escape($description)  . "',
                            add_by = " . $user_id . ",
                            modify_by = " . $user_id . ",
                            date_added = NOW(),
                            date_modified = NOW()";

                        $query = $this->db->query($sql);

                        $stock_issue_id =  $this->db->getLastId();
                        if ($stock_issue_id > 0) {
                            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

                            foreach ($item as $key2 => $product) {
                                $product_id = $product['product_id'];
                                $quantity = $product['quantity'];
                                $batch_date = $product['batch_date'];
                                $location_id = $product['location_id'];
                                $weight_class_id = $this->getWeightClassId($product_id);
                                $remark = isset($product['remark']) ? $product['remark'] : null;

                                $location = $this->getLocationText($location_id);
                                $stock_onhand = $this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
                                $stock_balance = $stock_onhand - $quantity;

                                if (!empty($batch_date)) {
                                    $batch_date = "'" . $batch_date . "'";
                                } else {
                                    $batch_date = "'0000-00-00'";
                                }

                                //insert into stock_issue_item table
                                $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                                SET stock_issue_id = " . $stock_issue_id . ",
                                    customer_id = " . (int)$customer_id . ",
                                    product_id = " . (int)$product_id . ",
                                    quantity = " . (float)$quantity . ",
                                    weight_class_id = " . (int)$weight_class_id . ",
                                    batch_date = " . $batch_date  . ",
                                    location_id = '" . (int)$location_id . "',
                                    location = '" . $this->db->escape($location) . "',
                                    remark = '" . $this->db->escape($remark) . "',
                                    stock_onhand = '" . (float)$stock_onhand . "',
                                    stock_balance = '" . (float)$stock_balance . "',
                                    add_by = " . $user_id . ",
                                    modify_by = " . $user_id . ",
                                    date_added = NOW(),
                                    date_modified = NOW()";

                                $this->db->query($item_sql);


                                //deduct item quantity if status =5 (completed)
                                if ($status == 5) {
                                    $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                    SET onhand_quantity = onhand_quantity - $quantity
                                    WHERE product_id = $product_id
                                    AND store_id = $store_id
                                    AND location_id = $location_id";

                                    $this->db->query($deduct_stock_sql);
                                }
                            }
                        }
                    }
                }
            }
        }
        return array("status" => $save_all_doc, "result" => $result);
    }
    /*
    public function addStockIssue_backup($data)
    {
        $result = array();
        if (!empty($data)) {

            foreach ($data as $key => $doc) {
                $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                $description = isset($doc['description']) ? $doc['description'] : null;
                $status = isset($doc['status']) ? $doc['status'] : 1; //1=draft, 5=completed

                $result[$key]['error'] = false;
                $result[$key]['error_text'] = "";

                $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();

                if (empty($item)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = "Missing Item";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                $products = array();
                $error_input = array();
                foreach ($item as $key2 => $product) {
                    $product_id = isset($product['product_id']) ? $product['product_id'] : null;
                    $quantity = isset($product['quantity']) ? $product['quantity'] : null;
                    $batch_date = isset($product['batch_date']) ? $product['batch_date'] : null;
                    $location_id = isset($product['location_id']) ? $product['location_id'] : null;
                    $products[$key2] = array();
                    $remark = isset($product['remark']) ? $product['remark'] : null;

                    // initialize
                    $result[$key]['issue_item'][$key2]['product_id']      = true;
                    $result[$key]['issue_item'][$key2]['location_id']     = true;
                    $result[$key]['issue_item'][$key2]['batch_date']      = true;
                    $result[$key]['issue_item'][$key2]['quantity']        = true;
                    $result[$key]['issue_item'][$key2]['remark']          = true;

                    $proceed = true;

                    //check param if status=5 (completed)

                    if ($status == 5) {
                        if (!$this->validateProduct($product_id)) {
                            $result[$key]['issue_item'][$key2]['product_id'] = false;
                            $proceed = false;
                            if (!in_array("product", $error_input)) {
                                $error_input[] = "product";
                            }
                        }
                        if (!$this->validateLocation($product_id, $location_id)) {
                            $result[$key]['issue_item'][$key2]['location_id'] = false;
                            $proceed = false;
                            if (!in_array("location", $error_input)) {
                                $error_input[] = "location";
                            }
                        }
                        if (!$this->validateBdate($product_id, $location_id, $batch_date)) {
                            $result[$key]['issue_item'][$key2]['batch_date'] = false;
                            $proceed = false;
                            if (!in_array("batch date", $error_input)) {
                                $error_input[] = "batch date";
                            }
                        }
                        if (!$this->validateQty($product_id, $location_id, $batch_date, $quantity)) {
                            $result[$key]['issue_item'][$key2]['quantity'] = false;
                            $proceed = false;
                            if (!in_array("quantity", $error_input)) {
                                $error_input[] = "quantity";
                            }
                        }
                    }

                    if (!$proceed) {
                        $result[$key]['error'] = true;
                    }
                }
                $error_text = implode(", ", $error_input);
                $result[$key]['error_text'] = $error_text ? $error_text . " is not valid" : "";

                //check customer_id
                if (!$this->validateCustomer($customer_id)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = $error_text ? $error_text . " ,customer_id is not valid" : "customer_id is not valid";
                }



                //save to db if doc no error
                if (!$result[$key]['error']) {
                    $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));
                    $store_id = $this->session->data['store_id'];
                    $user_id = $this->session->data['user_id'];

                    //insert stock_issue table
                    $sql = "INSERT INTO " . DB_PREFIX . "stock_issue
                    SET invoice_prefix = '" . $invoice_prefix . "',
                        store_id = " . $store_id . ",
                        customer_id = " . (int)$customer_id . ",
                        status = '$status',
                        description = '" . $this->db->escape($description)  . "',
                        add_by = " . $user_id . ",
                        modify_by = " . $user_id . ",
                        date_added = NOW(),
                        date_modified = NOW()";

                    $query = $this->db->query($sql);

                    $stock_issue_id =  $this->db->getLastId();
                    if ($stock_issue_id > 0) {
                        $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'catalog/stock_issue', 'store' => $this->session->data['store_id']));

                        foreach ($item as $key2 => $product) {
                            $product_id = $product['product_id'];
                            $quantity = $product['quantity'];
                            $batch_date = $product['batch_date'];
                            $location_id = $product['location_id'];
                            $weight_class_id = $this->getWeightClassId($product_id);
                            $remark = isset($product['remark']) ? $product['remark'] : null;

                            $location = $this->getLocationText($location_id);
                            $stock_onhand = $this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
                            $stock_balance = $stock_onhand - $quantity;

                            if (!empty($batch_date)) {
                                $batch_date = "'" . $batch_date . "'";
                            } else {
                                $batch_date = "'0000-00-00'";
                            }

                            //insert into stock_issue_item table
                            $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                             SET stock_issue_id = " . $stock_issue_id . ",
				                 customer_id = " . (int)$customer_id . ",
				                 product_id = " . (int)$product_id . ",
				                 quantity = " . (float)$quantity . ",
                                 weight_class_id = " . (int)$weight_class_id . ",
                                 batch_date = " . $batch_date  . ",
                                 location_id = '" . (int)$location_id . "',
                                 location = '" . $this->db->escape($location) . "',
                                 remark = '" . $this->db->escape($remark) . "',
                                 stock_onhand = '" . (float)$stock_onhand . "',
				                 stock_balance = '" . (float)$stock_balance . "',
				                 add_by = " . $user_id . ",
                                 modify_by = " . $user_id . ",
				                 date_added = NOW(),
                                 date_modified = NOW()";

                            $this->db->query($item_sql);


                            //deduct item quantity if status =5 (completed)
                            if ($status == 5) {
                                $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                SET onhand_quantity = onhand_quantity - $quantity
                                WHERE product_id = $product_id
                                AND store_id = $store_id
                                AND location_id = $location_id";

                                $this->db->query($deduct_stock_sql);
                            }
                        }
                    } else {
                        $result[$key]['error'] = true;
                        $result[$key]['error_text'] = "Failed to save to db";
                    }
                }
            }
        }
        return $result;
    }
    */
    public function editStockIssue($data)
    {
        $result = array();
        if (!empty($data)) {

            $save_all_doc = true;

            //first loop for checking doc sent
            foreach ($data as $key => $doc) {
                $stock_issue_id = isset($doc['stock_issue_id']) ? $doc['stock_issue_id'] : null;
                $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                $description = isset($doc['description']) ? $doc['description'] : null;
                $status = isset($doc['status']) ? $doc['status'] : 1; //1=draft, 5=completed

                $result[$key]['error'] = false;
                $result[$key]['error_text'] = "";

                $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();

                if (empty($stock_issue_id)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = "Missing Stock Issue Id";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                if (!$this->validateStockIssueId($stock_issue_id)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = "Stock Issue Id is not valid";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                if (empty($item)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = "Missing Item";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                $products = array();
                $error_input = array();
                foreach ($item as $key2 => $product) {
                    $product_id = isset($product['product_id']) ? $product['product_id'] : null;
                    $quantity = isset($product['quantity']) ? $product['quantity'] : null;
                    $batch_date = isset($product['batch_date']) ? $product['batch_date'] : null;
                    $location_id = isset($product['location_id']) ? $product['location_id'] : null;
                    $products[$key2] = array();
                    $remark = isset($product['remark']) ? $product['remark'] : null;

                    // initialize
                    $result[$key]['issue_item'][$key2]['product_id']      = true;
                    $result[$key]['issue_item'][$key2]['location_id']     = true;
                    $result[$key]['issue_item'][$key2]['batch_date']      = true;
                    $result[$key]['issue_item'][$key2]['quantity']        = true;
                    $result[$key]['issue_item'][$key2]['remark']          = true;

                    $proceed = true;

                    //check param if status=5 (completed)

                    if ($status == 5) {
                        if (!$this->validateProduct($product_id)) {
                            $result[$key]['issue_item'][$key2]['product_id'] = false;
                            $proceed = false;
                            if (!in_array("product", $error_input)) {
                                $error_input[] = "product";
                            }
                        }

                        if (!$this->validateLocation($product_id, $location_id)) {
                            $result[$key]['issue_item'][$key2]['location_id'] = false;
                            $proceed = false;
                            if (!in_array("location", $error_input)) {
                                $error_input[] = "location";
                            }
                        }
                        if (!$this->validateBdate($product_id, $location_id, $batch_date)) {
                            $result[$key]['issue_item'][$key2]['batch_date'] = false;
                            $proceed = false;
                            if (!in_array("batch date", $error_input)) {
                                $error_input[] = "batch date";
                            }
                        }
                        if (!$this->validateQty($product_id, $location_id, $batch_date, $quantity)) {
                            $result[$key]['issue_item'][$key2]['quantity'] = false;
                            $proceed = false;
                            if (!in_array("quantity", $error_input)) {
                                $error_input[] = "quantity";
                            }
                        }
                    }

                    if (!$proceed) {
                        $result[$key]['error'] = true;
                        $save_all_doc = false;
                    }
                }
                $error_text = implode(", ", $error_input);
                $result[$key]['error_text'] = $error_text ? $error_text . " is not valid" : "";

                //check customer_id
                if (!$this->validateCustomer($customer_id)) {
                    $result[$key]['error'] = true;
                    $save_all_doc = false;
                    $result[$key]['error_text'] = $error_text ? $error_text . " ,customer_id is not valid" : "customer_id is not valid";
                }
            }
            if ($save_all_doc) {
                //second loop for saving 
                foreach ($data as $key => $doc) {
                    $stock_issue_id = isset($doc['stock_issue_id']) ? $doc['stock_issue_id'] : null;
                    $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                    $description = isset($doc['description']) ? $doc['description'] : null;
                    $status = isset($doc['status']) ? $doc['status'] : 1; //1=draft, 5=completed
                    $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();


                    //save to db if doc no error
                    if (!$result[$key]['error']) {
                        $store_id = $this->session->data['store_id'];
                        $user_id = $this->session->data['user_id'];

                        //insert stock_issue table
                        $sql = "UPDATE " . DB_PREFIX . "stock_issue
                        SET 
                            customer_id = " . (int)$customer_id . ",
                            status = '$status',
                            description = '" . $this->db->escape($description)  . "',
                            modify_by = " . $user_id . ",
                            date_modified = NOW()
                            WHERE stock_issue_id = '" . (int)$stock_issue_id . "'
                        ";

                        $query = $this->db->query($sql);

                        $sql_delete = "DELETE FROM " . DB_PREFIX . "stock_issue_item WHERE stock_issue_id='" . (int)$stock_issue_id . "'";
                        $this->db->query($sql_delete);

                        foreach ($item as $key2 => $product) {
                            $product_id = $product['product_id'];
                            $quantity = $product['quantity'];
                            $batch_date = $product['batch_date'];
                            $location_id = $product['location_id'];
                            $weight_class_id = $this->getWeightClassId($product_id);
                            $remark = isset($product['remark']) ? $product['remark'] : null;

                            $location = $this->getLocationText($location_id);
                            $stock_onhand = $this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
                            $stock_balance = $stock_onhand - $quantity;

                            if (!empty($batch_date)) {
                                $batch_date = "'" . $batch_date . "'";
                            } else {
                                $batch_date = "'0000-00-00'";
                            }

                            //insert into stock_issue_item table
                            $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                             SET stock_issue_id = " . $stock_issue_id . ",
				                 customer_id = " . (int)$customer_id . ",
				                 product_id = " . (int)$product_id . ",
				                 quantity = " . (float)$quantity . ",
                                 weight_class_id = " . (int)$weight_class_id . ",
                                 batch_date = " . $batch_date  . ",
                                 location_id = '" . (int)$location_id . "',
                                 location = '" . $this->db->escape($location) . "',
                                 remark = '" . $this->db->escape($remark) . "',
                                 stock_onhand = '" . (float)$stock_onhand . "',
				                 stock_balance = '" . (float)$stock_balance . "',
				                 add_by = " . $user_id . ",
                                 modify_by = " . $user_id . ",
				                 date_added = NOW(),
                                 date_modified = NOW()";

                            $this->db->query($item_sql);


                            //deduct item quantity if status =5 (completed)
                            if ($status == 5) {
                                $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                SET onhand_quantity = onhand_quantity - $quantity
                                WHERE product_id = $product_id
                                AND store_id = $store_id
                                AND location_id = $location_id";

                                $this->db->query($deduct_stock_sql);
                            }
                        }
                    }
                }
            }
        }
        return array("status" => $save_all_doc, "result" => $result);
    }
    /*
    public function editStockIssue_backup($data)
    {
        $result = array();
        if (!empty($data)) {

            foreach ($data as $key => $doc) {
                $stock_issue_id = isset($doc['stock_issue_id']) ? $doc['stock_issue_id'] : null;
                $customer_id = isset($doc['customer_id']) ? $doc['customer_id'] : null;
                $description = isset($doc['description']) ? $doc['description'] : null;
                $status = isset($doc['status']) ? $doc['status'] : 1; //1=draft, 5=completed

                $result[$key]['error'] = false;
                $result[$key]['error_text'] = "";

                $item = isset($doc['issue_item']) ? $doc['issue_item'] : array();

                if (empty($stock_issue_id)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = "Missing Stock Issue Id";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                if (!$this->validateStockIssueId($stock_issue_id)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = "Stock Issue Id is not valid";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                if (empty($item)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = "Missing Item";
                    $result[$key]['issue_item'] = array();
                    continue;
                }

                $products = array();
                $error_input = array();
                foreach ($item as $key2 => $product) {
                    $product_id = isset($product['product_id']) ? $product['product_id'] : null;
                    $quantity = isset($product['quantity']) ? $product['quantity'] : null;
                    $batch_date = isset($product['batch_date']) ? $product['batch_date'] : null;
                    $location_id = isset($product['location_id']) ? $product['location_id'] : null;
                    $products[$key2] = array();
                    $remark = isset($product['remark']) ? $product['remark'] : null;

                    // initialize
                    $result[$key]['issue_item'][$key2]['product_id']      = true;
                    $result[$key]['issue_item'][$key2]['location_id']     = true;
                    $result[$key]['issue_item'][$key2]['batch_date']      = true;
                    $result[$key]['issue_item'][$key2]['quantity']        = true;
                    $result[$key]['issue_item'][$key2]['remark']          = true;

                    $proceed = true;

                    //check param if status=5 (completed)

                    if ($status == 5) {
                        if (!$this->validateProduct($product_id)) {
                            $result[$key]['issue_item'][$key2]['product_id'] = false;
                            $proceed = false;
                            if (!in_array("product", $error_input)) {
                                $error_input[] = "product";
                            }
                        }

                        if (!$this->validateLocation($product_id, $location_id)) {
                            $result[$key]['issue_item'][$key2]['location_id'] = false;
                            $proceed = false;
                            if (!in_array("location", $error_input)) {
                                $error_input[] = "location";
                            }
                        }
                        if (!$this->validateBdate($product_id, $location_id, $batch_date)) {
                            $result[$key]['issue_item'][$key2]['batch_date'] = false;
                            $proceed = false;
                            if (!in_array("batch date", $error_input)) {
                                $error_input[] = "batch date";
                            }
                        }
                        if (!$this->validateQty($product_id, $location_id, $batch_date, $quantity)) {
                            $result[$key]['issue_item'][$key2]['quantity'] = false;
                            $proceed = false;
                            if (!in_array("quantity", $error_input)) {
                                $error_input[] = "quantity";
                            }
                        }
                    }

                    if (!$proceed) {
                        $result[$key]['error'] = true;
                    }
                }
                $error_text = implode(", ", $error_input);
                $result[$key]['error_text'] = $error_text ? $error_text . " is not valid" : "";

                //check customer_id
                if (!$this->validateCustomer($customer_id)) {
                    $result[$key]['error'] = true;
                    $result[$key]['error_text'] = $error_text ? $error_text . " ,customer_id is not valid" : "customer_id is not valid";
                }

                //save to db if doc no error
                if (!$result[$key]['error']) {
                    $store_id = $this->session->data['store_id'];
                    $user_id = $this->session->data['user_id'];

                    //insert stock_issue table
                    $sql = "UPDATE " . DB_PREFIX . "stock_issue
                    SET 
                        customer_id = " . (int)$customer_id . ",
                        status = '$status',
                        description = '" . $this->db->escape($description)  . "',
                        modify_by = " . $user_id . ",
                        date_modified = NOW()
                        WHERE stock_issue_id = '" . (int)$stock_issue_id . "'
                    ";

                    $query = $this->db->query($sql);

                    $sql_delete = "DELETE FROM " . DB_PREFIX . "stock_issue_item WHERE stock_issue_id='" . (int)$stock_issue_id . "'";
                    $this->db->query($sql_delete);

                    foreach ($item as $key2 => $product) {
                        $product_id = $product['product_id'];
                        $quantity = $product['quantity'];
                        $batch_date = $product['batch_date'];
                        $location_id = $product['location_id'];
                        $weight_class_id = $this->getWeightClassId($product_id);
                        $remark = isset($product['remark']) ? $product['remark'] : null;

                        $location = $this->getLocationText($location_id);
                        $stock_onhand = $this->getStockOnhand($product_id, $location_id, $batch_date, $store_id);
                        $stock_balance = $stock_onhand - $quantity;

                        if (!empty($batch_date)) {
                            $batch_date = "'" . $batch_date . "'";
                        } else {
                            $batch_date = "'0000-00-00'";
                        }

                        //insert into stock_issue_item table
                        $item_sql = "INSERT INTO " . DB_PREFIX . "stock_issue_item
                             SET stock_issue_id = " . $stock_issue_id . ",
				                 customer_id = " . (int)$customer_id . ",
				                 product_id = " . (int)$product_id . ",
				                 quantity = " . (float)$quantity . ",
                                 weight_class_id = " . (int)$weight_class_id . ",
                                 batch_date = " . $batch_date  . ",
                                 location_id = '" . (int)$location_id . "',
                                 location = '" . $this->db->escape($location) . "',
                                 remark = '" . $this->db->escape($remark) . "',
                                 stock_onhand = '" . (float)$stock_onhand . "',
				                 stock_balance = '" . (float)$stock_balance . "',
				                 add_by = " . $user_id . ",
                                 modify_by = " . $user_id . ",
				                 date_added = NOW(),
                                 date_modified = NOW()";

                        $this->db->query($item_sql);


                        //deduct item quantity if status =5 (completed)
                        if ($status == 5) {
                            $deduct_stock_sql = "UPDATE " . DB_PREFIX . "product_to_store
                                SET onhand_quantity = onhand_quantity - $quantity
                                WHERE product_id = $product_id
                                AND store_id = $store_id
                                AND location_id = $location_id";

                            $this->db->query($deduct_stock_sql);
                        }
                    }
                }
            }
        }
        return $result;
    }
    */

    public function getWeightClassIds()
    {
        $query = $this->db->query("SELECT weight_class_id FROM " . DB_PREFIX . "weight_class");
        if ($query->num_rows) {
            return array_column($query->rows, "weight_class_id");
        } else {
            return array();
        }
    }

    private function getWeightClassId($product_id)
    {
        $sql = "SELECT weight_class_id FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row['weight_class_id'])) {
            return $query->row['weight_class_id'];
        } else {
            return 2;
        }
    }
    private function getLocationText($location_id)
    {

        if ($location_id == 0) {
            return "Default Location";
        } else {
            $query = $this->db->query("SELECT CONCAT(warehouse,' > ',zone,' > ',lot) as loc_text FROM " . DB_PREFIX . "wms_location WHERE location_id = '" . (int)$location_id . "'");
            $loc_text = !empty($query->row['loc_text']) ? $query->row['loc_text'] : '';
            return $loc_text;
        }
    }

    public function getStockOnhand($product_id, $location_id, $batch_date, $store_id)
    {
        if (empty($batch_date)) {
            $batch_date = '0000-00-00';
        }
        $sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
		WHERE product_id = '" . (int)$product_id . "' 
		AND store_id = '" . (int)$store_id . "'
		AND location_id = '" . (int)$location_id . "'
		AND batch_date='$batch_date'";
        $query = $this->db->query($sql);
        $qty = !empty($query->row['onhand_quantity']) ? $query->row['onhand_quantity'] : 0;
        return $qty;
    }

    //check param function
    private function validateStockIssueId($id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "stock_issue WHERE stock_issue_id='" . (int)$id . "' AND status <>'5'";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return true;
        } else {
            return false;
        }
    }

    private function validateCustomer($customer_id)
    {
        if ($customer_id) {
            $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    private function validateProduct($product_id)
    {
        if ($product_id) {
            // $sql = "SELECT * FROM " . DB_PREFIX . "product_to_store WHERE product_id = '" . (int)$product_id . "' AND store_id = '" . $this->session->data['store_id'] . "' ";

            //just check if the product_id exist
            $sql = "SELECT * FROM " . DB_PREFIX . "product WHERE product_id = '" . (int)$product_id . "'";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    private function validateLocation($product_id, $location_id)
    {
        return true;
        //disable checking at the moment
        /*
        if ($product_id) {
            $sql = "SELECT * FROM " . DB_PREFIX . "product_to_store 
            WHERE product_id = '" . (int)$product_id . "' 
            AND location_id = '" . (int)$location_id . "'
            AND store_id = '" . $this->session->data['store_id'] . "' ";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
        */
    }

    private function validateBdate($product_id, $location_id, $batch_date)
    {
        return true;
        //disable checking at the moment
        /*
        if ($product_id) {
            if (empty($batch_date)) {
                $batch_date = '0000-00-00';
            }
            $sql = "SELECT * FROM " . DB_PREFIX . "product_to_store 
            WHERE product_id = '" . (int)$product_id . "' 
            AND location_id = '" . (int)$location_id . "'
            AND batch_date = '" . $batch_date . "'
            AND store_id = '" . $this->session->data['store_id'] . "' ";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
        */
    }

    private function validateQty($product_id, $location_id, $batch_date, $qty)
    {
        return true;
        //disable checking at the moment
        /*
        if ($product_id) {
            if (empty($batch_date)) {
                $batch_date = '0000-00-00';
            }
            $sql = "SELECT onhand_quantity FROM " . DB_PREFIX . "product_to_store 
            WHERE product_id = '" . (int)$product_id . "' 
            AND location_id = '" . (int)$location_id . "'
            AND batch_date = '" . $batch_date . "'
            AND store_id = '" . $this->session->data['store_id'] . "' 
            AND onhand_quantity > 0";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                $stock = $query->row['onhand_quantity'];
            } else {
                $stock = 0;
            }
            if (is_numeric($qty)) {
                if ($qty > $stock) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
        */
    }

    //get filter function

    public function getFilterAddBy()
    {
        $sql = "SELECT sii.add_by AS 'id', CONCAT(u.firstname , ' ', u.lastname) AS 'name' FROM " . DB_PREFIX . "stock_issue_item sii LEFT JOIN " . DB_PREFIX . "user u ON(sii.add_by = u.user_id) GROUP BY sii.add_by";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return array();
        }
    }
    public function getFilterCustomer()
    {
        $sql = "SELECT si.customer_id AS 'id', CONCAT(c.firstname , ' ', c.lastname) AS 'name' FROM " . DB_PREFIX . "stock_issue si LEFT JOIN " . DB_PREFIX . "customer c ON(si.customer_id = c.customer_id) WHERE si.customer_id > 0 GROUP BY si.customer_id";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return array();
        }
    }
    public function getFilterLocation()
    {
        $result = array();
        $result[] = array(
            "warehouse" => "Default Location",
            "locations" => array(
                array(
                    "id" => "0",
                    "name" => "Default Location"
                )
            )
        );

        $query = $this->db->query("SELECT DISTINCT(warehouse) as warehouse FROM " . DB_PREFIX . "wms_location WHERE location_id in (SELECT DISTINCT(location_id) FROM " . DB_PREFIX . "stock_issue_item) ");

        if ($query->num_rows) {
            foreach ($query->rows as $row) {
                $sql = "SELECT location_id, CONCAT(warehouse, '>' ,zone, '>' ,lot) AS name FROM " . DB_PREFIX . "wms_location WHERE location_id IN (SELECT DISTINCT(location_id) FROM " . DB_PREFIX . "stock_issue_item) AND warehouse = '" . $this->db->escape($row['warehouse']) . "' ";
                $query2 = $this->db->query($sql);
                $locations = array();
                foreach ($query2->rows as $row2) {
                    $locations[] = array(
                        "id" => $row2['location_id'],
                        "name" => $row2['name'],
                    );
                }
                $result[] = array(
                    "warehouse" => $row['warehouse'],
                    "locations" => $locations
                );
            }
        }
        return $result;
    }
    public function getFilterStatus()
    {
        $sql = "SELECT si.status as id, os.name FROM " . DB_PREFIX . "stock_issue si 
        LEFT JOIN " . DB_PREFIX . "order_status os ON(si.status = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE si.status > 0
        GROUP BY si.status ORDER BY si.status";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return array();
        }
    }

    //master table function

    public function getProductToStore($store_id)
    {
        $sql = "SELECT pts.product_id,
        pd_cn.name as cn_name,
        pd_en.name as en_name,
        p.pinyin as pinyin,
        p.code as product_code,
        wcd.unit as unit,
        pts.store_id, 
        pts.location_id, 
        CASE WHEN pts.location_id = 0 THEN 'Default Location' ELSE concat(wms.warehouse,' > ',wms.zone,' > ',wms.lot) END as location_text,
        pts.batch_date 
        FROM " . DB_PREFIX . "product_to_store pts 
        LEFT JOIN " . DB_PREFIX . "wms_location wms ON (pts.location_id = wms.location_id) 

        LEFT JOIN " . DB_PREFIX . "product p ON (pts.product_id = p.product_id) 

        LEFT JOIN " . DB_PREFIX . "product_description pd_en ON (pts.product_id = pd_en.product_id AND pd_en.language_id='1') 

        LEFT JOIN " . DB_PREFIX . "product_description pd_cn ON (pts.product_id = pd_cn.product_id AND pd_cn.language_id='2') 
        
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON (p.weight_class_id = wcd.weight_class_id AND wcd.language_id='" . (int)$this->session->data['language_id'] . "') 

        WHERE
        pts.store_id='" . (int)$store_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomers()
    {
        $sql = "SELECT customer_id AS id, TRIM(CONCAT(firstname,' ',lastname)) AS name FROM " . DB_PREFIX . "customer WHERE customer_group_id='2'";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
