<?php

class ModelAndroidStaffLeave extends Model
{
    public function getUsers($data)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user 
        WHERE status = 1 
        ORDER BY TRIM(CONCAT(firstname,' ',lastname))
        LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getUser($user_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getUserHolidays($user_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user_holiday 
        WHERE user_id = '" . (int)$user_id . "'
        AND end > DATE_SUB(NOW(), INTERVAL 1 YEAR)
        AND store_id = '" . (int)$this->session->data['store_id'] . "'
        ORDER BY start DESC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function updateHoliday($data, $user_id)
    {
        if (empty($data['id'])) {
            $result = $this->addHoliday($data, $user_id);
        } else {
            $result = $this->editHoliday($data, $user_id);
        }
        return $result;
    }

    public function addHoliday($data, $user_id)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "user_holiday 
        SET user_id = '" . (int)$user_id . "',
        store_id = '" . (int)$this->session->data['store_id'] . "',
        title = '" . $this->db->escape($data['title']) . "',
        start = '" . $this->db->escape($data['start']) . "',
        end = '" . $this->db->escape($data['end']) . "'";
        $this->db->query($sql);
        $id = $this->db->getLastId();
        return $id;
    }

    public function editHoliday($data, $user_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "user_holiday 
        SET user_id = '" . (int)$user_id . "',
        store_id = '" . (int)$this->session->data['store_id'] . "',
        title = '" . $this->db->escape($data['title']) . "',
        start = '" . $this->db->escape($data['start']) . "',
        end = '" . $this->db->escape($data['end']) . "'
        WHERE id = '" . (int)$data['id'] . "'";
        $this->db->query($sql);
        return $data['id'];
    }

    public function deleteHoliday($id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "user_holiday WHERE id = '" . (int)$id . "'");
    }
}
