<?php

class ModelAndroidSettingStoreOpening extends Model
{
    public function getStoreOpenings()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "store_opening WHERE store_id = '" . $this->session->data['store_id'] . "' ";
        $sql .= " ORDER BY
        CASE day
            WHEN 'Sunday' THEN 1
            WHEN 'Monday' THEN 2
            WHEN 'Tuesday' THEN 3
            WHEN 'Wednesday' THEN 4
            WHEN 'Thursday' THEN 5
            WHEN 'Friday' THEN 6
            WHEN 'Saturday' THEN 7
        END ASC ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStoreOpeningTimes($store_opening_id)
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . $store_opening_id . "' ORDER BY store_opening_time_id ASC");

        return $query->rows;
    }

    public function getStoreOpening($store_opening_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "store_opening WHERE store_opening_id = '" . (int)$store_opening_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getAvailableDay()
    {
        $sql = "SELECT day FROM " . DB_PREFIX . "store_opening WHERE store_id = '" . $this->session->data['store_id'] . "'";
        $query = $this->db->query($sql);
        return array_column($query->rows, 'day');
    }

    public function updateStoreOpening($data)
    {
        if (empty($data['store_opening_id'])) {
            $existing = $this->checkDuplicate($data['day'], $this->session->data['store_id']);
            if (!empty($existing['store_opening_id'])) {
                $data['store_opening_id'] = $existing['store_opening_id'];
                $result = $this->editStoreOpening($data);
            } else {
                $result = $this->addStoreOpening($data);
            }
        } else {
            $result = $this->editStoreOpening($data);
        }
        return $result;
    }

    public function addStoreOpening($data)
    {
        $arr_store_opening_time = [];

        $sql = "INSERT INTO " . DB_PREFIX . "store_opening
        SET store_id = '" . (int)$this->session->data['store_id'] . "', 
        day = '" . $this->db->escape($data['day']) . "',
        session = '" . (int)$data['session'] . "',
        enable_session = '" . (int)$data['enable_session'] . "',
        date_added = NOW(),
        add_by = '" . (int)$this->session->data['user_id'] . "',
        date_modified = NOW(),
        modify_by = '" . (int)$this->session->data['user_id'] . "'";

        $this->db->query($sql);
        $store_opening_id = $this->db->getLastId();

        if ($store_opening_id > 0 && !empty($data['working_hours'])) {
            foreach ($data['working_hours'] as $time) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "store_opening_time
                SET store_opening_id = '" . (int)$store_opening_id . "',
                start_time = '" . $this->db->escape($time['start_time']) . "',
                end_time = '" . $this->db->escape($time['end_time']) . "',
                added_by = '" . $this->session->data['user_id'] . "',
                date_added = NOW()");

                $arr_store_opening_time[] = [
                    'store_opening_time_id' => $this->db->getLastId(),
                    'start_time'            => $time['start_time'],
                    'end_time'              => $time['end_time']
                ];
            }
        }

        return [
            "store_opening_id" => $store_opening_id,
            "store_opening_time" => $arr_store_opening_time
        ];
    }

    public function editStoreOpening($data)
    {
        $arr_store_opening_time = [];

        $store_opening_id = $data['store_opening_id'];

        $this->db->query("UPDATE " . DB_PREFIX . "store_opening
                          SET store_id = '" . (int)$this->session->data['store_id'] . "',
                              day = '" . $this->db->escape($data['day']) . "',
                              session = '" . (int)$data['session'] . "',
                              enable_session = '" . (int)$data['enable_session'] . "',
                              date_modified = NOW(),
                              modify_by = '" . (int)$this->session->data['user_id'] . "'
                          WHERE store_opening_id = '" . (int)$store_opening_id . "'");

        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id = '" . (int)$store_opening_id . "'");

        if (!empty($data['working_hours'])) {
            foreach ($data['working_hours'] as $time) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "store_opening_time
                SET store_opening_id = '" . (int)$store_opening_id . "',
                start_time = '" . $this->db->escape($time['start_time']) . "',
                end_time = '" . $this->db->escape($time['end_time']) . "',
                added_by = '" . $this->session->data['user_id'] . "',
                date_added = NOW()");

                $arr_store_opening_time[] = [
                    'store_opening_time_id'     => $this->db->getLastId(),
                    'start_time'                => $time['start_time'],
                    'end_time'                  => $time['end_time']
                ];
            }
        }

        return [
            "store_opening_id" => $store_opening_id,
            "store_opening_time" => $arr_store_opening_time
        ];
    }

    public function deleteStoreOpening($id){
        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening_time WHERE store_opening_id='" . (int)$id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "store_opening WHERE store_opening_id='" . (int)$id . "'");
    }

    private function checkDuplicate($day, $store_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "store_opening WHERE day = '" . $this->db->escape($day) . "' AND store_id = '" . (int)$store_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }
}
