<?php

class ModelAndroidServicePartnerServicePartner extends Model
{
    private $dosage_unit_en = [
        'SELF_HERBS'    => '',
        'SELF_BREWING'  => 'ml',
        'SELF_GRANULE'  => 'potion',
        'DECOCTION_BY_PARTNER'  => 'ml',
        'HERBS' => '',
        'GRANULE'   => 'potion',
    ];

    private $dosage_unit_cn = [
        'SELF_HERBS'    => '',
        'SELF_BREWING'  => '毫升',
        'SELF_GRANULE'  => '格',
        'DECOCTION_BY_PARTNER'  => '毫升',
        'HERBS' => '',
        'GRANULE'   => '格',
    ];

    #region Medical Record
    public function getMedicalRecordInfo($medical_record_id)
    {
        $sql = "SELECT  
            cs.`clinical_sale_id` AS medical_record_id, 
            cs.`sales_date` AS doc_date, 
            cs.`invoice_prefix` AS doc_no, 
            cs.`store_id`,
            (CASE WHEN s.`name` IS NULL THEN '" . $this->config->get('config_name')  . "' ELSE s.`name` END) AS store,
            cs.`doctor_id`,
            (SELECT TRIM(CONCAT(u.`firstname`,' ',u.`lastname`)) FROM `" . DB_PREFIX . "user` u WHERE u.`user_id` = cs.`doctor_id`) AS doctor,
            c.`customer_id`, 
            CONCAT(c.`firstname`,' ',c.`lastname`) AS customer,
            c.`customer_group_id`,
            (SELECT cgd.`name` FROM `" . DB_PREFIX . "customer_group_description` cgd WHERE cgd.`customer_group_id` = c.`customer_group_id` AND cgd.`language_id` = '" . (int)$this->session->data['language_id'] . "') AS customer_group, 
            c.`customer_ic`, 
            c.`telephone`, 
            c.`email`, 
            c.`customer_card`, 
            c.`gender`,
            (CASE WHEN c.`gender` = 1 THEN 'Male' ELSE 'Female' END) AS sex, 
            TIMESTAMPDIFF(YEAR,c.dob, CURDATE()) AS age,
            c.`address_id`,
            cs.`total`,
            CONCAT_WS(', ', NULLIF(cs.diagnostic,''), NULLIF(cs.doctoradvice,''), NULLIF(cs.pulse,''), NULLIF(cs.disease,''), NULLIF(cs.treatment,''), NULLIF(cs.acupuncture,''), NULLIF(cs.symptom,''), NULLIF(cs.remark,'')) AS diagnostic
            FROM `" . DB_PREFIX . "clinical_sale` cs
                LEFT JOIN `" . DB_PREFIX . "customer` c
                    ON c.`customer_id` = cs.`customer_id`   
                LEFT JOIN `" . DB_PREFIX . "store` s
                    ON s.`store_id` = cs.`store_id`
            WHERE 1
            AND cs.`clinical_sale_id` = '" . (int)$medical_record_id . "'
            ORDER BY cs.`sales_date` DESC,  cs.`invoice_prefix` DESC
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getUnmatchedProducts($prescription_id)
    {
        $sql = "SELECT 
                    GROUP_CONCAT(pd.name SEPARATOR ', ') AS products
                FROM `" . DB_PREFIX . "clinicalsale_product` cp 
                    LEFT JOIN `" . DB_PREFIX . "product_description` pd 
                        ON (cp.`product_id` = pd.`product_id` AND pd.`language_id` = '" .  (int)$this->session->data['language_id'] . "')
                    LEFT JOIN `" . DB_PREFIX . "etcm_service_partner_product_match` esppm
                        ON (cp.`product_id` = esppm.`product_id`)
                    WHERE 1
                        AND cp.prescription_id = '" . (int)$prescription_id . "'
                        AND (esppm.etcm_product_id IS NULL OR esppm.status = 0)
                    GROUP BY cp.`prescription_id`
        ";
        $query = $this->db->query($sql);
        return !empty($query->row['products']) ? $query->row['products'] : '';
    }

    public function getMedicalRecordPrescriptionsProducts($medical_record_id)
    {
        $sql = "SELECT 
                    cp.`prescription_id`,
                    GROUP_CONCAT(pd.name,TRIM(cp.`t_weight`) + 0,wcd.`unit` SEPARATOR ', ') AS products,
                    CONCAT('共', MAX(cp.`times`),'剂') AS time,
                    CONCAT('每日', MAX(cp.`day`),'次') AS day,
                    MAX(cp.`cook`) AS consume_method,
                    MAX(cp.`taketype`) AS take_type,
                    SUM(cp.`t_weight`) AS total_weight,
                    MAX(wcd.`unit`) AS uom,
                    COUNT(cp.`product_id`) AS total_products
                FROM `" . DB_PREFIX . "clinicalsale_product` cp 
                    LEFT JOIN `" . DB_PREFIX . "product_description` pd 
                        ON (cp.`product_id` = pd.`product_id` AND pd.`language_id` = '" .  (int)$this->session->data['language_id'] . "')
                    LEFT JOIN `" . DB_PREFIX . "weight_class_description` wcd 
                        ON (cp.`weight_class_id` = wcd.`weight_class_id` AND wcd.`language_id` = '" .  (int)$this->session->data['language_id'] . "')
                    WHERE 1
                        AND cp.clinical_sale_id = '" . (int)$medical_record_id . "'
                        AND cp.prescription_id IN (SELECT clinical_sale_prescription_id FROM `" . DB_PREFIX . "clinecal_sales_prescription` WHERE clinical_sale_id ='" . (int)$medical_record_id . "'  AND dispense_code <> '' AND dispense_code NOT LIKE 'SELF_%')
                    GROUP BY cp.`prescription_id`
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getMedicalRecordImages($medical_record_id)
    {
        $sql = "SELECT i.*, c.name AS category 
        FROM " . DB_PREFIX . "clinical_sale_image i 
        LEFT JOIN " . DB_PREFIX . "image_category_description c 
        ON(i.category_id=c.category_id AND c.language_id ='" . (int)$this->session->data['language_id'] . "')
        WHERE i.clinical_sale_id = '" . $medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }
    
    public function getMedicalRecordProducts($medical_record_id)
    {
        $data = [];

        $this->load->model('android/prescription/medicine');

        $dispense_code_statement = " AND dispense_code <> '' AND dispense_code NOT LIKE 'SELF_%'";

        $sql = "SELECT * FROM `" . DB_PREFIX . "clinecal_sales_prescription` WHERE clinical_sale_id = '" . (int)$medical_record_id . "' $dispense_code_statement";
        $query = $this->db->query($sql);
        $prescriptions = $query->rows;
        foreach ($prescriptions as $pid => $prescription) {
            #region products
            $sql = "SELECT
                    cp.product_id,
                    pd.name,
                    cp.quantity,
                    cp.t_weight,
                    wcd.weight_class_id,
                    wcd.unit,
                    esppm.etcm_product_id, 
                    esppm.etcm_product_code,
                    esppm.status
                FROM `" . DB_PREFIX . "clinicalsale_product` cp 
                    LEFT JOIN `" . DB_PREFIX . "product_description` pd 
                        ON (cp.`product_id` = pd.`product_id` AND pd.`language_id` = '" .  (int)$this->session->data['language_id'] . "')
                    LEFT JOIN `" . DB_PREFIX . "etcm_service_partner_product_match` esppm
                        ON (cp.product_id = esppm.product_id)
                    LEFT JOIN `" . DB_PREFIX . "weight_class_description` wcd 
                        ON (cp.`weight_class_id` = wcd.`weight_class_id` AND wcd.`language_id` = '" .  (int)$this->session->data['language_id'] . "')
                    WHERE 1
                        AND cp.prescription_id = '" . (int)$prescription['clinical_sale_prescription_id'] . "'
                ";
            $products_query = $this->db->query($sql);
            $products = $products_query->rows;
            $prescription_products = [];
            $total_weight = 0;
            $uom = '';
            foreach ($products as $product) {
                $prescription_products[] = [
                    'product_id' => (int) $product['product_id'],
                    'name' => $product['name'],
                    'quantity' => (float)$product['quantity'],
                    'total_weight' => (float)$product['t_weight'],
                    'weight_class_id' => (int)$product['weight_class_id'],
                    'unit' => $product['unit'],
                    'etcm_product_id' => (int)$product['etcm_product_id'],
                    'etcm_product_code' => $product['etcm_product_code'],
                    'etcm_product_status' => (int)$product['status']
                ];

                $total_weight += $product['t_weight'];
                $uom = $product['unit'];
            }

            #endregion
            $name = $prescription['name'];
            $category_name = $this->model_android_prescription_medicine->getCategoryNameById($prescription['category_id']);

            $medication_instruction = [];
            $language_id = $this->session->data['language_id'];
            if ($language_id == 1) {
                $dosage_unit = $this->dosage_unit_en;
            } else {
                $dosage_unit = $this->dosage_unit_cn;
            }

            if (!empty($prescription['dispense_code'])) {
                $dispense_text = $this->getDispenseCodeText($prescription['dispense_code']);
                $medication_instruction[] = $dispense_text;
            }

            if (!empty($prescription['times']) && !empty($prescription['day'])) {
                $day_time_text_en = 'Total ' . $prescription['times'] . ' day, ' . $prescription['day'] . ' times daily';

                $day_time_text_cn = '共' . $prescription['times'] . '剂/天, 每天' . $prescription['day'] . '次';

                $medication_instruction[] = $language_id == 1 ? $day_time_text_en : $day_time_text_cn;
            }

            if (!empty($prescription['daily_dosage'])) {
                $daily_dosage_text_en = $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']] . "/day";

                $daily_dosage_text_cn = "每次 " . $prescription['daily_dosage'] . $dosage_unit[$prescription['dispense_code']];

                $medication_instruction[] = $language_id == 1 ? $daily_dosage_text_en : $daily_dosage_text_cn;
            }

            $medication_instruction[] = $this->getPackagingText($prescription['day'], $prescription['times'], $prescription['dispense_code']);

            $data[] = [
                'name' => $this->convertPresName($name),
                'day' => !empty($prescription['day']) ? (int)$prescription['day'] : '',
                'time' => !empty($prescription['times']) ? (int)$prescription['times'] : '',
                "category_id" => (string) $prescription['category_id'],
                "category_name" => $category_name,
                'total_weight' => (float) $total_weight,
                'uom' => $uom,
                'total_products' => count($prescription_products),
                'service_type' => $prescription['dispense_code'],
                'usage' => (string)$prescription['medication_method'],
                "remark" => (string) $prescription['remark'],
                "medical_instruction" => implode(", ", array_filter($medication_instruction)),
                'products' => $prescription_products,
            ];
        }

        return $data;
    }

    private function convertPresName($name)
    {
        if ($this->session->data['language_id'] == 1) {
            $name = str_replace('处方', 'Prescription', $name);
        } else {
            $name = str_replace('Prescription', '处方', $name);
        }
        return $name;
    }

    private function getDispenseCodeText($code)
    {
        $text = '';
        $sql = "SELECT m.*, md.name FROM " . DB_PREFIX . "medication_dispense m LEFT JOIN " . DB_PREFIX . "medication_dispense_description md ON(md.medication_dispense_id = m.medication_dispense_id AND md.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE m.dispense_code='" . $this->db->escape($code) . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row['name'])) {
            $text .= $query->row['name'];

            $sql_parent = "SELECT m.*, md.name FROM " . DB_PREFIX . "medication_dispense m LEFT JOIN " . DB_PREFIX . "medication_dispense_description md ON(md.medication_dispense_id = m.medication_dispense_id AND md.language_id='" . (int)$this->session->data['language_id'] . "') 
            WHERE m.medication_dispense_id='" . $this->db->escape($query->row['parent_id']) . "'";
            $query_parent = $this->db->query($sql_parent);
            if (!empty($query_parent->row['name'])) {
                $text .= '(' . $query_parent->row['name'] . ')';
            }
        }
        return $text;
    }

    private function getPackagingText($day, $time, $code)
    {
        $language_id = $this->session->data['language_id'];
        $result = '';
        if ($code == 'DECOCTION_BY_PARTNER') {
            $no = $day * $time;
            $result = $language_id == 1 ? 'Total ' . $no . ' packs' : '共' . $no . '包';
        }
        if ($code == 'GRANULE') {
            $no = ceil(($day * $time) / 6);
            $result = $language_id == 1 ? 'Total ' . $no . ' boxes' : '共' . $no . '盒';
        }
        return $result;
    }

    #endregion

    #region Customer
    public function getCustomer($customer_id)
    {
        $sql = "SELECT  
            c.`customer_id`, 
            CONCAT(c.`firstname`,' ',c.`lastname`) AS customer,
            c.`store_id`,
            (CASE WHEN s.`name` IS NULL THEN '" . $this->config->get('config_name')  . "' ELSE s.`name` END) AS store,
            c.`customer_group_id`,
            (SELECT cgd.`name` FROM `" . DB_PREFIX . "customer_group_description` cgd WHERE cgd.`customer_group_id` = c.`customer_group_id` AND cgd.`language_id` = '" . (int)$this->session->data['language_id'] . "') AS customer_group, 
            c.`customer_ic`, 
            c.`telephone`, 
            c.`email`, 
            c.`customer_card`, 
            c.`gender`,
            (CASE WHEN c.`gender` = 1 THEN 'Male' ELSE 'Female' END) AS sex, 
            TIMESTAMPDIFF(YEAR,c.dob, CURDATE()) AS age,
            c.`address_id`,
            c.`allergic`,
            c.`occupation`,
            c.`diagnostic_history`
            FROM  `" . DB_PREFIX . "customer` c
                LEFT JOIN `" . DB_PREFIX . "store` s
                    ON s.`store_id` = c.`store_id`
            WHERE 1
            AND c.`customer_id` = '" . (int)$customer_id . "'
            ORDER BY CONCAT(c.`firstname`,c.`lastname`) ASC
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getCustomerAddresses($customer_id, $address_id)
    {
        $sql = "SELECT 
                    a.`address_id`,
                    a.`company`,
                    a.`firstname`,
                    a.`lastname`,
                    a.`telephone`,
                    a.`address_1`,
                    a.`address_2`,
                    a.`address_3`,
                    a.`city`,
                    a.`postcode`,
                    a.`zone_id`,
                    zo.`name` AS zone,
                    a.`country_id`,
                    co.`name` AS country,
                    (CASE WHEN a.`address_id` = $address_id THEN 1 ELSE 0 END) AS default_address
                FROM `" . DB_PREFIX . "address` a
                    LEFT JOIN `" . DB_PREFIX . "zone` zo
                        ON (zo.zone_id = a.zone_id)
                    LEFT JOIN `" . DB_PREFIX . "country` co
                        ON (co.country_id = a.country_id)
                WHERE a.customer_id = '" . (int)$customer_id . "'
                    AND a.customer_id <> ''
                ORDER BY default_address DESC, a.`address_id` ASC
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomerAddress($customer_id, $address_id)
    {
        $sql = "SELECT 
                    a.`address_id`,
                    a.`company`,
                    a.`firstname`,
                    a.`lastname`,
                    (CASE WHEN a.`telephone` = '' THEN (SELECT telephone FROM " . DB_PREFIX . "customer WHERE customer_id='" . (int)$customer_id . "' ) ELSE a.telephone END) AS telephone,
                    a.`address_1`,
                    a.`address_2`,
                    a.`address_3`,
                    a.`city`,
                    a.`postcode`,
                    a.`zone_id`,
                    zo.`name` AS zone,
                    a.`country_id`,
                    co.`name` AS country,
                    (CASE WHEN a.`address_id` = $address_id THEN 1 ELSE 0 END) AS default_address
                FROM `" . DB_PREFIX . "address` a
                    LEFT JOIN `" . DB_PREFIX . "zone` zo
                        ON (zo.zone_id = a.zone_id)
                    LEFT JOIN `" . DB_PREFIX . "country` co
                        ON (co.country_id = a.country_id)
                WHERE a.customer_id = '" . (int)$customer_id . "'
                    AND a.customer_id <> ''
                    AND a.address_id = '" . (int)$address_id  . "'
                ORDER BY default_address DESC, a.`address_id` ASC
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    private function getCustomerInfoByMedicalRecordId($medical_record_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = (SELECT customer_id FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id='" . (int)$medical_record_id . "')";
        $query = $this->db->query($sql);
        return $query->row;
    }
    #endregion

    #region SPP
    public function getPO($purchase_order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_partner_purchase_order WHERE purchase_order_id ='" . (int)$purchase_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function savePO($data)
    {

        // $invoice_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service_partner/purchase_order', 'store' => $this->session->data['store_id']));
        $invoice_no = $data['doc_no'];

        $customer_info = $this->getCustomerInfoByMedicalRecordId($data['medical_record_id']);

        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order SET
            etcm_purchase_order_id ='" . (int)$data['etcm_purchase_order_id'] . "',
            store_id ='" . (int)$this->session->data['store_id'] . "',
            doc_no ='" . $this->db->escape($invoice_no) . "',
            doc_date ='" . $this->db->escape($data['doc_date']) . "',
            customer_id ='" . (int)$customer_info['customer_id'] . "',
            customer_name ='" . $this->db->escape(TRIM($customer_info['firstname'] . ' ' . $customer_info['lastname'])) . "',
            customer_telephone ='" . $this->db->escape($customer_info['telephone']) . "',
            customer_email ='" . $this->db->escape($customer_info['email']) . "',
            medical_record_id ='" . (int)$data['medical_record_id'] . "',
            service_partner_id ='" . (int)$data['service_partner_id'] . "',
            service_partner_name ='" . $this->db->escape($data['service_partner_name']) . "',
            service_type ='" . $this->db->escape($data['service_type']) . "',
            shipping_type ='" . $this->db->escape($data['shipping_type']) . "',
            estimated_date ='" . $this->db->escape($data['estimated_date']) . "',
            shipping_address_id ='" . (int)$data['shipping_address_id'] . "',
            shipping_address ='" . $this->db->escape($data['shipping_address']) . "',
            shipping_address_json ='" . $this->db->escape($data['shipping_address_json']) . "',
            shipping_method ='" . $this->db->escape($data['shipping_method']) . "',
            payment_address ='" . $this->db->escape($data['payment_address']) . "',
            payment_address_json ='" . $this->db->escape($data['payment_address_json']) . "',
            payment_method ='" . $this->db->escape($data['payment_method']) . "',
            image_json ='" . $this->db->escape($data['image_json']) . "',
            service_partner_prescription_json ='" . $this->db->escape($data['service_partner_prescription_json']) . "',
            service_partner_total_json ='" . $this->db->escape($data['service_partner_total_json']) . "',
            service_partner_total ='" . $this->db->escape($data['service_partner_total']) . "',
            service_partner_total_text ='" . $this->db->escape($data['service_partner_total_text']) . "',
            service_charges ='" . $this->db->escape($data['service_charges']) . "',
            service_tax ='" . $this->db->escape($data['service_tax']) . "',
            tax_class_id ='" . (int)$data['tax_class_id'] . "',
            discount ='" . $this->db->escape($data['discount']) . "',
            total ='" . $this->db->escape($data['total']) . "',
            status_id ='" . (int)$data['status_id'] . "',
            etcm_status_code ='" . $this->db->escape($data['etcm_status_code']) . "',
            remark ='" . $this->db->escape($data['remark']) . "',
            date_ordered ='" . $this->db->escape($data['doc_date']) . "',
            date_payment ='" . $this->db->escape($data['date_payment']) . "',
            date_added = NOW(),
            added_by ='" . (int)$this->session->data['user_id'] . "',
            date_modified =NOW(),
            modified_by ='" . (int)$this->session->data['user_id'] . "'";

        $this->db->query($sql);
        $purchase_order_id = $this->db->getLastId();

        if ($purchase_order_id > 0) {

            // $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service_partner/purchase_order', 'store' => $this->session->data['store_id']));

            if (!empty($data['products'])) {
                foreach ($data['products'] as $product) {
                    $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order_product  SET 
                    purchase_order_id ='" . (int)$purchase_order_id . "',
                    prescription_id ='" . (int)$product['prescription_id'] . "',
                    product_id ='" . (int)$product['product_id'] . "',
                    name ='" . $this->db->escape($product['name']) . "',
                    code ='" . $this->db->escape($product['code']) . "',
                    model ='" . $this->db->escape($product['model']) . "',
                    quantity ='" . $this->db->escape($product['quantity']) . "',
                    weight ='" . $this->db->escape($product['weight']) . "',
                    weight_class_id ='" . (int)$product['weight_class_id'] . "',
                    price ='" . $this->db->escape($product['price']) . "',
                    total ='" . $this->db->escape($product['total']) . "',
                    tax ='" . $this->db->escape($product['tax']) . "'";

                    $this->db->query($sql);
                }
            }

            if (!empty($data['totals'])) {
                foreach ($data['totals'] as $total) {
                    $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order_total  
                    SET 
                    purchase_order_id ='" . (int)$purchase_order_id . "',
                    code ='" . $this->db->escape($total['code']) . "',
                    title ='" . $this->db->escape($total['title']) . "',
                    value ='" . $this->db->escape($total['value']) . "',
                    sort_order ='" . $this->db->escape($total['sort_order']) . "'";

                    $this->db->query($sql);
                }
            }
        }

        return $purchase_order_id;
    }

    public function updateShipping($data)
    {
        $sql = "UPDATE ".DB_PREFIX."service_partner_purchase_order SET ";
        if (!empty($data['shipping_address'])) {
            $sql .= "shipping_address = '" . $this->db->escape($data['shipping_address']) . "', ";
        }
        if (!empty($data['shipping_address_json'])) {
            if (is_string($data['shipping_address_json'])) {
                if (json_decode($data['shipping_address_json']) != null) {
                    $sql .= "shipping_address_json = '" . $this->db->escape($data['shipping_address_json']) . "', ";
                }
            } elseif (is_array($data['shipping_address_json'])) {
                $sql .= "shipping_address_json = '" . $this->db->escape(json_encode($data['shipping_address_json'])) . "', ";
            }
        }
        $sql .= " date_modified=NOW()
         WHERE etcm_purchase_order_id = '" . (int)$data['etcm_purchase_order_id'] . "'";

        if (!empty($data['etcm_purchase_order_id'])) {
            $this->db->query($sql);
        }
    }

    public function updatePO($data)
    {
        $sql = "UPDATE " . DB_PREFIX . "service_partner_purchase_order SET ";
        if (!empty($data['tracking_no'])) {
            $sql .= "tracking_no='" . $this->db->escape($data['tracking_no']) . "', ";
        }
        if (!empty($data['estimated_date'])) {
            $sql .= "estimated_date='" . $this->db->escape($data['estimated_date']) . "', ";
        }
        if (!empty($data['proof_of_delivery'])) {
            $sql .= "proof_of_delivery='" . $this->db->escape($data['proof_of_delivery']) . "', ";
        }
        if (!empty($data['status_id'])) {
            $sql .= "status_id='" . (int)$data['status_id'] . "', ";
        }
        if (!empty($data['etcm_status_code'])) {
            $sql .= "etcm_status_code='" . $this->db->escape($data['etcm_status_code']) . "', ";
        }
        if (!empty($data['date_payment'])) {
            $sql .= "date_payment='" . $this->db->escape($data['date_payment']) . "', ";
        }
        if (!empty($data['date_prepared'])) {
            $sql .= "date_prepared='" . $this->db->escape($data['date_prepared']) . "', ";
        }
        if (!empty($data['date_shipped'])) {
            $sql .= "date_shipped='" . $this->db->escape($data['date_shipped']) . "', ";
        }
        if (!empty($data['date_rated'])) {
            $sql .= "date_rated='" . $this->db->escape($data['date_rated']) . "', ";
        }
        if (!empty($data['rate_details'])) {
            $sql .= "rate_details='" . $this->db->escape($data['rate_details']) . "', ";
        }
        if (!empty($data['date_completed'])) {
            $sql .= "date_completed='" . $this->db->escape($data['date_completed']) . "', ";
        }
        if (!empty($data['date_cancelled'])) {
            $sql .= "date_cancelled='" . $this->db->escape($data['date_cancelled']) . "', ";
        }
        if (!empty($data['cancel_reason'])) {
            $sql .= "cancel_reason='" . $this->db->escape($data['cancel_reason']) . "', ";
        }
        $sql .= " date_modified=NOW()
         WHERE etcm_purchase_order_id = '" . (int)$data['etcm_purchase_order_id'] . "'";

        if (!empty($data['etcm_purchase_order_id'])) {
            $this->db->query($sql);
        }
    }

    public function getPObyEtcmId($etcm_purchase_order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_purchase_order_id = '" . (int)$etcm_purchase_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getPurchasedOrders($data)
    {
        $sql = "SELECT
                        *
                    FROM `" . DB_PREFIX . "service_partner_purchase_order`
                    WHERE 1
        ";

        if (!empty($data['search'])) {
            $sql .= " AND (
                    doc_no LIKE '%" . $this->db->escape($data['search']) . "%'
                    OR service_partner_name LIKE '%" . $this->db->escape($data['search']) . "%'
                    OR customer_name LIKE '%" . $this->db->escape($data['search']) . "%'
            ) ";
        }

        if (!empty($data['status']) && strtolower($data['status']) != 'all') {
            switch($data['status']){
                case 'TO_PAY':
                    $sql .= " AND (etcm_status_code = 'TO_SHIP' OR etcm_status_code = 'TO_PAY') AND date_prepared IS NULL";
                    break;
                case 'TO_SHIP':
                    $sql .= " AND etcm_status_code = 'TO_SHIP' AND date_prepared IS NOT NULL";
                    break;
                default:
                $sql .= " AND etcm_status_code = '" . $this->db->escape($data['status']) . "'";
            }
        }

        $sql .= ' ORDER BY doc_date DESC ';

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = $this->config->get('config_limit_admin');
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPurchasedOrder($purchase_order_id)
    {
        $sql = "SELECT * FROM `" . DB_PREFIX . "service_partner_purchase_order`
            WHERE 1 AND purchase_order_id = '" . (int)$purchase_order_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function checkPurchaseOrder($purchase_order_id)
    {
        $sql = "SELECT purchase_order_id FROM `" . DB_PREFIX . "service_partner_purchase_order`
            WHERE 1 AND purchase_order_id = '" . (int)$purchase_order_id . "'
                AND hide = 0
        ";
        $query = $this->db->query($sql);
        return $query->num_rows;
    }
    #endregion
}
