<?php

class ModelAndroidServicePartnerSaleOrder extends Model
{

    public function getSaleOrders($data)
    {
        $sql = "SELECT
                        *
                    FROM `" . DB_PREFIX . "service_partner_sale_order`
                    WHERE 1
        ";


        if (!empty($data['search'])) {
            $sql .= " AND (
                    doc_no LIKE '%" . $this->db->escape($data['search']) . "%'
                    OR service_partner_name LIKE '%" . $this->db->escape($data['search']) . "%'
                    OR customer_name LIKE '%" . $this->db->escape($data['search']) . "%'
            ) ";
        }

        if (!empty($data['status']) && strtolower($data['status']) != 'all') {
            switch ($data['status']) {
                case 'TO_PAY':
                    $sql .= " AND (etcm_status_code = 'TO_SHIP' OR etcm_status_code = 'TO_PAY') AND date_prepared IS NULL";
                    break;
                case 'TO_SHIP':
                    $sql .= " AND etcm_status_code = 'TO_SHIP' AND date_prepared IS NOT NULL";
                    break;
                default:
                    $sql .= " AND etcm_status_code = '" . $this->db->escape($data['status']) . "'";
            }
        }

        $sql .= ' ORDER BY doc_date DESC ';

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = $this->config->get('config_limit_admin');
            }

            $sql .= " LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSaleOrder($sale_order_id)
    {
        $sql = "SELECT * FROM `" . DB_PREFIX . "service_partner_sale_order`
            WHERE 1 AND sale_order_id = '" . (int)$sale_order_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function saveSO($data)
    {
        // $invoice_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service_partner/sale_order', 'store' => $this->session->data['store_id']));

        $invoice_no = $data['doc_no'];

        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order SET
            etcm_purchase_order_id ='" . (int)$data['etcm_purchase_order_id'] . "',
            store_id ='" . (int)0 . "',
            doc_no ='" . $this->db->escape($invoice_no) . "',
            doc_date ='" . $this->db->escape($data['doc_date']) . "',
            etcm_customer_id ='" . (int)$data['customer_id'] . "',
            customer_name ='" . $this->db->escape($data['customer_name']) . "',
            customer_telephone ='" . $this->db->escape($data['customer_telephone']) . "',
            customer_email ='" . $this->db->escape($data['customer_email']) . "',
            medical_record_id ='" . (int)$data['medical_record_id'] . "',
            service_partner_id ='" . (int)$data['service_partner_id'] . "',
            service_partner_name ='" . $this->db->escape($data['service_partner_name']) . "',
            service_type ='" . $this->db->escape($data['service_type']) . "',
            transaction_fee ='" . (float)$data['transaction_fee'] . "',
            shipping_type ='" . $this->db->escape($data['shipping_type']) . "',
            estimated_date ='" . $this->db->escape($data['estimated_date']) . "',
            shipping_address_id ='" . (int)$data['shipping_address_id'] . "',
            shipping_address ='" . $this->db->escape($data['shipping_address']) . "',
            shipping_address_json ='" . $this->db->escape(json_encode($data['shipping_address_json'])) . "',
            shipping_method ='" . $this->db->escape($data['shipping_method']) . "',
            payment_address ='" . $this->db->escape($data['payment_address']) . "',
            payment_address_json ='" . $this->db->escape(json_encode($data['payment_address_json'])) . "',
            payment_method ='" . $this->db->escape($data['payment_method']) . "',
            image_json ='" . $this->db->escape(json_encode($data['image_json'])) . "',
            service_partner_prescription_json ='" . $this->db->escape(json_encode($data['service_partner_prescription_json'])) . "',
            service_partner_total_json ='" . $this->db->escape(json_encode($data['service_partner_total_json'])) . "',
            service_partner_total ='" . $this->db->escape($data['service_partner_total']) . "',
            service_partner_total_text ='" . $this->db->escape($data['service_partner_total_text']) . "',
            service_charges ='" . $this->db->escape($data['service_charges']) . "',
            service_tax ='" . $this->db->escape($data['service_tax']) . "',
            tax_class_id ='" . (int)$data['tax_class_id'] . "',
            discount ='" . $this->db->escape($data['discount']) . "',
            total ='" . $this->db->escape($data['total']) . "',
            status_id ='" . (int)$data['status_id'] . "',
            etcm_status_code ='" . $this->db->escape($data['etcm_status_code']) . "',
            remark ='" . $this->db->escape($data['remark']) . "',
            date_ordered ='" . $this->db->escape($data['doc_date']) . "',
            date_payment ='" . $this->db->escape($data['date_payment']) . "',
            date_added = NOW(),
            date_modified =NOW()";

        $this->db->query($sql);
        $sale_order_id = $this->db->getLastId();

        if ($sale_order_id > 0) {

            // $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service_partner/sale_order', 'store' => $this->session->data['store_id']));

            if (!empty($data['products'])) {
                foreach ($data['products'] as $product) {
                    $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order_product  SET 
                    sale_order_id ='" . (int)$sale_order_id . "',
                    prescription_id ='" . (int)$product['prescription_id'] . "',
                    product_id ='" . (int)$product['product_id'] . "',
                    name ='" . $this->db->escape($product['name']) . "',
                    code ='" . $this->db->escape($product['code']) . "',
                    model ='" . $this->db->escape($product['model']) . "',
                    quantity ='" . $this->db->escape($product['quantity']) . "',
                    weight ='" . $this->db->escape($product['weight']) . "',
                    weight_class_id ='" . (int)$product['weight_class_id'] . "',
                    price ='" . $this->db->escape($product['price']) . "',
                    total ='" . $this->db->escape($product['total']) . "',
                    tax ='" . $this->db->escape($product['tax']) . "'";

                    $this->db->query($sql);
                }
            }

            if (!empty($data['totals'])) {
                foreach ($data['totals'] as $total) {
                    $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order_total  
                    SET 
                    sale_order_id ='" . (int)$sale_order_id . "',
                    code ='" . $this->db->escape($total['code']) . "',
                    title ='" . $this->db->escape($total['title']) . "',
                    value ='" . $this->db->escape($total['value']) . "',
                    sort_order ='" . $this->db->escape($total['sort_order']) . "'";

                    $this->db->query($sql);
                }
            }
        }

        return $sale_order_id;
    }

    public function updateShipping($data)
    {
        $sql = "UPDATE " . DB_PREFIX . "service_partner_sale_order SET ";
        if (!empty($data['shipping_address'])) {
            $sql .= "shipping_address = '" . $this->db->escape($data['shipping_address']) . "', ";
        }
        if (!empty($data['shipping_address_json'])) {
            if (is_string($data['shipping_address_json'])) {
                if (json_decode($data['shipping_address_json']) != null) {
                    $sql .= "shipping_address_json = '" . $this->db->escape($data['shipping_address_json']) . "', ";
                }
            } elseif (is_array($data['shipping_address_json'])) {
                $sql .= "shipping_address_json = '" . $this->db->escape(json_encode($data['shipping_address_json'])) . "', ";
            }
        }
        $sql .= " date_modified=NOW()
         WHERE etcm_purchase_order_id = '" . (int)$data['etcm_purchase_order_id'] . "'";

        if (!empty($data['etcm_purchase_order_id'])) {
            $this->db->query($sql);
        }
    }

    public function updateSO($data)
    {
        $sql = "UPDATE " . DB_PREFIX . "service_partner_sale_order SET ";
        if (is_numeric($data['carrier_id'])) {
            $sql .= "carrier_id='" . $this->db->escape($data['carrier_id']) . "', ";
        }
        if (!empty($data['tracking_no'])) {
            $sql .= "tracking_no='" . $this->db->escape($data['tracking_no']) . "', ";
        }
        if (!empty($data['estimated_date'])) {
            $sql .= "estimated_date='" . $this->db->escape($data['estimated_date']) . "', ";
        }
        if (!empty($data['proof_of_delivery'])) {
            $sql .= "proof_of_delivery='" . $this->db->escape($data['proof_of_delivery']) . "', ";
        }
        if (!empty($data['status_id'])) {
            $sql .= "status_id='" . (int)$data['status_id'] . "', ";
        }
        if (!empty($data['etcm_status_code'])) {
            $sql .= "etcm_status_code='" . $this->db->escape($data['etcm_status_code']) . "', ";
        }
        if (!empty($data['date_payment'])) {
            $sql .= "date_payment='" . $this->db->escape($data['date_payment']) . "', ";
        }
        if (!empty($data['date_prepared'])) {
            $sql .= "date_prepared='" . $this->db->escape($data['date_prepared']) . "', ";
        }
        if (!empty($data['date_shipped'])) {
            $sql .= "date_shipped='" . $this->db->escape($data['date_shipped']) . "', ";
        }
        if (!empty($data['date_rated'])) {
            $sql .= "date_rated='" . $this->db->escape($data['date_rated']) . "', ";
        }
        if (!empty($data['rate_details'])) {
            $sql .= "rate_details='" . $this->db->escape($data['rate_details']) . "', ";
        }
        if (!empty($data['date_completed'])) {
            $sql .= "date_completed='" . $this->db->escape($data['date_completed']) . "', ";
        }
        if (!empty($data['date_cancelled'])) {
            $sql .= "date_cancelled='" . $this->db->escape($data['date_cancelled']) . "', ";
        }
        if (!empty($data['cancel_reason'])) {
            $sql .= "cancel_reason='" . $this->db->escape($data['cancel_reason']) . "', ";
        }
        $sql .= " date_modified=NOW()
         WHERE etcm_purchase_order_id = '" . (int)$data['etcm_purchase_order_id'] . "'";

        if (!empty($data['etcm_purchase_order_id'])) {
            $this->db->query($sql);
        }
    }

    public function getSObyEtcmId($etcm_purchase_order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_partner_sale_order WHERE etcm_purchase_order_id = '" . (int)$etcm_purchase_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getRelatedPIC($store_id)
    {
        $ids = [];
        $permission_name = 'service_partner/sale_order';
        $sql = "SELECT user_id FROM " . DB_PREFIX . "user_to_store WHERE store_id = '" . (int)$store_id . "'";
        $query = $this->db->query($sql);
        $users = $query->rows;
        foreach ($users as $user) {
            $user_group_permission = $this->db->query("SELECT permission FROM " . DB_PREFIX . "user_group WHERE user_group_id = (SELECT user_group_id FROM " . DB_PREFIX . "user WHERE user_id ='" . (int)$user['user_id'] . "' )");
            if ($user_group_permission->num_rows) {
                $result = json_decode($user_group_permission->row['permission'], true);

                $result = $result == null ? unserialize($user_group_permission->row['permission']) : $result;
                if (!empty($result['access'])) {
                    if (is_array($result['access'])) {
                        if (in_array($permission_name, $result['access'])) {
                            $ids[] = $user['user_id'];
                        }
                    }
                }
            }
        }

        return $ids;
    }

    public function getProductDetailByEtcmProductId($etcm_product_id)
    {
        $sql = "SELECT p.*,pd.name FROM " . DB_PREFIX . "etcm_service_partner_product_match pm 
        LEFT JOIN " . DB_PREFIX . "product p ON(p.product_id=pm.product_id)
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(pd.product_id=p.product_id AND pd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE pm.etcm_product_id = '" . (int)$etcm_product_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getPriceStockByIds($product_ids)
    {
        $sql = "SELECT p.product_id, p.price, pts.onhand_quantity FROM " . DB_PREFIX . "product p LEFT JOIN " . DB_PREFIX . "product_to_store pts ON(p.product_id = pts.product_id AND pts.store_id = '0') WHERE p.product_id IN ('" . implode("', '", $product_ids) . "')";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCarriers()
    {
        $sql = "SELECT carrier_id AS id, name FROM " . DB_PREFIX . "order_tracking_carriers";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
