<?php

class ModelAndroidServiceSetting extends Model
{
    public function getServices()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int) $this->session->data['language_id'] . "' WHERE 1";
        $sql .= " ORDER BY csd.name";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServiceInfo($id)
    {
        $info = $this->db->query("SELECT cs.clinicalservice_id AS service_id, en.name AS en_name, cn.name AS cn_name, cs.*
        FROM " . DB_PREFIX . "clinical_service cs
        LEFT JOIN " . DB_PREFIX . "clinical_service_description en ON(en.clinicalservice_id = cs.clinicalservice_id AND en.language_id = '1') 
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cn ON(cn.clinicalservice_id = cs.clinicalservice_id AND cn.language_id = '2')
        WHERE cs.clinicalservice_id = '" . (int)$id . "'")->row;

        if (!empty($info)) {
            $service_id = $info['clinicalservice_id'];

            $db_stores = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$service_id . "'")->rows;
            $stores = [];
            if (!empty($db_stores)) {
                foreach ($db_stores as $store) {
                    $stores[] = $store['store_id'];
                }
            } else {
                foreach (unserialize($info['store_id']) as $id) {
                    $stores[] = $id;
                }
            }

            $db_doctors = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$service_id . "'")->rows;
            $doctors = [];
            if (!empty($db_doctors)) {
                foreach ($db_doctors as $doctor) {
                    $doctors[] = $doctor['doctor_id'];
                }
            } else {
                foreach (unserialize($info['doctor_id']) as $id) {
                    $doctors[] = $id;
                }
            }

            $db_facilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'")->rows;
            $facilities = [];
            foreach ($db_facilities as $facility) {
                $facilities[] = $facility['facility_id'];
            }
            $result = $info;
            $result['stores']        = $stores;
            $result['doctors']       = $doctors;
            $result['facilities']    = $facilities;

            return $result;
        } else {
            return [];
        }
    }

    public function getDoctors()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE position = '2'";
        return $this->db->query($sql)->rows;
    }

    public function getFacilities()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "facility WHERE status = '1'";
        return $this->db->query($sql)->rows;
    }

    public function getStores()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "store WHERE store_id != 0";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTaxClasses()
    {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "tax_class");
        $tax_class_data = $query->rows;

        return $tax_class_data;
    }

    public function updateService($data)
    {
        if (!empty($data['service_id'])) {
            $service_id = $this->editService($data);
        } else {
            $service_id = $this->addService($data);
        }

        return $service_id;
    }

    private function addService($data)
    {
        $sql = "
		INSERT INTO " . DB_PREFIX . "clinical_service SET
			store_id	 = '" . $this->db->escape(serialize($data['stores'])) . "',
			doctor_id	 = '" . $this->db->escape(serialize($data['doctors'])) . "',
			type		 = '" . (int)$data['type'] . "',
			cs_minute	 = '" . (int)$data['cs_minute'] . "',
            status       = '" . (int)$data['status'] . "',
            enable_appointment = '" . (int)$data['enable_appointment'] . "',
            enable_etcm  = '" . (int)$data['enable_etcm'] . "',
			cs_session	 = '" . (int)$data['cs_session'] . "',
			price		 = '" . (float)$data['price'] . "',
			tax_class_id = '" . (int)$data['tax_class_id'] . "',
			createby	 = '" . (int)$this->session->data['user_id'] . "',
			createdate	 = NOW()
		";
        $query = $this->db->query($sql);

        $lastid = $this->db->getLastId();


        if (!empty($data['en_name'])) {
            $sql_en = "
			INSERT INTO " . DB_PREFIX . "clinical_service_description SET
            clinicalservice_id = '$lastid',
            language_id = '1',
            name = '" . $this->db->escape($data['en_name']) . "'
			";
            $this->db->query($sql_en);
        }

        if (!empty($data['cn_name'])) {
            $sql_cn = "
			INSERT INTO " . DB_PREFIX . "clinical_service_description SET
            clinicalservice_id = '$lastid',
            language_id = '2',
            name = '" . $this->db->escape($data['cn_name']) . "'
			";
            $this->db->query($sql_cn);
        }

        if (empty($data['cn_name']) && empty($data['en_name'])) {
            if (!empty($data['service_name'])) {
                $sql_en = "
                INSERT INTO " . DB_PREFIX . "clinical_service_description SET
                clinicalservice_id = '$lastid',
                language_id = '1',
                name = '" . $this->db->escape($data['service_name']) . "'
                ";
                $this->db->query($sql_en);

                $sql_cn = "
                INSERT INTO " . DB_PREFIX . "clinical_service_description SET
                clinicalservice_id = '$lastid',
                language_id = '2',
                name = '" . $this->db->escape($data['service_name']) . "'
                ";
                $this->db->query($sql_cn);
            }
        }


        foreach ($data['stores'] as $storeid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_store SET
            service_id = '" . (int)$lastid . "',
            store_id = '" . (int)$storeid . "'
            
            ");
        }

        foreach ($data['facilities'] as $facilityid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_facility SET
        service_id = '" . (int)$lastid . "',
        facility_id = '" . (int)$facilityid . "'
        
        ");
        }

        foreach ($data['doctors'] as $doctorid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_doctor SET
            service_id = '" . (int)$lastid . "',
            doctor_id = '" . (int)$doctorid . "'
            
            ");
        }

        return $lastid;
    }

    private function editService($data)
    {
        $sql = "
		UPDATE " . DB_PREFIX . "clinical_service SET
			store_id	 = '" . $this->db->escape(serialize($data['stores'])) . "',
			doctor_id	 = '" . $this->db->escape(serialize($data['doctors'])) . "',
			type		 = '" . (int)$data['type'] . "',
			cs_minute	 = '" . (int)$data['cs_minute'] . "',
            status       = '" . (int)$data['status'] . "',
            enable_appointment = '" . (int)$data['enable_appointment'] . "',
            enable_etcm  = '" . (int)$data['enable_etcm'] . "',
			cs_session	 = '" . (int)$data['cs_session'] . "',
			price		 = '" . (float)$data['price'] . "',
			tax_class_id = '" . (int)$data['tax_class_id'] . "',
			modifyby	 = '" . (int)$this->session->data['user_id'] . "',
			modifydate	 = NOW()
        WHERE clinicalservice_id = '" . (int)$data['service_id'] . "'
		";
        $query = $this->db->query($sql);

        $id = (int)$data['service_id'];

        if (!empty($data['en_name'])) {
            $sql_en = "
			UPDATE " . DB_PREFIX . "clinical_service_description SET
            name = '" . $this->db->escape($data['en_name']) . "'
            WHERE
				clinicalservice_id = '" . (int)$id . "'
				AND language_id = '1'
			";
            $this->db->query($sql_en);
        }
        if (!empty($data['cn_name'])) {
            $sql_cn = "
			UPDATE " . DB_PREFIX . "clinical_service_description SET
            name = '" . $this->db->escape($data['cn_name']) . "'
            WHERE
				clinicalservice_id = '" . (int)$id . "'
				AND language_id = '2'
			";
            $this->db->query($sql_cn);
        }

        if (empty($data['cn_name']) && empty($data['en_name'])) {
            if (!empty($data['service_name'])) {
                $sql_name = "
                UPDATE " . DB_PREFIX . "clinical_service_description SET
                name = '" . $this->db->escape($data['service_name']) . "'
                WHERE
                    clinicalservice_id = '" . (int)$id . "'
                    AND language_id = '" . (int)$this->session->data['language_id'] . "'
                ";
                $this->db->query($sql_name);
            }
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$id . "'");

        foreach ($data['stores'] as $storeid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_store SET
            service_id = '" . (int)$id . "',
            store_id = '" . (int)$storeid . "'
            
            ");
        }

        foreach ($data['facilities'] as $facilityid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_facility SET
        service_id = '" . (int)$id . "',
        facility_id = '" . (int)$facilityid . "'
        
        ");
        }

        foreach ($data['doctors'] as $doctorid) {
            $this->db->query("INSERT INTO " . DB_PREFIX . "service_to_doctor SET
            service_id = '" . (int)$id . "',
            doctor_id = '" . (int)$doctorid . "'
            
            ");
        }

        return $id;
    }

    public function delete_clinical_service($clinicalservice_id)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_store WHERE service_id = '" . (int)$clinicalservice_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$clinicalservice_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_to_doctor WHERE service_id = '" . (int)$clinicalservice_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_service WHERE clinicalservice_id = '" . (int) $clinicalservice_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_service_description WHERE clinicalservice_id = '" . (int) $clinicalservice_id . "'");
    }
}
