<?php

class ModelAndroidServiceService extends Model
{
    public function getServiceList($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ";
            $search_statement .= "cd.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
        }

        $sql = "SELECT 
        c.clinicalservice_id AS id,
        CONCAT(cd.name,' (',c.cs_minute,' minutes',')') AS label,
        cd.name AS name,
        c.cs_minute AS service_minute,
        CONCAT('RM',c.price) AS price
        FROM
        " . DB_PREFIX . "clinical_service c
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        $search_statement
        ORDER BY label
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceAvailableList()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service WHERE doctor_id <> 'a:0:{}'";
        $query = $this->db->query($sql);
        if (!empty($query->rows)) {
            $service_ids = [];
            foreach ($query->rows as $row) {
                $store_ids =  unserialize($row['store_id']);
                if (in_array($this->session->data['store_id'], $store_ids)) {
                    $service_ids[] = $row['clinicalservice_id'];
                }
            }

            //get selected service_id info
            $sql = "SELECT 
                    c.clinicalservice_id AS id,
                    CONCAT(cd.name,' (',c.cs_minute,' minutes',')') AS label,
                    cd.name AS name,
                    c.cs_minute AS service_minute,
                    CONCAT('RM',c.price) AS price
                    FROM
                    " . DB_PREFIX . "clinical_service c
                    LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
                    WHERE c.clinicalservice_id IN (" . implode(",", $service_ids) . ")
                    ORDER BY label";

            $query = $this->db->query($sql);
            return $query->rows;
        } else {
            return array();
        }
    }

    public function getService($service_id)
    {
        $sql = "SELECT 
        c.*,
        cd.name
        FROM 
        " . DB_PREFIX . "clinical_service c
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        
        AND c.clinicalservice_id = '" . (int)$service_id . "'
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $service = $query->row;
            $info = array(
                "id"             => $service["clinicalservice_id"],
                "label"          => $service["name"],
                "service_minute" => $service["cs_minute"],
                "price"          => $service["price"],
            );
            $info['doctors'] = $this->getDoctors();
            $acupunture_points = array();
            if (!empty($service['enable_acupuncture']) && $service['enable_acupuncture'] == '1') {
                $acupunture_points = $this->getAcupuncturePoints();
            }
            $info['acupuncture_points'] = $acupunture_points;
            return $info;
        } else {
            return null;
        }
    }

    public function getDoctors()
    {
        $sql = "SELECT 
        user_id AS id,
        TRIM(CONCAT(firstname,' ',lastname)) AS name
        FROM " . DB_PREFIX . "user
        WHERE position='2'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAcupuncturePoints()
    {
        $sql = "SELECT 
        a.acupuncture_id AS id,
        an.name
        FROM " . DB_PREFIX . "acupuncture a
        LEFT JOIN " . DB_PREFIX . "acupuncture_name an ON(a.acupuncture_id = an.acupuncture_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE a.parent_id > 0
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceFormInfo($service_form_id)
    {
        $sql = "SELECT *
        FROM " . DB_PREFIX . "service_form
        WHERE service_form_id = '" . (int)$service_form_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    // public function getCustomer($customer_id)
    // {
    //     $sql = "SELECT *,TRIM(CONCAT(firstname,' ',lastname)) AS customer_name FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
    //     $query = $this->db->query($sql);
    //     return $query->row;
    // }

    public function getCustomer($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getServiceFormList($data)
    {

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;
        $filter_customer_id = isset($data['filter_customer_id']) ? $data['filter_customer_id'] : false;
        $filter_customer_ic = isset($data['filter_customer_ic']) ? $data['filter_customer_ic'] : false;
        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;

        $filter_name = isset($data['filter_name']) ? $data['filter_name'] : false;
        $filter_card_no = isset($data['filter_card_no']) ? $data['filter_card_no'] : false;

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;





        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        //prepare where clause statement

        $filter_status_statement = $filter_status ? "AND sf.serviceform_action = '$filter_status'" : "";
        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND sf.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";
        $filter_customer_id_statement = $filter_customer_id ? "AND sf.customer_id = '" . (int) $filter_customer_id . "'" : "";
        $filter_customer_ic_statement = $filter_customer_ic ? "AND c.customer_ic LIKE '%" . $filter_customer_ic . "%'" : "";
        $filter_date_from_statement = $filter_date_from ? "AND DATE(sf.service_date) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(sf.service_date) <= DATE('" . $filter_date_to . "')" : "";


        $filter_name_statement = $filter_name ? "AND CONCAT(c.firstname , ' ', c.lastname) LIKE '%" . $filter_name . "%'" : "";
        $filter_card_no_statement = $filter_card_no ? "AND c.customer_card LIKE '%" . $filter_name . "%'" : "";

        $sql = "
            SELECT
            
                sf.service_form_id,
                sf.service_date,
                sf.invoice_prefix,
                sf.date_added,
                sf.remark,
                sf.total_price,
                sf.consultation,
                sf.net_amount,
                sf.store_id,
                sf.customer_id,
                sf.hide,
                (SELECT st.name FROM " . DB_PREFIX . "store st WHERE st.store_id = sf.store_id ) AS store_name,
                sf.order_invoice_prefix,
                sf.serviceform_action,
                sf.order_action,
                os.name as status,
                os2.name as payment_status,
                o.payment_method,
                c.customer_ic,
                c.telephone,
                c.occupation,
                c.allergic,
                c.gender,
                c.age,
                c.customer_card,
                c.customer_group_id,
                cgd.name as group_name,

                CONCAT(c.firstname , ' ', c.lastname) AS 'customer_name',
                CONCAT(u1.firstname , ' ', u1.lastname) AS 'add_by'
                

        FROM

        " . DB_PREFIX . "service_form sf

        LEFT JOIN " . DB_PREFIX . "order o ON(sf.order_id = o.order_id )

        LEFT JOIN " . DB_PREFIX . "customer c ON(sf.customer_id = c.customer_id)

        LEFT JOIN " . DB_PREFIX . "user u1 ON(sf.add_by = u1.user_id)

        LEFT JOIN " . DB_PREFIX . "customer_group_description cgd ON(c.customer_group_id = cgd.customer_group_id AND cgd.language_id='1')

        LEFT JOIN " . DB_PREFIX . "order_status os ON(sf.serviceform_action = os.order_status_id AND os.language_id='1')

        LEFT JOIN " . DB_PREFIX . "order_status os2 ON(sf.order_action = os2.order_status_id AND os2.language_id='1')


        WHERE 1
        AND c.customer_id IS NOT NULL
        AND sf.store_id = '" . (int)$this->session->data['store_id'] . "'  
        
        $filter_status_statement
        $filter_invoice_prefix_statement
        $filter_customer_id_statement
        $filter_customer_ic_statement
        $filter_date_from_statement
        $filter_date_to_statement
        $filter_name_statement
        $filter_card_no_statement
        AND sf.hide=0
        ORDER BY sf.service_date DESC, sf.service_form_id DESC
		LIMIT $start, $limit";


        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getFilterStatus()
    {
        $sql = "SELECT sf.serviceform_action as id, os.name FROM " . DB_PREFIX . "service_form sf 
        LEFT JOIN " . DB_PREFIX . "order_status os ON(sf.serviceform_action = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE sf.serviceform_action > 0
        GROUP BY sf.serviceform_action ORDER BY sf.serviceform_action";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return array();
        }
    }

    public function addService1($data)
    {
        $this->load->model('setting/setting');
        $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $data['store_id']));

        $this->db->query("
        INSERT INTO " . DB_PREFIX . "service_form SET
        customer_id ='" . (int) $data['customer_id'] . "',
        invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
        serviceform_action='" . (int) 1 . "',
        order_action = '" . (int) 17 . "',
        store_id = '" . (int) $data['store_id'] . "',
        add_by = '" . (int) $data['user_id'] . "',
        service_date = NOW(),
        modifi_by = '" . (int) $data['user_id'] . "',
        date_added = NOW(),
        date_modified= NOW()

        ");

        $service_form_id = $this->db->getLastId();

        if ($service_form_id != 0) {
            $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $data['store_id']));
        }
        return $service_form_id;
    }

    public function addServiceCustomer($data)
    {
        $customer_id = $data['customer']['customer_id'];
        if (empty($customer_id)) {
            //if new customer,need to add customer first in table
            $customer_response = $this->addCustomer($data['customer']);
            $customer_id = $customer_response['customer_id'];
        } else {
            $customer_response = $this->editCustomer($data['customer']);
        }

        $serviceform_id = $data['serviceform_id'];
        if (empty($serviceform_id)) {
            $this->load->model('setting/setting');
            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $data['store_id']));

            $this->db->query("
            INSERT INTO " . DB_PREFIX . "service_form SET
            customer_id = '" . (int) $customer_id . "',
            user_id '" . (int) $data['staff_id'] . "',
            invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
            serviceform_action='" . (int) 1 . "',
            order_action = '" . (int) 17 . "',
            store_id = '" . (int) $data['store_id'] . "',
            add_by = '" . (int) $data['user_id'] . "',
            service_date = NOW(),
            modifi_by = '" . (int) $data['user_id'] . "',
            date_added = NOW(),
            date_modified= NOW()        
            ");

            $serviceform_id = $this->db->getLastId();

            if ($serviceform_id != 0) {
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $data['store_id']));
            }
        } else {
            $this->db->query("
            UPDATE " . DB_PREFIX . "service_form SET
            customer_id = '" . (int) $customer_id . "',
            store_id = '" . (int) $data['store_id'] . "',
            modifi_by = '" . (int) $data['user_id'] . "',
            date_modified= NOW() 
            WHERE service_form_id ='" . (int)$serviceform_id . "' 
            ");
        }
        return array(
            "serviceform_id" => strval($serviceform_id),
            "customer_id" =>  strval($customer_response['customer_id']),
        );
    }

    public function addCustomer($data)
    {
        do {
            $insert_customer = false;
            $unique_id = md5(rand() . $data['customer_ic'] . time());
            $customer_row = $this->check_unique_id($unique_id);
            $this->load->model('setting/setting');

            $customer_card_no = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));

            if (empty($data['customer_card'])) {
                $customer_card = $customer_card_no;
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'sale/customer', 'store' => $this->session->data['store_id']));
            } else {
                $customer_card = $data['customer_card'];
            }

            if (empty($customer_row)) {
                $insert_customer = true;
                $this->db->query("
                INSERT INTO " . DB_PREFIX . "customer SET
                  unique_customer_id ='" . $this->db->escape($unique_id) . "',
                  firstname = '" . $this->db->escape($data['customer_name']) . "',
                  gender ='" . $this->db->escape($data['gender']) . "',
                  customer_ic ='" . $this->db->escape($data['customer_ic']) . "',
                  telephone ='" . $this->db->escape($data['telephone']) . "',
                  dob ='" . $this->db->escape($data['dob']) . "',
                  customer_card = '" . $this->db->escape($customer_card) . "',
                  email='" . $this->db->escape($data['email']) . "',
                  status = '1',
                  approved ='1',
                  safe = '0',
                  date_added =NOW()
                ");
            }
        } while ($insert_customer == false);
        $customer_id = $this->db->getLastId();

        return array("customer_id" => $customer_id);
    }

    public function editCustomer($data)
    {
        $customer_id = $data['customer_id'];

        $this->db->query("
        UPDATE " . DB_PREFIX . "customer SET
         firstname='" . $this->db->escape($data['customer_name']) . "',
         gender = '" . $this->db->escape($data['gender']) . "',
         dob='" . $this->db->escape($data['dob']) . "',
         customer_card = '" . $this->db->escape($data['customer_card']) . "',
         customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
         telephone = '" . $this->db->escape($data['telephone']) . "',
         email ='" . $this->db->escape($data['email']) . "'
         WHERE customer_id = '" . (int)$customer_id . "'    
        ");

        return array("customer_id" => $customer_id);
    }

    public function editServiceForm($id, $data, $services, $taxes = array())
    {
        $survive_service_id = array();

        //post data
        $action  = $data['action'];

        $service_subtotal = 0;
        $service_total = 0;
        $service_gst  = 0;

        // var_dump($services);
        // die();
        foreach ($services as $service_id => $service) {
            $survive_service_id[] = $service_id;

            $starttime_mil         = $service['starttime'];
            $starttime_seconds     = $starttime_mil / 1000;
            $starttime_datetime = date("Y-m-d H:i:s", $starttime_seconds);

            $endtime_mil         = $service['endtime'];
            $endtime_seconds     = $endtime_mil / 1000;
            $endtime_datetime     = date("Y-m-d H:i:s", $endtime_seconds);

            if ($this->serviceItemExists($id, $service_id)) {
                $sql = "
				UPDATE " . DB_PREFIX . "service_item SET
				service_form_id = '" . (int) $id . "',
				clinicalservice_id = '" . (int)$service_id . "',
				servicename ='" . $this->db->escape($service['service_name']) . "',
				serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
				user_id = '" . (int)$service['staff_id'] . "',
				start_time				= '" . $starttime_datetime . "',
				end_time				= '" .  $endtime_datetime . "',
				price = '" . (float)$service['price'] . "',
				tax_class_id = '" . (int)$service['tax_class_id'] . "',
				tax_code = '" . $this->db->escape($service['tax_code']) . "',
				tax_format = '" . $this->db->escape($service['tax_format']) . "',
				gst = '" . (float)$service['tax'] . "',
				net_amount = '" . (float)$service['net_amount'] . "',
				total = '" . (float)$service['total'] . "',
				modifi_by = '" . (int)$this->session->data['user_id'] . "',
				date_modified = NOW()
				WHERE service_form_id 	= '$id'
				AND clinicalservice_id 	= $service_id";

                $service_subtotal += $service['net_amount'];
                $service_total += $service['total'];
                $service_gst   += $service['tax'];


                $query = $this->db->query($sql);

                // get the service item
                $item_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$id . "' AND clinicalservice_id = '" . (int)$service_id . "'");
                $item_row = $item_query->row;

                $service_Item_id = $item_row['service_Item_id'];

                $this->db->query("DELETE FROM " . DB_PREFIX . "service_item_acupuncture_point WHERE service_Item_id = '" . (int)$service_Item_id . "'");

                if (!empty($data['acupuncture'][$service_id])) {
                    foreach ($data['acupuncture'][$service_id] as $acupuncture_point) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
										  SET service_Item_id = '" . (int)$service_Item_id . "',
										  	  acupuncture_id = '" . (int)$acupuncture_point['acupuncture_point_id'] . "',
											  num_of_acupuncture = '" . (int)$acupuncture_point['num_of_acupuncture'] . "'");
                    }
                }
            } else {
                $sql = "
				INSERT INTO " . DB_PREFIX . "service_item SET
				service_form_id = '" . (int) $id . "',
				clinicalservice_id = '" . (int)$service_id . "',
				servicename ='" . $this->db->escape($service['service_name']) . "',
				serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
				user_id = '" . (int)$service['staff_id'] . "',
				price = '" . (float)$service['price'] . "',
				tax_class_id = '" . (int)$service['tax_class_id'] . "',
				tax_code = '" . $this->db->escape($service['tax_code']) . "',
				tax_format = '" . $this->db->escape($service['tax_format']) . "',
				gst = '" . (float)$service['tax'] . "',
				net_amount = '" . (float)$service['net_amount'] . "',
				total = '" . (float)$service['total'] . "',
				modifi_by = '" . (int)$this->session->data['user_id'] . "',
				date_modified = NOW()";

                $service_subtotal += $service['net_amount'];
                $service_total += $service['total'];
                $service_gst   += $service['tax'];
                // start_time				= '" . $starttime_datetime . "',
                // end_time				= '" .  $endtime_datetime . "',

                // var_dump($sql);
                // die();
                $query = $this->db->query($sql);

                $service_item_id = $this->db->getLastId();

                if (!empty($data['acupuncture'][$service_id])) {
                    foreach ($data['acupuncture'][$service_id] as $acupuncture_point) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
										  SET service_Item_id = '" . (int)$service_item_id . "',
										  	  acupuncture_id = '" . (int)$acupuncture_point['acupuncture_point_id'] . "',
											  num_of_acupuncture = '" . (int)$acupuncture_point['num_of_acupuncture'] . "'");
                    }
                }
            }
        }
        if (!empty($survive_service_id)) {
            $service_item_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = $id AND clinicalservice_id NOT IN(" . implode(',', $survive_service_id) . ")");

            $service_item_rows = $service_item_query->rows;

            foreach ($service_item_rows as $row) {
                $service_Item_id = $row['service_Item_id'];

                $this->db->query("DELETE FROM " . DB_PREFIX . "service_item WHERE service_Item_id = '" . (int)$service_Item_id . "'");
                $this->db->query("DELETE FROM " . DB_PREFIX . "service_item_acupuncture_point WHERE service_Item_id = '" . (int)$service_Item_id . "'");
            }
        }

        //general update

        $sql = "
		UPDATE " . DB_PREFIX . "service_form SET
        serviceform_action 	= $action, 
        remark = '" . $this->db->escape($data['remark']) . "',
		total_price = '" . (float)$service_total . "',
		net_amount = '" . (float)$service_subtotal . "',
		t_gst = '" . (float)$service_gst . "',
		modifi_by 			= '" . $this->session->data['user_id'] . "',
		date_modified 			= NOW()
		WHERE service_form_id 	= '$id'
		";
        $query = $this->db->query($sql);

        // Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_total WHERE service_form_id = '" . (int) $id . "' AND id ='1' ");

        if (isset($taxes)) {
            foreach ($taxes as $order_total) {
                $tcode =  !empty($order_total['tax_code']) ? $order_total['tax_code'] : '';
                $tkey  = !empty($order_total['tax_key']) ? $order_total['tax_key'] : '';


                $this->db->query("
				INSERT INTO " . DB_PREFIX . "service_total
				SET
				service_form_id = '" . (int) $id . "', 
				id ='1',
				code = '" . $this->db->escape($order_total['code']) . "',
				tax_code = '" . $this->db->escape($tcode) . "',
				tax_key = '" . (int)$tkey . "',
				title = '" . $this->db->escape($order_total['title']) . "',
				`value` = '" . (float) $order_total['value'] . "',
				sort_order = '" . (int) $order_total['sort_order'] . "'
				");
            }
        }

        // return $id;
    }

    public function check_unique_id($unique_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE unique_customer_id = '" . $this->db->escape($unique_id) . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function serviceItemExists($serviceform_id, $clinicalservice_id)
    {
        $sql = "
		SELECT COUNT(*) AS num
		FROM " . DB_PREFIX . "service_item
		WHERE service_form_id = $serviceform_id
		AND clinicalservice_id = $clinicalservice_id
		";
        $query = $this->db->query($sql);

        return $query->row["num"] > 0;
    }

    public function getServiceHistoryList($data)
    {
        $sort   = isset($data['sort']) ? $data['sort'] : "date_added";
        $order  = isset($data['order']) ? $data['order'] : "DESC";

        $filter_date_from = isset($data['filter_date_from']) ? $data['filter_date_from'] : false;
        $filter_date_from_str = trim($filter_date_from);
        $filter_date_from = (!empty($filter_date_from_str)) ? date("Y-m-d", strtotime($filter_date_from)) . " 00:00:00" : false;

        $filter_date_to = isset($data['filter_date_to']) ? $data['filter_date_to'] : false;
        $filter_date_to_str = trim($filter_date_to);
        $filter_date_to = (!empty($filter_date_to_str)) ? date("Y-m-d", strtotime($filter_date_to)) . " 23:59:59" : false;

        $filter_invoice_prefix = isset($data['filter_invoice_prefix']) ? $data['filter_invoice_prefix'] : false;
        $filter_store_id = isset($data['filter_store_id']) ? $data['filter_store_id'] : false;

        $filter_status = isset($data['filter_status']) ? $data['filter_status'] : false;

        $filter_total_price = isset($data['filter_total_price']) ? $data['filter_total_price'] : false;


        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        //prepare where clause statement

        $filter_date_from_statement = $filter_date_from ? "AND DATE(c.date_added) >= DATE('" . $filter_date_from . "')" : "";

        $filter_date_to_statement = $filter_date_to ? "AND DATE(c.date_added) <= DATE('" . $filter_date_to . "')" : "";

        $filter_invoice_prefix_statement = $filter_invoice_prefix ? "AND c.invoice_prefix LIKE '%" . $filter_invoice_prefix . "%'" : "";

        $filter_store_id_statement = $filter_store_id !== false ? "AND c.store_id in (" . $filter_store_id . ")" : "";

        $filter_status_statement = $filter_status ? "AND c.status = '$filter_status'" : "";

        $filter_total_price_statement = $filter_total_price ? "AND c.total_price LIKE '%" . $filter_total_price . "%'" : "";

        $sql = "
        SELECT *
        FROM(
            SELECT
            sf.service_form_id,
            sf.service_date,
            sf.invoice_prefix,
            sf.store_id,
            sf.remark,
            sf.date_added,
            sf.customer_id,
            os.name as status,
            sf.total_price,
            sf.serviceform_action,
            sf.date_modified,
            sf.hide,
            c.telephone,
            c.age,
            si.servicename,
            si.price,
            si.service_time,
            si.start_time,
            si.end_time,
            si.service_period,
            si.serviceminutes,
            o.invoice_prefix AS order_no,
            os2.name as payment_status,
            o.payment_method,
            o.date_added AS payment_date,


            CONCAT(c.firstname , ' ', c.lastname) AS 'customer_name',
            CONCAT(u1.firstname , ' ', u1.lastname) AS 'modifi_by'

            FROM

            " . DB_PREFIX . "service_form sf

            LEFT JOIN " . DB_PREFIX . "customer c ON(sf.customer_id = c.customer_id)

            LEFT JOIN " . DB_PREFIX . "order_status os ON(sf.serviceform_action = os.order_status_id AND os.language_id='1')

            LEFT JOIN " . DB_PREFIX . "order_status os2 ON(sf.order_action = os2.order_status_id AND os2.language_id='1')

            LEFT JOIN " . DB_PREFIX . "service_item si ON(sf.service_form_id = si.service_form_id)

            LEFT JOIN " . DB_PREFIX . "user u1 ON(sf.modifi_by = u1.user_id)

            LEFT JOIN " . DB_PREFIX . "order o ON(sf.order_id = o.order_id)



            WHERE 1
            AND c.customer_id IS NOT NULL

            )c
  
            WHERE 1
            
            $filter_date_from_statement
            $filter_date_to_statement
            $filter_invoice_prefix_statement
            $filter_store_id_statement 
            $filter_status_statement
            $filter_total_price_statement
            AND c.hide = 0

            ORDER BY c.$sort $order
            LIMIT $start, $limit";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getServiceItems($service_form_id)
    {
        $sql = "SELECT si.*,(CONCAT(firstname,' ',lastname)) AS doctor_name FROM " . DB_PREFIX . "service_item si 
        LEFT JOIN " . DB_PREFIX . "user u ON(si.user_id = u.user_id)
        WHERE service_form_id = '" . (int)$service_form_id . "'";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceItem($service_item_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_item 
        WHERE service_Item_id = '" . (int)$service_item_id . "'";

        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getAcupuncturePointByServiceItemId($service_item_id)
    {
        $sql = "SELECT an.name AS acupuncture_point,
					   siap.acupuncture_id,
					   siap.num_of_acupuncture
				FROM " . DB_PREFIX . "service_item_acupuncture_point siap
				LEFT JOIN " . DB_PREFIX . "acupuncture_name an
				ON an.acupuncture_id = siap.acupuncture_id
				AND an.language_id = '" . $this->session->data['language_id'] . "'
				WHERE siap.service_Item_id = '" . (int)$service_item_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getClinicalServiceList($data)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_service cs LEFT JOIN " . DB_PREFIX . "clinical_service_description csd ON csd.clinicalservice_id = cs.clinicalservice_id AND csd.language_id = '" . (int)$this->session->data['language_id'] . "' WHERE 1";

        if (!empty($data['filter_name'])) {
            $sql .= " AND csd.name LIKE '%" . $data['filter_name'] . "%'";
        }

        $sort_data = array(
            'name',
            'cs_minute',
            'price',
            'type'
        );

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY csd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getMeridianList($data)
    {
        $acupuncture_result = array();

        $sort     = isset($data['sort']) ? $data['sort'] : "a.acupuncture_id";
        $order     = isset($data['order']) ? $data['order'] : "ASC";

        $limit_statement = "";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $filter_acupuncture_statement = !empty($data['filter_meridian']) ? "AND a.parent_id = '" . (int)$data['filter_meridian'] . "'" : "";

        // $filter_meridian_statement = !empty($data['filter_meridian_statement']) ? "AND a.parent_id LIKE '%" . $this->db->escape($data['filter_meridian_statement']) . "%'" : "";

        $filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND an.name LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";
        // $filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND CONCAT(cn.name,' ',en.name) LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

        $filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

        if (!empty($data['filter_body_part'])) {
            $ac_point_arr = array();

            // select all acupuncture points
            $ac_point_query = $this->db->query("SELECT *
        										FROM " . DB_PREFIX . "acupuncture
        										WHERE parent_id > 0");

            $ac_point_rows = $ac_point_query->rows;

            // loop the acupuncture points and find out all the acupuncture point of the body part
            foreach ($ac_point_rows as $row) {
                $ac_point_acupuncture_parts = unserialize($row['acupuncture_parts']);

                if (in_array($data['filter_body_part'], $ac_point_acupuncture_parts)) {
                    $ac_point_arr[] = $row['acupuncture_id'];
                }
            }

            $ac_point_str = implode(',', $ac_point_arr);

            $acupuncture_query = $this->db->query("SELECT *
            FROM " . DB_PREFIX . "acupuncture a
            LEFT JOIN " . DB_PREFIX . "acupuncture_name an
            ON an.acupuncture_id = a.acupuncture_id
            AND an.language_id = '" . $this->session->data['language_id'] . "'
             WHERE a.parent_id > 0
            AND a.acupuncture_id IN(" . $ac_point_str . ")
            $filter_acupuncture_statement
            $filter_acupuncture_point_statement
            $filter_acupuncture_point_code_statement
            ORDER BY $sort $order
            $limit_statement");

            // $acupuncture_query = $this->db->query("SELECT a.*, cn.name as cn_name, en.name as en_name
            // FROM " . DB_PREFIX . "acupuncture a
            // LEFT JOIN " . DB_PREFIX . "acupuncture_name cn
            // ON (cn.acupuncture_id = a.acupuncture_id AND cn.language_id='2')
            // LEFT JOIN " . DB_PREFIX . "acupuncture_name en ON (en.acupuncture_id = a.acupuncture_id  AND en.language_id='1')
            // WHERE a.parent_id > 0
            // AND a.acupuncture_id IN(" . $ac_point_str . ")
            // $filter_acupuncture_statement
            // $filter_acupuncture_point_statement
            // $filter_acupuncture_point_code_statement
            // ORDER BY $sort $order
            // $limit_statement");

            $acupuncture_rows = $acupuncture_query->rows;

            foreach ($acupuncture_rows as $row) {
                $parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->session->data['language_id'] . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

                $parent_name = $parent_query->row['name'];

                $acupuncture_result[] = array(
                    'acupuncture_id'        => $row['acupuncture_id'],
                    'name'                    => $row['name'],
                    // 'name'                    => $row['cn_name'] . ' ' . $row['en_name'],
                    'code'                    => $row['code'],
                    'meridian'                => $parent_name,
                    'location'                => $row['location'],
                    'ways'                    => $row['ways'],
                    'symptoms'                => $row['symptoms']
                );
            }
        } else {
            $acupuncture_query = $this->db->query("SELECT *
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name an
									ON an.acupuncture_id = a.acupuncture_id
									AND an.language_id =  '" . $this->session->data['language_id'] . "'
									WHERE a.parent_id > 0
									$filter_acupuncture_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement
									ORDER BY $sort $order
									$limit_statement");

            // $acupuncture_query = $this->db->query("SELECT a.*, cn.name as cn_name, en.name as en_name
            // 						FROM " . DB_PREFIX . "acupuncture a
            // 						LEFT JOIN " . DB_PREFIX . "acupuncture_name cn
            // 						ON (cn.acupuncture_id = a.acupuncture_id)
            //                         LEFT JOIN " . DB_PREFIX . "acupuncture_name en ON (en.acupuncture_id = a.acupuncture_id)
            //                         language_id = '" . $this->session->data['language_id'] . "'
            // 						WHERE a.parent_id > 0
            // 						$filter_acupuncture_statement
            // 						$filter_acupuncture_point_statement
            // 						$filter_acupuncture_point_code_statement
            // 						ORDER BY $sort $order
            // 						$limit_statement");

            $acupuncture_rows = $acupuncture_query->rows;

            foreach ($acupuncture_rows as $row) {
                $parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id='" . (int)$this->session->data['language_id'] . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

                $parent_name = $parent_query->row['name'];

                $acupuncture_result[] = array(
                    'acupuncture_id'        => $row['acupuncture_id'],
                    'name'                    => $row['name'],
                    // 'name'                    => $row['cn_name'] . ' ' . $row['en_name'],
                    'code'                    => $row['code'],
                    'meridian'                => $parent_name,
                    'location'                => $row['location'],
                    'ways'                    => $row['ways'],
                    'symptoms'                => $row['symptoms']
                );
            }
        }
        // }

        return $acupuncture_result;
    }

    public function getBodyList($data)
    {
        $acupuncture_result = array();

        $sort     = isset($data['sort']) ? $data['sort'] : "a.acupuncture_id";
        $order     = isset($data['order']) ? $data['order'] : "ASC";

        $limit_statement = "";
        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        // $filter_meridian_statement = !empty($data['filter_meridian']) ? "AND a.parent_id = '" . (int)$data['filter_meridian'] . "'" : "";

        $filter_meridian_statement = !empty($data['filter_meridian_statement']) ? "AND a.parent_id LIKE '%" . $this->db->escape($data['filter_meridian_statement']) . "%'" : "";

        $filter_acupuncture_point_statement = !empty($data['filter_acupuncture_point']) ? "AND CONCAT(cn.name,' ',en.name) LIKE '%" . $this->db->escape($data['filter_acupuncture_point']) . "%'" : "";

        $filter_acupuncture_point_code_statement = !empty($data['filter_acupuncture_point_code']) ? "AND a.code LIKE '%" . $this->db->escape($data['filter_acupuncture_point_code']) . "%'" : "";

        // if (!empty($data['filter_body_part'])) {
        //     $ac_point_arr = array();

        //     // select all acupuncture points
        //     $ac_point_query = $this->db->query("SELECT *
        // 										FROM " . DB_PREFIX . "acupuncture
        // 										WHERE parent_id > 0");

        //     $ac_point_rows = $ac_point_query->rows;

        //     // loop the acupuncture points and find out all the acupuncture point of the body part
        //     foreach ($ac_point_rows as $row) {
        //         $ac_point_acupuncture_parts = unserialize($row['acupuncture_parts']);

        //         if (in_array($data['filter_body_part'], $ac_point_acupuncture_parts)) {
        //             $ac_point_arr[] = $row['acupuncture_id'];
        //         }
        //     }

        //     $ac_point_str = implode(',', $ac_point_arr);

        //     $acupuncture_query = $this->db->query("SELECT *
        // 							FROM " . DB_PREFIX . "acupuncture a
        // 							LEFT JOIN " . DB_PREFIX . "acupuncture_name an
        // 							ON an.acupuncture_id = a.acupuncture_id
        // 							AND an.language_id = '" . $this->session->data['language_id'] . "' WHERE a.parent_id > 0
        // 							AND a.acupuncture_id IN(" . $ac_point_str . ")
        // 							$filter_acupuncture_statement
        // 							$filter_acupuncture_point_statement
        // 							$filter_acupuncture_point_code_statement
        // 							ORDER BY $sort $order
        // 							$limit_statement");

        //     $acupuncture_rows = $acupuncture_query->rows;

        //     foreach ($acupuncture_rows as $row) {
        //         $parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id = '" . $this->session->data['language_id'] . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

        //         $parent_name = $parent_query->row['name'];

        //         $acupuncture_result[] = array(
        //             'acupuncture_id'        => $row['acupuncture_id'],
        //             'name'                    => $row['name'],
        //             'code'                    => $row['code'],
        //             'jingluo'                => $parent_name,
        //             'location'                => $row['location'],
        //             'ways'                    => $row['ways'],
        //             'symptoms'                => $row['symptoms']
        //         );
        //     }
        // } else {
        $acupuncture_query = $this->db->query("SELECT a.*, cn.name as cn_name, en.name as en_name
									FROM " . DB_PREFIX . "acupuncture a
									LEFT JOIN " . DB_PREFIX . "acupuncture_name cn
									ON (cn.acupuncture_id = a.acupuncture_id AND cn.language_id='2')
                                    LEFT JOIN " . DB_PREFIX . "acupuncture_name en ON (en.acupuncture_id = a.acupuncture_id  AND en.language_id='1')
									WHERE a.parent_id > 0
									$filter_meridian_statement
									$filter_acupuncture_point_statement
									$filter_acupuncture_point_code_statement
									ORDER BY $sort $order
									$limit_statement");

        $acupuncture_rows = $acupuncture_query->rows;

        foreach ($acupuncture_rows as $row) {
            $parent_query = $this->db->query("SELECT name FROM " . DB_PREFIX . "acupuncture_name WHERE language_id='" . (int)$this->session->data['language_id'] . "' AND acupuncture_id = '" . $row['parent_id'] . "'");

            $parent_name = $parent_query->row['name'];

            $acupuncture_result[] = array(
                'acupuncture_id'        => $row['acupuncture_id'],
                'name'                    => $row['cn_name'] . ' ' . $row['en_name'],
                'code'                    => $row['code'],
                'meridian'                => $parent_name,
                'location'                => $row['location'],
                'ways'                    => $row['ways'],
                'symptoms'                => $row['symptoms']
            );
        }
        // }

        return $acupuncture_result;
    }

    public function getacupunctureBodyList()
    {

        $sql = "SELECT a.acupuncture_id, an.name, a.image 
				FROM " . DB_PREFIX . "acupuncture a
				LEFT JOIN " . DB_PREFIX . "acupuncture_name an
				ON an.acupuncture_id = a.acupuncture_id
				AND an.language_id = '" . (int)$this->session->data['language_id'] . "'
				WHERE a.parent_id = 0";

        $query = $this->db->query($sql);
        // }
        return $query->rows;
    }

    public function getSummaryInfo($service_form_id)
    {
        // $sql = "SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$service_form_id . "'";

        $sql = "SELECT si.*,(CONCAT(firstname,' ',lastname)) AS doctor_name FROM " . DB_PREFIX . "service_item si 
        LEFT JOIN " . DB_PREFIX . "user u ON(si.user_id = u.user_id)
        WHERE service_form_id = '" . (int)$service_form_id . "'";

        $query = $this->db->query($sql);

        if (!empty($query->row)) {
            $service = $query->row;
            $info = array(
                "servicename" => $service['servicename'],
                "serviceminutes" => $service['serviceminutes'],
                'start_time' => $service['start_time'],
                'end_time' => $service['end_time'],
                'doctor' =>  array("id" => $service['user_id'], "name" => $service['doctor_name']),
                // 'price'    => $service['price'],

            );

            // $info['doctor'] = $this->getDoctors();
            $totals = $this->getServiceTotals($service['service_form_id']);
            $info['totals'] = $totals;
            return $info;
        } else {
            return null;
        }
    }

    public function getServiceTotals($service_form_id)
    {
        $query = $this->db->query("SELECT code, title, value FROM " . DB_PREFIX . "service_total WHERE service_form_id = '" . (int)$service_form_id . "' ORDER BY sort_order");

        return $query->rows;
    }

    public function setTime($data)
    {
        $service_item_id = $data['service_Item_id'];
        $start_time = $data['start_time'];
        $end_time = $data['end_time'];

        if (!empty($service_item_id)) {
            $start_time_statement = '';
            $end_time_statement = '';
            //checking starttime & endtime
            if (!empty($start_time)) {
                $start_time_statement = "start_time = '" . $start_time . "',";
            }
            if (!empty($end_time)) {
                $end_time_statement = "end_time = '" . $end_time . "',";
            }


            $this->db->query("
                UPDATE " . DB_PREFIX . "service_item SET
                $start_time_statement
                $end_time_statement
                modifi_by = '" . (int) $this->session->data['user_id'] . "',
                date_modified = NOW()
                WHERE service_item_id='" . (int)$service_item_id . "'
            ");
        }
        return $this->db->countAffected();
    }

    public function getServiceInfo($service_id)
    {
        $sql = "SELECT 
        c.*,
        cd.name
        FROM 
        " . DB_PREFIX . "clinical_service c
        LEFT JOIN " . DB_PREFIX . "clinical_service_description cd ON(c.clinicalservice_id=cd.clinicalservice_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        AND c.clinicalservice_id = '" . (int)$service_id . "'
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $service = $query->row;
            $info = array(
                "service_id"     => $service["clinicalservice_id"],
                "service_minute" => $service["cs_minute"],
                "service_name"   => $service["name"],
                "price"          => $service["price"],
                "tax_class_id"   => $service["tax_class_id"]
            );

            $info['doctors'] = $this->getDoctors();
            $acupunture_points = array();
            if (!empty($service['enable_acupuncture']) && $service['enable_acupuncture'] == '1') {
                $acupunture_points = $this->getAcupuncturePoints();
            }
            $info['acupuncture_points'] = $acupunture_points;
            return $info;
        } else {
            return null;
        }
    }

    public function saveServiceForm($data, $taxes = array())
    {
        $service_form_id = $data['service_form_id'];

        $service_subtotal = 0;
        $service_total = 0;
        $service_gst  = 0;

        if (empty($service_form_id)) {
            $this->load->model('setting/setting');
            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

            $sql = "INSERT INTO " . DB_PREFIX . "service_form SET
            customer_id ='" . (int) $data['customer_id'] . "',
            user_id ='" . (int) $data['doctor_id'] . "',
            invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
            store_id = '" . (int) $this->session->data['store_id'] . "',
            serviceform_action='" . (int) 1 . "',
            order_action = '" . (int) 17 . "',
            service_date = NOW(),
            remark = '" . $this->db->escape($data['remark']) . "',
            add_by = '" . (int) $this->session->data['user_id'] . "',
            date_added = NOW(),
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()";
            $this->db->query($sql);

            $service_form_id = $this->db->getLastId();

            if ($service_form_id != 0) {
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));
            }
        } else {
            $sql = "UPDATE " . DB_PREFIX . "service_form SET
            customer_id = '" . (int) $data['customer_id'] . "',
            user_id ='" . (int) $data['doctor_id'] . "',
            remark = '" . $this->db->escape($data['remark']) . "',
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()
            WHERE service_form_id='" . (int)$service_form_id . "'";
            $this->db->query($sql);
        }

        // get the service item
        $service_item_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "service_item WHERE service_form_id = '" . (int)$service_form_id . "'");

        $service_item_row = $service_item_query->rows;

        foreach ($service_item_row as $row) {
            $service_Item_id = $row['service_Item_id'];

            $this->db->query("DELETE FROM " . DB_PREFIX . "service_item_acupuncture_point WHERE service_Item_id = '" . (int)$service_Item_id . "'");
        }
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_item WHERE service_form_id= '" . (int)$service_form_id . "'");



        //service item
        if (!empty($data['services'])) {
            foreach ($data['services'] as $service) {
                $sql = "INSERT INTO " . DB_PREFIX . "service_item SET
                        service_form_id = '" . (int) $service_form_id . "',
                        clinicalservice_id = '" . (int) $service['service_id'] . "',
                        servicename ='" . $this->db->escape($service['service_name']) . "',
                        serviceminutes = '" . $this->db->escape($service['service_minute']) . "',
                        user_id = '" . (int)$service['doctor_id'] . "',
                        price = '" . (float)$service['price'] . "',
                        tax_class_id = '" . (int)$service['tax_class_id'] . "',
                        start_time = '" . $this->db->escape($service['start_time']) . "',
                        end_time = '" . $this->db->escape($service['end_time']) . "',
                        tax_code = '" . $this->db->escape($service['tax_code']) . "',
                        tax_format = '" . $this->db->escape($service['tax_format']) . "',
                        net_amount = '" . (float)$service['net_amount'] . "',
                        total = '" . (float)$service['total'] . "',
                        modifi_by = '" . (int)$this->session->data['user_id'] . "',
                        date_modified = NOW()";

                $service_subtotal += $service['net_amount'];
                $service_total += $service['total'];
                // $service_gst   += $service['tax'];

                $this->db->query($sql);
                $service_item_id = $this->db->getLastId();

                if (!empty($service['acupunctures'])) {
                    foreach ($service['acupunctures'] as $acupuncture_point) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
                    SET service_Item_id = '" . (int)$service_item_id . "',
                        acupuncture_id = '" . (int)$acupuncture_point['acupuncture_id'] . "',
                        num_of_acupuncture = '" . (int)$acupuncture_point['num_of_acupuncture'] . "'");
                    }
                }
            }
        }
        // var_dump($data['services']);
        // die();


        //general update

        $sql = "
        UPDATE " . DB_PREFIX . "service_form SET
        remark = '" . $this->db->escape($data['remark']) . "', 
        total_price = '" . (float)$service_total . "',
        net_amount = '" . (float)$service_subtotal . "',
        t_gst = '" . (float)$service_gst . "',
        modifi_by  = '" . $this->session->data['user_id'] . "',
        date_modified = NOW()
        WHERE service_form_id = '" . (int) $service_form_id . "'";

        $query = $this->db->query($sql);

        //Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "service_total WHERE service_form_id = '" . (int) $service_form_id . "' AND id ='1' ");
        $subtotal = 0;
        $tax = 0;
        $total = 0;

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {

                $tcode = isset($order_total['tax_code']) ? $order_total['tax_code'] : '';
                $tkey = isset($order_total['key']) ? $order_total['key'] : '';

                $this->db->query("INSERT INTO " . DB_PREFIX . "service_total SET service_form_id = '" . (int) $service_form_id . "',
                id ='1',
                tax_code ='" . $this->db->escape($tcode) . "', 
                code = '" . $this->db->escape($order_total['code']) . "', 
                tax_key = '" . (int) $tkey . "', 
                title = '" . $this->db->escape($order_total['title']) . "',  
                `value` = '" . (float) $order_total['value'] . "', 
                sort_order = '" . (int) $order_total['sort_order'] . "'");

                if ($order_total['code'] == 'sub_total') {
                    $subtotal += $order_total['value'];
                }
                if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                }
                if ($order_total['code'] == 'total') {
                    $total += $order_total['value'];
                }
            }
        }

        // if (isset($taxes)) {
        //     foreach ($taxes as $order_total) {
        //         $tcode =  !empty($order_total['tax_code']) ? $order_total['tax_code'] : '';
        //         $tkey  = !empty($order_total['tax_key']) ? $order_total['tax_key'] : '';


        //         $this->db->query("
        //          INSERT INTO " . DB_PREFIX . "service_total
        //          SET
        //          service_form_id = '" . (int) $service_form_id . "', 
        //          id ='1',
        //          code = '" . $this->db->escape($order_total['code']) . "',
        //          tax_code = '" . $this->db->escape($tcode) . "',
        //          tax_key = '" . (int)$tkey . "',
        //          title = '" . $this->db->escape($order_total['title']) . "',
        //          `value` = '" . (float) $order_total['value'] . "',
        //          sort_order = '" . (int) $order_total['sort_order'] . "'
        //          ");
        //     }
        // }

        return $service_form_id;
    }

    public function completeService($service_form_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "service_form SET
        serviceform_action = '5',
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()
        WHERE service_form_id = '" . (int) $service_form_id . "'");
    }

    public function cancelService($service_form_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "service_form SET
        serviceform_action = '7',
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()
        WHERE service_form_id = '" . (int) $service_form_id . "'");
    }

    public function deleteServiceForm($service_form_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "service_form SET
            hide ='1',
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()
		WHERE service_form_id = '" . (int) $service_form_id . "'");
    }

    public function getServiceDetails($service_id)
    {
        $query = $this->db->query("
        SELECT 
        price
        staff_id
        FROM `oc_clinical_service`
        WHERE 1
        AND clinicalservice_id ='" . (int) $service_id . "'
        ");
        return $query->row;
    }

    public function getAddressesByCustomerId($customer_id)
    {
        $sql = "SELECT a.*, z.name as zone, c.name as country FROM " . DB_PREFIX . "address a 
        LEFT JOIN " . DB_PREFIX . "zone z ON(a.zone_id=z.zone_id)
        LEFT JOIN " . DB_PREFIX . "country c ON(a.country_id=c.country_id)
        WHERE a.customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
