<?php
class ModelAndroidReportStockSummary extends Model
{
    public function getCategories()
    {
        $sql = "SELECT cd.category_id as id, cd.name FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd ON(cd.category_id = c.category_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE 1
        ORDER BY cd.name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getUserStore()
    {
        $result = [];
        $sql = "SELECT store_id FROM oc_user_to_store WHERE user_id = '" . (int)$this->session->data['user_id'] . "'";
        $query = $this->db->query($sql);
        if (!empty($query->rows)) {
            $result = array_column($query->rows, 'store_id');
        }
        return $result;
    }

    public function productStockExists($product_id)
    {
        $sql = "
        SELECT 
                COUNT(*) AS total
            FROM
                `oc_product_to_store` pts
                LEFT JOIN 
                    `oc_product` p
                        ON pts.product_id = p.product_id
            WHERE 
                1
                AND p.product_id <>''
                AND pts.product_id = '" . (int) $product_id . "'
            GROUP BY 
                pts.product_id
            ";

        $query = $this->db->query($sql);
        return $query->row['total'] > 0;
    }

    public function getStocks($data)
    {
        if ($this->session->data['user_info']['viewalldata']) {
            $store_statement = " AND pts.store_id IN ('" . implode("', '", $data['all_stores']) . "')";
        } else {
            $userStores = $this->getUserStore();
            $store_statement = " AND pts.store_id  IN ('" . implode("', '", $userStores) . "')";
        }

        if (is_numeric($data['store_id'])) {
            if (in_array($data['store_id'], $data['all_stores'])) {
                $store_statement = " AND pts.store_id = '" . (int)$data['store_id'] . "'";
            }
        }

        $category_statement = '';
        if (!empty($data['category_id'])) {
            $category_statement = " AND ptc.category_id = '" . (int)$data['category_id'] . "'";
        }

        $quantity_statement = '';
        if (is_numeric($data['min_qty'])) {
            $quantity_statement .= " AND pts.onhand_quantity >= '" . (float)$data['min_qty'] . "'";
        }
        if (is_numeric($data['max_qty'])) {
            $quantity_statement .= " AND pts.onhand_quantity <= '" . (float)$data['max_qty'] . "'";
        }

        $product_statement = '';
        if (!empty($data['product_name'])) {
            $product_statement = " AND (CONCAT(pd_en.name,' ',pd_cn.name) LIKE '%" . $this->db->escape(trim($data['product_name'])) . "%' OR p.code LIKE '%".$this->db->escape(trim($data['product_name']))."%')";
        }

        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $sql = "SELECT p.product_id,
        p.code,
        pts.store_id,
        pts.onhand_quantity,
        pd_en.name AS en_name,
        pd_cn.name AS cn_name,
        cd.name AS category_name
        FROM " . DB_PREFIX . "product p 
        LEFT JOIN " . DB_PREFIX . "product_to_store pts ON(p.product_id = pts.product_id)
        LEFT JOIN " . DB_PREFIX . "product_description pd_en ON(p.product_id = pd_en.product_id AND pd_en.language_id = '1')
        LEFT JOIN " . DB_PREFIX . "product_description pd_cn ON(p.product_id = pd_cn.product_id AND pd_cn.language_id = '2')
        LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "category_description cd ON(ptc.category_id = cd.category_id AND cd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        $store_statement
        $category_statement
        $quantity_statement
        $product_statement
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStockTransactions($product_id, $data)
    {
        $open_date = !empty($data['start_date']) ? $data['start_date'] : date('Y-m-d');

        $close_date = !empty($data['end_date']) ? $data['end_date'] : date('Y-m-d');

        $store_id = $data['store_id'] != '' ? $data['store_id'] : '';

        $person_statement = '';
        if (!empty($data['person_name'])) {
            $person_statement = "AND column_name LIKE '%" . $this->db->escape($data['person_name']) . "%'";
        }

        $doc_no_statement = '';
        if (!empty($data['doc_no'])) {
            $doc_no_statement = "AND column_name LIKE '%" . $this->db->escape($data['doc_no']) . "%'";
        }

        $limit_statement = "";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $limit_statement = "LIMIT " . (int) $data['start'] . "," . (int) $data['limit'];
        }

        $start_date = $this->db->escape($open_date) .  " 00:00:00";
        $end_date  = $this->db->escape($close_date) .  " 23:59:59";

        $sqlSet = "SET @stock = " . (float) $this->getStockQty($start_date, $product_id, $store_id);
        $this->db->query($sqlSet);

        $sql = "
        SELECT 
                a.date_added, 
                a.product_id, 
                a.id, 
                a.name, 
                a.person_type, 
                a.action, 
                a.quantity, 
                a.add, 
                a.deduct, 
                a.store_id, 
                a.stock_type,
		        (CASE WHEN action = 1 THEN @stock := @stock + a.quantity 
		        ELSE @stock := @stock - a.quantity END) AS balance
		    FROM
		    (	
			#stock adjustment
			SELECT
				    sai.date_added,
				    sai.product_id,
				    sa.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    sai.action,
				    sai.qty AS quantity,
                    (CASE WHEN sai.action = 1 THEN sai.qty
                    ELSE NULL END) AS 'add',
                    (CASE WHEN sai.action = 1 THEN NULL
                    ELSE sai.qty END) AS deduct,
				    sa.store_id,
				    1 AS stock_type
			    FROM 
				    `oc_stock_adjustment_item` sai
                        LEFT JOIN 
                            `oc_stock_adjustment` sa 
                                ON sai.stock_adjustment_id = sa.stock_adjustment_id
                        LEFT JOIN    
                            `oc_user` u
                                ON sa.add_by = u.user_id
                WHERE 
                    1
                    AND sai.product_id = '" . (int) $product_id . "'  
                    AND sai.date_added >=  '" . $this->db->escape($start_date) . "'               
                    AND sai.date_added <= '" . $this->db->escape($end_date) . "'
                    AND sa.store_id   = '" . (int) $store_id  .  "'
                    AND sa.status   = 5
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "sa.invoice_prefix", $doc_no_statement) . "
            UNION ALL
            
            #stock issue
            SELECT
				    sii.date_added,
				    sii.product_id,
				    si.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
                    0 AS action,
				    sii.quantity,
                    NULL AS 'add',
                    sii.quantity AS deduct,
				    si.store_id,
				    1 AS stock_type
			    FROM
				    `oc_stock_issue_item` sii
                        LEFT JOIN
                            `oc_stock_issue` si
                                ON sii.stock_issue_id = si.stock_issue_id
                        LEFT JOIN
                            `oc_user` u
                                ON si.add_by = u.user_id
                WHERE
                    1
                    AND sii.product_id = '" . (int) $product_id . "'
                    AND sii.date_added >=  '" . $this->db->escape($start_date) . "'
                    AND sii.date_added <= '" . $this->db->escape($end_date) . "'
                    AND si.store_id   = '" . (int) $store_id  .  "'
                    AND si.status   = 5
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "si.invoice_prefix", $doc_no_statement) . "

            UNION ALL
			
			#received from store,出货
			SELECT
				    st.received_date as date_added,
				    std.product_id,
				    st.transfer_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    (CASE WHEN st.from_store = '" . (int) $store_id . "' THEN 1 ELSE 0 END) AS action,
				    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store = '" . (int) $store_id . "' THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store = '" . (int) $store_id . "' THEN std.received_quantity ELSE NULL END) AS deduct,
				    st.to_store AS store_id,
				    2 AS stock_type
			    FROM 
                    `oc_stock_transfer_detail` std
                        LEFT JOIN
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE
                    1
                    AND std.received_quantity > 0
                    AND std.product_id = '" . (int) $product_id . "'  
                    AND st.received_date >=  '" . $this->db->escape($start_date) . "'               
                    AND st.received_date <= '" . $this->db->escape($end_date) . "'
                    AND st.to_store   = '" . (int) $store_id  .  "'
                    AND st.status >= 4
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "st.transfer_no", $doc_no_statement) . "
                            
			UNION ALL
			
			#tranfer to store,进货
			SELECT 
				    st.transfer_date as date_added,
				    std.product_id,
				    st.transfer_no AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    (CASE WHEN st.from_store = '" . (int) $store_id . "' THEN 1 ELSE 0 END) AS action,
				    std.received_quantity AS quantity,
                    (CASE WHEN st.from_store = '" . (int) $store_id . "' THEN std.received_quantity ELSE NULL END) AS 'add',
                    (CASE WHEN st.to_store = '" . (int) $store_id . "' THEN std.received_quantity ELSE NULL END) AS deduct,
				    st.from_store AS store_id,
				    2 AS stock_type
                FROM 
                    `oc_stock_transfer_detail` std
                        LEFT JOIN 
                            `oc_stock_transfer` st
                                ON std.stock_transfer_id = st.stock_transfer_id
                        LEFT JOIN
                            `oc_user` u
                                ON st.created_by = u.user_id
                WHERE 
                    1
                    AND std.received_quantity > 0
                    AND std.product_id = '" . (int) $product_id . "'  
                    AND st.transfer_date >=  '" . $this->db->escape($start_date) . "'               
                    AND st.transfer_date <= '" . $this->db->escape($end_date) . "'
                    AND st.from_store   = '" . (int) $store_id  .  "'
                    AND st.status >= 4
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "st.transfer_no", $doc_no_statement) . "
			
			UNION ALL
			
			#sold
			SELECT
				    o.date_added,
				    op.product_id,
				    o.invoice_prefix AS id,
				    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
				    0 as action,
				    ROUND(op.weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.weight,2) AS deduct,
				    o.store_id,
				    3 AS stock_type
                FROM 
                    `oc_order_product` op
                        LEFT JOIN 
                            `oc_order` o
			                    ON op.order_id = o.order_id
                        LEFT JOIN 
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND op.product_id = '" . (int) $product_id . "'  
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'  
                    AND o.store_id   = '" . (int) $store_id  .  "'
                    AND o.order_status_id IN ('1','3','5','15')
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 0
                    " . str_replace('column_name', "CONCAT(o.firstname, ' ', o.lastname)", $person_statement) . "
                    " . str_replace('column_name', "o.invoice_prefix", $doc_no_statement) . "
            
            UNION ALL
            
            #order_wholesaler
			SELECT
				    o.date_added,
				    op.product_id,
				    o.invoice_prefix AS id,
				    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
				    0 as action,
				    ROUND(op.total_weight,2) AS quantity,
                    NULL as 'add',
                    ROUND(op.total_weight,2) AS deduct,
				    o.store_id,
				    3 AS stock_type
                FROM 
                    `oc_order_product` op
                        LEFT JOIN 
                            `oc_order` o
			                    ON op.order_id = o.order_id
                        LEFT JOIN 
                            `oc_weight_class` wc
                                ON op.weight_class_id = wc.weight_class_id
                WHERE
                    1
                    AND op.product_id = '" . (int) $product_id . "'  
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'  
                    AND o.store_id   = '" . (int) $store_id  .  "'
                    AND o.order_status_id IN ('1','3','5','15')
                    AND o.invoice_prefix <>''
                    AND o.invoice_wholesaler = 1 
                    " . str_replace('column_name', "CONCAT(o.firstname, ' ', o.lastname)", $person_statement) . "
                    " . str_replace('column_name', "o.invoice_prefix", $doc_no_statement) . "
            
            UNION ALL
            
            #herbal remedies
            SELECT 
                    o.date_added,
                    csp.product_id,
                    CONCAT(o.invoice_prefix,'-',cs.invoice_prefix) AS id,
                    CONCAT(o.firstname, ' ', o.lastname) AS name,
				    2 AS person_type,
                    0 as action,
                    ROUND(t_weight,2) AS quantity,
                    NULL AS 'add',
                    ROUND(t_weight,2) AS deduct,
                    o.store_id,
                    3 stock_type
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND csp.product_id = '" . (int) $product_id . "' 
                    AND o.date_added >=  '" . $this->db->escape($start_date) . "' AND o.date_added <= '" . $this->db->escape($end_date) . "'  
                    AND o.store_id   = '" . (int) $store_id  .  "'
                    AND o.order_status_id IN ('1','3','5','15')
                    AND o.invoice_prefix <>''
                    " . str_replace('column_name', "CONCAT(o.firstname, ' ', o.lastname)", $person_statement) . "
                    " . str_replace('column_name', "CONCAT(o.invoice_prefix,'-',cs.invoice_prefix)", $doc_no_statement) . "

            UNION ALL
			
			#purchase receive
			SELECT
				    pr.date_added,
				    prp.product_id,
				    pr.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    ROUND(prp.quantity,2) AS quantity,
				    ROUND(prp.quantity,2) AS 'add',
				    NULL AS deduct,
				    pr.store_id,
				    4 AS stock_type
                FROM 
                    `oc_purchase_receive_product` prp
                        LEFT JOIN 
                            `oc_purchase_receive` pr
			                    ON prp.purchase_receive_id = pr.purchase_receive_id
                        LEFT JOIN 
                            `oc_user` u
			                    ON pr.add_by = u.user_id
                WHERE 
                    1
                    AND pr.order_status_id = '5'
                    AND prp.product_id = '" . (int) $product_id . "'  
                    AND pr.date_added >=  '" . $this->db->escape($start_date) . "' 
                    AND pr.date_added <= '" . $this->db->escape($end_date) . "'  
                    AND pr.store_id   = '" . (int) $store_id  .  "'
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "pr.invoice_prefix", $doc_no_statement) . "
			
			UNION ALL
			
			#purchase invoice
			SELECT
				    pi.date_added,
				    pip.product_id,
				    pi.invoice_prefix AS id,
				    CONCAT(u.firstname, ' ', u.lastname) AS name,
				    1 AS person_type,
				    1 AS action,
				    ROUND(pip.quantity,2) AS quantity,
				    ROUND(pip.quantity,2) AS 'add',
				    NULL AS deduct,
				    pi.store_id,
				    5 AS stock_type
                FROM 
                    `oc_purchase_invoice_product` pip
                        LEFT JOIN 
                            `oc_purchase_invoice` pi
			                    ON pip.purchase_invoice_id = pi.purchase_invoice_id
                        LEFT JOIN 
                            `oc_user` u
			                    ON pi.add_by = u.user_id
                WHERE 
                    1
			        AND pip.product_id != 0
			        AND pi.type IN (3, 5, 6)		
			        AND pi.stock_affect = '1'
                    AND pi.order_status_id = '5'
                    AND pip.product_id = '" . (int) $product_id . "'  
                    AND pi.date_added >=  '" . $this->db->escape($start_date) . "' 
                    AND pi.date_added <= '" . $this->db->escape($end_date) . "'  
                    AND pi.store_id   = '" . (int) $store_id  .  "'
                    " . str_replace('column_name', "CONCAT(u.firstname, ' ', u.lastname)", $person_statement) . "
                    " . str_replace('column_name', "pi.invoice_prefix", $doc_no_statement) . "
		) a
		ORDER BY a.date_added ASC
		$limit_statement
		";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getOpenStock($datetime, $product_id, $store_id = "")
    {
        return $this->getStockQty($datetime, $product_id, $store_id, false);
    }

    public function getCloseStock($datetime, $product_id, $store_id = "")
    {
        return $this->getStockQty($datetime, $product_id, $store_id, true);
    }

    private function getStockQty($datetime, $product_id, $store_id = '', $equal = false)
    {
        $equal_statement = $equal ? "=" : "";

        $filter_store_id_statement = $store_id != '' && $store_id != '*' ?
            "AND a.store_id = '" . (int) $store_id . "'" :
            "";

        $sql = "
		SELECT SUM(a.quantity) AS stock
		    FROM
		    (
			    #stock adjustment
			    SELECT
				        (CASE WHEN sai.action = 1 THEN sai.qty ELSE (sai.qty * -1) END) AS quantity
			        FROM 
                        `oc_stock_adjustment_item` sai
                            LEFT JOIN 
                                `oc_stock_adjustment` sa
                                    ON sai.stock_adjustment_id = sa.stock_adjustment_id 
                    WHERE 
                        1
                        AND sai.product_id = '" . (int) $product_id . "'  
                        AND sai.date_added <$equal_statement '" . $this->db->escape($datetime) . "'               
                        AND sa.store_id   = '" . (int) $store_id  .  "'
                        AND sa.status   = 5
				
            UNION ALL
            
                #stock issue
                    SELECT
                            (sii.quantity * -1) AS quantity
                        FROM
                            `oc_stock_issue_item` sii
                                LEFT JOIN
                                    `oc_stock_issue` si
                                        ON sii.stock_issue_id = si.stock_issue_id
                        WHERE
                            1
                            AND sii.product_id = '" . (int) $product_id . "'
                            AND sii.date_added <$equal_statement '" . $this->db->escape($datetime) . "'
                            AND si.store_id   = '" . (int) $store_id  .  "'
                            AND si.status   = 5

            UNION ALL
			
                #received from store
                SELECT
                        (CASE WHEN st.from_store = '" . (int) $store_id . "' THEN std.received_quantity ELSE (std.received_quantity * -1) END) AS quantity
                    FROM 
                        `oc_stock_transfer_detail` std
                            LEFT JOIN
                                `oc_stock_transfer` st
                                    ON std.stock_transfer_id = st.stock_transfer_id
                    WHERE 
                        1
                        AND std.received_quantity > 0
                        AND std.product_id = '" . (int) $product_id . "'  
                        AND st.received_date <$equal_statement  '" . $this->db->escape($datetime) . "'               
                        AND st.to_store   = '" . (int) $store_id  .  "'
                        AND st.status >= 4
			
			UNION ALL
			
                #tranfer to store store
                SELECT 
                        (CASE WHEN st.to_store = '" . (int) $store_id . "' THEN (std.received_quantity * -1) ELSE std.received_quantity END) AS quantity
                    FROM 
                        `oc_stock_transfer_detail` std
                            LEFT JOIN    
                                `oc_stock_transfer` st
                                    ON std.stock_transfer_id = st.stock_transfer_id
                    WHERE 
                        1
                        AND std.received_quantity > 0
                        AND std.product_id = '" . (int) $product_id . "'  
                        AND st.transfer_date <$equal_statement  '" . $this->db->escape($datetime) . "'               
                        AND st.from_store   = '" . (int) $store_id  .  "'
                        AND st.status >= 4
                
            UNION ALL
			
			#sold
                SELECT
                        ROUND(op.weight * -1,2) AS quantity
                    FROM 
                        `oc_order_product` op
                            LEFT JOIN 
                                `oc_order` o
                                    ON op.order_id = o.order_id
                            LEFT JOIN 
                                `oc_weight_class` wc
                                    ON op.weight_class_id = wc.weight_class_id
                    WHERE
                        1
                        AND op.product_id = '" . (int) $product_id . "'  
                        AND o.date_added <$equal_statement  '" . $this->db->escape($datetime) . "'               
                        AND o.store_id   = '" . (int) $store_id  .  "'
                        AND o.order_status_id IN ('1','3','5','15')
                        AND o.invoice_prefix <>''
                        AND o.invoice_wholesaler = 0

            UNION ALL
            
            #order_wholesaler
                SELECT
                        ROUND(op.total_weight * -1,2) AS quantity
                    FROM 
                        `oc_order_product` op
                            LEFT JOIN 
                                `oc_order` o
                                    ON op.order_id = o.order_id
                            LEFT JOIN 
                                `oc_weight_class` wc
                                    ON op.weight_class_id = wc.weight_class_id
                    WHERE
                        1
                        AND op.product_id = '" . (int) $product_id . "'  
                        AND o.date_added <$equal_statement '" . $this->db->escape($datetime) . "'               
                        AND o.store_id   = '" . (int) $store_id  .  "'
                        AND o.order_status_id IN ('1','3','5','15')
                        AND o.invoice_prefix <>''
                        AND o.invoice_wholesaler = 1

            UNION ALL

            #herbal remedies
            SELECT 
                    ROUND(t_weight * -1,2) AS quantity
                FROM
                    `oc_clinicalsale_product` csp
                        LEFT JOIN
                            `oc_clinical_sale` cs
                                ON csp.clinical_sale_id = cs.clinical_sale_id
                        LEFT JOIN
                            `oc_order` o
                                ON cs.order_id = o.order_id
                WHERE
                    1
                    AND csp.product_id = '" . (int) $product_id . "' 
                    AND o.date_added <$equal_statement  '" . $this->db->escape($datetime) . "'
                    AND o.store_id   = '" . (int) $store_id  .  "'
                    AND o.order_status_id IN ('1','3','5','15')
                    AND o.invoice_prefix <>''

			UNION ALL
			
			#purchase receive
                SELECT
                        ROUND(prp.quantity,2) AS quantity
                    FROM 
                        `oc_purchase_receive_product` prp
                            LEFT JOIN 
                                `oc_purchase_receive` pr
                                    ON prp.purchase_receive_id = pr.purchase_receive_id
                    WHERE 
                        1
                        AND pr.order_status_id = '5'
                        AND prp.product_id = '" . (int) $product_id . "'  
                        AND pr.date_added <$equal_statement  '" . $this->db->escape($datetime) . "'               
                        AND pr.store_id   = '" . (int) $store_id  .  "'
			
			UNION ALL
			
			#purchase invoice
                SELECT
                        ROUND(pip.quantity,2) AS quantity
                    FROM 
                        `oc_purchase_invoice_product` pip
                            LEFT JOIN 
                                `oc_purchase_invoice` pi
                                    ON pip.purchase_invoice_id = pi.purchase_invoice_id
                    WHERE 
                        1
                        AND stock_affect = '1'
                        AND pip.product_id != '0'
                        AND pi.type IN (3, 5, 6)
                        AND pi.order_status_id = '5'
                        AND pip.product_id = '" . (int) $product_id . "'  
                        AND pi.date_added <$equal_statement  '" . $this->db->escape($datetime) . "'               
                        AND pi.store_id   = '" . (int) $store_id  .  "'
		) a
		";

        $query = $this->db->query($sql);
        return $query->row['stock'] ? $query->row['stock'] : 0;
    }
}
