<?php
class ModelAndroidReportStock extends Model
{
    public function getStockSummary($data)
    {
        $sort_statement = '';
        if (!empty($data['sort'])) {
            $columns = explode(",", $data['sort']);
            foreach ($columns as $column) {
                list($col, $direction) = explode("-", $column);
                if ($col == 'quantity') {
                    $col = 'qty';
                }
                $sort_statement .= $sort_statement ? ", $col $direction" : " $col $direction";
            }
        } else {
            $sort   = "qty";
            $order  = "ASC";
            $sort_statement .= " qty ASC";
        }


        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        $filter_product_code = isset($data['filter_product_code']) ? $data['filter_product_code'] : false;
        $filter_product_name = isset($data['filter_product_name']) ? $data['filter_product_name'] : false;
        $filter_store_id = isset($data['filter_store_id']) ? implode(", ", $data['filter_store_id']) : false;
        $filter_categories = isset($data['filter_categories']) ? implode(", ", $data['filter_categories']) : false;
        $filter_low_stock = isset($data['filter_low_stock']) ? $data['filter_low_stock'] : false;

        //prepare where clause statement
        $filter_product_code_statement = $filter_product_code ? "AND a.code LIKE '%" . $filter_product_code . "%'" : "";

        $filter_product_name_statement = $filter_product_name ? "AND (CONCAT(a.en_name,' ',a.cn_name) LIKE '%" . $filter_product_name . "%' OR a.pinyin LIKE '%" . $filter_product_name . "%' OR a.code LIKE '%" . $filter_product_name . "%')" : "";

        $filter_store_id_statement = $filter_store_id !== false ? "AND a.store_id in (" . $filter_store_id . ")" : "";

        $filter_categories_statement = $filter_categories !== false ? "AND ptc.category_id in (" . $filter_categories . ")" : "";

        //prepare having statement
        $filter_low_stock_statement = $filter_low_stock ? "HAVING sum(a.quantity) <= a.low_stock" : '';

        $sql = "SELECT 
               a.product_id,
               a.code,
               a.pinyin,
               a.en_name,
               a.cn_name,
               a.name,
               a.store_id,
               (CASE WHEN a.store_id = '0' THEN '" . $this->getDefaultStore() . "' ELSE CASE WHEN s.name is NULL THEN 'Invalid Store' ELSE s.name END END) AS store_name,
               SUM(a.quantity) AS qty,
               CONCAT( (SUM(a.quantity)) ,' ',a.uom) AS quantity_text,
               a.low_stock
        
            FROM(
            SELECT
                p.product_id AS product_id,
                p.code AS code,
                p.pinyin AS pinyin,
                en.name AS en_name,
                cn.name AS cn_name,
                TRIM(pd.name) AS name,
                (CASE WHEN pts.store_id is NULL THEN 0 ELSE pts.store_id END) AS store_id,
                (CASE WHEN pts.onhand_quantity is NULL THEN 0 ELSE pts.onhand_quantity END) AS quantity,
                wcd.unit AS uom,
                (CASE WHEN plw.quantity is NULL THEN 0 ELSE plw.quantity END) AS low_stock
            FROM
                " . DB_PREFIX . "product p
                LEFT JOIN " . DB_PREFIX . "product_to_store pts
                ON p.product_id = pts.product_id

                LEFT JOIN " . DB_PREFIX . "product_description cn
                ON p.product_id = cn.product_id AND cn.language_id = '2'

                LEFT JOIN " . DB_PREFIX . "product_description en
                ON p.product_id = en.product_id AND en.language_id = '1'

                LEFT JOIN " . DB_PREFIX . "product_description pd
                ON p.product_id = pd.product_id AND pd.language_id = '" . (int)$this->session->data['language_id'] . "'
                
                LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                ON p.weight_class_id = wcd.weight_class_id AND wcd.language_id ='" . (int)$this->session->data['language_id'] . "'
                
                LEFT JOIN " . DB_PREFIX . "product_to_category ptc
                ON p.product_id = ptc.product_id

                LEFT JOIN " . DB_PREFIX . "product_low_stock plw
                ON p.product_id = plw.product_id AND pts.store_id =plw.store_id



                WHERE 1 
                $filter_categories_statement

            )a
            LEFT JOIN " . DB_PREFIX . "store s
            ON a.store_id = s.store_id

            WHERE 1
                $filter_store_id_statement 
                $filter_product_name_statement
                $filter_product_code_statement
            
            GROUP BY a.product_id, a.store_id

            $filter_low_stock_statement
            
            ORDER BY $sort_statement

            LIMIT $start, $limit
            ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getStockDetail($product_id, $store_id)
    {
        $sql = "SELECT 
                    (CASE WHEN pts.location_id = 0 THEN 'Default Location' ELSE
                    CONCAT(wms.warehouse,'>',wms.zone,'>',wms.lot) END) AS location_text,
                    pts.batch_date,
                    pts.onhand_quantity AS quantity, 
                    CONCAT(pts.onhand_quantity,' ',wcd.unit) AS quantity_text
                FROM
                    " . DB_PREFIX . "product_to_store pts

                    LEFT JOIN " . DB_PREFIX . "wms_location wms
                    ON(pts.location_id = wms.location_id)

                    LEFT JOIN " . DB_PREFIX . "product p
                    ON(pts.product_id=p.product_id)

                    LEFT JOIN " . DB_PREFIX . "weight_class_description wcd
                    ON p.weight_class_id = wcd.weight_class_id AND wcd.language_id ='" . (int)$this->session->data['language_id'] . "'
                WHERE
                    pts.product_id = '" . (int)$product_id . "' AND pts.store_id = '" . (int)$store_id . "'
                ORDER BY location_text, pts.batch_date
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getFilterCategories()
    {
        $sql = "SELECT DISTINCT(ptc.category_id) AS id, cd.name FROM
               " . DB_PREFIX . "product_to_category ptc LEFT JOIN
               " . DB_PREFIX . "category_description cd 
               ON (ptc.category_id = cd.category_id AND cd.language_id ='" . (int)$this->session->data['language_id'] . "') 
               ORDER BY cd.name";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return $query->rows;
        } else {
            return array();
        }
    }

    public function getFilterStoreId()
    {
        $filter_stores = array();
        $user_id = $this->session->data['user_id'];
        $sql_user = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id='" . (int)$user_id . "' AND viewalldata='1'";
        $query_user = $this->db->query($sql_user);
        if ($query_user->num_rows) {
            $default_store = $this->getDefaultStore();
            if ($default_store) {
                $filter_stores[] = array('id' => "0", 'name' => $default_store);
            }
            //get all stores name
            $query_store = $this->db->query("SELECT store_id AS id, name FROM " . DB_PREFIX . "store");
            if ($query_store->num_rows) {
                foreach ($query_store->rows as $store) {
                    $filter_stores[] = array('id' => $store['id'], 'name' => $store['name']);
                }
            }
            return $filter_stores;
        } else {
            return array();
        }
    }

    public function getDefaultStore()
    {
        $sql = "SELECT value FROM " . DB_PREFIX . "setting WHERE `store_id` = '0' AND `code` = 'config' AND `key` = 'config_name'";
        $query = $this->db->query($sql);
        return !empty($query->row['value']) ? $query->row['value'] : '';
    }

    public function productAutocomplete($product_name)
    {

        $sql = "SELECT 
                en.name AS en_name,
                cn.name AS cn_name
        FROM " . DB_PREFIX . "product p 

        LEFT JOIN " . DB_PREFIX . "product_description cn
                ON p.product_id = cn.product_id AND cn.language_id = '2'

        LEFT JOIN " . DB_PREFIX . "product_description en
                ON p.product_id = en.product_id AND en.language_id = '1' 
        WHERE 
        CONCAT(en.name,' ',cn.name) LIKE'%" . $this->db->escape($product_name) . "%' 
        OR p.pinyin LIKE '%" . $this->db->escape($product_name) . "%' 
        OR p.code LIKE '%" . $this->db->escape($product_name) . "%' 
        LIMIT 0, 100";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
