<?php
class ModelAndroidReportReport extends Model
{
    public function getDoctors($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $limit_statement = '';
        if (!empty($limit) && $start !== null) {
            $limit_statement = "LIMIT $start, $limit";
        }

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "TRIM(CONCAT(firstname,' ',lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ") ";
        }

        $sql = "SELECT 
        user_id AS id,
        TRIM(CONCAT(firstname,' ',lastname)) AS name
        FROM " . DB_PREFIX . "user
        WHERE position='2'
        $search_statement
        ORDER BY TRIM(CONCAT(firstname,' ',lastname))
        $limit_statement
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomers($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND (";
            $search_statement .= "TRIM(CONCAT(firstname,' ',lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR customer_ic LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR telephone LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ") ";
        }

        $sql = "SELECT * FROM " . DB_PREFIX . "customer
        WHERE 1
        $search_statement
        ORDER BY TRIM(CONCAT(firstname,' ',lastname))
        LIMIT $start, $limit
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getBrewingCustomers($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';

        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND (";
            $search_statement .= "customer_name LIKE '%" . $this->db->escape($filter_search) . "%'";
            $search_statement .= "OR customer_telephone LIKE '%" . $this->db->escape($filter_search) . "%'";
            $search_statement .= "OR customer_email LIKE '%" . $this->db->escape($filter_search) . "%'";
            $search_statement .= ")";
        }

        $sql = "SELECT customer_id, customer_name, customer_telephone, customer_email 
        FROM " . DB_PREFIX . "service_partner_sale_order
        WHERE 1
        $search_statement
        GROUP BY customer_id, customer_name
        ORDER BY customer_name
        LIMIT $start, $limit
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
