<?php
class ModelAndroidReportHerbal extends Model
{

    public function getTransactions($data)
    {
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 20;

        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND cs.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                cs.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                cs.add_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND cs.sales_date >= '" . $data['date_start'] . "' AND cs.sales_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND cs.clinicalsale_action ='" . (int)$data['status'] . "'";
        }

        $filter_payment_status_statement = '';
        if (!empty($data['payment_status'])) {
            $filter_payment_status_statement = " AND cs.order_action ='" . (int)$data['payment_status'] . "'";
        }

        $filter_customer_statement = '';
        if (!empty($data['customer_id'])) {
            $filter_customer_statement = " AND cs.customer_id = '" . (int)$data['customer_id'] . "'";
        }
        if (!empty($data['customer_name'])) {
            $filter_customer_statement .= " AND TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        $filter_doctor_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_doctor_statement = " AND cs.doctor_id = '" . (int)$data['doctor_id'] . "'";
        }
        if (!empty($data['doctor_name'])) {
            $filter_doctor_statement .= " AND TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($data['doctor_name']) . "%'";
        }

        $filter_amount_statement = '';
        if (!empty($data['amount_start'])) {
            $filter_amount_statement .= " AND cs.total >= '" . (float)$data['amount_start'] . "'";
        }

        if (!empty($data['amount_end'])) {
            $filter_amount_statement .= " AND cs.total <= '" . (float)$data['amount_end'] . "'";
        }

        $sql = "SELECT cs.* ,
        TRIM(CONCAT(c.firstname,' ',c.lastname)) AS customer_name,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name,
        c.customer_ic,
        cst.value AS final_total
        FROM " . DB_PREFIX . "clinical_sale cs 
        LEFT JOIN " . DB_PREFIX . "customer c ON(cs.customer_id = c.customer_id) 
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id) 
        LEFT JOIN ".DB_PREFIX."clinical_sale_total cst ON(cst.clinical_sale_id = cs.clinical_sale_id AND cst.id='2' AND cst.code='total')
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement
        $filter_customer_statement
        $filter_doctor_statement
        $filter_amount_statement
        $filter_payment_status_statement

        ORDER BY cs.sales_date DESC, cs.clinical_sale_id DESC
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalTransactions($data)
    {

        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND cs.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                cs.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                cs.add_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND cs.sales_date >= '" . $data['date_start'] . "' AND cs.sales_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND cs.clinicalsale_action ='" . (int)$data['status'] . "'";
        }

        $filter_payment_status_statement = '';
        if (!empty($data['payment_status'])) {
            $filter_payment_status_statement = " AND cs.order_action ='" . (int)$data['payment_status'] . "'";
        }

        $filter_customer_statement = '';
        if (!empty($data['customer_id'])) {
            $filter_customer_statement = " AND cs.customer_id = '" . (int)$data['customer_id'] . "'";
        }
        if (!empty($data['customer_name'])) {
            $filter_customer_statement .= " AND TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }

        $filter_doctor_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_doctor_statement = " AND cs.doctor_id = '" . (int)$data['doctor_id'] . "'";
        }
        if (!empty($data['doctor_name'])) {
            $filter_doctor_statement .= " AND TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($data['doctor_name']) . "%'";
        }

        $filter_amount_statement = '';
        if (!empty($data['amount_start'])) {
            $filter_amount_statement .= " AND cs.total >= '" . (float)$data['amount_start'] . "'";
        }

        if (!empty($data['amount_end'])) {
            $filter_amount_statement .= " AND cs.total <= '" . (float)$data['amount_end'] . "'";
        }


        $sql = "SELECT COUNT(*) AS transactions, SUM(cst.value) AS amount
        FROM " . DB_PREFIX . "clinical_sale cs 
        LEFT JOIN " . DB_PREFIX . "customer c ON(cs.customer_id = c.customer_id) 
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id) 
        LEFT JOIN ".DB_PREFIX."clinical_sale_total cst ON(cst.clinical_sale_id = cs.clinical_sale_id AND cst.id='2' AND cst.code='total')
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement
        $filter_customer_statement
        $filter_doctor_statement
        $filter_amount_statement
        $filter_payment_status_statement
        ";

        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getTotalSale($data)
    {
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND cs.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                cs.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                OR 
                cs.add_by = '" . (int)$this->session->data['user_id'] . "'
                )";
            }
        }

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND cs.sales_date >= '" . $data['date_start'] . "' AND cs.sales_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND cs.order_action ='" . (int)$data['status'] . "'";
        }

        $sql = "SELECT SUM(cst.value) as amount FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN ".DB_PREFIX."clinical_sale_total cst ON(cst.clinical_sale_id = cs.clinical_sale_id AND cst.id='2' AND cst.code='total')
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement";
        $query = $this->db->query($sql);
        return !empty($query->row['amount']) ? (float) $query->row['amount'] : 0;
    }

    public function getLastUpdate()
    {
        $sql = "SELECT date_added FROM " . DB_PREFIX . "clinical_sale ORDER BY date_added DESC LIMIT 1";
        $query = $this->db->query($sql);
        return !empty($query->row['date_added']) ? $query->row['date_added'] : '';
    }

    public function getStatuses()
    {
        $sql = "SELECT order_status_id AS id, name FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int)$this->session->data['language_id'] . "' ORDER BY name";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
