<?php
class ModelAndroidReportDailySales extends Model
{
    public function getDoctorSales($data)
    {
        $result = [];
        $start = isset($data['start']) ? $data['start'] : 0;
        $limit = isset($data['limit']) ? $data['limit'] : 10;

        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            $filter_access_statement = " AND u.user_id = '" . (int)$this->session->data['user_id'] . "'";
        }

        $filter_doctor_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_doctor_statement = " AND u.user_id = '" . (int)$data['doctor_id'] . "'";
        }

        $sql_doctors = "SELECT u.* FROM " . DB_PREFIX . "user u 
        WHERE 1 
        AND u.position='2'
        $filter_doctor_statement
        $filter_access_statement 
        ORDER BY TRIM(CONCAT(u.firstname,' ',u.lastname))
        LIMIT $start, $limit";

        $query_doctor = $this->db->query($sql_doctors);
        if (!empty($query_doctor->rows)) {
            $doctor_ids = array_column($query_doctor->rows, 'user_id');
            //all customer
            $all_medical_totals = $this->getMedicalTotal($data, $doctor_ids, 'all');
            $all_service_totals = $this->getServiceTotal($data, $doctor_ids, 'all');
            $all_consultation_totals = $this->getConsultationTotal($data, $doctor_ids, 'all');

            //new customer
            $new_medical_totals = $this->getMedicalTotal($data, $doctor_ids, 'new');
            $new_service_totals = $this->getServiceTotal($data, $doctor_ids, 'new');
            $new_consultation_totals = $this->getConsultationTotal($data, $doctor_ids, 'new');
            // $new_patients = $this->getTotalCustomer($data, $doctor_ids, 'new');

            //existing customer
            $existing_medical_totals = $this->getMedicalTotal($data, $doctor_ids, 'existing');
            $existing_service_totals = $this->getServiceTotal($data, $doctor_ids, 'existing');
            $existing_consultation_totals = $this->getConsultationTotal($data, $doctor_ids, 'existing');
            // $existing_patients = $this->getTotalCustomer($data, $doctor_ids, 'existing');

            foreach ($query_doctor->rows as $doctor) {

                $new_patient = $existing_patient = 0;
                $doctor_name = trim($doctor['firstname'] . " " . $doctor['lastname']);
                $doctor_id = $doctor['user_id'];

                //all patient
                $medical_total = !empty($all_medical_totals[$doctor_id]) ? $all_medical_totals[$doctor_id] : 0;

                $consultation_total = !empty($all_consultation_totals[$doctor_id]) ? $all_consultation_totals[$doctor_id] : 0;

                $service_total = !empty($all_service_totals[$doctor_id]) ? $all_service_totals[$doctor_id] : 0;

                //new patient
                $new_medical_total = !empty($new_medical_totals[$doctor_id]) ? $new_medical_totals[$doctor_id] : 0;

                $new_consultation_total = !empty($new_consultation_totals[$doctor_id]) ? $new_consultation_totals[$doctor_id] : 0;

                $new_service_total = !empty($new_service_totals[$doctor_id]) ? $new_service_totals[$doctor_id] : 0;

                // $new_patient = !empty($new_patients[$doctor_id]) ? $new_patients[$doctor_id] : 0;
                $new_patient = $this->getTotalCustomer($data, $doctor['user_id'], 'new');

                //existing patient
                $existing_medical_total = !empty($existing_medical_totals[$doctor_id]) ? $existing_medical_totals[$doctor_id] : 0;

                $existing_consultation_total = !empty($existing_consultation_totals[$doctor_id]) ? $existing_consultation_totals[$doctor_id] : 0;

                $existing_service_total = !empty($existing_service_totals[$doctor_id]) ? $existing_service_totals[$doctor_id] : 0;

                // $existing_patient = !empty($existing_patients[$doctor_id]) ? $existing_patients[$doctor_id] : 0;
                $existing_patient = $this->getTotalCustomer($data, $doctor['user_id'], 'existing');

                $result[] = array(
                    'image' => $doctor['image'],
                    'doctor_id' => $doctor_id,
                    'doctor_name' => $doctor_name,
                    'medical' => $medical_total,
                    'consultation' => $consultation_total,
                    'service' => $service_total,
                    // 'total_patient' => $all_patient,
                    'new_medical' => $new_medical_total,
                    'new_consultation' => $new_consultation_total,
                    'new_service' => $new_service_total,
                    'new_patient' => $new_patient,
                    'existing_medical' => $existing_medical_total,
                    'existing_consultation' => $existing_consultation_total,
                    'existing_service' => $existing_service_total,
                    'existing_patient' => $existing_patient,
                );
            }
        }

        return $result;
    }

    private function getTotalCustomer($data, $doctor_id, $type = 'all')
    {
        $cs_condition = '';
        $sf_condition = '';
        $si_condition = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $cs_condition .= " AND cs.sales_date >= '" . $data['date_start'] . "' AND cs.sales_date <= '" . $data['date_end'] . "'";
            $sf_condition .= " AND sf.service_date >= '" . $data['date_start'] . "' AND sf.service_date <= '" . $data['date_end'] . "'";
        }

        if (!empty($data['payment_status'])) {
            $cs_condition .= " AND cs.order_action = '" . (int)$data['payment_status'] . "'";
            $sf_condition .= " AND sf.order_action = '" . (int)$data['payment_status'] . "'";
        }

        if (!empty($doctor_id)) {
            $cs_condition .= " AND cs.doctor_id = '" . (int)$doctor_id . "'";
            $si_condition .= " AND si.user_id = '" . (int)$doctor_id . "'";
        }

        $sql = "SELECT COUNT(DISTINCT c.customer_id) AS total FROM " . DB_PREFIX . "customer c 
        LEFT JOIN " . DB_PREFIX . "clinical_sale cs ON(cs.customer_id = c.customer_id $cs_condition)
        LEFT JOIN " . DB_PREFIX . "service_form sf ON(sf.customer_id = c.customer_id $sf_condition)
        LEFT JOIN " . DB_PREFIX . "service_item si ON(si.service_form_id = sf.service_form_id $si_condition)
        WHERE 1
        AND (cs.clinical_sale_id > 0 OR si.service_Item_id > 0)
        ";

        switch ($type) {
            case 'new':
                $sql .= " AND c.date_added >= '" . $data['date_start'] . " 00:00:00' AND c.date_added <= '" . $data['date_end'] . " 23:59:59'";
                break;
            case 'existing':
                $sql .= " AND c.date_added < '" . $data['date_start'] . " 00:00:00'";
                break;
            default:
                //do nothing
        }
        $query = $this->db->query($sql);
        return !empty($query->row['total']) ? $query->row['total'] : 0;
    }

    private function getTotalCustomer2($data, $doctor_id, $type = 'all')
    {
        $result = [];
        $cs_condition = '';
        $sf_condition = '';
        $si_condition = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $cs_condition .= " AND cs.sales_date >= '" . $data['date_start'] . "' AND cs.sales_date <= '" . $data['date_end'] . "'";
            $sf_condition .= " AND sf.service_date >= '" . $data['date_start'] . "' AND sf.service_date <= '" . $data['date_end'] . "'";
        }

        if (!empty($data['payment_status'])) {
            $cs_condition .= " AND cs.order_action = '" . (int)$data['payment_status'] . "'";
            $sf_condition .= " AND sf.order_action = '" . (int)$data['payment_status'] . "'";
        }

        if (!empty($doctor_id)) {
            if (is_array($doctor_id)) {
                $cs_condition = " AND cs.doctor_id IN (" . implode(",", $doctor_id) . ")";
                $si_condition = " AND si.user_id IN (" . implode(",", $doctor_id) . ")";
            } else {
                $cs_condition .= " AND cs.doctor_id = '" . (int)$doctor_id . "'";
                $si_condition .= " AND si.user_id = '" . (int)$doctor_id . "'";
            }
        }

        $sql = "SELECT 
        CASE WHEN cs.doctor_id IS NOT NULL AND si.user_id IS NULL THEN cs.doctor_id ELSE si.user_id END AS doctor_id,
        COUNT(DISTINCT c.customer_id) AS total 
        FROM " . DB_PREFIX . "customer c 
        LEFT JOIN " . DB_PREFIX . "clinical_sale cs ON(cs.customer_id = c.customer_id $cs_condition)
        LEFT JOIN " . DB_PREFIX . "service_form sf ON(sf.customer_id = c.customer_id $sf_condition)
        LEFT JOIN " . DB_PREFIX . "service_item si ON(si.service_form_id = sf.service_form_id $si_condition)
        WHERE 1
        AND (cs.clinical_sale_id > 0 OR si.service_Item_id > 0)
        ";

        switch ($type) {
            case 'new':
                $sql .= " AND c.date_added >= '" . $data['date_start'] . " 00:00:00' AND c.date_added <= '" . $data['date_end'] . " 23:59:59'";
                break;
            case 'existing':
                $sql .= " AND c.date_added < '" . $data['date_start'] . " 00:00:00'";
                break;
            default:
                //do nothing
        }

        $sql .= " GROUP BY doctor_id";

        echo "\n$sql\n";
        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $result[$row['doctor_id']] = $row['total'];
        }
        return $result;
    }

    private function getMedicalTotal($data, $doctor_id, $type = 'all')
    {
        $result = [];
        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND sales_date >= '" . $data['date_start'] . "' AND sales_date <= '" . $data['date_end'] . "'";
        }

        $filter_payment_status_statement = '';
        if (!empty($data['payment_status'])) {
            $filter_payment_status_statement = " AND order_action = '" . (int)$data['payment_status'] . "'";
        }

        $filter_doctor_statement = '';
        if (!empty($doctor_id)) {
            if (is_array($doctor_id)) {
                $filter_doctor_statement = " AND doctor_id IN (" . implode(",", $doctor_id) . ")";
            } else {
                $filter_doctor_statement = " AND doctor_id='" . (int)$doctor_id . "'";
            }
        }

        $sql = "SELECT doctor_id, SUM(clinicalsale_total) AS total FROM " . DB_PREFIX . "clinical_sale WHERE 1
        $filter_doctor_statement
        $filter_date_statement
        $filter_payment_status_statement";

        switch ($type) {
            case 'new':
                $sql .= " AND customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added >= '" . $data['date_start'] . " 00:00:00' AND date_added <= '" . $data['date_end'] . " 23:59:59')";
                break;
            case 'existing':
                $sql .= " AND customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added < '" . $data['date_start'] . " 00:00:00')";
                break;
            default:
                //do nothing
        }

        $sql .= " GROUP BY doctor_id";

        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $result[$row['doctor_id']] = $row['total'];
        }
        return $result;
    }

    private function getConsultationTotal($data, $doctor_id, $type = 'all')
    {
        $result = [];
        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND sales_date >= '" . $data['date_start'] . "' AND sales_date <= '" . $data['date_end'] . "'";
        }

        $filter_payment_status_statement = '';
        if (!empty($data['payment_status'])) {
            $filter_payment_status_statement = " AND order_action = '" . (int)$data['payment_status'] . "'";
        }

        $filter_doctor_statement = '';
        if (!empty($doctor_id)) {
            if (is_array($doctor_id)) {
                $filter_doctor_statement = " AND doctor_id IN (" . implode(",", $doctor_id) . ")";
            } else {
                $filter_doctor_statement = " AND doctor_id='" . (int)$doctor_id . "'";
            }
        }

        $sql = "SELECT doctor_id, SUM(clinicalsale_concultation) AS total FROM " . DB_PREFIX . "clinical_sale WHERE 1 AND collect_consultation_price = '1'
        $filter_doctor_statement
        $filter_date_statement
        $filter_payment_status_statement";

        switch ($type) {
            case 'new':
                $sql .= " AND customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added >= '" . $data['date_start'] . " 00:00:00' AND date_added <= '" . $data['date_end'] . " 23:59:59')";
                break;
            case 'existing':
                $sql .= " AND customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added < '" . $data['date_start'] . " 00:00:00')";
                break;
            default:
                //do nothing
        }

        $sql .= " GROUP BY doctor_id";

        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $result[$row['doctor_id']] = $row['total'];
        }
        return $result;
    }
    private function getServiceTotal($data, $doctor_id, $type = 'all')
    {
        $result = [];
        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND sf.service_date >= '" . $data['date_start'] . "' AND sf.service_date <= '" . $data['date_end'] . "'";
        }


        $filter_payment_status_statement = '';
        if (!empty($data['payment_status'])) {
            $filter_payment_status_statement = " AND sf.order_action = '" . (int)$data['payment_status'] . "'";
        }

        $filter_doctor_statement = '';
        if (!empty($doctor_id)) {
            if (is_array($doctor_id)) {
                $filter_doctor_statement = " AND si.user_id IN (" . implode(",", $doctor_id) . ")";
            } else {
                $filter_doctor_statement = " AND si.user_id='" . (int)$doctor_id . "'";
            }
        }

        $sql = "SELECT si.user_id AS doctor_id, SUM(si.total) AS total FROM " . DB_PREFIX . "service_item si
        LEFT JOIN " . DB_PREFIX . "service_form sf
        ON(si.service_form_id=sf.service_form_id)
        WHERE 1
        AND sf.service_form_id IS NOT NULL
        $filter_doctor_statement
        $filter_date_statement
        $filter_payment_status_statement";

        switch ($type) {
            case 'new':
                $sql .= " AND sf.customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added >= '" . $data['date_start'] . " 00:00:00' AND date_added <= '" . $data['date_end'] . " 23:59:59')";
                break;
            case 'existing':
                $sql .= " AND sf.customer_id IN (SELECT customer_id FROM " . DB_PREFIX . "customer WHERE date_added < '" . $data['date_start'] . " 00:00:00')";
                break;
            default:
                //do nothing
        }
        $sql .= " GROUP BY doctor_id";

        $query = $this->db->query($sql);
        foreach ($query->rows as $row) {
            $result[$row['doctor_id']] = $row['total'];
        }
        return $result;
    }

    public function getResultTotal($data)
    {
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            $filter_access_statement = " AND user_id = '" . (int)$this->session->data['user_id'] . "'";
        }

        $filter_doctor_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_doctor_statement = " AND user_id = '" . (int)$data['doctor_id'] . "'";
        }

        $doctors = $this->db->query("SELECT user_id FROM " . DB_PREFIX . "user 
        WHERE position = '2'
        $filter_doctor_statement
        $filter_access_statement")->rows;
        $doctor_ids = array_column($doctors, 'user_id');
        //initialize
        $all_medical_total = $all_consultation_total = $all_service_total = $new_medical_total = $new_consultation_total = $new_service_total = $existing_medical_total = $existing_consultation_total = $existing_service_total = 0;
        if (!empty($doctor_ids)) {
            //all patient
            $all_medical_total = $this->getMedicalTotal($data, $doctor_ids, 'all');
            $all_consultation_total = $this->getConsultationTotal($data, $doctor_ids, 'all');
            $all_service_total = $this->getServiceTotal($data, $doctor_ids, 'all');

            //new patient
            $new_medical_total = $this->getMedicalTotal($data, $doctor_ids, 'new');
            $new_consultation_total = $this->getConsultationTotal($data, $doctor_ids, 'new');
            $new_service_total = $this->getServiceTotal($data, $doctor_ids, 'new');

            //existing patient
            $existing_medical_total = $this->getMedicalTotal($data, $doctor_ids, 'existing');
            $existing_consultation_total = $this->getConsultationTotal($data, $doctor_ids, 'existing');
            $existing_service_total = $this->getServiceTotal($data, $doctor_ids, 'existing');
        }
        return [
            "all_medical_total"         => array_sum($all_medical_total),
            "all_consultation_total"    => array_sum($all_consultation_total),
            "all_service_total"         => array_sum($all_service_total),

            "new_medical_total"         => array_sum($new_medical_total),
            "new_consultation_total"    => array_sum($new_consultation_total),
            "new_service_total"         => array_sum($new_service_total),

            "existing_medical_total"        => array_sum($existing_medical_total),
            "existing_consultation_total"   => array_sum($existing_consultation_total),
            "existing_service_total"        => array_sum($existing_service_total),
        ];
    }

    public function getLastUpdate()
    {
        $sql = "SELECT MAX(last_update) AS last_update FROM (
            SELECT MAX(date_added) AS last_update FROM " . DB_PREFIX . "clinical_sale
            UNION ALL
            SELECT MAX(date_added) AS last_update FROM " . DB_PREFIX . "service_form
            ) a";
        $query = $this->db->query($sql);
        return !empty($query->row['last_update']) ? $query->row['last_update'] : '';
    }

    public function getStatuses()
    {
        $sql = "SELECT order_status_id AS id, name FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int)$this->session->data['language_id'] . "' ORDER BY name";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
