<?php
class ModelAndroidReportBrewingSale extends Model
{
    public function getTransactions($data)
    {
        $start  = isset($data['start']) ? $data['start'] : 0;
        $limit  = isset($data['limit']) ? $data['limit'] : 20;

        $filter_access_statement = "AND o.store_id = '" . (int)$this->session->data['store_id'] . "'";

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND o.doc_date >= '" . $data['date_start'] . "' AND o.doc_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND o.etcm_status_code ='" . $this->db->escape($data['status']) . "'";
        }

        $filter_customer_statement = '';
        if (!empty($data['customer_name'])) {
            $filter_customer_statement = " AND o.customer_name LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }
        if (!empty($data['customer_id'])){
            $filter_customer_statement .=" AND o.customer_id = '".(int)$data['customer_id']."'";
        }

        $filter_amount_statement = '';
        if (!empty($data['amount_start'])) {
            $filter_amount_statement .= " AND o.total >= '" . (float)$data['amount_start'] . "'";
        }

        if (!empty($data['amount_end'])) {
            $filter_amount_statement .= " AND o.total <= '" . (float)$data['amount_end'] . "'";
        }

        $sql = "SELECT *,
        (SELECT SUM(t.value) FROM " . DB_PREFIX . "service_partner_sale_order_total t WHERE t.sale_order_id = o.sale_order_id AND t.code NOT IN ('credit','total')) AS grand_total
         FROM " . DB_PREFIX . "service_partner_sale_order o
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement
        $filter_customer_statement
        $filter_amount_statement

        ORDER BY o.doc_date DESC
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalTransactions($data)
    {
        $filter_access_statement = "AND o.store_id = '" . (int)$this->session->data['store_id'] . "'";

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND o.doc_date >= '" . $data['date_start'] . "' AND o.doc_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND o.etcm_status_code ='" . $this->db->escape($data['status']) . "'";
        }

        $filter_customer_statement = '';
        if (!empty($data['customer_name'])) {
            $filter_customer_statement = " AND o.customer_name LIKE '%" . $this->db->escape($data['customer_name']) . "%'";
        }
        if (!empty($data['customer_id'])){
            $filter_customer_statement .=" AND o.customer_id = '".(int)$data['customer_id']."'";
        }

        $filter_amount_statement = '';
        if (!empty($data['amount_start'])) {
            $filter_amount_statement .= " AND o.total >= '" . (float)$data['amount_start'] . "'";
        }

        if (!empty($data['amount_end'])) {
            $filter_amount_statement .= " AND o.total <= '" . (float)$data['amount_end'] . "'";
        }

        $sql = "SELECT 
        COUNT(*) AS transactions,
        SUM(a.total) AS amount,
        SUM((a.total * a.transaction_fee) / 100) AS commission
        FROM (SELECT SUM(t.value) AS total, o.transaction_fee FROM " . DB_PREFIX . "service_partner_sale_order o 
        LEFT JOIN " . DB_PREFIX . "service_partner_sale_order_total t 
        ON(o.sale_order_id = t.sale_order_id AND t.code NOT IN ('credit','total'))
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement
        $filter_customer_statement
        $filter_amount_statement
        GROUP BY o.sale_order_id
        ) a";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getTotalSale($data)
    {

        $filter_access_statement = "AND o.store_id = '" . (int)$this->session->data['store_id'] . "'";

        $filter_date_statement = '';
        if (!empty($data['date_start']) && !empty($data['date_end'])) {
            $filter_date_statement = " AND o.doc_date >= '" . $data['date_start'] . "' AND o.doc_date <= '" . $data['date_end'] . "'";
        }

        $filter_status_statement = '';
        if (!empty($data['status'])) {
            $filter_status_statement = " AND o.etcm_status_code ='" . $this->db->escape($data['status']) . "'";
        }

        // $sql = "SELECT SUM(t.`value`) AS amount FROM " . DB_PREFIX . "service_partner_sale_order o
        // LEFT JOIN ".DB_PREFIX."service_partner_sale_order_total t ON(o.sale_order_id = t.sale_order_id AND t.code NOT IN ('credit','total'))
        // WHERE 1 
        // $filter_date_statement
        // $filter_access_statement
        // $filter_status_statement 
        // ";

        $sql = "SELECT 
        SUM(a.total) AS amount,
        SUM((a.total * a.transaction_fee) / 100) AS commission
        FROM (SELECT SUM(t.value) AS total, o.transaction_fee FROM " . DB_PREFIX . "service_partner_sale_order o 
        LEFT JOIN " . DB_PREFIX . "service_partner_sale_order_total t 
        ON(o.sale_order_id = t.sale_order_id AND t.code NOT IN ('credit','total'))
        WHERE 1
        $filter_access_statement
        $filter_date_statement
        $filter_status_statement
        GROUP BY o.sale_order_id
        ) a";
        $query = $this->db->query($sql);
        // return !empty($query->row['amount']) ? (float) $query->row['amount'] : 0;
        $amount = !empty($query->row['amount']) ? (float) $query->row['amount'] : 0;
        $commission = !empty($query->row['commission']) ? (float) $query->row['commission'] : 0;

        return [$amount, $commission];
    }

    public function getLastUpdate()
    {
        $sql = "SELECT date_added FROM " . DB_PREFIX . "service_partner_sale_order ORDER BY date_added DESC LIMIT 1";
        $query = $this->db->query($sql);
        return !empty($query->row['date_added']) ? $query->row['date_added'] : '';
    }
}
