<?php

class ModelAndroidProductProduct extends Model
{

    public function getProducts($data)
    {
        #region sorting & pagination

        //default sort by name desc
        $order_column = "p.date_added";
        $direction = "DESC";

        if (!empty($data['sort_by'])) {
            if (in_array($data['sort_by'], ['date_added'])) {
                $order_column = "p.date_added";
            }
        }

        if (!empty($data['sort_direction'])) {
            if (in_array($data['sort_direction'], ['ASC', 'DESC'])) {
                $direction = $data['sort_direction'];
            }
        }

        $order_statement = "ORDER BY $order_column $direction, cn_pd.name ASC";

        $start = $data['start'];
        $limit = $data['limit'];
        #endregion

        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            $filter_access_statement = " AND pts.store_id = '" . (int)$this->session->data['store_id'] . "'";
        }


        $filter_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $filter_statement .= " AND (";
            $filter_statement .= "en_pd.name LIKE '%" . $this->db->escape($filter_search) . "%'  ";
            $filter_statement .= " OR cn_pd.name LIKE '%" . $this->db->escape($filter_search) . "%'  ";
            $filter_statement .= " OR p.code LIKE '%" . $this->db->escape($filter_search) . "%'  ";
            $filter_statement .= ") ";
        }

        if (!empty($data['min_sell_price'])) {
            $filter_statement .= " AND p.price >= '" . (float)$data['min_sell_price'] . "'";
        }

        if (!empty($data['max_sell_price'])) {
            $filter_statement .= " AND p.price <= '" . (float)$data['max_sell_price'] . "'";
        }

        $sql = "SELECT p.*, 
            en_pd.name as en_name,
            cn_pd.name as cn_name,
            GROUP_CONCAT(cd.name ORDER BY cd.name ASC) AS category_name
            FROM " . DB_PREFIX . "product p
            LEFT JOIN " . DB_PREFIX . "product_description en_pd ON(p.product_id=en_pd.product_id AND en_pd.language_id='1')
            LEFT JOIN " . DB_PREFIX . "product_description cn_pd ON(p.product_id=cn_pd.product_id AND cn_pd.language_id='2')
            LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON(ptc.product_id = p.product_id)
            LEFT JOIN " . DB_PREFIX . "category_description cd ON(cd.category_id = ptc.category_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "')
            LEFT JOIN " . DB_PREFIX . "product_to_store pts ON(pts.product_id = p.product_id)
            WHERE 1
            $filter_statement
            $filter_access_statement
            GROUP BY p.product_id
            $order_statement
            LIMIT $start,$limit";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProduct($product_id)
    {
        $sql = "SELECT p.*,
        en_pd.name as en_name,
        cn_pd.name as cn_name 
        FROM " . DB_PREFIX . "product p
            LEFT JOIN " . DB_PREFIX . "product_description en_pd ON(p.product_id=en_pd.product_id AND en_pd.language_id='1')
            LEFT JOIN " . DB_PREFIX . "product_description cn_pd ON(p.product_id=cn_pd.product_id AND cn_pd.language_id='2')
        WHERE p.product_id='" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function addProduct($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "product 
        SET 
        model = '" . $this->db->escape($data['model']) . "', 
        code = '" . $this->db->escape($data['code']) . "', 
        quantity = '" . (int) $data['quantity'] . "', 
        minimum = '" . (int) $data['minimum'] . "', 
        subtract = '" . (int) $data['subtract'] . "', 
        shipping = '" . (int) $data['shipping'] . "', 
        price = '" . (float) $data['sellingprice'] . "', 
        costprice = '" . (float) $data['costprice'] . "', 
        selling_product = '" . (int) $data['pos_selling'] . "', 
        product_type = '" . (int) $data['product_type'] . "', 
        weight = '" . (float) $data['weight'] . "', 
        weight_class_id = '" . (int) $data['weight_class_id'] . "', 
        length_class_id = '" . (int) $data['length_class_id'] . "', 
        status = '" . (int) $data['status'] . "', 
        internal_status = '" . (int) $data['internal_status'] . "', 
        tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', 
        add_by = '" . (int) $this->session->data['user_id'] . "', 
        modify_by = '" . (int) $this->session->data['user_id'] . "', 
        date_added = NOW()";

        $this->db->query($sql);

        $product_id = $this->db->getLastId();

        foreach ($data['product_desc'] as $language_id => $value) {
            $sql = "INSERT INTO " . DB_PREFIX . "product_description SET 
            product_id = '" . (int) $product_id . "', 
            language_id = '" . (int) $language_id . "', 
            name = '" . $this->db->escape($value['name']) . "', 
            description = '" . $this->db->escape($value['name']) . "', 
            tag = '" . $this->db->escape($value['name']) . "', 
            meta_title = '" . $this->db->escape($value['name']) . "', 
            meta_description = '" . $this->db->escape($value['name']) . "', 
            meta_keyword = '" . $this->db->escape($value['name']) . "'";
            $this->db->query($sql);
        }

        if (isset($data['product_store'])) {
            foreach ($data['product_store'] as $store_id) {
                $sql = "INSERT INTO " . DB_PREFIX . "product_to_store SET product_id = '" . (int) $product_id . "', store_id = '" . (int) $store_id . "'";
                $this->db->query($sql);
            }
        }

        return $product_id;
    }

    public function editProduct($data)
    {
        $sql = "UPDATE " . DB_PREFIX . "product 
        SET 
        model = '" . $this->db->escape($data['model']) . "', 
        code = '" . $this->db->escape($data['code']) . "', 
        price = '" . (float) $data['sellingprice'] . "', 
        costprice = '" . (float) $data['costprice'] . "', 
        selling_product = '" . (int) $data['pos_selling'] . "', 
        weight = '" . (float) $data['weight'] . "', 
        weight_class_id = '" . (int) $data['weight_class_id'] . "', 
        internal_status = '" . (int) $data['internal_status'] . "', 
        tax_class_id = '" . $this->db->escape($data['tax_class_id']) . "', 
        modify_by = '" . (int) $this->session->data['user_id'] . "', 
        date_modified = NOW()
        WHERE product_id = '" . (int)$data['product_id'] . "'";

        $this->db->query($sql);

        if (isset($data['en_name'])) {
            $sql = "UPDATE " . DB_PREFIX . "product_description SET 
            name = '" . $this->db->escape($data['en_name']) . "'
            WHERE 
            product_id = '" . (int) $data['product_id'] . "' AND
            language_id = '" . (int) 1 . "'";
            $this->db->query($sql);
        }
        if (isset($data['cn_name'])) {
            $sql = "UPDATE " . DB_PREFIX . "product_description SET 
            name = '" . $this->db->escape($data['cn_name']) . "'
            WHERE 
            product_id = '" . (int) $data['product_id'] . "' AND
            language_id = '" . (int) 2 . "'";
            $this->db->query($sql);
        }

        return $data['product_id'];
    }

    public function saveImage($product_id, $image)
    {
        $sql = "UPDATE " . DB_PREFIX . "product SET image = '" . $this->db->escape($image) . "' WHERE product_id='" . (int)$product_id . "'";
        $this->db->query($sql);
    }

    public function deleteImage($product_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "product SET image = '' WHERE product_id='" . (int)$product_id . "'";
        $this->db->query($sql);
    }

    public function deleteProduct($product_id)
    {
        $sql = "DELETE FROM " . DB_PREFIX . "product WHERE product_id='" . (int)$product_id . "'";
        $this->db->query($sql);
        $sql = "DELETE FROM " . DB_PREFIX . "product_description WHERE product_id='" . (int)$product_id . "'";
        $this->db->query($sql);
        $sql = "DELETE FROM " . DB_PREFIX . "product_to_store WHERE product_id='" . (int)$product_id . "'";
        $this->db->query($sql);
    }

    public function getTaxClasses()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "tax_class ORDER BY title ASC";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getWeightClasses()
    {
        $sql = "SELECT w.* FROM " . DB_PREFIX . "weight_class_description w WHERE w.language_id='" . (int)$this->session->data['language_id'] . "'";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
