<?php

class ModelAndroidPrescriptionProduct extends Model
{
    public function getProductList($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        $category_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "p.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR pd.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }
        if (!empty($data['filter_categories'])) {
            $category_statement = " AND ptc.category_id in ('" . implode("','", $data['filter_categories']) . "')";
        } else {
            $category_statement = " AND ptc.category_id IN ('" . implode("', '", $this->getShowCategories()) . "')";
        }

        $sql = "SELECT 
        p.product_id AS id,
        TRIM(CONCAT( pd.name,'(',p.code,')')) AS label,
        p.image,
        SUM(pts.onhand_quantity) AS stock_qty
        FROM
        " . DB_PREFIX . "product p
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON(p.product_id=ptc.product_id)
        LEFT JOIN " . DB_PREFIX . "product_to_store pts ON(p.product_id = pts.product_id AND pts.store_id = '" . (int)$this->session->data['store_id'] . "')
        WHERE 1
        AND p.internal_status = 1 
        $search_statement
        $category_statement
        GROUP BY p.product_id
        ORDER BY SUM(pts.onhand_quantity) DESC, label
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProduct($product_id)
    {
        $currency = $this->currency->getSymbolLeft($this->config->get('config_currency'));
        $sql = "SELECT 
        p.product_id, 
        pd.name,
        p.code, 
        TRIM(CONCAT( pd.name,'(',p.code,')')) AS label,
        '$currency' AS currency,
        p.price,
        wcd.unit AS weight_class,
        p.weight_class_id
        FROM " . DB_PREFIX . "product p
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        /* AND p.internal_status = 1 */
        AND p.product_id = '" . (int)$product_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getCategories()
    {
        $sql = "SELECT cd.category_id as id, cd.name FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd ON(cd.category_id = c.category_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE c.status='1' AND
        c.category_id IN ('" . implode("', '", $this->getShowCategories()) . "')
        ORDER BY cd.name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getShowCategories()
    {
        $sql = "SELECT DISTINCT(category_id) AS id FROM " . DB_PREFIX . "cook_type WHERE status='1'";
        $query = $this->db->query($sql);
        return !empty($query->rows) ? array_column($query->rows, 'id') : [];
    }
}
