<?php

class ModelAndroidPrescriptionPrescription extends Model
{
    public function getPrescriptionList($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "p.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR pn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT 
        p.prescription_id AS id,
        TRIM(CONCAT( pn.name,'(',p.code,')')) AS label
        FROM
        " . DB_PREFIX . "prescription p
        LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id=pn.prescription_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE p.status = 1
        $search_statement
        ORDER BY label
        LIMIT $start, $limit
        ";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPrescription($prescription_id)
    {
        $sql = "SELECT p.prescription_id, pn.name, p.code FROM " . DB_PREFIX . "prescription p
        LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id=pn.prescription_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE p.status='1' 
        AND p.prescription_id = '" . (int)$prescription_id . "' 
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $info = $query->row;
            $info['products'] = $this->getPrescriptionItem($prescription_id);
            return $info;
        } else {
            return null;
        }
    }

    public function getPrescriptionItem($prescription_id)
    {
        $currency = $this->currency->getSymbolLeft($this->config->get('config_currency'));
        $language_id = $this->session->data['language_id'];
        $sql = "SELECT 
        p.product_id,
        pd.name,
        p.code,
        '$currency' AS currency,
        p.price,
        pi.used_qty AS quantity,
        wcd.unit AS weight_class,
        p.weight_class_id 
        FROM " . DB_PREFIX . "prescription_item pi
        RIGHT JOIN " . DB_PREFIX . "product p ON (pi.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id = '" . (int)$language_id . "') 
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$language_id . "')
        WHERE pi.prescription_id ='" . (int)$prescription_id . "'
        ORDER BY pi.display_order, pd.name
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getConsumeMethods()
    {
        $sql = "SELECT ckd.name FROM " . DB_PREFIX . "cook_type ck
        LEFT JOIN " . DB_PREFIX . "cook_type_description ckd 
        ON(ck.cook_type_id = ckd.cook_type_id AND ckd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE ck.status= '1'
        ";
        $query = $this->db->query($sql);
        if (!empty($query->rows)) {
            $result = array_column($query->rows, 'name');
        } else {
            $result = array();
        }
        return $result;
    }

    public function getTakeTypes()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "prescription_taketype_description WHERE language_id = '" . (int)$this->session->data['language_id'] . "'
        ";
        $query = $this->db->query($sql);
        if (!empty($query->rows)) {
            $result = array_column($query->rows, 'name');
        } else {
            $result = array();
        }
        return $result;
    }

    public function getHerbServiceTypes()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "herb_service_type WHERE language_id ='" . (int)$this->session->data['language_id'] . "'";

        $query = $this->db->query($sql);
        return $query->rows;
    }
}
