<?php

class ModelAndroidPrescriptionMedicine extends Model
{
    private $etcm_categories = [
        array(
            "id" => "E_HERBS",
            "cn_name" => "ETCM药房联盟",
            "en_name" => "ETCM药房联盟",
        ),
        array(
            "id" => "E_NGP",
            "cn_name" => "新绿色药房联盟",
            "en_name" => "NGP新绿色药房联盟"
        )
    ];

    public function getItems($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $category_statement = '';
        $search_statement_product = '';
        $search_statement_prescription = '';

        if (!empty($data['filter_search'])) {
            $filter_search = trim($data['filter_search']);

            //prepare search statement for products
            $search_statement_product .= " AND(";
            $search_statement_product .= "p.code LIKE '%" . $this->db->escape($filter_search) . "%'";
            $search_statement_product .= "OR pd.name LIKE '%" . $this->db->escape($filter_search) . "%'";
            $search_statement_product .= ")";

            //prepare search statement for prescriptions
            $search_statement_prescription .= " AND ( ";
            $search_statement_prescription .= "p.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement_prescription .= "OR pn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement_prescription .= ")";
        }

        if (!empty($data['filter_categories'])) {
            $category_id = $data['filter_categories'];
            if (is_numeric($category_id)) {
                $category_statement = " AND ptc.category_id = '" . (int)$category_id . "'";
            } else {
                $category_id = $category_id == 'E_NGP' ? '80' : '63';
                $category_statement = " AND ptc.category_id = '" . (int)$category_id . "' AND p.product_id IN (SELECT product_id FROM " . DB_PREFIX . "etcm_service_partner_product_match)";
            }
        }
        //  else {
        //     // $category_statement = " AND ptc.category_id IN ('" . implode("', '", $this->getShowCategories()) . "')";
        // }

        //overwrite category_statement if dispense_code passed
        if (!empty($data['dispense_code'])) {
            $category_statement = '';
            $dispense_info = $this->getDispenseInfo($data['dispense_code']);
            if (!empty($dispense_info['product_type'])) {
                $category_statement = " AND ptc.category_id IN (SELECT DISTINCT(category_id) FROM " . DB_PREFIX . "product_code_match WHERE product_type='" . $this->db->escape($dispense_info['product_type']) . "')";
            }

            // if ETCM dispense
            if (substr($data['dispense_code'], 0, 5) !== 'SELF_') {
                $category_statement .= " AND p.product_id IN (SELECT product_id FROM " . DB_PREFIX . "etcm_service_partner_product_match)";
            }
        }

        $type_statement = '';
        $type = '';
        if (!empty($data['type'])) {
            $type = $data['type'];
            $type_statement = " AND a.type = '" . $this->db->escape($data['type']) . "'";
        }

        $sql_mixed = "SELECT * FROM (
            SELECT p.product_id AS id, TRIM(CONCAT( pd.name,'(',p.code,')')) AS label, 'product' AS type, p.price
            FROM " . DB_PREFIX . "product p
            LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id='" . (int)$this->session->data['language_id'] . "')
            LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON(p.product_id=ptc.product_id)
            WHERE p.internal_status = 1 
            $search_statement_product
            $category_statement
            GROUP BY p.product_id

            UNION ALL

            SELECT p.prescription_id AS id, TRIM(CONCAT( pn.name,'(',p.code,')')) AS label, 'prescription' AS type, NULL as price
            FROM " . DB_PREFIX . "prescription p
            LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id = pn.prescription_id AND language_id = '" . (int)$this->session->data['language_id'] . "')
            WHERE p.status = 1
            $search_statement_prescription
        )a
        WHERE 1
        $type_statement
        ORDER BY a.label LIMIT $start, $limit";

        $sql_product = "SELECT p.product_id AS id, 
        TRIM(CONCAT( pd.name,'(',p.code,')')) AS label, 
        'product' AS type, p.price
            FROM " . DB_PREFIX . "product p
            LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id='" . (int)$this->session->data['language_id'] . "')
            LEFT JOIN " . DB_PREFIX . "product_to_category ptc ON(p.product_id=ptc.product_id)
            WHERE p.internal_status = 1 
            $search_statement_product
            $category_statement
            GROUP BY p.product_id
        ORDER BY TRIM(CONCAT( pd.name,'(',p.code,')')) LIMIT $start, $limit";

        $sql_prescription = "SELECT p.prescription_id AS id,
        TRIM(CONCAT( pn.name,'(',p.code,')')) AS label,
        'prescription' AS type
            FROM " . DB_PREFIX . "prescription p
            LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id = pn.prescription_id AND language_id = '" . (int)$this->session->data['language_id'] . "')
            WHERE p.status = 1
            $search_statement_prescription
        
        ORDER BY TRIM(CONCAT( pn.name,'(',p.code,')')) LIMIT $start, $limit";

        switch ($type) {
            case 'product':
                $sql = $sql_product;
                break;
            case 'prescription':
                $sql = $sql_prescription;
                break;
            default:
                $sql = $sql_mixed;
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCategories()
    {
        $category_statement = "AND
        c.category_id IN ('" . implode("', '", $this->getShowCategories()) . "')";
        $category_statement = ''; //temporary show all
        $sql = "SELECT cd.category_id as id, cd.name FROM " . DB_PREFIX . "category c LEFT JOIN " . DB_PREFIX . "category_description cd ON(cd.category_id = c.category_id AND cd.language_id='" . (int)$this->session->data['language_id'] . "') 
        WHERE c.status='1' $category_statement
        ORDER BY cd.name";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDispenseInfo($code)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "medication_dispense WHERE dispense_code='" . $this->db->escape($code) . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getShowCategories()
    {
        return array(63, 80);
    }

    public function getConsumeMethods()
    {
        $sql = "SELECT ck.*, ckd.name FROM " . DB_PREFIX . "cook_type ck
        LEFT JOIN " . DB_PREFIX . "cook_type_description ckd 
        ON(ck.cook_type_id = ckd.cook_type_id AND ckd.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE ck.status= '1'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTakeTypes()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "prescription_taketype_description WHERE language_id = '" . (int)$this->session->data['language_id'] . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getMedicationDispenses($parent_id = 0)
    {
        $sql = "SELECT m.*, md.name FROM " . DB_PREFIX . "medication_dispense m 
        LEFT JOIN " . DB_PREFIX . "medication_dispense_description md ON(m.medication_dispense_id = md.medication_dispense_id AND md.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE m.status = '1' AND m.parent_id='" . (int)$parent_id . "'";
        if ($parent_id) {
            $sql .= "ORDER BY md.name";
        } else {
            $sql .= "ORDER BY m.medication_dispense_id";
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProductTypeByCategoryId($category_id)
    {
        if (is_numeric($category_id)) {
            $sql = "SELECT product_type FROM " . DB_PREFIX . "product_code_match WHERE category_id = '" . (int)$category_id . "' LIMIT 1";
            $query = $this->db->query($sql);
            return $query->row['product_type'];
        } else {
            if ($category_id == 'E_NGP') {
                return 'granule';
            } else {
                return 'herbs';
            }
        }
    }
    public function getCategoryNameById($category_id)
    {
        if (is_numeric($category_id)) {
            $sql = "SELECT name FROM " . DB_PREFIX . "category_description WHERE category_id = '" . (int)$category_id . "' AND language_id='" . (int)$this->session->data['language_id'] . "'";
            $query = $this->db->query($sql);
            return strtoupper($query->row['name']);
        } else {
            $cat_name = null;
            foreach ($this->etcm_categories as $cat) {
                if ($category_id == $cat['id']) {
                    $cat_name = $this->session->data['language_id'] == 1 ? $cat['en_name'] : $cat['cn_name'];
                }
            }
            return $cat_name;
        }
    }


    public function savePrescription($data)
    {
        $name = trim($data['name']);
        $name_en = !empty($data['name_en']) ? trim($data['name_en']) : $name;
        $code = trim($data['code']);


        $sql = "INSERT INTO " . DB_PREFIX . "prescription SET 
        code = '" . $this->db->escape($code) . "',
        status = '1',
        sort_order = '1',
        add_by = '" . (int)$this->session->data['user_id'] . "',
        date_added = NOW(),
        modify_by = '" . (int)$this->session->data['user_id'] . "',
        date_modified = NOW()
        ";
        $this->db->query($sql);

        $prescription_id = $this->db->getLastId();

        if ($prescription_id) {
            //save prescription name
            $sql_en = "INSERT INTO " . DB_PREFIX . "prescription_name SET
            prescription_id = '" . (int)$prescription_id . "',
            name = '" . $this->db->escape($name_en) . "',
            language_id = '1'";
            $sql_cn = "INSERT INTO " . DB_PREFIX . "prescription_name SET
            prescription_id = '" . (int)$prescription_id . "',
            name = '" . $this->db->escape($name) . "',
            language_id = '2'";

            $this->db->query($sql_en);
            $this->db->query($sql_cn);


            //insert item
            foreach ($data['items'] as $item) {
                $sql_item = "INSERT INTO " . DB_PREFIX . "prescription_item SET
                prescription_id = '" . (int)$prescription_id . "',
                product_id = '" . (int)$item['product_id'] . "',
                used_qty = '" . (int)$item['qty'] . "',
                display_order = '1',
                remark = '',
                add_by = '" . (int)$this->session->data['user_id'] . "',
                date_added = NOW(),
                modify_by = '" . (int)$this->session->data['user_id'] . "',
                date_modified = NOW()";
                $this->db->query($sql_item);
            }

            $item_query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "prescription_item WHERE prescription_id = '" . (int)$prescription_id . "'");
            if (empty($item_query->row['total'])) {
                //delete pres if no item added
                $this->db->query("DELETE FROM " . DB_PREFIX . "prescription_name WHERE prescription_id = '" . (int)$prescription_id . "'");
                $this->db->query("DELETE FROM " . DB_PREFIX . "prescription WHERE prescription_id = '" . (int)$prescription_id . "'");
                $prescription_id = 0;
            }
        }

        return $prescription_id;
    }
}
