<?php

class ModelAndroidMedicalRecordMedicalRecord extends Model
{
    public function getMedicalRecords($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $filter_statement = '';
        if (!empty($data['customer_id'])) {
            $filter_statement .= " AND cs.customer_id ='" . (int)$data['customer_id'] . "'";
        }
        if (!empty($data['ic_no'])) {
            $filter_statement .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['ic_no']) . "%'";
        }
        if (!empty($data['card_no'])) {
            $filter_statement .= " AND c.customer_card LIKE '%" . $this->db->escape($data['card_no']) . "%'";
        }
        if (!empty($data['name'])) {
            $filter_statement .= " AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['name']) . "%'";
        }
        if (!empty($data['status_id'])) {
            $filter_statement .= " AND cs.clinicalsale_action ='" . (int)$data['status_id'] . "'";
        }
        if (!empty($data['gender'])) {
            $filter_statement .= " AND c.gender ='" . (int)$data['gender'] . "'";
        }

        if (!empty($data['telephone'])) {
            $filter_statement .= " AND (c.telephone like '%" . $this->db->escape($data['telephone']) . "%' OR c.telephone2 like '%" . $this->db->escape($data['telephone']) . "%')";
        }

        if (!empty($data['doc_no_start'])) {
            $filter_statement .= " AND cs.invoice_prefix >= '" . $this->db->escape($data['doc_no_start']) . "'";
        }
        if (!empty($data['doc_no_end'])) {
            $filter_statement .= " AND cs.invoice_prefix <= '" . $this->db->escape($data['doc_no_end']) . "'";
        }

        if (!empty($data['date_start'])) {
            $filter_statement .= " AND cs.sales_date >= '" . $this->db->escape($data['date_start']) . "'";
        }
        if (!empty($data['date_end'])) {
            $filter_statement .= " AND cs.sales_date <= '" . $this->db->escape($data['date_end']) . "'";
        }

        // if (!empty($data['service'])) {
        //     if ($data['service'] == 1) {
        //         //required etcm service partner
        //         $filter_statement .= " AND cs.service_type = '1' AND cs.clinical_sale_id NOT IN (SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED')";
        //     }
        // }
        if (!empty($data['service'])) {
            if ($data['service'] == 1) {
                //required etcm service partner
                $filter_statement .= " AND cs.clinical_sale_id NOT IN (SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED') AND cs.clinical_sale_id IN (SELECT clinical_sale_id FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE dispense_code <> '' AND dispense_code NOT LIKE 'SELF_%') AND cs.clinicalsale_action='5'";
            }
        }

        //if required all store data (currently for patient history)
        if ($data['all_store'] && !empty($data['customer_id'])) {
            $filter_access_statement = '';
        } else {
            //check user data access
            if (!empty($this->session->data['user_info']['viewalldata'])) {
                $filter_access_statement = '';
            } else {
                //restricted by store id(currently logged)
                $filter_access_statement = " AND cs.store_id='" . (int)$this->session->data['store_id'] . "'";

                //restricted by doctor file for doctor
                if ($this->session->data['user_info']['position'] == '2') {
                    $filter_access_statement .= " AND 
                    (
                    cs.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                    OR 
                    cs.add_by = '" . (int)$this->session->data['user_id'] . "'
                    )";
                }
            }
        }

        //for quicksearch
        $filter_keyword = '';
        if (!empty($data['keyword'])) {
            $keyword = $data['keyword'];
            $filter_keyword .= " AND (";
            $filter_keyword .= "TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= " OR c.customer_ic LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= " OR c.telephone LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= ") ";
        }

        $sql = "SELECT 
        cs.customer_id,
        cs.clinical_sale_id,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor,
        (CASE WHEN s.name IS NULL THEN '" . $this->config->get('config_name') . "' ELSE s.name END) AS store,
        cs.sales_date,
        cs.invoice_prefix,
        cst.value AS total,
        os2.name AS payment_status,
        cs.clinicalsale_action AS status_id,
        os.name AS status,
        CONCAT_WS(', ',  NULLIF(TRIM(cs.diagnostic),''), NULLIF(TRIM(cs.doctoradvice),''), NULLIF(TRIM(cs.pulse),''), NULLIF(TRIM(cs.disease),''), NULLIF(TRIM(cs.treatment),''), NULLIF(TRIM(cs.acupuncture),''), NULLIF(TRIM(cs.symptom),''), NULLIF(TRIM(cs.remark),'')) AS diagnostic
        FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "store s ON(cs.store_id = s.store_id)
        LEFT JOIN " . DB_PREFIX . "customer c ON(cs.customer_id = c.customer_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON(cs.clinicalsale_action = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "order_status os2 ON(cs.order_action = os2.order_status_id AND os2.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "clinical_sale_total cst ON(cst.clinical_sale_id = cs.clinical_sale_id AND cst.id='2' AND cst.code='total')
        WHERE 1
        $filter_keyword
        $filter_statement
        $filter_access_statement
        AND cs.hide = 0
        ORDER BY cs.clinical_sale_id DESC
        LIMIT $start,$limit";

        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTotalMedicalRecords($data)
    {
        $filter_statement = '';
        if (!empty($data['customer_id'])) {
            $filter_statement .= " AND cs.customer_id ='" . (int)$data['customer_id'] . "'";
        }
        if (!empty($data['ic_no'])) {
            $filter_statement .= " AND c.customer_ic LIKE '%" . $this->db->escape($data['ic_no']) . "%'";
        }
        if (!empty($data['card_no'])) {
            $filter_statement .= " AND c.customer_card LIKE '%" . $this->db->escape($data['card_no']) . "%'";
        }
        if (!empty($data['name'])) {
            $filter_statement .= " AND CONCAT(c.firstname,' ',c.lastname) LIKE '%" . $this->db->escape($data['name']) . "%'";
        }
        if (!empty($data['status_id'])) {
            $filter_statement .= " AND cs.clinicalsale_action ='" . (int)$data['status_id'] . "'";
        }
        if (!empty($data['gender'])) {
            $filter_statement .= " AND c.gender ='" . (int)$data['gender'] . "'";
        }

        if (!empty($data['telephone'])) {
            $filter_statement .= " AND (c.telephone like '%" . $this->db->escape($data['telephone']) . "%' OR c.telephone2 like '%" . $this->db->escape($data['telephone']) . "%')";
        }

        if (!empty($data['doc_no_start'])) {
            $filter_statement .= " AND cs.invoice_prefix >= '" . $this->db->escape($data['doc_no_start']) . "'";
        }
        if (!empty($data['doc_no_end'])) {
            $filter_statement .= " AND cs.invoice_prefix <= '" . $this->db->escape($data['doc_no_end']) . "'";
        }

        if (!empty($data['date_start'])) {
            $filter_statement .= " AND cs.sales_date >= '" . $this->db->escape($data['date_start']) . "'";
        }
        if (!empty($data['date_end'])) {
            $filter_statement .= " AND cs.sales_date <= '" . $this->db->escape($data['date_end']) . "'";
        }

        // if (!empty($data['service'])) {
        //     if ($data['service'] == 1) {
        //         //required etcm service partner
        //         $filter_statement .= " AND cs.service_type = '1' AND cs.clinical_sale_id NOT IN (SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED')";
        //     }
        // }

        if (!empty($data['service'])) {
            if ($data['service'] == 1) {
                //required etcm service partner
                $filter_statement .= " AND cs.clinical_sale_id NOT IN (SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED') AND cs.clinical_sale_id IN (SELECT clinical_sale_id FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE category_id IN ('E_NGP','E_HERBS') AND dispense_code <> '' AND dispense_code NOT LIKE 'SELF_%') ";
            }
        }

        //if required all store data (currently for patient history)
        if ($data['all_store'] && !empty($data['customer_id'])) {
            $filter_access_statement = '';
        } else {
            //check user data access
            if (!empty($this->session->data['user_info']['viewalldata'])) {
                $filter_access_statement = '';
            } else {
                //restricted by store id(currently logged)
                $filter_access_statement = " AND cs.store_id='" . (int)$this->session->data['store_id'] . "'";

                //restricted by doctor file for doctor
                if ($this->session->data['user_info']['position'] == '2') {
                    $filter_access_statement .= " AND 
                    (
                    cs.doctor_id = '" . (int)$this->session->data['user_id'] . "' 
                    OR 
                    cs.add_by = '" . (int)$this->session->data['user_id'] . "'
                    )";
                }
            }
        }

        //for quicksearch
        $filter_keyword = '';
        if (!empty($data['keyword'])) {
            $keyword = $data['keyword'];
            $filter_keyword .= " AND (";
            $filter_keyword .= "TRIM(CONCAT(c.firstname,' ',c.lastname)) LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= " OR c.customer_ic LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= " OR c.telephone LIKE'%" . $this->db->escape($keyword) . "%'";
            $filter_keyword .= ") ";
        }

        $sql = "SELECT 
        COUNT(cs.customer_id) AS total
        FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "store s ON(cs.store_id = s.store_id)
        LEFT JOIN " . DB_PREFIX . "customer c ON(cs.customer_id = c.customer_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON(cs.clinicalsale_action = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "order_status os2 ON(cs.order_action = os2.order_status_id AND os2.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE 1
        $filter_keyword
        $filter_statement
        $filter_access_statement
        AND cs.hide = 0
        ";

        $query = $this->db->query($sql);
        return $query->row['total'];
    }

    public function canPlaceOrder($medical_record_id)
    {
        $sql = " SELECT * FROM " . DB_PREFIX . "clinical_sale cs WHERE cs.clinical_sale_id NOT IN (SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED') 
        AND cs.clinical_sale_id IN (SELECT clinical_sale_id FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE dispense_code <> '' AND dispense_code NOT LIKE 'SELF_%') AND cs.clinical_sale_id = '" . (int)$medical_record_id . "'";
        $query = $this->db->query($sql);
        return !empty($query->row) ? true : false;
    }

    public function orderBeenPlaced($medical_record_id)
    {
        $sql = "SELECT medical_record_id FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_status_code <> 'CANCELLED' AND medical_record_id = '" . (int)$medical_record_id . "'";
        $query = $this->db->query($sql);
        return !empty($query->row) ? true : false;
    }

    public function isNgpProducts($product_id, $detail_result = false)
    {
        if (!empty($product_id)) {
            if (is_array($product_id)) {
                $product_id_statement = " AND product_id IN ('" . implode("', '", $product_id) . "')";
            } else {
                $product_id_statement = " AND product_id = '" . (int)$product_id . "'";
            }
            $sql = "SELECT * FROM " . DB_PREFIX . "ngp_product WHERE 1 $product_id_statement";
            $query = $this->db->query($sql);
            if ($query->num_rows) {
                $result = true;
                $data = is_array($product_id) ? $query->rows : $query->row;
            } else {
                $result = false;
                $data = [];
            }
        } else {
            $result = false;
            $data = [];
        }
        if ($detail_result) {
            return $data;
        } else {
            return $result;
        }
    }

    public function getPrescriptionSummary($clinical_sale_id)
    {

        $times_suffix = "times";
        $day_suffix = "per day";

        if ($this->session->data['language_id'] == '1') {
            $product_column = " TRIM(GROUP_CONCAT(pd.name,' ',TRIM(cp.t_weight) + 0, wcd.unit SEPARATOR ',')) AS products,";
        } else {
            $product_column = " TRIM(GROUP_CONCAT(pd.name,TRIM(cp.t_weight) + 0, wcd.unit SEPARATOR ',')) AS products,";
        }

        $sql = "SELECT 
        $product_column
        CONCAT(MAX(cp.times),' ','$times_suffix') AS time,
        CONCAT(MAX(cp.day),' ','$day_suffix') AS day,
        cp.cook AS consume_method,
        cp.taketype AS take_type
        FROM " . DB_PREFIX . "clinicalsale_product cp 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(cp.product_id=pd.product_id AND pd.language_id = '" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(cp.weight_class_id=wcd.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE cp.clinical_sale_id = '" . (int)$clinical_sale_id . "'
        GROUP BY cp.prescription_id
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function saveClinicalSale($data)
    {

        $this->load->model('localisation/currency');

        $currency_info = $this->model_localisation_currency->getCurrencyByCode($this->config->get('config_currency'));

        if ($currency_info) {
            $currency_id = $currency_info['currency_id'];
            $currency_code = $currency_info['code'];
            $currency_value = $currency_info['value'];
        } else {
            $currency_id = 0;
            $currency_code = $this->config->get('config_currency');
            $currency_value = 1.00000;
        }

        $medical_record_id = $data['medical_record_id'];
        if (empty($medical_record_id)) {
            $this->load->model('setting/setting');
            $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));

            $sql_cs = "INSERT INTO " . DB_PREFIX . "clinical_sale SET
            customer_id = '" . (int) $data['customer_id'] . "',
            shipping_address_id = '" . (int) $data['shipping_address_id'] . "',
            doctor_id = '" . (int) $data['doctor_id'] . "',
            invoice_prefix ='" . $this->db->escape($invoice_prefix) . "',
            saved = '1',
            sales_date = NOW(),
            store_id = '" . (int) $this->session->data['store_id'] . "',
            clinicalsale_action = '" . (int) 1 . "',
            clinicalsale_concultation = '" . (float) $data['consultation_fee'] . "',
            collect_consultation_price = '" . (int) $data['collect_consultation_price'] . "',
            service_type = '" . (int)$data['service_type'] . "',
            herb_service_type = '" . $this->db->escape($data['herb_service_type']) . "',
            order_action = '" . (int) 17 . "',
            diagnostic = '" . $this->db->escape($data['diagnostic']) . "',
            doctoradvice = '" . $this->db->escape($data['doctoradvice']) . "',
            pulse = '" . $this->db->escape($data['pulse']) . "',
            disease = '" . $this->db->escape($data['disease']) . "',
            treatment = '" . $this->db->escape($data['treatment']) . "',
            acupuncture = '" . $this->db->escape($data['acupuncture']) . "',
            symptom = '" . $this->db->escape($data['symptom']) . "',
            remark = '" . $this->db->escape($data['remark']) . "',
            add_by = '" . (int) $this->session->data['user_id'] . "',
            date_added = NOW(),
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()";
            $this->db->query($sql_cs);

            $medical_record_id = $this->db->getLastId();

            if ($medical_record_id != 0) {
                $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'herbal/herbal', 'store' => $this->session->data['store_id']));
            }
        } else {
            $sql_cs = "UPDATE " . DB_PREFIX . "clinical_sale SET
            customer_id = '" . (int) $data['customer_id'] . "',
            shipping_address_id = '" . (int) $data['shipping_address_id'] . "',
            doctor_id = '" . (int) $data['doctor_id'] . "',
            clinicalsale_concultation = '" . (float) $data['consultation_fee'] . "',
            collect_consultation_price = '" . (int) $data['collect_consultation_price'] . "',
            service_type = '" . (int)$data['service_type'] . "',
            herb_service_type = '" . $this->db->escape($data['herb_service_type']) . "',
            diagnostic = '" . $this->db->escape($data['diagnostic']) . "',
            doctoradvice = '" . $this->db->escape($data['doctoradvice']) . "',
            pulse = '" . $this->db->escape($data['pulse']) . "',
            disease = '" . $this->db->escape($data['disease']) . "',
            treatment = '" . $this->db->escape($data['treatment']) . "',
            acupuncture = '" . $this->db->escape($data['acupuncture']) . "',
            symptom = '" . $this->db->escape($data['symptom']) . "',
            remark = '" . $this->db->escape($data['remark']) . "',
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()
            WHERE clinical_sale_id='" . (int)$medical_record_id . "'";
            $this->db->query($sql_cs);
        }

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_sales_prescription WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinicalsale_product WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        $product_total = 0;
        $product_tax = 0;
        $product_sutotal = 0;
        $weight = 0;
        $times = 0;
        $total_times = 0;
        $per_time = 0;

        if (!empty($data['prescription'])) {


            foreach ($data['prescription'] as $key => $item) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_sales_prescription SET
                    clinical_sale_id = '" . (int) $medical_record_id . "',
                    prescription_id = '" . $this->db->escape($item['id']) . "',
                    discount='" . (float)$item['discount'] . "', 
                    name='" . $this->db->escape($item['name']) . "', 
                    category_id='" . $this->db->escape($item['category_id']) . "', 
                    times='" . (int)$item['times'] . "', 
                    day='" . (int)$item['day'] . "', 
                    taketype='" . $this->db->escape($item['taketype']) . "', 
                    dispense_code='" . $this->db->escape($item['dispense_code']) . "', 
                    daily_dosage='" . $this->db->escape($item['daily_dosage']) . "', 
                    contraindications='" . $this->db->escape($item['contraindications']) . "', 
                    medication_method='" . $this->db->escape($item['usage']) . "', 
                    remark='" . $this->db->escape($item['remark']) . "', 
                    modifi_by='" . (int) $this->session->data['user_id'] . "', 
                    date_modified=NOW()");

                $prescription_id = $this->db->getLastId();
                if (!empty($data['products'])) {
                    foreach ($data['products'][$key] as $product_id => $product) {
                        $this->db->query("INSERT INTO " . DB_PREFIX . "clinicalsale_product SET
                            clinical_sale_id = '" . (int) $medical_record_id . "',
                            product_id = '" . (int) $product['product_id'] . "',
                            prescription_id = '" . (int) $prescription_id . "',
                            quantity = '" . (float) $product['quantity'] . "',
                            times = '" . (int) $product['times'] . "',
                            price = '" . (float) $product['price'] . "',
                            day = '" . (int) $product['day'] . "',
                            t_qty = '" . (float) $product['quantity'] * (int) $product['times'] . "',
                            weight = '" . (float) $product['product_weight'] . "',
                            weight_class_id = '" . (int) $product['weight_class_id'] . "',
                            t_weight = '" . (float) $product['weight'] . "',
                            remark = '" . $this->db->escape($product['usage']) . "',
                            cook = '" . $this->db->escape($product['cook']) . "',
                            taketype = '" . $this->db->escape($product['taketype']) . "',
                            t_gst = '" . (float) $product['tax'] . "',
                            discount = '" . (float) $product['discount'] . "',
                            t_net_price = '" . (float) $product['subtotal'] . "',
                            tax_class_id = '" . (int) $product['tax_class_id'] . "',
                            tax_code = '" . $this->db->escape($product['tax_code']) . "',
                            tax_format = '" . $this->db->escape($product['tax_format']) . "',
                            gst = '" . (float) $product['product_tax'] . "',
                            net_price = '" . (float) $product['product_subtotal'] . "',
                            rowtotal = '" . (float) $product['total'] . "',
                            modifi_by = '" . (int) $this->session->data['user_id'] . "',
                            date_modified = NOW()");

                        $product_total += $product['total'];
                        $product_sutotal += $product['subtotal'];
                        $product_tax += $product['tax'];
                        $times = $product['times'];
                        $per_time = $product['day'];
                    }
                }

                $total_times += $times;
            }

            $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
                clinicalsale_total = '" . (float) $product_total . "',
                net_total = '" . (float) $product_sutotal . "',
                gst = '" . (float) $product_tax . "'
                WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");
        } //end add product and prescription

        if ($this->allowEditService($medical_record_id)) {
            $this->db->query("DELETE FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");
            if (!empty($data['service'])) {
                foreach ($data['service'] as $key => $service) {
                    $this->db->query("INSERT INTO " . DB_PREFIX . "clinecal_service_item SET
					  clinical_sale_id = '" . (int) $medical_record_id . "',
					  clinicalservice_id = '" . (int) $service['service_id'] . "',
					  staffincharge ='" . (int) $service['staff_id'] . "',
					  servicename ='" . $this->db->escape($service['service_name']) . "',
					  serviceminutes ='" . $this->db->escape($service['service_minute']) . "',
					  price = '" . (float) $service['price'] . "',
					  tax_class_id = '" . (int) $service['tax_class_id'] . "',
					  tax_code = '" . $this->db->escape($service['tax_code']) . "',
					  tax_format = '" . $this->db->escape($service['tax_format']) . "',
					  t_gst = '" . (float) $service['tax'] . "',
					  t_net_price = '" . (int) $service['subtotal'] . "',
					  gst = '" . $service['net_tax'] . "',
					  net_price = '" . (float) $service['net_price'] . "',
					  rowtotal = '" . (float) $service['total'] . "',
					  modifi_by = '" . (int) $this->session->data['user_id'] . "',
					  date_modified = NOW()");

                    $clinecal_service_item_id = $this->db->getLastId();

                    if (!empty($data['acupuncture_list'][$service['service_id']])) {
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize($data['acupuncture_list'][$service['service_id']])) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                    } else {
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET acupuncture_parts = '" . $this->db->escape(serialize(array())) . "' WHERE clinecal_service_id = '" . (int) $clinecal_service_item_id . "'");
                    }
                }
            }
        }
        // Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $medical_record_id . "' AND id ='1' ");
        $subtotal = 0;
        $tax = 0;
        $total = 0;

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {

                $temp_tax_code = isset($order_total['tax_code']) ? $order_total['tax_code'] : '';
                $temp_key = isset($order_total['key']) ? $order_total['key'] : '';

                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $medical_record_id . "',
                id ='1',
                tax_code ='" . $this->db->escape($temp_tax_code) . "', 
                code = '" . $this->db->escape($order_total['code']) . "', 
                tax_key = '" . (int) $temp_key . "', 
                title = '" . $this->db->escape($order_total['title']) . "',  
                `value` = '" . (float) $order_total['value'] . "', 
                sort_order = '" . (int) $order_total['sort_order'] . "'");

                if ($order_total['code'] == 'sub_total') {
                    $subtotal += $order_total['value'];
                }
                if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                }
                if ($order_total['code'] == 'total') {
                    $total += $order_total['value'];
                }
            }
        }

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
        clinicalsale_total = '" . (float) $total . "', net_total = '" . (float) $subtotal . "', gst ='" . (float) $tax . "' WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        $subtotal = 0;
        $tax = 0;
        $total = 0;

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $medical_record_id . "' AND id ='2' ");

        if (isset($data['medical_total_data'])) {
            foreach ($data['medical_total_data'] as $medical_total_data) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $medical_record_id . "',id ='2', tax_code ='" . $this->db->escape($medical_total_data['tax_code']) . "', code = '" . $this->db->escape($medical_total_data['code']) . "', tax_key = '" . (int) $medical_total_data['key'] . "', title = '" . $this->db->escape($medical_total_data['title']) . "',  `value` = '" . (float) $medical_total_data['value'] . "', sort_order = '" . (int) $medical_total_data['sort_order'] . "'");

                if ($medical_total_data['code'] == 'sub_total') {
                    $subtotal += $medical_total_data['value'];
                }
                if ($medical_total_data['code'] == 'tax') {
                    $tax += $medical_total_data['value'];
                }
                if ($medical_total_data['code'] == 'total') {
                    $total += $medical_total_data['value'];
                }
            }
        }

        $total_sales = $data['medical_total'];

        $total_net =  ($data['collect_consultation_price'] == '1') ?  $data['consultation_fee'] : 0;
        $total_dgst =  ($data['collect_consultation_price'] == '1') ? $data['consultation_fee'] : 0;

        $total_weight = ($total_times * $per_time) * $this->config->get('config_herbal_weight');
        $weight_class_id = $this->config->get('config_herbal_weight_class_id');
        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
            total_d_gst = '" . (float) $total_dgst . "', 
            collect_consultation_price = '" . (int) $data['collect_consultation_price'] . "', 
            clinicalsale_concultation = '" . (float) $data['consultation_fee'] . "', 
            d_gst ='" . (float) $data['doctor_tax'] . "', 
            d_net_amount ='" . (float) $total_net . "', 
            tax_format='" . $this->db->escape($data['tax_format']) . "', 
            tax_class_id ='" . (int) $data['tax_class_id'] . "', 
            total ='" . (float) $total_sales . "', 
            tax_code ='" . $this->db->escape($data['tax_code']) . "',
            currency_id = '" . (int) $currency_id . "', 
            currency_code = '" . $this->db->escape($currency_code) . "', 
            weight ='" . (float) $total_weight . "', 
            weight_class_id ='" . (int) $weight_class_id . "', 
            currency_value = '" . (float) $currency_value . "' 
            WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        return $medical_record_id;
    }

    public function revertPending($medical_record_id)
    {
        $sql = "UPDATE " . DB_PREFIX . "clinical_sale 
        SET clinicalsale_action='1' 
        WHERE
        clinical_sale_id='" . (int)$medical_record_id . "' AND order_action <>'5'";
        $this->db->query($sql);
    }

    public function updateTotal($medical_record_id, $data)
    {
        // Get the total
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $medical_record_id . "' AND id ='1' ");
        $subtotal = 0;
        $tax = 0;
        $total = 0;

        if (isset($data['order_total'])) {
            foreach ($data['order_total'] as $order_total) {

                $temp_tax_code = isset($order_total['tax_code']) ? $order_total['tax_code'] : '';
                $temp_key = isset($order_total['key']) ? $order_total['key'] : '';

                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $medical_record_id . "',
                       id ='1',
                       tax_code ='" . $this->db->escape($temp_tax_code) . "', 
                       code = '" . $this->db->escape($order_total['code']) . "', 
                       tax_key = '" . (int) $temp_key . "', 
                       title = '" . $this->db->escape($order_total['title']) . "',  
                       `value` = '" . (float) $order_total['value'] . "', 
                       sort_order = '" . (int) $order_total['sort_order'] . "'");

                if ($order_total['code'] == 'sub_total') {
                    $subtotal += $order_total['value'];
                }
                if ($order_total['code'] == 'tax') {
                    $tax += $order_total['value'];
                }
                if ($order_total['code'] == 'total') {
                    $total += $order_total['value'];
                }
            }
        }

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
               clinicalsale_total = '" . (float) $total . "', net_total = '" . (float) $subtotal . "', gst ='" . (float) $tax . "' WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        $subtotal = 0;
        $tax = 0;
        $total = 0;

        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $medical_record_id . "' AND id ='2' ");

        if (isset($data['medical_total_data'])) {
            foreach ($data['medical_total_data'] as $medical_total_data) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $medical_record_id . "',id ='2', tax_code ='" . $this->db->escape($medical_total_data['tax_code']) . "', code = '" . $this->db->escape($medical_total_data['code']) . "', tax_key = '" . (int) $medical_total_data['key'] . "', title = '" . $this->db->escape($medical_total_data['title']) . "',  `value` = '" . (float) $medical_total_data['value'] . "', sort_order = '" . (int) $medical_total_data['sort_order'] . "'");

                if ($medical_total_data['code'] == 'sub_total') {
                    $subtotal += $medical_total_data['value'];
                }
                if ($medical_total_data['code'] == 'tax') {
                    $tax += $medical_total_data['value'];
                }
                if ($medical_total_data['code'] == 'total') {
                    $total += $medical_total_data['value'];
                }
            }
        }
    }

    public function updateMedicalTotal($medical_record_id, $data)
    {
        $this->db->query("DELETE FROM " . DB_PREFIX . "clinical_sale_total WHERE clinical_sale_id = '" . (int) $medical_record_id . "' AND id ='2' ");

        if (isset($data['medical_total_data'])) {
            foreach ($data['medical_total_data'] as $medical_total_data) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "clinical_sale_total SET clinical_sale_id = '" . (int) $medical_record_id . "',id ='2', tax_code ='" . $this->db->escape($medical_total_data['tax_code']) . "', code = '" . $this->db->escape($medical_total_data['code']) . "', tax_key = '" . (int) $medical_total_data['key'] . "', title = '" . $this->db->escape($medical_total_data['title']) . "',  `value` = '" . (float) $medical_total_data['value'] . "', sort_order = '" . (int) $medical_total_data['sort_order'] . "'");
            }
        }

        $total_sales = $data['medical_total'];

        $total_net =  ($data['collect_consultation_price'] == '1') ?  $data['consultation_fee'] : 0;
        $total_dgst =  ($data['collect_consultation_price'] == '1') ? $data['consultation_fee'] : 0;

        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
            total_d_gst = '" . (float) $total_dgst . "', 
            collect_consultation_price = '" . (int) $data['collect_consultation_price'] . "', 
            clinicalsale_concultation = '" . (float) $data['consultation_fee'] . "', 
            d_gst ='" . (float) $data['doctor_tax'] . "', 
            d_net_amount ='" . (float) $total_net . "', 
            total ='" . (float) $total_sales . "' 
            WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");
    }

    public function updateServiceTotal($medical_record_id, $total)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "service_form SET
                    total_price = '" . (float) $total . "'
                    WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");
    }

    public function getTotalFromServiceForm($medical_record_id)
    {
        $sql = "SELECT total_price FROM " . DB_PREFIX . "service_form WHERE clinical_sale_id = '" . (int) $medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function cancelClinicalSale($medical_record_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
        clinicalsale_action = '7',
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()
        WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        //get service data
        $sql_services = "SELECT DISTINCT(service_form_id) FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id='" . (int)$medical_record_id . "' AND service_form_id <> '0'";
        $query = $this->db->query($sql_services);
        $services = $query->rows;
        if (!empty($services)) {
            foreach ($services as $service) {
                $this->db->query("
                 UPDATE " . DB_PREFIX . "service_form SET
                 serviceform_action = '" . (int) 7 . "',
                 modifi_by = '" . (int) $this->session->data['user_id'] . "',
                 date_modified = NOW()
                 WHERE service_form_id='" . (int)$service['service_form_id'] . "' 
                 AND date_added <> date_modified
                 ");
            }
        }
    }

    public function completeClinicalSale($medical_record_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
        clinicalsale_action = '5',
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()
        WHERE clinical_sale_id = '" . (int) $medical_record_id . "'");

        //get service data
        $sql_services = "SELECT * FROM " . DB_PREFIX . "clinecal_service_item WHERE clinical_sale_id='" . (int)$medical_record_id . "' AND service_form_id ='0'";
        $query = $this->db->query($sql_services);
        $services = $query->rows;

        //add services
        // check condition before add
        if ($this->allowEditService($medical_record_id)) {
            if (!empty($services)) {
                //get customer_id
                $query2 = $this->db->query("SELECT customer_id FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id='" . (int)$medical_record_id . "'");
                $customer_id = !empty($query2->row['customer_id']) ? $query2->row['customer_id'] : 0;

                if ($customer_id) {
                    $this->load->model('setting/setting');
                    $invoice_prefix = $this->load->controller('setting/transaction_no/getTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

                    $this->db->query("
                INSERT INTO " . DB_PREFIX . "service_form SET
                        clinical_sale_id = '" . (int) $medical_record_id . "',
                        invoice_prefix = '" . $this->db->escape($invoice_prefix) . "',
                        customer_id = '" . (int) $customer_id . "',
                        user_id = '" . (int) $services[0]['staffincharge'] . "',
                        service_date = NOW(),
                        store_id = '" . (int) $this->session->data['store_id'] . "',
                        serviceform_action = '" . (int) 1 . "',
                        order_action = '" . (int) 17 . "',
                        add_by = '" . (int) $this->session->data['user_id'] . "',
                        date_added = NOW(),
                        modifi_by = '" . (int) $this->session->data['user_id'] . "',
                        date_modified = NOW()
                ");

                    $service_form_id = $this->db->getLastId();

                    if ($service_form_id != 0) {
                        $this->load->controller('setting/transaction_no/setTransactionNo', array('module' => 'service/service_form', 'store' => $this->session->data['store_id']));

                        //update service_form_id to clinecal_service_item for linkage
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_service_item SET service_form_id='" . (int)$service_form_id . "' WHERE clinical_sale_id='" . (int)$medical_record_id . "'");


                        $service_subtotal = 0;
                        $service_total = 0;
                        $service_gst = 0;
                        foreach ($services as $service) {
                            $this->db->query("INSERT INTO " . DB_PREFIX . "service_item SET
                        service_form_id = '" . (int) $service_form_id . "',
                        clinicalservice_id = '" . (int) $service['clinicalservice_id'] . "',
                        servicename ='" . $this->db->escape($service['servicename']) . "',
                        serviceminutes = '" . $this->db->escape($service['serviceminutes']) . "',
                        user_id = '" . (int) $service['staffincharge'] . "',
                        price = '" . (float) $service['price'] . "',
                        total = '" . (float) $service['rowtotal'] . "',
                        net_amount = '" . (float) $service['net_price'] . "',
                        tax_class_id = '" . (int) $service['tax_class_id'] . "',
                        tax_code = '" . $this->db->escape($service['tax_code']) . "',
                        tax_format = '" . $this->db->escape($service['tax_format']) . "',
                        gst = '" . $service['gst'] . "',
                        modifi_by = '" . (int) $this->session->data['user_id'] . "',
                        date_modified = NOW()");

                            $service_item_id = $this->db->getLastId();

                            $acupuncture_parts = !empty($service['acupuncture_parts']) ? unserialize($service['acupuncture_parts']) : array();
                            if (is_array($acupuncture_parts)) {
                                foreach ($acupuncture_parts as $acupuncture) {
                                    $this->db->query("INSERT INTO " . DB_PREFIX . "service_item_acupuncture_point
                            SET service_Item_id = '" . (int) $service_item_id . "',
                            acupuncture_id = '" . (int) $acupuncture['acupuncture_id'] . "',
                            num_of_acupuncture = '" . (int) $acupuncture['num_of_acupuncture'] . "'");
                                }
                            }

                            $service_subtotal += $service['t_net_price'];
                            $service_total += $service['rowtotal'];
                            $service_gst += $service['t_gst'];
                        }

                        $this->db->query("UPDATE " . DB_PREFIX . "service_form SET
                    total_price = '" . (float) $service_total . "',
                    net_amount = '" . (float) $service_subtotal . "',
                    t_gst = '" . (float) $service_gst . "'
                    WHERE service_form_id = '" . (int) $service_form_id . "'");
                    }
                }
            }
        }
    }

    public function deleteClinicalSale($clinical_sale_id)
    {
        $this->db->query("UPDATE " . DB_PREFIX . "clinical_sale SET
            hide ='1',
            modifi_by = '" . (int) $this->session->data['user_id'] . "',
            date_modified = NOW()
		WHERE clinical_sale_id = '" . (int) $clinical_sale_id . "'");
    }

    public function checkImageUploaded($image)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_image WHERE image like '%" . $this->db->escape($image) . "'";
        $query = $this->db->query($sql);
        if ($query->num_rows) {
            return true;
        } else {
            return false;
        }
    }

    public function getClinicalSaleImage($image_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_image_id='" . (int)$image_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function addClinicalSaleImage($data)
    {
        $folder = $this->getImageFolder($data['category_id']);
        $sql = "INSERT INTO " . DB_PREFIX . "clinical_sale_image SET
        clinical_sale_id = '" . (int) $data['clinical_sale_id'] . "',
        folder = '" . $this->db->escape($folder) . "',
        customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
        category_id = '" . (int) $data['category_id'] . "',
        remark = '" . $this->db->escape($data['remark']) . "',
        image ='" . $this->db->escape($data['image']) . "',
        modifi_by = '" . (int) $this->session->data['user_id'] . "',
        date_modified = NOW()";
        $query = $this->db->query($sql);
        $image_id = $this->db->getLastId();
        return $image_id;
    }

    public function deleteClinicalSaleImage($image_id)
    {
        $sql = "DELETE FROM " . DB_PREFIX . "clinical_sale_image WHERE clinical_sale_image_id='" . (int)$image_id . "'";
        $this->db->query($sql);
    }

    public function getImageFolder($category_id)
    {
        $sql = "SELECT index_name FROM " . DB_PREFIX . "image_category WHERE category_id='" . (int)$category_id . "'";
        $query = $this->db->query($sql);
        if (!empty($query->row['index_name'])) {
            return $query->row['index_name'];
        } else {
            return '';
        }
    }

    public function getClinicalSale($clinical_sale_id)
    {
        $sql = "SELECT 
        cs.*,
        os2.name AS payment_status,
        os.name AS status,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name
        FROM " . DB_PREFIX . "clinical_sale cs
        LEFT JOIN " . DB_PREFIX . "user u ON(cs.doctor_id = u.user_id)
        LEFT JOIN " . DB_PREFIX . "order_status os ON(cs.clinicalsale_action = os.order_status_id AND os.language_id='" . (int)$this->session->data['language_id'] . "')
        LEFT JOIN " . DB_PREFIX . "order_status os2 ON(cs.order_action = os2.order_status_id AND os2.language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE cs.clinical_sale_id='" . (int)$clinical_sale_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getTotals($clinical_sale_id, $id = 1)
    {
        $sql = "SELECT code, title, value FROM " . DB_PREFIX . "clinical_sale_total WHERE id='" . (int)$id . "' AND clinical_sale_id='" . (int)$clinical_sale_id . "' ORDER BY sort_order";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getCustomer($customer_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getAddressesByCustomerId($customer_id)
    {
        $sql = "SELECT a.*, z.name as zone, c.name as country FROM " . DB_PREFIX . "address a 
        LEFT JOIN " . DB_PREFIX . "zone z ON(a.zone_id=z.zone_id)
        LEFT JOIN " . DB_PREFIX . "country c ON(a.country_id=c.country_id)
        WHERE a.customer_id = '" . (int)$customer_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getImages($clinical_sale_id)
    {
        $sql = "SELECT i.*, c.name AS category 
        FROM " . DB_PREFIX . "clinical_sale_image i 
        LEFT JOIN " . DB_PREFIX . "image_category_description c 
        ON(i.category_id=c.category_id AND c.language_id ='" . (int)$this->session->data['language_id'] . "')
        WHERE i.clinical_sale_id = '" . $clinical_sale_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    private function updateHerbalPrescriptionTimeDay($pres)
    {
        if (!empty($pres)) {
            foreach ($pres as $p) {
                if (empty($p['times']) && empty($p['day'])) {
                    $prods = $this->getHerbalProduct($p['clinical_sale_prescription_id']);
                    if (!empty($prods[0]['day']) && !empty($prods[0]['times'])) {
                        $this->db->query("UPDATE " . DB_PREFIX . "clinecal_sales_prescription SET times='" . (int)$prods[0]['times'] . "', day='" . (int)$prods[0]['day'] . "' WHERE clinical_sale_prescription_id='" . (int)$p['clinical_sale_prescription_id'] . "'");
                    }
                }
            }
        }
    }

    public function getHerbalPrescription($medical_record_id)
    {

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_sales_prescription cp WHERE cp.clinical_sale_id = '" . (int) $medical_record_id . "'");

        //for old record that dont have time and day column
        $this->updateHerbalPrescriptionTimeDay($query->rows);
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "clinecal_sales_prescription cp WHERE cp.clinical_sale_id = '" . (int) $medical_record_id . "'");
        return $query->rows;
    }

    public function getHerbalProduct($prescription_id)
    {
        $sql = "SELECT cp.*, pd.name AS product_name, p.code AS product_code, p.price AS product_price, wcd.unit
        FROM " . DB_PREFIX . "clinicalsale_product cp 
        LEFT JOIN " . DB_PREFIX . "product p ON (cp.product_id = p.product_id) 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON (cp.product_id = pd.product_id  AND pd.language_id = '" . (int) $this->session->data['language_id'] . "') 
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(cp.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$this->session->data['language_id'] . "')
        WHERE cp.prescription_id = '" . (int) $prescription_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getHerbalService($medical_record_id)
    {
        $query = $this->db->query("SELECT cs.*, TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name FROM " . DB_PREFIX . "clinecal_service_item cs LEFT JOIN " . DB_PREFIX . "user u ON(cs.staffincharge=u.user_id) WHERE cs.clinical_sale_id = '" . (int) $medical_record_id . "'");

        return $query->rows;
    }

    public function getServiceFormItems($medical_record_id)
    {
        $sql = "SELECT si.*, TRIM(CONCAT(u.firstname,' ',u.lastname)) AS doctor_name FROM " . DB_PREFIX . "service_item si LEFT JOIN " . DB_PREFIX . "service_form sf ON(si.service_form_id = sf.service_form_id) 
        LEFT JOIN " . DB_PREFIX . "user u ON(si.user_id=u.user_id)
        WHERE sf.clinical_sale_id='" . (int)$medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServices($clinical_sale_id)
    {
        $sql = "SELECT *
        FROM " . DB_PREFIX . "clinecal_service_item
        WHERE clinical_sale_id = '" . (int)$clinical_sale_id . "'
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getServiceDetails($service_id)
    {
        $query = $this->db->query("
			SELECT
					price,
					staff_id
				FROM `oc_clinical_service`
				WHERE 1
					AND clinicalservice_id = '" . (int) $service_id . "'
		");
        return $query->row;
    }

    public function getDoctors($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $limit_statement = '';
        if (!empty($limit) && $start !== null) {
            $limit_statement = "LIMIT $start, $limit";
        }

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "TRIM(CONCAT(u.firstname,' ',u.lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ") ";
        }

        //access statement
        //check user data access
        if (!empty($this->session->data['user_info']['viewalldata'])) {
            $filter_access_statement = '';
        } else {
            //restricted by store id(currently logged)
            $filter_access_statement = " AND us.store_id='" . (int)$this->session->data['store_id'] . "'";

            //restricted by doctor file for doctor
            if ($this->session->data['user_info']['position'] == '2') {
                $filter_access_statement .= " AND 
                (
                u.user_id = '" . (int)$this->session->data['user_id'] . "' 
                )";
            }
        }

        $sql = "SELECT 
        u.user_id AS id,
        u.image,
        TRIM(CONCAT(u.firstname,' ',u.lastname)) AS name
        FROM " . DB_PREFIX . "user u
        LEFT JOIN " . DB_PREFIX . "user_to_store us ON (u.user_id = us.user_id)
        WHERE u.position='2'
        $search_statement
        $filter_access_statement
        GROUP BY u.user_id
        ORDER BY TRIM(CONCAT(u.firstname,' ',u.lastname))
        $limit_statement
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctors_backup($data)
    {
        $start = $data['start'];
        $limit = $data['limit'];

        $limit_statement = '';
        if (!empty($limit) && $start !== null) {
            $limit_statement = "LIMIT $start, $limit";
        }

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "TRIM(CONCAT(firstname,' ',lastname)) LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ") ";
        }

        $sql = "SELECT 
        user_id AS id,
        TRIM(CONCAT(firstname,' ',lastname)) AS name
        FROM " . DB_PREFIX . "user
        WHERE position='2'
        $search_statement
        ORDER BY TRIM(CONCAT(firstname,' ',lastname))
        $limit_statement
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getUser($user_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "user WHERE user_id = '" . (int)$user_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getOrderStatuses()
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "order_status WHERE language_id='" . (int)$this->session->data['language_id'] . "'";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function allowEditService($medical_record_id)
    {
        $allow = false;
        $services = $this->getServiceForm($medical_record_id);
        if (empty($services)) {
            $allow = true;
        }
        return $allow;
    }

    private function getServiceForm($medical_record_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_form WHERE
        clinical_sale_id = '" . (int) $medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getPrescription($prescription_id)
    {
        $sql = "SELECT p.prescription_id, pn.name, p.code FROM " . DB_PREFIX . "prescription p
        LEFT JOIN " . DB_PREFIX . "prescription_name pn ON(p.prescription_id=pn.prescription_id AND language_id='" . (int)$this->session->data['language_id'] . "')
        WHERE p.status='1' 
        AND p.prescription_id = '" . (int)$prescription_id . "' 
        ";
        $query = $this->db->query($sql);
        if (!empty($query->row)) {
            $info = $query->row;
            $info['products'] = $this->getPrescriptionItem($prescription_id);
            return $info;
        } else {
            return null;
        }
    }

    public function getPrescriptionItem($prescription_id)
    {
        $currency = $this->currency->getSymbolLeft($this->config->get('config_currency'));
        $language_id = $this->session->data['language_id'];
        $sql = "SELECT 
        p.product_id,
        pd.name,
        p.code,
        '$currency' AS currency,
        p.price,
        pi.used_qty AS quantity,
        wcd.unit AS weight_class,
        p.weight_class_id 
        FROM " . DB_PREFIX . "prescription_item pi
        RIGHT JOIN " . DB_PREFIX . "product p ON (pi.product_id = p.product_id)
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id=pd.product_id AND pd.language_id = '" . (int)$language_id . "') 
        LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON(p.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int)$language_id . "')
        WHERE pi.prescription_id ='" . (int)$prescription_id . "'
        ORDER BY pi.display_order, pd.name
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getProduct($product_id)
    {
        $sql = "SELECT p.*, pd.name FROM " . DB_PREFIX . "product p 
        LEFT JOIN " . DB_PREFIX . "product_description pd ON(p.product_id = pd.product_id AND pd.language_id='" . (int)$this->session->data['language_id'] . "') WHERE p.product_id='" . (int)$product_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }
}
