<?php
class ModelAndroidHome extends Model
{
    public function getTodayAppointments($doctor_id, $completed = false)
    {
        $today = date('Y-m-d');
        $sql = "SELECT count(*) AS total FROM " . DB_PREFIX . "appointment 
        WHERE doctor_id='" . (int)$doctor_id . "' AND appointment_date = '" . $this->db->escape($today) . "'";
        if ($completed) {
            $sql .= " AND status='5'";
        }
        $query = $this->db->query($sql);
        $total = isset($query->row['total']) ? $query->row['total'] : 0;
        return $total;
    }

    public function getTodayMedicalRecords($doctor_id, $completed = false)
    {
        $today = date('Y-m-d');
        $sql = "SELECT count(*) AS total FROM " . DB_PREFIX . "clinical_sale 
        WHERE doctor_id='" . (int)$doctor_id . "' AND sales_date = '" . $this->db->escape($today) . "'";
        if ($completed) {
            $sql .= " AND clinicalsale_action='5'";
        }
        $query = $this->db->query($sql);
        $total = isset($query->row['total']) ? $query->row['total'] : 0;
        return $total;
    }

    public function getTotalCustomerWeekly($doctor_id)
    {
        $monday = date('Y-m-d', strtotime('monday this week'));
        $sunday = date('Y-m-d', strtotime('sunday this week'));

        $sql = "SELECT DISTINCT(customer_id) FROM " . DB_PREFIX . "clinical_sale 
        WHERE doctor_id='" . (int)$doctor_id . "' AND sales_date >= '" . $this->db->escape($monday) . "' AND sales_date <= '" . $this->db->escape($sunday) . "'";
        $query = $this->db->query($sql);
        $total = $query->num_rows;
        return $total;
    }

    public function getTotalSalesMonthly($doctor_id)
    {
        $start = date('Y-m-01');
        $end = date('Y-m-t');

        $sql = "SELECT sum(clinicalsale_total) as total FROM " . DB_PREFIX . "clinical_sale 
        WHERE doctor_id='" . (int)$doctor_id . "' AND sales_date >= '" . $this->db->escape($start) . "' AND sales_date <= '" . $this->db->escape($end) . "'";
        $query = $this->db->query($sql);
        $total = isset($query->row['total']) ? $query->row['total'] : 0;
        return $total;
    }
}
