<?php

class ModelAndroidHerbsHerbsQuotation extends Model {

    public function addHerbsQuotation($user_data, $product_cart, $remark, $invoice_date) {

        $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request SET
                        invoice_date = '" . $this->db->escape($invoice_date) . "',
                        order_status_id = '1',
                        remark = '" . $this->db->escape($remark) . "',
                        date_added = NOW(),
                        added_by = '" . (int) $user_data['user_id'] . "'
                ");

        $quotation_request_id = $this->db->getLastId();

        foreach ($product_cart as $product) {

            $product_code = !empty($product['product_code']) ? $product['product_code'] : '';

            $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request_product SET
                                quotation_request_id = '" . (int) $quotation_request_id . "',
                                product_id = '" . (int) $product['product_id'] . "',
                                name = '" . $this->db->escape($product['product_name']) . "',
                                code = '" . $this->db->escape($product_code) . "',
                                weight = '" . $this->db->escape($product['quantity']) . "',
                                quantity = '" . $this->db->escape($product['quantity']) . "',
                                price = 0,
                                weight_class_id = '" . (int) $product['weight_class_id'] . "'
                    ");
        }

        $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request_history SET
                            quotation_request_id = '" . (int) $quotation_request_id . "',
                            order_status_id = '1',
                            remark = '" . $this->db->escape($remark) . "',
                            date_added = NOW(),
                            added_by = '" . (int) $user_data['user_id'] . "'
                ");

        return $quotation_request_id;
    }

    public function getQuotationRequestDetail($quotation_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request WHERE 1 AND quotation_request_id = '" . (int) $quotation_request_id . "'";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getQuotationRequestProduct($quotation_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request_product WHERE 1 AND quotation_request_id = '" . (int) $quotation_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getOrderStatus($order_status_id) {
        $sql = "SELECT name FROM " . DB_PREFIX . "order_status WHERE 1 AND order_status_id = '" . (int) $order_status_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['name'] : '';
    }

    public function getQuotationRequestLists($data = array()) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request WHERE 1";

        if (!empty($data['search'])) {
            $sql .= " AND (quotation_request_id LIKE '%" . $this->db->escape($data['search']) . "%'
                     OR invoice_prefix LIKE '%" . $this->db->escape($data['search']) . "%')
					";
        }

        if (!empty($data['filter_date_start']) && !empty($data['filter_date_end'])) {
            $sql .= " AND DATE(date_added) BETWEEN '" . $this->db->escape($data['filter_date_start']) . "' AND '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY quotation_request_id";
        }

        if (isset($data['order']) && ($data['order'] == 'ASC')) {
            $sql .= " ASC";
        } else {
            $sql .= " DESC";
        }

        if (isset($data['page']) || isset($data['show'])) {
            if ($data['page'] < 0) {
                $data['page'] = 0;
            }

            if ($data['show'] < 1) {
                $data['show'] = 30;
            }

            $sql .= " LIMIT " . (int) $data['page'] . "," . (int) $data['show'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getproductlist() {
        $sql = "SELECT * FROM oc_product WHERE 1";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateQuotationRequest($quotation_request_info, $products, $total_data, $remark, $order_status_id) {
        $this->db->query("UPDATE " . DB_PREFIX . "quotation_request SET date_modified = NOW(), order_status_id = '" . (int) $order_status_id . "' WHERE 1 AND quotation_request_id = '" . (int) $quotation_request_info['customer_quotation_request_id'] . "'");

        if (!empty($products)) {
            foreach ($products as $product) {
                $this->db->query("UPDATE " . DB_PREFIX . "quotation_request_product SET
                                price = '" . $product['price'] . "',
                                total = '" . $this->db->escape($product['total']) . "'    
                                WHERE quotation_request_id = '" . (int) $quotation_request_info['customer_quotation_request_id'] . "' AND product_id = '" . (int) $product['product_id'] . "'  
                    ");
            }
        }

        if (!empty($total_data)) {
            foreach ($total_data as $total) {
                $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request_total SET
                                quotation_request_id = '" . (int) $quotation_request_info['customer_quotation_request_id'] . "',
                                code = '" . $this->db->escape($total['code']) . "',
                                title = '" . $this->db->escape($total['title']) . "',
                                text= '" . $this->db->escape($total['text']) . "',
                                value = '" . $this->db->escape($total['value']) . "',
                                sort_order = '" . $this->db->escape($total['sort_order']) . "'     
                        ");
            }
        }

        $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request_history SET
                quotation_request_id = '" . (int) $quotation_request_info['customer_quotation_request_id'] . "',
                order_status_id = '" . (int) $order_status_id . "',
                remark = '" . $this->db->escape($remark) . "',
                date_added = NOW(),
                added_by = 0
                ");
    }

    public function getWeightClass($weight_class_id) {
        $sql = "SELECT unit FROM " . DB_PREFIX . "weight_class wc LEFT JOIN " . DB_PREFIX . "weight_class_description wcd ON wc.weight_class_id = wcd.weight_class_id AND wcd.language_id = '" . (int) $this->config->get('config_language_id') . "' WHERE wc.weight_class_id = '" . (int) $weight_class_id . "'";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['unit'] : '';
    }

    public function getQuotationRequestRemarkDetail($quotation_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request_history WHERE quotation_request_id = '" . (int) $quotation_request_id . "' ORDER BY date_added DESC LIMIT 1";

        $query = $this->db->query($sql);

        return $query->row;
    }

    public function getQuotationReqeustRemarkList($quotation_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request_history WHERE quotation_request_id = '" . (int) $quotation_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function getQuotationRequestTotal($quotation_request_id) {
        $sql = "SELECT * FROM " . DB_PREFIX . "quotation_request_total WHERE quotation_request_id = '" . (int) $quotation_request_id . "'";

        $query = $this->db->query($sql);

        return $query->rows;
    }

    public function updateInvoicePrefix($quotation_request_id, $invoice_prefix) {
        $this->db->query("UPDATE " . DB_PREFIX . "quotation_request SET invoice_prefix = '" . $this->db->escape($invoice_prefix) . "' WHERE 1 AND quotation_request_id = '" . (int) $quotation_request_id . "'");
    }

    public function updatOrderStatusCancel($quotation_request_id, $order_status_id, $cancel_order_reason, $post_user) {
        $this->db->query("UPDATE " . DB_PREFIX . "quotation_request SET order_status_id = '" . (int) $order_status_id . "' WHERE 1 AND quotation_request_id = '" . (int) $quotation_request_id . "'");
        
        $this->db->query("INSERT INTO " . DB_PREFIX . "quotation_request_history SET
                            quotation_request_id = '" . (int) $quotation_request_id . "',
                            remark = '" . $this->db->escape($cancel_order_reason) . "',
                            order_status_id = '" . (int) $order_status_id . "',
                            date_added = NOW(),
                            added_by = '" . (int) $post_user['user_id'] . "'
                                
                ");
    }

    public function getCancelReasonForQuotationRequest() {
        $sql = "SELECT * FROM " . DB_PREFIX . "cancel_reason cr
                LEFT JOIN " . DB_PREFIX . "cancel_reason_desc crd
                ON cr.reason_id = crd.reason_id 
                AND crd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                WHERE 1 AND cr.status = '1' AND type = 'herbs_quotation'    
                ";

        $query = $this->db->query($sql);

        return $query->rows;
    }
    
    public function getSingleCancelReasonForQuotationRequest($reason_id) {
        $sql = "SELECT crd.name FROM " . DB_PREFIX . "cancel_reason cr
                LEFT JOIN " . DB_PREFIX . "cancel_reason_desc crd
                ON cr.reason_id = crd.reason_id 
                AND crd.language_id = '" . (int) $this->config->get('config_language_id') . "'
                WHERE 1 AND cr.status = '1' AND type = 'herbs_quotation' AND cr.reason_id = '" . (int) $reason_id . "'
                ";

        $query = $this->db->query($sql);

        return !empty($query->row) ? $query->row['name'] : '';
    }

}
