<?php

class ModelAndroidEtcmServicePartner extends Model
{
    public function getPOByEtcmId($etcm_purchase_order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_partner_purchase_order WHERE etcm_purchase_order_id ='" . (int)$etcm_purchase_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function getSOByEtcmId($etcm_purchase_order_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_partner_sale_order WHERE etcm_purchase_order_id ='" . (int)$etcm_purchase_order_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    public function checkPO($data)
    {

        $po_exist = $this->getPOByEtcmId($data['etcm_purchase_order_id']);
        if (!empty($po_exist)) {
            return $po_exist['purchase_order_id'];
        } else {
            $invoice_no = $data['doc_no'];

            $customer_info = $this->getCustomerInfoByMedicalRecordId($data['medical_record_id']);

            $medical_record_info = $this->getMedicalRecord($data['medical_record_id']);
            $store_id = !empty($medical_record_info['store_id']) ? $medical_record_info['store_id'] : 0;

            $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order SET
            etcm_purchase_order_id ='" . (int)$data['etcm_purchase_order_id'] . "',
            store_id ='" . (int)$store_id . "',
            doc_no ='" . $this->db->escape($invoice_no) . "',
            doc_date ='" . $this->db->escape($data['doc_date']) . "',
            customer_id ='" . (int)$customer_info['customer_id'] . "',
            customer_name ='" . $this->db->escape(TRIM($customer_info['firstname'] . ' ' . $customer_info['lastname'])) . "',
            customer_telephone ='" . $this->db->escape($customer_info['telephone']) . "',
            customer_email ='" . $this->db->escape($customer_info['email']) . "',
            medical_record_id ='" . (int)$data['medical_record_id'] . "',
            service_partner_id ='" . (int)$data['service_partner_id'] . "',
            service_partner_name ='" . $this->db->escape($data['service_partner_name']) . "',
            service_type ='" . $this->db->escape($data['service_type']) . "',
            shipping_type ='" . $this->db->escape($data['shipping_type']) . "',
            estimated_date ='" . $this->db->escape($data['estimated_date']) . "',
            shipping_address_id ='" . (int)$data['shipping_address_id'] . "',
            shipping_address ='" . $this->db->escape($data['shipping_address']) . "',
            shipping_address_json ='" . $this->db->escape(json_encode($data['shipping_address_json'])) . "',
            shipping_method ='" . $this->db->escape($data['shipping_method']) . "',
            payment_address ='" . $this->db->escape($data['payment_address']) . "',
            payment_address_json ='" . $this->db->escape(json_encode($data['payment_address_json'])) . "',
            payment_method ='" . $this->db->escape($data['payment_method']) . "',
            image_json ='" . $this->db->escape(json_encode($data['image_json'])) . "',
            service_partner_prescription_json ='" . $this->db->escape(json_encode($data['service_partner_prescription_json'])) . "',
            service_partner_total_json ='" . $this->db->escape(json_encode($data['service_partner_total_json'])) . "',
            service_partner_total ='" . $this->db->escape($data['service_partner_total']) . "',
            service_partner_total_text ='" . $this->db->escape($data['service_partner_total_text']) . "',
            service_charges ='" . $this->db->escape($data['service_charges']) . "',
            service_tax ='" . $this->db->escape($data['service_tax']) . "',
            tax_class_id ='" . (int)$data['tax_class_id'] . "',
            discount ='" . $this->db->escape($data['discount']) . "',
            total ='" . $this->db->escape($data['total']) . "',
            status_id ='" . (int)$data['status_id'] . "',
            etcm_status_code ='" . $this->db->escape($data['etcm_status_code']) . "',
            remark ='" . $this->db->escape($data['remark']) . "',
            date_ordered ='" . $this->db->escape($data['doc_date']) . "',
            date_payment ='" . $this->db->escape($data['date_payment']) . "',
            date_added = NOW(),
            date_modified =NOW()";

            $this->db->query($sql);
            $purchase_order_id = $this->db->getLastId();

            if ($purchase_order_id > 0) {

                if (!empty($data['products'])) {
                    foreach ($data['products'] as $product) {
                        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order_product  SET 
                    purchase_order_id ='" . (int)$purchase_order_id . "',
                    prescription_id ='" . (int)$product['prescription_id'] . "',
                    product_id ='" . (int)$product['product_id'] . "',
                    name ='" . $this->db->escape($product['name']) . "',
                    code ='" . $this->db->escape($product['code']) . "',
                    model ='" . $this->db->escape($product['model']) . "',
                    quantity ='" . $this->db->escape($product['quantity']) . "',
                    weight ='" . $this->db->escape($product['weight']) . "',
                    weight_class_id ='" . (int)$product['weight_class_id'] . "',
                    price ='" . $this->db->escape($product['price']) . "',
                    total ='" . $this->db->escape($product['total']) . "',
                    tax ='" . $this->db->escape($product['tax']) . "'";

                        $this->db->query($sql);
                    }
                }

                if (!empty($data['totals'])) {
                    foreach ($data['totals'] as $total) {
                        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_purchase_order_total  
                    SET 
                    purchase_order_id ='" . (int)$purchase_order_id . "',
                    code ='" . $this->db->escape($total['code']) . "',
                    title ='" . $this->db->escape($total['title']) . "',
                    value ='" . $this->db->escape($total['value']) . "',
                    sort_order ='" . $this->db->escape($total['sort_order']) . "'";

                        $this->db->query($sql);
                    }
                }
            }

            return $purchase_order_id;
        }
    }

    public function checkSO($data)
    {
        $so_exist = $this->getSOByEtcmId($data['etcm_purchase_order_id']);
        if (!empty($so_exist)) {
            return $so_exist['sale_order_id'];
        } else {
            $invoice_no = $data['doc_no'];

            $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order SET
            etcm_purchase_order_id ='" . (int)$data['etcm_purchase_order_id'] . "',
            store_id ='" . (int)0 . "',
            doc_no ='" . $this->db->escape($invoice_no) . "',
            doc_date ='" . $this->db->escape($data['doc_date']) . "',
            etcm_customer_id ='" . (int)$data['customer_id'] . "',
            customer_name ='" . $this->db->escape($data['customer_name']) . "',
            customer_telephone ='" . $this->db->escape($data['customer_telephone']) . "',
            customer_email ='" . $this->db->escape($data['customer_email']) . "',
            medical_record_id ='" . (int)$data['medical_record_id'] . "',
            service_partner_id ='" . (int)$data['service_partner_id'] . "',
            service_partner_name ='" . $this->db->escape($data['service_partner_name']) . "',
            service_type ='" . $this->db->escape($data['service_type']) . "',
            transaction_fee ='" . (float)$data['transaction_fee'] . "',
            shipping_type ='" . $this->db->escape($data['shipping_type']) . "',
            estimated_date ='" . $this->db->escape($data['estimated_date']) . "',
            shipping_address_id ='" . (int)$data['shipping_address_id'] . "',
            shipping_address ='" . $this->db->escape($data['shipping_address']) . "',
            shipping_address_json ='" . $this->db->escape(json_encode($data['shipping_address_json'])) . "',
            shipping_method ='" . $this->db->escape($data['shipping_method']) . "',
            payment_address ='" . $this->db->escape($data['payment_address']) . "',
            payment_address_json ='" . $this->db->escape(json_encode($data['payment_address_json'])) . "',
            payment_method ='" . $this->db->escape($data['payment_method']) . "',
            image_json ='" . $this->db->escape(json_encode($data['image_json'])) . "',
            service_partner_prescription_json ='" . $this->db->escape(json_encode($data['service_partner_prescription_json'])) . "',
            service_partner_total_json ='" . $this->db->escape(json_encode($data['service_partner_total_json'])) . "',
            service_partner_total ='" . $this->db->escape($data['service_partner_total']) . "',
            service_partner_total_text ='" . $this->db->escape($data['service_partner_total_text']) . "',
            service_charges ='" . $this->db->escape($data['service_charges']) . "',
            service_tax ='" . $this->db->escape($data['service_tax']) . "',
            tax_class_id ='" . (int)$data['tax_class_id'] . "',
            discount ='" . $this->db->escape($data['discount']) . "',
            total ='" . $this->db->escape($data['total']) . "',
            status_id ='" . (int)$data['status_id'] . "',
            etcm_status_code ='" . $this->db->escape($data['etcm_status_code']) . "',
            remark ='" . $this->db->escape($data['remark']) . "',
            date_ordered ='" . $this->db->escape($data['doc_date']) . "',
            date_payment ='" . $this->db->escape($data['date_payment']) . "',
            date_added = NOW(),
            date_modified =NOW()";

            $this->db->query($sql);
            $sale_order_id = $this->db->getLastId();

            if ($sale_order_id > 0) {

                if (!empty($data['products'])) {
                    foreach ($data['products'] as $product) {
                        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order_product  SET 
                    sale_order_id ='" . (int)$sale_order_id . "',
                    prescription_id ='" . (int)$product['prescription_id'] . "',
                    product_id ='" . (int)$product['product_id'] . "',
                    name ='" . $this->db->escape($product['name']) . "',
                    code ='" . $this->db->escape($product['code']) . "',
                    model ='" . $this->db->escape($product['model']) . "',
                    quantity ='" . $this->db->escape($product['quantity']) . "',
                    weight ='" . $this->db->escape($product['weight']) . "',
                    weight_class_id ='" . (int)$product['weight_class_id'] . "',
                    price ='" . $this->db->escape($product['price']) . "',
                    total ='" . $this->db->escape($product['total']) . "',
                    tax ='" . $this->db->escape($product['tax']) . "'";

                        $this->db->query($sql);
                    }
                }

                if (!empty($data['totals'])) {
                    foreach ($data['totals'] as $total) {
                        $sql = "INSERT INTO " . DB_PREFIX . "service_partner_sale_order_total  
                    SET 
                    sale_order_id ='" . (int)$sale_order_id . "',
                    code ='" . $this->db->escape($total['code']) . "',
                    title ='" . $this->db->escape($total['title']) . "',
                    value ='" . $this->db->escape($total['value']) . "',
                    sort_order ='" . $this->db->escape($total['sort_order']) . "'";

                        $this->db->query($sql);
                    }
                }
            }
            return $sale_order_id;
        }
    }

    private function getCustomerInfoByMedicalRecordId($medical_record_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE customer_id = (SELECT customer_id FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id='" . (int)$medical_record_id . "')";
        $query = $this->db->query($sql);
        return $query->row;
    }

    private function getMedicalRecord($medical_record_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "clinical_sale WHERE clinical_sale_id='" . (int)$medical_record_id . "'";
        $query = $this->db->query($sql);
        return $query->row;
    }
}
