<?php

class ModelAndroidEtcmAppointment extends Model
{

    public function getAppointments($data)
    {
        $filter_statement = '';
        if (!empty($data['doctor_id'])) {
            $filter_statement .= " AND a.doctor_id = '" . (int)$data['doctor_id'] . "'";
        }

        if (!empty($data['service_id'])) {
            $filter_statement .= " AND a.clinicalservice_id = '" . (int)$data['service_id'] . "'";
        }

        if (!empty($data['start_date'])) {
            $filter_statement .= " AND a.appointment_date >= '" . $this->db->escape($data['start_date']) . "'";
        }

        if (!empty($data['end_date'])) {
            $filter_statement .= " AND a.appointment_date <= '" . $this->db->escape($data['end_date']) . "'";
        }

        $sql = "SELECT a.*, s.cs_minute AS service_minute FROM " . DB_PREFIX . "appointment a 
        LEFT JOIN " . DB_PREFIX . "clinical_service s ON(a.clinicalservice_id = s.clinicalservice_id)
        WHERE 1 
        AND a.hide = '0'
        AND a.status <> '2'
        AND a.store_id = '" . (int)$data['store_id'] . "'
        $filter_statement
        ";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    // public function checkBooked($doctor_id, $date, $time, $appointment_id)
    // {
    //     $sql = "SELECT * FROM " . DB_PREFIX . "appointment 
    //     WHERE doctor_id = '" . (int)$doctor_id . "'
    //     AND appointment_date = '" . $this->db->escape($date) . "'
    //     AND appointment_time = '" . $this->db->escape($time) . "'
    //     AND status <> '2'";
    //     if (!empty($appointment_id)) {
    //         $sql .= " AND appointment_id <> '" . (int)$appointment_id . "'";
    //     }
    //     $query = $this->db->query($sql);
    //     return $query->rows;
    // }

    public function addAppointment($data)
    {
        $sql = "INSERT INTO " . DB_PREFIX . "appointment
        SET
            store_id = '" . (int)$data['store_id'] . "',
			customer_id = '" . (int)$data['customer_id'] . "',
			customer_name = '" . $this->db->escape($data['customer_name']) . "',
			customer_ic = '" . $this->db->escape($data['customer_ic']) . "',
			email = '" . $this->db->escape($data['email']) . "',
			telephone = '" . $this->db->escape($data['telephone']) . "',
			clinicalservice_id = '" . $data['service_id'] . "',
			facility_id = '" . (int)$data['facility_id'] . "',
			status = 0,
            from_etcm = '" . (int)$data['etcm_app_id'] . "',
            appointment_date = '" . $this->db->escape($data['appointment_date']) . "',
            appointment_time = '" . $this->db->escape($data['appointment_time']) . "', 
            doctor_id = '" . (int)$data['doctor_id'] . "',
            remark = '" . $this->db->escape($data['remark']) . "', 
			new_customer = '" . (int)1 . "',
			created_by = '0',
			created_date = NOW(),
			lastmodified_by = '0',
			lastmodified_date = NOW()";

        $this->db->query($sql);
        $appointment_id = $this->db->getLastId();
        return $appointment_id;
    }

    public function cancelAppointment($data)
    {
        $cancel_reasons = !empty($data['reason']) ? "cancel_reasons = '" . $this->db->escape($data['reason']) . "', " : '';

        $sql = "UPDATE " . DB_PREFIX . "appointment SET 
        status = '2', 
        cancel_reason_id = '" . (int)0 . "',
        $cancel_reasons
        lastmodified_by = '0', 
        lastmodified_date = NOW() 
        WHERE from_etcm = '" . (int)$data['etcm_app_id'] . "'";
        $this->db->query($sql);

        $result = $this->db->query("SELECT appointment_id FROM " . DB_PREFIX . "appointment WHERE from_etcm = '" . (int)$data['etcm_app_id'] . "' AND status = '2'")->row;
        return !empty($result['appointment_id']) ? $result['appointment_id'] : 0;
    }

    public function getAppointment($id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "appointment WHERE appointment_id = '" . (int)$id . "'";
        return $this->db->query($sql)->row;
    }

    public function getServiceFacilities($service_id)
    {
        $sql = "SELECT * FROM " . DB_PREFIX . "service_to_facility WHERE service_id = '" . (int)$service_id . "'
        AND facility_id IN (SELECT facility_id FROM " . DB_PREFIX . "facility WHERE status = '1')";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getFacilitiesDetail($facility_id)
    {
        $facility_info = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility WHERE facility_id = '" . (int)$facility_id . "'")->row;
        if (!empty($facility_info)) {
            $availabilities = $this->db->query("SELECT * FROM " . DB_PREFIX . "facility_availability WHERE facility_id = '" . (int)$facility_id . "'")->rows;
            $facility_info['availabilities'] = $availabilities;
        }
        return $facility_info;
    }
}
