<?php

class ModelAndroidDiagnosticDiagnostic extends Model
{

    public function getDiagnosticList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "d.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR dn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }
        $sql = "SELECT d.diagnostic_id AS id, d.code, dn.name 
        FROM " . DB_PREFIX . "diagnostic d LEFT JOIN " . DB_PREFIX . "diagnostic_name dn
        ON(d.diagnostic_id = dn.diagnostic_id AND dn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND d.parent_id <> '0'
        AND d.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getPulseList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "p.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR pn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT p.pulse_id AS id, p.code, pn.name 
        FROM " . DB_PREFIX . "pulse p LEFT JOIN " . DB_PREFIX . "pulse_name pn
        ON(p.pulse_id = pn.pulse_id AND pn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND p.parent_id <> '0'
        AND p.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDiseaseList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "d.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR dn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT d.disease_id AS id, d.code, dn.name 
        FROM " . DB_PREFIX . "disease d LEFT JOIN " . DB_PREFIX . "disease_name dn
        ON(d.disease_id = dn.disease_id AND dn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND d.parent_id <> '0'
        AND d.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getTreatmentList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "t.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR tn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT t.treatment_id AS id, t.code, tn.name 
        FROM " . DB_PREFIX . "treatment t LEFT JOIN " . DB_PREFIX . "treatment_name tn
        ON(t.treatment_id = tn.treatment_id AND tn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND t.parent_id <> '0'
        AND t.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getSymptomList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "s.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR sn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT s.symptom_id AS id, s.code, sn.name 
        FROM " . DB_PREFIX . "symptom s LEFT JOIN " . DB_PREFIX . "symptom_name sn
        ON(s.symptom_id = sn.symptom_id AND sn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND s.parent_id <> '0'
        AND s.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getAcupunctureList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "a.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR an.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT a.acupuncture_id AS id, a.code, an.name 
        FROM " . DB_PREFIX . "acupuncture a LEFT JOIN " . DB_PREFIX . "acupuncture_name an
        ON(a.acupuncture_id = an.acupuncture_id AND an.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND a.parent_id <> '0'
        AND a.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function getDoctorAdviceList($data)
    {
        $language_id = $this->session->data['language_id'];

        $start = $data['start'];
        $limit = $data['limit'];

        $search_statement = '';
        if (!empty($data['filter_search'])) {
            $filter_search = $data['filter_search'];
            $search_statement .= "AND ( ";
            $search_statement .= "d.code LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= "OR dn.name LIKE '%" . $this->db->escape($filter_search) . "%' ";
            $search_statement .= ")";
        }

        $sql = "SELECT d.doctoradvice_id AS id, d.code, dn.name 
        FROM " . DB_PREFIX . "doctoradvice d LEFT JOIN " . DB_PREFIX . "doctoradvice_name dn
        ON(d.doctoradvice_id = dn.doctoradvice_id AND dn.language_id=" . (int)$language_id . ")
        WHERE 1 
        AND d.parent_id <> '0'
        AND d.status = '1'
        $search_statement
        LIMIT $start, $limit";
        $query = $this->db->query($sql);
        return $query->rows;
    }
}
